/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;

public abstract class MenuItem {
    public FocusListener listener;
    public BuildMenu m_pMenu;
    public char[] text;
    public BuildFont font;
    public boolean fontShadow;
    public int x = 0;
    public int y = 0;
    public int width = 0;
    public int flags = 0;
    public int pal = 0;
    public int align;

    public MenuItem(Object text, BuildFont textStyle) {
        if (text != null) {
            if (text instanceof String) {
                this.text = ((String)text).toCharArray();
            } else if (text instanceof char[]) {
                this.text = (char[])text;
            }
        }
        this.font = textStyle;
        this.listener = new FocusListener(){

            @Override
            public boolean isFocused() {
                return MenuItem.this.m_pMenu.mGetFocusedItem(MenuItem.this);
            }
        };
    }

    public void mCheckEnableItem(boolean nEnable) {
        this.flags = nEnable ? 7 : 1;
    }

    public boolean isEnabled() {
        return (this.flags & 7) == 7;
    }

    public boolean isFocused() {
        return this.listener.isFocused();
    }

    public void dbDrawDimensions(Engine draw, int col) {
        int x = Gameutils.coordsConvertXScaled(this.x - 1, Gameutils.ConvertType.Normal);
        int y = Gameutils.coordsConvertYScaled(this.y - 1);
        int x2 = Gameutils.coordsConvertXScaled(this.x + this.width + 1, Gameutils.ConvertType.Normal);
        int y2 = Gameutils.coordsConvertYScaled(this.y + this.font.getHeight() + 1);
        draw.getrender().drawline256(x * 4096, y * 4096, x2 * 4096, y * 4096, col);
        draw.getrender().drawline256(x * 4096, y2 * 4096, x2 * 4096, y2 * 4096, col);
        draw.getrender().drawline256(x * 4096, y * 4096, x * 4096, y2 * 4096, col);
        draw.getrender().drawline256(x2 * 4096, y * 4096, x2 * 4096, y2 * 4096, col);
    }

    public abstract void draw(MenuHandler var1);

    public abstract boolean callback(MenuHandler var1, MenuHandler.MenuOpt var2);

    public abstract boolean mouseAction(int var1, int var2);

    public abstract void open();

    public abstract void close();

    protected static interface FocusListener {
        public boolean isFocused();
    }
}

