/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.ScreenAdapter;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.ScreenAdapters.LoadingAdapter;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Strhandler;

public abstract class GameAdapter
extends ScreenAdapter {
    protected BuildGame game;
    protected BuildNet pNet;
    protected MenuHandler pMenu;
    protected BuildEngine pEngine;
    protected BuildConfig pCfg;
    protected Runnable gScreenCapture;
    protected LoadingAdapter load;
    public byte[] captBuffer;
    private final Runnable startboard = new Runnable(){

        @Override
        public void run() {
            GameAdapter.this.pNet.WaitForAllPlayers(0);
            System.gc();
            GameAdapter.this.pNet.ResetTimers();
            GameAdapter.this.game.pInput.resetMousePos();
            GameAdapter.this.pNet.ready2send = true;
            GameAdapter.this.game.changeScreen(GameAdapter.this);
            GameAdapter.this.pEngine.faketimerhandler();
        }
    };

    public GameAdapter(BuildGame game, LoadingAdapter load) {
        this.game = game;
        this.pNet = game.pNet;
        this.pMenu = game.pMenu;
        this.pEngine = game.pEngine;
        this.pCfg = game.pCfg;
        this.load = load;
    }

    public void PreFrame(BuildNet net) {
    }

    public void PostFrame(BuildNet net) {
    }

    public abstract void ProcessFrame(BuildNet var1);

    public abstract void DrawWorld(float var1);

    public abstract void DrawHud(float var1);

    public abstract void KeyHandler();

    public abstract void sndHandlePause(boolean var1);

    protected abstract boolean prepareboard(String var1);

    public GameAdapter setTitle(String title) {
        this.load.setTitle(title);
        return this;
    }

    public GameAdapter loadboard(final String map, final Runnable prestart) {
        this.pNet.ready2send = false;
        this.game.changeScreen(this.load);
        this.load.init(new Runnable(){

            @Override
            public void run() {
                if (GameAdapter.this.prepareboard(map)) {
                    String mapname;
                    int index;
                    if (prestart != null) {
                        prestart.run();
                    }
                    if ((index = Strhandler.toLowerCase(mapname = map).indexOf(".map")) == -1) {
                        mapname = mapname + ".map";
                    }
                    if (GameAdapter.this.game.currentDef.mapInfo.load(mapname)) {
                        System.err.println("Maphack loaded for map: " + mapname);
                    }
                    GameAdapter.this.startboard(GameAdapter.this.startboard);
                }
            }
        });
        return this;
    }

    protected void startboard(Runnable startboard) {
        startboard.run();
    }

    @Override
    public void show() {
        this.pMenu.mClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void render(float delta) {
        this.KeyHandler();
        if (Mmulti.numplayers > 1) {
            this.pEngine.faketimerhandler();
            this.pNet.GetPackets();
            while (this.pNet.gPredictTail < this.pNet.gNetFifoHead[Mmulti.myconnectindex] && !this.game.gPaused) {
                this.pNet.UpdatePrediction(this.pNet.gFifoInput[this.pNet.gPredictTail & 0xFF][Mmulti.myconnectindex]);
            }
        } else {
            this.pNet.bufferJitter = 0;
        }
        this.PreFrame(this.pNet);
        while (this.pNet.gNetFifoHead[Mmulti.myconnectindex] - this.pNet.gNetFifoTail > this.pNet.bufferJitter && !this.game.gExit) {
            short i = Mmulti.connecthead;
            while (i >= 0 && this.pNet.gNetFifoTail != this.pNet.gNetFifoHead[i]) {
                i = Mmulti.connectpoint2[i];
            }
            if (i >= 0) break;
            GameAdapter gameAdapter = this;
            synchronized (gameAdapter) {
                this.pEngine.faketimerhandler();
                this.ProcessFrame(this.pNet);
            }
        }
        this.pNet.CheckSync();
        float smoothratio = 65536.0f;
        if (!(this.game.gPaused || this.game.nNetMode == BuildGame.NetMode.Single && (this.pMenu.gShowMenu || Console.IsShown()) || !((smoothratio = (float)this.pEngine.getsmoothratio()) < 0.0f) && !(smoothratio > 65536.0f))) {
            smoothratio = Gameutils.BClipRange(smoothratio, 0.0f, 65536.0f);
        }
        this.game.pInt.dointerpolations(smoothratio);
        this.DrawWorld(smoothratio);
        if (this.gScreenCapture != null) {
            this.gScreenCapture.run();
            this.gScreenCapture = null;
        }
        this.DrawHud(smoothratio);
        this.game.pInt.restoreinterpolations();
        if (this.pMenu.gShowMenu) {
            this.pMenu.mDrawMenu();
        }
        this.PostFrame(this.pNet);
        if (this.pCfg.gShowFPS) {
            this.pEngine.printfps(this.pCfg.gFpsScale);
        }
        this.pEngine.sampletimer();
        this.pEngine.nextpage();
        this.game.pInt.clearinterpolations();
    }

    public void capture(final int width, final int height) {
        this.gScreenCapture = new Runnable(){

            @Override
            public void run() {
                GameAdapter.this.captBuffer = GameAdapter.this.pEngine.getrender().screencapture(width, height);
            }
        };
    }

    public boolean isScreenSaving() {
        return this.gScreenCapture != null;
    }

    @Override
    public void pause() {
        if (this.game.nNetMode == BuildGame.NetMode.Single && Mmulti.numplayers < 2) {
            this.game.gPaused = true;
            this.sndHandlePause(this.game.gPaused);
        }
        if (BuildGdx.graphics.getFrameType() == BuildFrame.FrameType.GL) {
            BuildGdx.graphics.extra(BuildGraphics.Option.GLDefConfiguration, new Object[0]);
        }
    }

    @Override
    public void resume() {
        if (this.game.nNetMode == BuildGame.NetMode.Single && Mmulti.numplayers < 2) {
            this.game.gPaused = false;
            this.pNet.ototalclock = Engine.totalclock;
            this.sndHandlePause(this.game.gPaused);
        }
        this.game.updateColorCorrection();
    }
}

