/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.ScreenAdapter;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Settings.BuildConfig;

public abstract class MenuAdapter
extends ScreenAdapter {
    protected BuildGame game;
    protected MenuHandler menu;
    protected Engine engine;
    protected BuildConfig cfg;
    protected BuildMenu mainMenu;

    public abstract void draw(float var1);

    public void process(float delta) {
    }

    public MenuAdapter(BuildGame game, BuildMenu mainMenu) {
        this.game = game;
        this.menu = game.pMenu;
        this.engine = game.pEngine;
        this.cfg = game.pCfg;
        this.mainMenu = mainMenu;
    }

    @Override
    public void render(float delta) {
        if (!this.engine.getrender().isInited()) {
            return;
        }
        this.engine.clearview(0);
        this.engine.sampletimer();
        this.draw(delta);
        this.engine.handleevents();
        if (this.menu.gShowMenu) {
            this.menu.mKeyHandler(this.game.pInput, delta);
            this.menu.mDrawMenu();
        } else if (this.game.pInput.ctrlGetInputKey(BuildConfig.GameKeys.Menu_Toggle, true)) {
            this.menu.mOpen(this.mainMenu, -1);
        }
        this.process(delta);
        if (this.cfg.gShowFPS) {
            this.engine.printfps(this.cfg.gFpsScale);
        }
        this.engine.nextpage();
    }

    @Override
    public void pause() {
        if (BuildGdx.graphics.getFrameType() == BuildFrame.FrameType.GL) {
            BuildGdx.graphics.extra(BuildGraphics.Option.GLDefConfiguration, new Object[0]);
        }
    }

    @Override
    public void resume() {
        this.game.updateColorCorrection();
    }
}

