/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.Tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;

public class SaveManager {
    private final List<SaveInfo> SavList = new ArrayList<SaveInfo>();
    private final HashMap<String, SaveInfo> SavHash = new HashMap();
    public static final int Screenshot = Engine.MAXTILES - 1;

    public SaveInfo getSlot(int num) {
        return this.SavList.get(num);
    }

    public List<SaveInfo> getList() {
        return this.SavList;
    }

    public void add(String savname, long time, String filename) {
        SaveInfo info = this.SavHash.get(filename);
        if (info == null) {
            info = new SaveInfo(savname, time, filename);
            this.SavList.add(0, info);
            this.SavHash.put(filename, info);
        } else {
            this.SavList.remove(info);
            info.update(savname, time, filename);
            this.SavList.add(0, info);
        }
    }

    public void delete(String filename) {
        File file;
        SaveInfo info = this.SavHash.get(filename);
        if (info != null && (file = BuildGdx.compat.checkFile(filename, Compat.Path.User)) != null && file.delete()) {
            this.SavList.remove(info);
            BuildGdx.compat.getDirectory(Compat.Path.User).checkCacheList();
        }
    }

    public String getLast() {
        if (this.SavList.size() > 0) {
            return this.SavList.get((int)0).filename;
        }
        return null;
    }

    public void sort() {
        Collections.sort(this.SavList);
    }

    public class SaveInfo
    implements Comparable<SaveInfo> {
        public String name;
        public long time;
        public String filename;

        public SaveInfo(String name, long time, String filename) {
            this.name = name;
            this.time = time;
            this.filename = filename;
        }

        public void update(String name, long time, String filename) {
            this.name = name;
            this.time = time;
            this.filename = filename;
        }

        @Override
        public int compareTo(SaveInfo obj) {
            return obj.time < this.time ? -1 : 1;
        }
    }
}

