/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;

public class GLFog {
    protected int FOGDISTCONST = 48;
    protected final float FULLVIS_BEGIN = 2.9E30f;
    protected final float FULLVIS_END = 3.0E30f;
    public int shade;
    public int pal;
    public float combvis;
    public boolean nofog;
    public boolean isEnabled;
    protected TextureManager manager;
    protected final float[] color = new float[4];
    protected float start;
    protected float end;
    protected float curstart;
    protected float curend;
    protected float[] curcolor = new float[4];

    public void init(TextureManager manager) {
        if (BuildGdx.graphics.getGLVersion().getVendorString().compareTo("NVIDIA Corporation") == 0) {
            BuildGdx.gl.glHint(3156, 4354);
        } else {
            BuildGdx.gl.glHint(3156, 4352);
        }
        BuildGdx.gl.glFogi(2917, 9729);
        this.manager = manager;
    }

    public void copy(GLFog src) {
        this.shade = src.shade;
        this.combvis = src.combvis;
        this.pal = src.pal;
    }

    public void clear() {
        this.shade = 0;
        this.combvis = 0.0f;
        this.pal = 0;
    }

    public void calc() {
        if (this.combvis == 0.0f) {
            this.start = 2.9E30f;
            this.end = 3.0E30f;
        } else if (this.shade >= Engine.numshades - 1) {
            this.start = -1.0f;
            this.end = 0.001f;
        } else {
            this.start = this.shade > 0 ? 0.0f : (float)(-(this.FOGDISTCONST * this.shade)) / this.combvis;
            this.end = (float)(this.FOGDISTCONST * (Engine.numshades - 1 - this.shade)) / this.combvis;
        }
        this.color[0] = (float)Engine.palookupfog[this.pal][0] / 63.0f;
        this.color[1] = (float)Engine.palookupfog[this.pal][1] / 63.0f;
        this.color[2] = (float)Engine.palookupfog[this.pal][2] / 63.0f;
        this.color[3] = 1.0f;
        BuildGdx.gl.glFogfv(2918, this.color, 0);
        BuildGdx.gl.glFogf(2915, this.start);
        BuildGdx.gl.glFogf(2916, this.end);
    }

    public void setFogScale(int var) {
        this.FOGDISTCONST = var;
    }

    public void apply() {
    }

    public void enable() {
        if (!this.nofog) {
            this.isEnabled = true;
            BuildGdx.gl.glEnable(2912);
        }
    }

    public void disable() {
        this.isEnabled = false;
        BuildGdx.gl.glDisable(2912);
    }
}

