/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.GdxRender.GDXRenderer;
import ru.m210projects.Build.Render.GdxRender.Shaders.ShaderManager;
import ru.m210projects.Build.Render.ModelHandle.GLModel;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2ModelGL20;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3ModelGL20;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDSkinmap;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.ModelHandle.ModelManager;
import ru.m210projects.Build.Render.ModelHandle.Voxel.GLVoxel;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelGL20;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelSkin;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.Hicreplctyp;
import ru.m210projects.Build.Render.TextureHandle.IndexedShader;
import ru.m210projects.Build.Render.TextureHandle.PixmapTileData;
import ru.m210projects.Build.Render.TextureHandle.TileData;

public class GDXModelManager
extends ModelManager {
    private final GDXRenderer parent;

    public GDXModelManager(GDXRenderer parent) {
        this.parent = parent;
    }

    @Override
    public GLVoxel allocateVoxel(VoxelData vox, int voxmip, int flags) {
        return new VoxelGL20(vox, voxmip, flags){

            @Override
            public GLTile getSkin(int pal) {
                TileData.PixelFormat fmt = GDXModelManager.this.parent.getTexFormat();
                if (Engine.palookup[pal] == null || fmt == TileData.PixelFormat.Pal8) {
                    pal = 0;
                }
                if (this.texid[pal] == null) {
                    long startticks = System.nanoTime();
                    VoxelSkin dat = new VoxelSkin(fmt, this.skinData, pal);
                    GLTile dst = ((GDXModelManager)GDXModelManager.this).parent.textureCache.newTile(dat, pal, false);
                    dst.unsafeSetFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest, true);
                    dst.unsafeSetAnisotropicFilter(1.0f, true);
                    this.texid[pal] = dst;
                    long etime = System.nanoTime() - startticks;
                    System.out.println("Load voxskin: p" + pal + " for tile " + GDXModelManager.this.getTile(this) + "... " + (float)etime / 1000000.0f + " ms");
                }
                return this.texid[pal];
            }

            @Override
            public void setTextureParameters(GLTile tile, int pal, int shade, int visibility, float alpha) {
                if (tile.getPixelFormat() == TileData.PixelFormat.Pal8) {
                    ((GDXModelManager)GDXModelManager.this).parent.manager.textureTransform(((GDXModelManager)GDXModelManager.this).parent.texture_transform.idt(), 0);
                    ((GDXModelManager)GDXModelManager.this).parent.manager.textureParams8(pal, shade, alpha, true);
                    ((IndexedShader)((GDXModelManager)GDXModelManager.this).parent.manager.getProgram()).setVisibility((int)((float)(-visibility) / 64.0f));
                } else {
                    ((GDXModelManager)GDXModelManager.this).parent.manager.color(1.0f, 1.0f, 1.0f, alpha);
                    GDXModelManager.this.parent.calcFog(pal, shade, visibility);
                }
            }

            @Override
            public ShaderProgram getShader() {
                return ((GDXModelManager)GDXModelManager.this).parent.manager.getProgram();
            }
        };
    }

    @Override
    public GLModel allocateModel(ModelInfo modelInfo) {
        switch (modelInfo.getType()) {
            case Md2: {
                return new MD2ModelGL20((MD2Info)modelInfo){

                    @Override
                    public ShaderProgram getShader() {
                        return ((GDXModelManager)GDXModelManager.this).parent.manager.getProgram();
                    }

                    @Override
                    protected int bindSkin(int pal, int skinnum) {
                        return GDXModelManager.this.bindMDSkin(this, pal, skinnum, 0);
                    }

                    @Override
                    protected GLTile loadTexture(String skinfile, int palnum) {
                        return GDXModelManager.this.loadMDTexture(this, skinfile, palnum);
                    }
                };
            }
            case Md3: {
                return new MD3ModelGL20((MD3Info)modelInfo){

                    @Override
                    public ShaderProgram getShader() {
                        return ((GDXModelManager)GDXModelManager.this).parent.manager.getProgram();
                    }

                    @Override
                    protected int bindSkin(int pal, int skinnum, int surfnum) {
                        return GDXModelManager.this.bindMDSkin(this, pal, skinnum, surfnum);
                    }

                    @Override
                    protected GLTile loadTexture(String skinfile, int palnum) {
                        return GDXModelManager.this.loadMDTexture(this, skinfile, palnum);
                    }
                };
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GLTile loadMDTexture(MDModel m, String skinfile, int palnum) {
        GLTile texidx = this.findLoadedMultitexture(skinfile, palnum);
        if (texidx != null) {
            return texidx;
        }
        Resource res = BuildGdx.cache.open(skinfile, 0);
        if (res == null) {
            Console.Println("Skin " + skinfile + " not found.", Console.OSDTEXT_YELLOW);
            return null;
        }
        try {
            byte[] data = res.getBytes();
            Pixmap pix = new Pixmap(data, 0, data.length);
            texidx = this.parent.textureCache.newTile(new PixmapTileData(pix, true, 0), 0, true);
            if (palnum == 255 || palnum == 254) {
                texidx.setHighTile(new Hicreplctyp(palnum));
            }
            m.usesalpha = true;
        }
        catch (Exception e) {
            Console.Println("Couldn't load file: " + skinfile, Console.OSDTEXT_YELLOW);
            GLTile gLTile = null;
            return gLTile;
        }
        finally {
            res.close();
        }
        texidx.setupTextureWrap(Texture.TextureWrap.Repeat);
        return texidx;
    }

    protected int bindMDSkin(MDModel m, int pal, int skinnum, int surfnum) {
        int texunits = -1;
        GLTile texid = m.getSkin(pal, skinnum, surfnum);
        if (texid != null) {
            this.parent.textureCache.bind(texid);
            if (this.parent.manager.getShader() == null || this.parent.isSkyShader() || texid.getPixelFormat() != this.parent.manager.getPixelFormat()) {
                this.parent.switchShader(texid.getPixelFormat() != TileData.PixelFormat.Pal8 ? ShaderManager.Shader.RGBWorldShader : ShaderManager.Shader.IndexedWorldShader);
            }
            texunits = 33984;
        }
        return texunits;
    }

    protected GLTile findLoadedMultitexture(String skinfile, int palnum) {
        if (palnum >= 252) {
            for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
                GLModel m = this.models[i];
                if (!(m instanceof MDModel)) continue;
                MDSkinmap sk = ((MDModel)m).skinmap;
                while (sk != null) {
                    if (sk.fn.equalsIgnoreCase(skinfile) && sk.texid != null) {
                        if (sk.palette != palnum) {
                            GLTile texidx = sk.texid.clone();
                            if (palnum == 255 || palnum == 254) {
                                texidx.setHighTile(new Hicreplctyp(palnum));
                                texidx.update(null, palnum, true);
                                return texidx;
                            }
                        }
                        return sk.texid;
                    }
                    sk = sk.next;
                }
            }
        }
        return null;
    }
}

