/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.math.Matrix4;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.GDXRenderer;
import ru.m210projects.Build.Render.GdxRender.Shaders.ShaderManager;
import ru.m210projects.Build.Render.ModelHandle.GLModel;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.ModelHandle.Voxel.GLVoxel;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.Palette;
import ru.m210projects.Build.Render.Types.Spriteext;
import ru.m210projects.Build.Render.Types.Tile2model;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;

public class GDXModelRenderer {
    private final Matrix4 transform = new Matrix4();
    private final GDXRenderer parent;
    private final Engine engine;

    public GDXModelRenderer(GDXRenderer parent) {
        this.parent = parent;
        this.engine = parent.engine;
    }

    public boolean mddraw(GLModel m, SPRITE tspr) {
        float b;
        boolean isFloorAligned;
        if (m == null) {
            return false;
        }
        boolean bl = isFloorAligned = (tspr.cstat & 0x30) == 32;
        if (m.getType() == ModelInfo.Type.Voxel && isFloorAligned) {
            return false;
        }
        ShaderManager.Shader shader = ShaderManager.Shader.RGBWorldShader;
        if (m.getType() == ModelInfo.Type.Voxel && this.parent.getTexFormat() == TileData.PixelFormat.Pal8) {
            shader = ShaderManager.Shader.IndexedWorldShader;
        }
        this.parent.switchShader(shader);
        DefScript defs = this.parent.defs;
        ShaderManager manager = this.parent.manager;
        Matrix4 transport = this.prepareTransform(m, tspr);
        if (m.getType() == ModelInfo.Type.Voxel) {
            GLVoxel vox = (GLVoxel)m;
            this.transform.translate(-vox.xpiv / 64.0f, -vox.ypiv / 64.0f, -vox.zpiv / 64.0f);
            if (isFloorAligned) {
                this.transform.rotate(-1.0f, 0.0f, 0.0f, 90.0f);
                this.transform.translate(0.0f, -vox.ypiv / 64.0f, -vox.zpiv / 64.0f);
            }
        } else if (m instanceof MDModel) {
            ((MDModel)m).updateanimation(defs.mdInfo, tspr);
            if (m.getType() == ModelInfo.Type.Md3) {
                this.transform.scale(0.015625f, 0.015625f, -0.015625f);
            }
        }
        manager.transform(transport);
        manager.frustum(null);
        byte shade = tspr.shade;
        int pal = tspr.pal & 0xFF;
        float alpha = 1.0f;
        float g = b = (float)(Engine.numshades - Math.min(Math.max(shade, 0), Engine.numshades)) / (float)Engine.numshades;
        float r = b;
        if (this.parent.defs != null) {
            Palette p = this.parent.defs.texInfo.getTints(pal);
            r *= (float)p.r / 255.0f;
            g *= (float)p.g / 255.0f;
            b *= (float)p.b / 255.0f;
        }
        if ((tspr.cstat & 2) != 0) {
            alpha = (tspr.cstat & 0x200) == 0 ? Engine.TRANSLUSCENT1 : Engine.TRANSLUSCENT2;
        }
        manager.color(r, g, b, alpha);
        manager.textureTransform(this.parent.texture_transform.idt(), 0);
        int vis = this.getVisibility(tspr);
        if (m.getType() != ModelInfo.Type.Voxel) {
            this.parent.calcFog(pal, shade, vis);
        }
        BuildGdx.gl.glEnable(3042);
        Tile2model t2m = defs.mdInfo.getParams(tspr.picnum);
        m.render(pal, shade, t2m != null ? t2m.skinnum : 0, vis, alpha);
        BuildGdx.gl.glFrontFace(2304);
        return true;
    }

    private int getVisibility(SPRITE tspr) {
        int vis = Engine.globalvisibility;
        if (Engine.sector[tspr.sectnum].visibility != 0) {
            vis = Pragmas.mulscale(Engine.globalvisibility, Engine.sector[tspr.sectnum].visibility + 16 & 0xFF, 4);
        }
        return vis;
    }

    private Matrix4 prepareTransform(GLModel m, SPRITE tspr) {
        BuildCamera cam = this.parent.cam;
        Tile pic = this.engine.getTile(tspr.picnum);
        short orientation = tspr.cstat;
        boolean xflip = (orientation & 4) != 0;
        boolean yflip = (orientation & 8) != 0;
        boolean isWallAligned = (orientation & 0x30) == 16;
        boolean isFloorAligned = (orientation & 0x30) == 32;
        float xoff = tspr.xoffset;
        float yoff = yflip ? (float)(-tspr.yoffset) : (float)tspr.yoffset;
        float posx = tspr.x;
        float posy = tspr.y;
        float posz = tspr.z;
        if (m.getType() == ModelInfo.Type.Voxel) {
            GLVoxel vox = (GLVoxel)m;
            if ((orientation & 0x80) == 0) {
                posz -= (float)(vox.zsiz * tspr.yrepeat << 1);
            }
            if (yflip && (orientation & 0x10) == 0) {
                posz += ((float)pic.getHeight() * 0.5f - vox.zpiv) * (float)tspr.yrepeat * 8.0f;
            }
        } else {
            if ((orientation & 0x80) != 0 && !isFloorAligned) {
                posz += (float)(pic.getHeight() * tspr.yrepeat << 1);
            }
            if (yflip) {
                posz -= (float)(pic.getHeight() * tspr.yrepeat << 2);
            }
        }
        float f = (float)tspr.xrepeat / 32.0f * m.getScale();
        float g = (float)tspr.yrepeat / 32.0f * m.getScale();
        if (!isWallAligned && !isFloorAligned) {
            f *= 0.8f;
        }
        this.transform.setToTranslation(posx / cam.xscale, posy / cam.xscale, posz / cam.yscale);
        float yoffset = 0.0f;
        if (m instanceof MDModel) {
            MDModel md = (MDModel)m;
            this.transform.translate(0.0f, 0.0f, -md.getYOffset(false) * g);
            yoffset = md.getYOffset(true);
        }
        this.transform.scale(f, f, yflip ? -g : g);
        Spriteext sprext = this.parent.defs.mapInfo.getSpriteInfo(tspr.owner);
        float ang = tspr.ang + (sprext != null ? sprext.angoff : (short)0);
        this.transform.rotate(0.0f, 0.0f, 1.0f, (float)Gameutils.AngleToDegrees(ang));
        this.transform.scale(isFloorAligned ? -1.0f : 1.0f, xflip ^ isFloorAligned ? -1.0f : 1.0f, 1.0f);
        if (m.getType() == ModelInfo.Type.Voxel) {
            this.transform.rotate(0.0f, 0.0f, -1.0f, 90.0f);
        }
        this.transform.translate(-xoff / 64.0f, 0.0f, -yoff / 64.0f - yoffset);
        if (m.isRotating()) {
            this.transform.rotate(0.0f, 0.0f, -1.0f, Engine.totalclock % 360);
        }
        if (m instanceof MDModel) {
            this.transform.scale(0.01f, 0.01f, 0.01f);
            this.transform.rotate(1.0f, 0.0f, 0.0f, -90.0f);
        }
        BuildGdx.gl.glEnable(2884);
        if (yflip ^ xflip) {
            BuildGdx.gl.glFrontFace(m.getType() != ModelInfo.Type.Md2 ? 2305 : 2304);
        } else {
            BuildGdx.gl.glFrontFace(m.getType() != ModelInfo.Type.Md2 ? 2304 : 2305);
        }
        return this.transform;
    }
}

