/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Scanner;

import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.GdxRender.Pool;
import ru.m210projects.Build.Render.GdxRender.Scanner.WallFrustum2d;
import ru.m210projects.Build.Types.LinkedList;
import ru.m210projects.Build.Types.RuntimeArray;
import ru.m210projects.Build.Types.WALL;

public class RayCaster {
    protected List<Segment> segments = new ArrayList<Segment>();
    protected RuntimeArray<EndPoint> endpoints = new RuntimeArray();
    protected LinkedList<Segment> open = new LinkedList();
    protected byte[] gotwall = new byte[Engine.MAXWALLS >> 3];
    protected byte[] handled = new byte[Engine.MAXWALLS >> 3];
    protected boolean globalcheck;
    private final Pool<Segment> pSegmentPool = new Pool<Segment>(){

        @Override
        protected Segment newObject() {
            return new Segment();
        }
    };
    private final Pool<EndPoint> pEndpointPool = new Pool<EndPoint>(){

        @Override
        protected EndPoint newObject() {
            return new EndPoint();
        }
    };
    protected Comparator<EndPoint> comparator = new Comparator<EndPoint>(){

        @Override
        public int compare(EndPoint a, EndPoint b) {
            if (a.angle != b.angle) {
                return a.angle > b.angle ? 1 : -1;
            }
            if (a.begin != b.begin) {
                return !a.begin && b.begin ? 1 : -1;
            }
            return 0;
        }
    };
    protected Comparator<Segment> wallfront = new Comparator<Segment>(){

        @Override
        public int compare(Segment o1, Segment o2) {
            if (!RayCaster.this.wallfront(o1, o2)) {
                return -1;
            }
            return 0;
        }
    };

    public void init(boolean globalcheck) {
        this.segments.clear();
        this.endpoints.clear();
        Gameutils.fill(this.gotwall, 0);
        Gameutils.fill(this.handled, 0);
        this.globalcheck = globalcheck;
        this.pSegmentPool.reset();
        this.pEndpointPool.reset();
    }

    public boolean wallfront(Segment a, Segment b) {
        double cross3;
        boolean t2;
        float x11 = a.p1.x;
        float y11 = a.p1.y;
        float x21 = a.p2.x;
        float y21 = a.p2.y;
        float x12 = b.p1.x;
        float y12 = b.p1.y;
        float x22 = b.p2.x;
        float y22 = b.p2.y;
        float dx = x21 - x11;
        float dy = y21 - y11;
        double f = 0.001;
        double invf = 0.999;
        double py = (double)y12 * 0.999 + (double)y22 * 0.001;
        double px = (double)x12 * 0.999 + (double)x22 * 0.001;
        double cross = (double)dx * (py - (double)y11) - (double)dy * (px - (double)x11);
        boolean t1 = cross < 1.0E-5;
        px = (double)x22 * 0.999 + (double)x12 * 0.001;
        py = (double)y22 * 0.999 + (double)y12 * 0.001;
        double cross1 = (double)dx * (py - (double)y11) - (double)dy * (px - (double)x11);
        boolean bl = t2 = cross1 < 1.0E-5;
        if (t1 == t2) {
            boolean bl2 = t1 = (double)(dx * ((float)Engine.globalposy - y11) - dy * ((float)Engine.globalposx - x11)) < 1.0E-5;
            if (t2 == t1) {
                return true;
            }
        }
        t1 = (cross3 = (double)(dx = x22 - x12) * ((py = (double)y11 * 0.999 + (double)y21 * 0.001) - (double)y12) - (double)(dy = y22 - y12) * ((px = (double)x11 * 0.999 + (double)x21 * 0.001) - (double)x12)) < 1.0E-5;
        px = (double)x21 * 0.999 + (double)x11 * 0.001;
        py = (double)y21 * 0.999 + (double)y11 * 0.001;
        double cross4 = (double)dx * (py - (double)y12) - (double)dy * (px - (double)x12);
        boolean bl3 = t2 = cross4 < 1.0E-5;
        if (t1 == t2) {
            if (this.globalcheck && Math.abs(cross) < 1.0E-5 && Math.abs(cross1) < 1.0E-5 && Math.abs(cross3) < 1.0E-5 && Math.abs(cross4) < 1.0E-5 && a.isPortal() && !b.isPortal()) {
                return false;
            }
            t1 = (double)(dx * ((float)Engine.globalposy - y12) - dy * ((float)Engine.globalposx - x12)) < 1.0E-5;
            return t2 != t1;
        }
        return false;
    }

    public Segment addSegment(int id, float x1, float y1, float x2, float y2) {
        EndPoint p1 = this.pEndpointPool.obtain();
        EndPoint p2 = this.pEndpointPool.obtain();
        Segment segment = this.pSegmentPool.obtain();
        p1.x = x1;
        p1.y = y1;
        p2.x = x2;
        p2.y = y2;
        p1.segment = segment;
        p2.segment = segment;
        segment.p1 = p1;
        segment.p2 = p2;
        segment.wallid = id;
        segment.index = this.segments.size();
        this.segments.add(segment);
        this.endpoints.add(p1);
        this.endpoints.add(p2);
        int n = id >> 3;
        this.handled[n] = (byte)(this.handled[n] | Engine.pow2char[id & 7]);
        return segment;
    }

    public void update() {
        for (int i = 0; i < this.segments.size(); ++i) {
            Segment segment = this.segments.get(i);
            segment.p1.angle = this.atan2(segment.p1.y - (float)Engine.globalposy, segment.p1.x - (float)Engine.globalposx);
            segment.p2.angle = this.atan2(segment.p2.y - (float)Engine.globalposy, segment.p2.x - (float)Engine.globalposx);
            float dAngle = segment.p2.angle - segment.p1.angle;
            if (dAngle <= -2.0f) {
                dAngle += 4.0f;
            }
            if (dAngle > 2.0f) {
                dAngle -= 4.0f;
            }
            segment.p1.begin = (double)dAngle > 0.0;
            segment.p2.begin = !segment.p1.begin;
        }
        this.sweep();
    }

    public float atan2(float dx, float dy) {
        float len = (float)Math.sqrt(dx * dx + dy * dy);
        if (len == 0.0f) {
            return 0.0f;
        }
        dx /= len;
        if (dy >= 0.0f) {
            return dx;
        }
        if (dx >= 0.0f) {
            return 2.0f - dx;
        }
        return -(2.0f + dx);
    }

    public void add(int z, WallFrustum2d frust) {
        WALL wal = Engine.wall[z];
        WALL wal2 = Engine.wall[wal.point2];
        if (frust == null || frust.sectnum == Engine.globalcursectnum) {
            this.addSegment(z, wal.x, wal.y, wal2.x, wal2.y);
        } else {
            WallFrustum2d f = frust;
            do {
                if (f.isGreater180()) {
                    this.addSegment(z, wal.x, wal.y, wal2.x, wal2.y);
                    continue;
                }
                this.addClippedSegment(f, z);
            } while ((f = f.next) != null);
        }
    }

    public void addClippedSegment(WallFrustum2d frustum, int z) {
        Plane[] planes = frustum.planes;
        WALL p1 = Engine.wall[z];
        WALL p2 = Engine.wall[p1.point2];
        float p1x = p1.x;
        float p1y = p1.y;
        float p2x = p2.x;
        float p2y = p2.y;
        for (int i = 0; i < 2; ++i) {
            Vector3 p = planes[i].normal;
            float t1 = p.dot(p1x - (float)Engine.globalposx, p1y - (float)Engine.globalposy, 0.0f);
            float t2 = p.dot(p2x - (float)Engine.globalposx, p2y - (float)Engine.globalposy, 0.0f);
            if (t1 < 1.0E-4f && t2 < 1.0E-4f) {
                float angle1 = this.atan2(p1y - (float)Engine.globalposy, p1x - (float)Engine.globalposx);
                float angle2 = this.atan2(p2y - (float)Engine.globalposy, p2x - (float)Engine.globalposx);
                float dAngle = angle2 - angle1;
                if (dAngle >= 0.01f) {
                    int n = z >> 3;
                    this.handled[n] = (byte)(this.handled[n] | Engine.pow2char[z & 7]);
                }
                return;
            }
            if (t1 >= -1.0E-4f == t2 >= -1.0E-4f) continue;
            float r = t1 / (t1 - t2);
            float dx = p2x - p1x;
            float dy = p2y - p1y;
            if (t1 >= -1.0E-4f) {
                p2x = (float)Math.ceil(dx * r + p1x);
                p2y = (float)Math.ceil(dy * r + p1y);
                continue;
            }
            p1x = (float)Math.ceil(dx * r + p1x);
            p1y = (float)Math.ceil(dy * r + p1y);
        }
        this.addSegment(z, p1x, p1y, p2x, p2y);
    }

    public boolean check(int z) {
        if ((this.handled[z >> 3] & Engine.pow2char[z & 7]) == 0) {
            return true;
        }
        return (this.gotwall[z >> 3] & Engine.pow2char[z & 7]) != 0;
    }

    protected void sweep() {
        this.endpoints.sort(this.comparator);
        this.open.clear();
        for (int i = 0; i < 2; ++i) {
            for (int pi = 0; pi < this.endpoints.size(); ++pi) {
                EndPoint p = this.endpoints.get(pi);
                Segment current_old = this.open.getFirst();
                while (current_old != null && current_old.isPortal()) {
                    if (i == 1) {
                        int n = current_old.wallid >> 3;
                        this.gotwall[n] = (byte)(this.gotwall[n] | Engine.pow2char[current_old.wallid & 7]);
                    }
                    this.open.remove(current_old);
                    current_old = this.open.getFirst();
                }
                if (p.begin) {
                    this.open.add(p.segment, this.wallfront);
                } else {
                    this.open.remove(p.segment);
                }
                if (current_old == this.open.getFirst() || i != 1 || current_old == null) continue;
                int z = current_old.wallid;
                int n = z >> 3;
                this.gotwall[n] = (byte)(this.gotwall[n] | Engine.pow2char[z & 7]);
            }
        }
    }

    public class Segment
    extends LinkedList.Node<Segment>
    implements Pool.Poolable {
        public EndPoint p1;
        public EndPoint p2;
        public int wallid;
        public int index;

        @Override
        public Segment getValue() {
            return this;
        }

        public boolean isPortal() {
            return Engine.wall[this.wallid].nextsector != -1;
        }

        @Override
        public void reset() {
            this.p2 = null;
            this.p1 = null;
            this.prev = null;
            this.next = null;
            this.index = 0;
            this.wallid = 0;
        }
    }

    public class EndPoint {
        public float x;
        public float y;
        public boolean begin;
        public Segment segment;
        public float angle;
    }
}

