/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Scanner;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.Pool;
import ru.m210projects.Build.Render.GdxRender.Scanner.PolygonClipper;
import ru.m210projects.Build.Render.GdxRender.Scanner.PotentiallyVisibleSet;
import ru.m210projects.Build.Render.GdxRender.Scanner.VisibleSector;
import ru.m210projects.Build.Render.GdxRender.Scanner.WallFrustum3d;
import ru.m210projects.Build.Render.GdxRender.Tesselator;
import ru.m210projects.Build.Render.GdxRender.WorldMesh;
import ru.m210projects.Build.Types.QuickSort;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public abstract class SectorScanner {
    private final Pool<WallFrustum3d> pFrustumPool = new Pool<WallFrustum3d>(){

        @Override
        protected WallFrustum3d newObject() {
            return new WallFrustum3d();
        }
    };
    private final Pool<VisibleSector> pSectorPool = new Pool<VisibleSector>(){

        @Override
        protected VisibleSector newObject() {
            return new VisibleSector();
        }
    };
    private final Vector2 projPoint = new Vector2();
    private final PotentiallyVisibleSet pvs;
    private final WallFrustum3d[] portqueue;
    private final int queuemask;
    private int pqhead;
    private int pqtail;
    private final VisibleSector[] handled;
    private final WallFrustum3d[] gotviewport;
    private final WallFrustum3d[] skyviewport;
    private final byte[] gotwall;
    private final byte[] wallflags;
    protected Engine engine;
    public int[] maskwall = new int[Engine.MAXWALLS];
    public int maskwallcnt;
    private SECTOR skyFloor;
    private SECTOR skyCeiling;
    private final PolygonClipper cl = new PolygonClipper();
    protected QuickSort.IntComparator wallcomp = new QuickSort.IntComparator(){

        @Override
        public int compare(int o1, int o2) {
            if (!SectorScanner.this.wallfront(Engine.wall[o1], Engine.wall[o2])) {
                return -1;
            }
            return 0;
        }
    };
    private static final Vector3[] tmpVec = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};

    public SectorScanner(Engine engine) {
        this.engine = engine;
        this.pvs = new PotentiallyVisibleSet();
        this.portqueue = new WallFrustum3d[512];
        this.queuemask = this.portqueue.length - 1;
        Engine.tsprite = new SPRITE[1025];
        this.gotviewport = new WallFrustum3d[Engine.MAXSECTORS];
        this.skyviewport = new WallFrustum3d[Engine.MAXSECTORS];
        this.handled = new VisibleSector[Engine.MAXSECTORS];
        this.gotwall = new byte[Engine.MAXWALLS >> 3];
        this.wallflags = new byte[Engine.MAXWALLS];
    }

    public void init() {
        this.pvs.info.init(this.engine);
    }

    public void clear() {
        this.pSectorPool.reset();
        this.pFrustumPool.reset();
    }

    public void process(ArrayList<VisibleSector> sectors, BuildCamera cam, WorldMesh mesh, int sectnum) {
        VisibleSector sec;
        WallFrustum3d pFrustum;
        if (!Gameutils.isValidSector(sectnum)) {
            return;
        }
        this.pvs.process(cam, mesh, sectnum);
        Arrays.fill(this.gotviewport, null);
        Gameutils.fill(this.gotwall, 0);
        Gameutils.fill(this.wallflags, 0);
        Arrays.fill(this.handled, null);
        this.skyCeiling = null;
        this.skyFloor = null;
        this.maskwallcnt = 0;
        Engine.spritesortcnt = 0;
        this.pqtail = 0;
        this.pqhead = 0;
        int cursectnum = sectnum;
        this.portqueue[this.pqtail++ & this.queuemask] = this.pFrustumPool.obtain().set(cam, sectnum);
        this.gotviewport[sectnum] = pFrustum = this.portqueue[this.pqhead];
        while (this.pqhead != this.pqtail) {
            sectnum = pFrustum.sectnum;
            sec = this.handled[sectnum];
            if (this.handled[sectnum] == null) {
                sec = this.pSectorPool.obtain().set(sectnum);
            }
            if (!pFrustum.handled) {
                pFrustum.handled = true;
                int startwall = Engine.sector[sectnum].wallptr;
                int endwall = Engine.sector[sectnum].wallnum + startwall;
                for (int z = startwall; z < endwall; ++z) {
                    WALL wal = Engine.wall[z];
                    if (!this.pvs.checkWall(z)) continue;
                    short nextsectnum = wal.nextsector;
                    if (!pFrustum.wallInFrustum(mesh.getPoints(WorldMesh.Heinum.Max, sectnum, z))) continue;
                    int n = z >> 3;
                    this.gotwall[n] = (byte)(this.gotwall[n] | Engine.pow2char[z & 7]);
                    if (Engine.sector[sectnum].isParallaxFloor() && (nextsectnum == -1 || !Engine.sector[nextsectnum].isParallaxFloor()) && pFrustum.wallInFrustum(mesh.getPoints(WorldMesh.Heinum.SkyLower, sectnum, z))) {
                        int n2 = z;
                        this.wallflags[n2] = (byte)(this.wallflags[n2] | 8);
                    }
                    if (Engine.sector[sectnum].isParallaxCeiling() && (nextsectnum == -1 || !Engine.sector[nextsectnum].isParallaxCeiling()) && pFrustum.wallInFrustum(mesh.getPoints(WorldMesh.Heinum.SkyUpper, sectnum, z))) {
                        int n3 = z;
                        this.wallflags[n3] = (byte)(this.wallflags[n3] | 0x10);
                    }
                    if (nextsectnum == -1) continue;
                    if (!this.checkWallRange(nextsectnum, wal.nextwall)) {
                        int gap;
                        short theline = wal.nextwall;
                        short i = (short)gap;
                        for (gap = Engine.numsectors >> 1; gap > 1; gap >>= 1) {
                            if (Engine.sector[i].wallptr < theline) {
                                i = (short)(i + gap);
                                continue;
                            }
                            i = (short)(i - gap);
                        }
                        while (Engine.sector[i].wallptr > theline) {
                            i = (short)(i - 1);
                        }
                        while (Engine.sector[i].wallptr + Engine.sector[i].wallnum <= theline) {
                            i = (short)(i + 1);
                        }
                        nextsectnum = i;
                        System.err.println("Error on " + i);
                        wal.nextsector = i;
                    }
                    if (pFrustum.wallInFrustum(mesh.getPoints(WorldMesh.Heinum.Lower, sectnum, z))) {
                        int n4 = z;
                        this.wallflags[n4] = (byte)(this.wallflags[n4] | 1);
                    }
                    if (pFrustum.wallInFrustum(mesh.getPoints(WorldMesh.Heinum.Upper, sectnum, z))) {
                        int n5 = z;
                        this.wallflags[n5] = (byte)(this.wallflags[n5] | 2);
                    }
                    if (!this.pvs.checkSector(nextsectnum)) continue;
                    WallFrustum3d portal = null;
                    if ((Engine.sector[sectnum].ceilingstat & Engine.sector[nextsectnum].ceilingstat & 1) != 0 || (Engine.sector[sectnum].floorstat & Engine.sector[nextsectnum].floorstat & 1) != 0) {
                        portal = pFrustum.clone(this.pFrustumPool);
                        portal.sectnum = nextsectnum;
                    } else {
                        ArrayList<Tesselator.Vertex> points = mesh.getPoints(WorldMesh.Heinum.Portal, sectnum, z);
                        if (points == null) continue;
                        WallFrustum3d clip = null;
                        boolean bNearPlaneClipped = this.NearPlaneCheck(cam, points);
                        if (bNearPlaneClipped) {
                            float posx = Engine.globalposx;
                            float posy = Engine.globalposy;
                            if (Engine.sector[sectnum].isParallaxCeiling() || Engine.sector[sectnum].isParallaxFloor() || this.projectionToWall(posx, posy, wal, this.projPoint) && Math.abs(posx - this.projPoint.x) + Math.abs(posy - this.projPoint.y) <= cam.near * cam.xscale * 2.0f) {
                                clip = pFrustum.clone(this.pFrustumPool);
                                clip.sectnum = nextsectnum;
                            }
                        }
                        if ((sectnum == cursectnum || bNearPlaneClipped) && clip == null && (points = this.cl.ClipPolygon(cam.frustum, points)).size() < 3 || wal.isOneWay() && clip == null) continue;
                        WallFrustum3d wallFrustum3d = portal = clip != null ? clip : pFrustum.build(cam, this.pFrustumPool, points, nextsectnum);
                    }
                    if (portal == null) continue;
                    int n6 = z;
                    this.wallflags[n6] = (byte)(this.wallflags[n6] | 4);
                    if (this.gotviewport[nextsectnum] == null) {
                        this.portqueue[this.pqtail++ & this.queuemask] = this.gotviewport[nextsectnum] = portal;
                        continue;
                    }
                    WallFrustum3d nextp = this.gotviewport[nextsectnum];
                    if ((nextp = nextp.expand(portal)) == null || this.handled[nextsectnum] == null) continue;
                    this.portqueue[this.pqtail++ & this.queuemask] = nextp;
                }
            }
            if (this.handled[sectnum] == null) {
                this.handled[sectnum] = sec;
            }
            if (pFrustum.next != null) {
                pFrustum = pFrustum.next;
                continue;
            }
            pFrustum = this.portqueue[++this.pqhead & this.queuemask];
        }
        this.pqtail = 0;
        this.pqhead = 0;
        sectnum = cursectnum;
        this.portqueue[this.pqtail++ & this.queuemask] = this.gotviewport[cursectnum];
        this.skyviewport[cursectnum] = this.gotviewport[cursectnum];
        this.gotviewport[cursectnum] = null;
        do {
            pFrustum = this.portqueue[this.pqhead++ & this.queuemask];
            sectnum = pFrustum.sectnum;
            sec = this.handled[sectnum];
            if (Engine.automapping == 1) {
                int n = sectnum >> 3;
                Engine.show2dsector[n] = (byte)(Engine.show2dsector[n] | Engine.pow2char[sectnum & 7]);
            }
            boolean isParallaxCeiling = Engine.sector[sectnum].isParallaxCeiling();
            boolean isParallaxFloor = Engine.sector[sectnum].isParallaxFloor();
            int startwall = Engine.sector[sectnum].wallptr;
            int endwall = Engine.sector[sectnum].wallnum + startwall;
            for (int z = startwall; z < endwall; ++z) {
                WALL wal = Engine.wall[z];
                short nextsectnum = wal.nextsector;
                if ((this.gotwall[z >> 3] & Engine.pow2char[z & 7]) == 0) continue;
                if (nextsectnum != -1 && this.gotviewport[nextsectnum] != null) {
                    this.portqueue[this.pqtail++ & this.queuemask] = this.gotviewport[nextsectnum];
                    this.skyviewport[nextsectnum] = this.gotviewport[nextsectnum];
                    this.gotviewport[nextsectnum] = null;
                }
                if (wal.isMasked() || wal.isOneWay()) {
                    this.maskwall[this.maskwallcnt++] = z;
                }
                if ((this.wallflags[z] & 0x18) != 0) {
                    int n = z;
                    this.wallflags[n] = (byte)(this.wallflags[n] & 0xFFFFFFE7);
                    if (isParallaxCeiling && this.engine.getTile(Engine.sector[sectnum].ceilingpicnum).hasSize()) {
                        this.skyCeiling = Engine.sector[sectnum];
                    }
                    if (isParallaxFloor && this.engine.getTile(Engine.sector[sectnum].floorpicnum).hasSize()) {
                        this.skyFloor = Engine.sector[sectnum];
                    }
                    sec.skywalls.add(z);
                }
                sec.walls.add(z);
                sec.wallflags.add(this.wallflags[z]);
            }
            byte secflags = 0;
            if (!isParallaxFloor && this.isSectorVisible(pFrustum, cam.frustum.planes[0], true, sectnum)) {
                secflags = (byte)(secflags | 1);
            }
            if (!isParallaxCeiling && this.isSectorVisible(pFrustum, cam.frustum.planes[0], false, sectnum)) {
                secflags = (byte)(secflags | 2);
            }
            this.checkSprites(pFrustum, sectnum);
            sec.secflags = secflags;
            sec.setFrustum(pFrustum.getPlanes());
            sectors.add(sec);
        } while (this.pqhead != this.pqtail);
        QuickSort.sort(this.maskwall, this.maskwallcnt, this.wallcomp);
    }

    protected boolean wallfront(WALL w1, WALL w2) {
        double cross3;
        boolean t2;
        WALL wp1 = Engine.wall[w1.point2];
        float x11 = w1.x;
        float y11 = w1.y;
        float x21 = wp1.x;
        float y21 = wp1.y;
        WALL wp2 = Engine.wall[w2.point2];
        float x12 = w2.x;
        float y12 = w2.y;
        float x22 = wp2.x;
        float y22 = wp2.y;
        float dx = x21 - x11;
        float dy = y21 - y11;
        double f = 0.001;
        double invf = 0.999;
        double py = (double)y12 * 0.999 + (double)y22 * 0.001;
        double px = (double)x12 * 0.999 + (double)x22 * 0.001;
        double cross = (double)dx * (py - (double)y11) - (double)dy * (px - (double)x11);
        boolean t1 = cross < 1.0E-5;
        px = (double)x22 * 0.999 + (double)x12 * 0.001;
        py = (double)y22 * 0.999 + (double)y12 * 0.001;
        double cross1 = (double)dx * (py - (double)y11) - (double)dy * (px - (double)x11);
        boolean bl = t2 = cross1 < 1.0E-5;
        if (t1 == t2) {
            boolean bl2 = t1 = (double)(dx * ((float)Engine.globalposy - y11) - dy * ((float)Engine.globalposx - x11)) < 1.0E-5;
            if (t2 == t1) {
                return true;
            }
        }
        t1 = (cross3 = (double)(dx = x22 - x12) * ((py = (double)y11 * 0.999 + (double)y21 * 0.001) - (double)y12) - (double)(dy = y22 - y12) * ((px = (double)x11 * 0.999 + (double)x21 * 0.001) - (double)x12)) < 1.0E-5;
        px = (double)x21 * 0.999 + (double)x11 * 0.001;
        py = (double)y21 * 0.999 + (double)y11 * 0.001;
        double cross4 = (double)dx * (py - (double)y12) - (double)dy * (px - (double)x12);
        boolean bl3 = t2 = cross4 < 1.0E-5;
        if (t1 == t2) {
            t1 = (double)(dx * ((float)Engine.globalposy - y12) - dy * ((float)Engine.globalposx - x12)) < 1.0E-5;
            return t2 != t1;
        }
        return false;
    }

    public SECTOR getLastSkySector(WorldMesh.Heinum h) {
        if (h == WorldMesh.Heinum.SkyLower) {
            return this.skyFloor;
        }
        return this.skyCeiling;
    }

    private boolean checkWallRange(int sectnum, int z) {
        return z >= Engine.sector[sectnum].wallptr && z < Engine.sector[sectnum].wallptr + Engine.sector[sectnum].wallnum;
    }

    private void checkSprites(WallFrustum3d pFrustum, int sectnum) {
        short z = Engine.headspritesect[sectnum];
        while (z >= 0) {
            SPRITE spr = Engine.sprite[z];
            if (((spr.cstat & 0x8000) == 0 || Engine.showinvisibility) && spr.xrepeat > 0 && spr.yrepeat > 0 && Engine.spritesortcnt < 1024) {
                int xs = spr.x - Engine.globalposx;
                int ys = spr.y - Engine.globalposy;
                if (((spr.cstat & 0x70) != 80 || Pragmas.dmulscale(Engine.sintable[spr.ang + 512 & 0x7FF], -xs, Engine.sintable[spr.ang & 0x7FF], -ys, 6) > 0) && this.spriteInFrustum(pFrustum, spr)) {
                    SPRITE tspr = this.addTSprite();
                    tspr.set(spr);
                    tspr.owner = z;
                }
            }
            z = Engine.nextspritesect[z];
        }
    }

    public boolean spriteInFrustum(WallFrustum3d frustum, SPRITE tspr) {
        Vector3[] points = tmpVec;
        float SIZEX = 0.5f;
        float SIZEY = 0.5f;
        Matrix4 mat = this.getSpriteMatrix(tspr);
        if (mat != null) {
            points[0].set(-SIZEX, SIZEY, 0.0f).mul(mat);
            points[1].set(SIZEX, SIZEY, 0.0f).mul(mat);
            points[2].set(SIZEX, -SIZEY, 0.0f).mul(mat);
            points[3].set(-SIZEX, -SIZEY, 0.0f).mul(mat);
            WallFrustum3d n = frustum;
            do {
                if (!n.wallInFrustum(points, 4)) continue;
                return true;
            } while ((n = n.next) != null);
        }
        return false;
    }

    protected abstract Matrix4 getSpriteMatrix(SPRITE var1);

    private SPRITE addTSprite() {
        if (Engine.tsprite[Engine.spritesortcnt] == null) {
            Engine.tsprite[Engine.spritesortcnt] = new SPRITE();
        }
        return Engine.tsprite[Engine.spritesortcnt++];
    }

    private boolean isSectorVisible(WallFrustum3d frustum, Plane near, boolean isFloor, int sectnum) {
        int i;
        frustum.rebuild();
        int n = i = near == null ? 0 : -1;
        while (i < frustum.planes.length) {
            block4: {
                Plane plane = i == -1 ? near : frustum.planes[i];
                int startwall = Engine.sector[sectnum].wallptr;
                int endwall = Engine.sector[sectnum].wallnum + startwall;
                for (int z = startwall; z < endwall; ++z) {
                    int wz;
                    WALL wal = Engine.wall[z];
                    int n2 = wz = isFloor ? this.engine.getflorzofslope((short)sectnum, wal.x, wal.y) : this.engine.getceilzofslope((short)sectnum, wal.x, wal.y);
                    if (isFloor && !Engine.sector[sectnum].isSlopedFloor() && Engine.globalposz > wz || !isFloor && !Engine.sector[sectnum].isSlopedCeiling() && Engine.globalposz < wz || plane.testPoint(wal.x, wal.y, wz) == Plane.PlaneSide.Back) {
                        continue;
                    }
                    break block4;
                }
                if (frustum.next != null) {
                    return this.isSectorVisible(frustum.next, null, isFloor, sectnum);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean NearPlaneCheck(BuildCamera cam, ArrayList<? extends Vector3> points) {
        Plane near = cam.frustum.planes[0];
        for (int i = 0; i < points.size(); ++i) {
            if (near.testPoint(points.get(i)) != Plane.PlaneSide.Back) continue;
            return true;
        }
        return false;
    }

    public boolean projectionToWall(float posx, float posy, WALL w, Vector2 n) {
        WALL p2 = Engine.wall[w.point2];
        int dx = p2.x - w.x;
        int dy = p2.y - w.y;
        float i = (float)dx * (posx - (float)w.x) + (float)dy * (posy - (float)w.y);
        if (i < 0.0f) {
            n.set(w.x, w.y);
            return false;
        }
        float j = dx * dx + dy * dy;
        if (i > j) {
            n.set(p2.x, p2.y);
            return false;
        }
        n.set((float)dx * (i /= j) + (float)w.x, (float)dy * i + (float)w.y);
        return true;
    }

    public int getSpriteCount() {
        return Engine.spritesortcnt;
    }

    public SPRITE[] getSprites() {
        return Engine.tsprite;
    }

    public int getMaskwallCount() {
        return this.maskwallcnt;
    }

    public int[] getMaskwalls() {
        return this.maskwall;
    }
}

