/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Scanner;

import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector2;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.GdxRender.Pool;
import ru.m210projects.Build.Types.WALL;

public class WallFrustum2d
implements Pool.Poolable {
    private static final Vector2 tmp = new Vector2();
    public final Plane[] planes = new Plane[3];
    public int sectnum;
    public WallFrustum2d next;
    public boolean isFullAngle = false;
    protected float sinA = 0.0f;
    public boolean handled = false;

    public WallFrustum2d() {
        for (int i = 0; i < this.planes.length; ++i) {
            this.planes[i] = new Plane();
        }
    }

    public WallFrustum2d set(int sectnum) {
        this.sectnum = sectnum;
        return this.setFullAngle();
    }

    public WallFrustum2d set(WALL wal) {
        float cosA;
        this.sectnum = wal.nextsector;
        float x1 = wal.x - Engine.globalposx;
        float y1 = wal.y - Engine.globalposy;
        WALL wal2 = Engine.wall[wal.point2];
        float x2 = wal2.x - Engine.globalposx;
        float y2 = wal2.y - Engine.globalposy;
        this.setPlane(0, x1, y1, 0.0f);
        this.setPlane(1, -x2, -y2, 0.0f);
        this.calcSinA();
        if (this.sinA == 0.0f && (cosA = -this.planes[0].normal.y * this.planes[1].normal.y - this.planes[0].normal.x * this.planes[1].normal.x) > 0.0f) {
            return null;
        }
        return this;
    }

    public WallFrustum2d set(WallFrustum2d frustum) {
        this.planes[0].set(frustum.planes[0]);
        this.planes[1].set(frustum.planes[1]);
        this.planes[2].set(frustum.planes[2]);
        this.sinA = frustum.sinA;
        return this;
    }

    protected WallFrustum2d setFullAngle() {
        this.planes[0].normal.set(this.planes[1].normal);
        this.planes[0].normal.scl(-1.0f);
        this.planes[0].d = -this.planes[1].d;
        this.isFullAngle = true;
        this.sinA = -1.0f;
        return this;
    }

    public boolean isGreater180() {
        return this.sinA < 0.0f;
    }

    protected void calcSinA() {
        this.sinA = this.planes[0].normal.y * this.planes[1].normal.x - this.planes[0].normal.x * this.planes[1].normal.y;
    }

    protected void setPlane(int num, float nx, float ny, float nz) {
        this.planes[num].getNormal().set(-ny, nx, nz);
    }

    public boolean wallInFrustum(WALL wal) {
        if (this.isFullAngle) {
            return true;
        }
        int x1 = wal.x - Engine.globalposx;
        int y1 = wal.y - Engine.globalposy;
        WALL wal2 = Engine.wall[wal.point2];
        int x2 = wal2.x - Engine.globalposx;
        int y2 = wal2.y - Engine.globalposy;
        if (this.isGreater180()) {
            for (int i = 0; i < 2; ++i) {
                Plane plane = this.planes[i];
                if (plane.normal.dot(x1, y1, 0.0f) >= 0.0f) {
                    return true;
                }
                if (!(plane.normal.dot(x2, y2, 0.0f) >= 0.0f)) continue;
                return true;
            }
            return false;
        }
        if (!this.NearPlaneCheck(wal)) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            Plane plane = this.planes[i];
            if (plane.normal.dot(x1, y1, 0.0f) >= 0.0f || plane.normal.dot(x2, y2, 0.0f) >= 0.0f) continue;
            return false;
        }
        return true;
    }

    private boolean NearPlaneCheck(WALL wal) {
        tmp.set(this.planes[0].normal.x, this.planes[0].normal.y);
        tmp.add(this.planes[1].normal.x, this.planes[1].normal.y);
        int x1 = wal.x - Engine.globalposx;
        int y1 = wal.y - Engine.globalposy;
        if (tmp.dot(x1, y1) >= 0.0f) {
            return true;
        }
        int x2 = Engine.wall[wal.point2].x - Engine.globalposx;
        int y2 = Engine.wall[wal.point2].y - Engine.globalposy;
        return tmp.dot(x2, y2) >= 0.0f;
    }

    public boolean fieldOfViewClipping(WallFrustum2d frustum) {
        if (frustum.isFullAngle) {
            return true;
        }
        float precise = 1.0E-5f;
        float dot1 = this.planes[1].normal.x * frustum.planes[0].normal.y - this.planes[1].normal.y * frustum.planes[0].normal.x;
        float dot2 = this.planes[0].normal.y * frustum.planes[1].normal.x - this.planes[0].normal.x * frustum.planes[1].normal.y;
        float dot3 = this.planes[0].normal.x * frustum.planes[0].normal.y - this.planes[0].normal.y * frustum.planes[0].normal.x;
        float dot4 = this.planes[1].normal.y * frustum.planes[1].normal.x - this.planes[1].normal.x * frustum.planes[1].normal.y;
        boolean isGreater180 = this.isGreater180();
        boolean frustumIsGreater180 = frustum.isGreater180();
        if (!isGreater180) {
            if (this.frustumInFrustum(dot1, dot2, dot3, dot4, isGreater180) && !frustumIsGreater180) {
                float frdiry;
                float diry;
                float frdirx;
                float dirx;
                if (this.sinA + frustum.sinA < 1.0E-5f && (dirx = this.planes[0].normal.x + this.planes[1].normal.x) * (frdirx = frustum.planes[0].normal.x + frustum.planes[1].normal.x) + (diry = this.planes[0].normal.y + this.planes[1].normal.y) * (frdiry = frustum.planes[0].normal.y + frustum.planes[1].normal.y) < 0.0f) {
                    return false;
                }
                if (dot1 >= -1.0E-5f && dot2 >= -1.0E-5f) {
                    this.set(frustum);
                    return true;
                }
            }
            if (this.frustumInFrustum(dot2, dot1, -dot3, -dot4, frustumIsGreater180)) {
                return true;
            }
            if (dot1 >= -1.0E-5f && dot3 >= -1.0E-5f) {
                this.planes[0].set(frustum.planes[0]);
                this.calcSinA();
                return true;
            }
            if (dot2 >= -1.0E-5f && dot4 >= -1.0E-5f) {
                this.planes[1].set(frustum.planes[1]);
                this.calcSinA();
                return true;
            }
        } else {
            if (this.frustumInFrustum(dot2, dot1, -dot3, -dot4, frustumIsGreater180) && dot1 >= -1.0E-5f && dot2 >= -1.0E-5f && dot3 <= 1.0E-5f && dot4 <= 1.0E-5f) {
                return true;
            }
            if (this.frustumInFrustum(dot1, dot2, dot3, dot4, isGreater180) && (!frustumIsGreater180 && (dot3 >= -1.0E-5f || dot4 >= -1.0E-5f) || frustumIsGreater180 && (dot1 <= 1.0E-5f || dot2 <= 1.0E-5f))) {
                this.set(frustum);
                return true;
            }
            if (dot1 <= 1.0E-5f && dot3 <= 1.0E-5f && (dot2 >= -1.0E-5f || dot4 >= -1.0E-5f)) {
                this.planes[1].set(frustum.planes[1]);
                this.calcSinA();
                return true;
            }
            if (dot2 <= 1.0E-5f && dot4 <= 1.0E-5f && (dot1 >= -1.0E-5f || dot3 >= -1.0E-5f)) {
                this.planes[0].set(frustum.planes[0]);
                this.calcSinA();
                return true;
            }
        }
        return false;
    }

    public boolean frustumInFrustum(WallFrustum2d frustum) {
        float dot1 = this.planes[1].normal.x * frustum.planes[0].normal.y - this.planes[1].normal.y * frustum.planes[0].normal.x;
        float dot2 = this.planes[0].normal.y * frustum.planes[1].normal.x - this.planes[0].normal.x * frustum.planes[1].normal.y;
        float dot3 = this.planes[0].normal.x * frustum.planes[0].normal.y - this.planes[0].normal.y * frustum.planes[0].normal.x;
        float dot4 = this.planes[1].normal.y * frustum.planes[1].normal.x - this.planes[1].normal.x * frustum.planes[1].normal.y;
        return this.frustumInFrustum(dot1, dot2, dot3, dot4, this.isGreater180());
    }

    private boolean frustumInFrustum(float dot1, float dot2, float dot3, float dot4, boolean isGreater180) {
        float precise = 1.0E-5f;
        if (isGreater180) {
            boolean point2InFrustum;
            boolean point1InFrustum;
            boolean bl = point1InFrustum = dot3 >= -1.0E-5f;
            if (!point1InFrustum) {
                point1InFrustum = dot1 >= -1.0E-5f;
            }
            boolean bl2 = point2InFrustum = dot2 >= -1.0E-5f;
            if (!point2InFrustum) {
                point2InFrustum = dot4 >= -1.0E-5f;
            }
            return point1InFrustum && point2InFrustum;
        }
        return dot3 >= -1.0E-5f && dot2 >= -1.0E-5f && dot1 >= -1.0E-5f && dot4 >= -1.0E-5f;
    }

    public FrustumStatus isExpanded(WallFrustum2d frustum) {
        if (this.isFullAngle) {
            return FrustumStatus.Inside;
        }
        if (frustum.isFullAngle) {
            this.setFullAngle();
            return FrustumStatus.Expanded;
        }
        float precise = 1.0E-5f;
        float dot1 = this.planes[1].normal.x * frustum.planes[0].normal.y - this.planes[1].normal.y * frustum.planes[0].normal.x;
        float dot2 = this.planes[0].normal.y * frustum.planes[1].normal.x - this.planes[0].normal.x * frustum.planes[1].normal.y;
        float dot3 = this.planes[0].normal.x * frustum.planes[0].normal.y - this.planes[0].normal.y * frustum.planes[0].normal.x;
        float dot4 = this.planes[1].normal.y * frustum.planes[1].normal.x - this.planes[1].normal.x * frustum.planes[1].normal.y;
        boolean isGreater180 = this.isGreater180();
        boolean frustumIsGreater180 = frustum.isGreater180();
        if (!isGreater180) {
            if (this.frustumInFrustum(dot1, dot2, dot3, dot4, isGreater180)) {
                if (!frustumIsGreater180 && this.sinA + frustum.sinA >= 1.0E-5f) {
                    return FrustumStatus.Inside;
                }
                float dirx = this.planes[0].normal.x + this.planes[1].normal.x;
                float frdirx = frustum.planes[0].normal.x + frustum.planes[1].normal.x;
                float diry = this.planes[0].normal.y + this.planes[1].normal.y;
                float frdiry = frustum.planes[0].normal.y + frustum.planes[1].normal.y;
                if (dirx * frdirx + diry * frdiry >= 0.0f) {
                    return FrustumStatus.Inside;
                }
                if (dot1 >= -1.0E-5f && dot2 >= -1.0E-5f) {
                    this.setFullAngle();
                    return FrustumStatus.Expanded;
                }
            }
            if (this.frustumInFrustum(dot2, dot1, -dot3, -dot4, frustumIsGreater180)) {
                this.set(frustum);
                return FrustumStatus.Expanded;
            }
            if (dot1 >= -1.0E-5f && dot3 >= -1.0E-5f) {
                this.planes[1].set(frustum.planes[1]);
                this.calcSinA();
                return FrustumStatus.Expanded;
            }
            if (dot2 >= -1.0E-5f && dot4 >= -1.0E-5f) {
                this.planes[0].set(frustum.planes[0]);
                this.calcSinA();
                return FrustumStatus.Expanded;
            }
        } else {
            if (this.frustumInFrustum(dot2, dot1, -dot3, -dot4, frustumIsGreater180) && frustumIsGreater180 && dot1 <= 1.0E-5f && dot2 <= 1.0E-5f && dot3 <= 1.0E-5f && dot4 <= 1.0E-5f) {
                this.set(frustum);
                return FrustumStatus.Expanded;
            }
            if (this.frustumInFrustum(dot1, dot2, dot3, dot4, isGreater180)) {
                if (!frustumIsGreater180 && (dot3 >= -1.0E-5f || dot4 >= -1.0E-5f) || frustumIsGreater180 && (dot1 <= 1.0E-5f || dot2 <= 1.0E-5f)) {
                    return FrustumStatus.Inside;
                }
                this.setFullAngle();
                return FrustumStatus.Expanded;
            }
            if (dot1 <= 1.0E-5f && dot3 <= 1.0E-5f && (dot2 >= -1.0E-5f || dot4 >= -1.0E-5f)) {
                this.planes[0].set(frustum.planes[0]);
                this.calcSinA();
                return FrustumStatus.Expanded;
            }
            if (dot2 <= 1.0E-5f && dot4 <= 1.0E-5f && (dot1 >= -1.0E-5f || dot3 >= -1.0E-5f)) {
                this.planes[1].set(frustum.planes[1]);
                this.calcSinA();
                return FrustumStatus.Expanded;
            }
        }
        return FrustumStatus.Outside;
    }

    public WallFrustum2d fieldOfViewExpand(WallFrustum2d frustum) {
        WallFrustum2d prev;
        WallFrustum2d n = this;
        do {
            FrustumStatus stat;
            if ((stat = n.isExpanded(frustum)) == FrustumStatus.Expanded) {
                n.handled = false;
                return n;
            }
            if (stat == FrustumStatus.Inside) {
                return null;
            }
            prev = n;
        } while ((n = n.next) != null);
        prev.next = frustum;
        return prev.next;
    }

    public Vector2 getPlane(int num) {
        if (num == 0) {
            tmp.set(this.planes[num].normal.y, -this.planes[num].normal.x);
        } else {
            tmp.set(-this.planes[num].normal.y, this.planes[num].normal.x);
        }
        return tmp;
    }

    public Vector2 getNormal(int num) {
        tmp.set(this.planes[num].normal.x, this.planes[num].normal.y);
        return tmp;
    }

    public float getHFov() {
        float rang;
        if (this.isFullAngle) {
            return 360.0f;
        }
        float lang = this.getPlane(0).angle();
        if (lang > (rang = this.getPlane(1).angle())) {
            lang -= 360.0f;
        }
        return rang - lang;
    }

    public Vector2 getDirection(boolean normalized) {
        tmp.set(this.planes[0].normal.x, this.planes[0].normal.y);
        tmp.add(this.planes[1].normal.x, this.planes[1].normal.y);
        if (normalized) {
            tmp.nor();
        }
        return tmp;
    }

    public boolean isSameDirection(WallFrustum2d frustum) {
        float dirx = this.planes[0].normal.x + this.planes[1].normal.x;
        float frdirx = frustum.planes[0].normal.x + frustum.planes[1].normal.x;
        float diry = this.planes[0].normal.y + this.planes[1].normal.y;
        float frdiry = frustum.planes[0].normal.y + frustum.planes[1].normal.y;
        return dirx * frdirx + diry * frdiry >= 0.0f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append("fov : ").append(this.getHFov());
        sb.append(", dir: ").append(this.getDirection(true).angle());
        sb.append(", plane0 ").append(this.getPlane(0));
        sb.append(", plane1 ").append(this.getPlane(1));
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void reset() {
        this.next = null;
        this.handled = false;
        this.isFullAngle = false;
        this.sinA = 0.0f;
    }

    public static enum FrustumStatus {
        Inside,
        Outside,
        Expanded;

    }
}

