/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Scanner;

import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.Pool;

public class WallFrustum3d
implements Pool.Poolable {
    public final Plane[] planes = new Plane[4];
    public int sectnum;
    public WallFrustum3d next;
    public boolean handled = false;
    private boolean rebuildRequest = false;
    private BuildCamera cam;
    public Vector3[] bounds = new Vector3[2];
    private static final Vector3[] tmpVec = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};
    public static final Plane[] clipPlanes = new Plane[]{new Plane(), new Plane()};

    public WallFrustum3d() {
        int i;
        for (i = 0; i < this.planes.length; ++i) {
            this.planes[i] = new Plane();
        }
        for (i = 0; i < this.bounds.length; ++i) {
            this.bounds[i] = new Vector3();
        }
    }

    public WallFrustum3d set(BuildCamera cam, int sectnum) {
        this.sectnum = sectnum;
        this.cam = cam;
        int j = 2;
        for (int i = 0; i < 4; ++i) {
            this.planes[i].set(cam.frustum.planes[j++]);
        }
        this.setBounds(0.0f, 0.0f, Engine.windowx2 + 1, Engine.windowy2 + 1);
        return this;
    }

    public void rebuild() {
        if (this.rebuildRequest) {
            this.buildFrustum();
            this.rebuildRequest = false;
        }
    }

    public boolean wallInFrustum(Vector3[] points, int len) {
        this.rebuild();
        block0: for (int i = 0; i < this.planes.length; ++i) {
            Plane plane = this.planes[i];
            for (int p = 0; p < len; ++p) {
                if (plane.testPoint(points[p]) != Plane.PlaneSide.Back) continue block0;
            }
            return false;
        }
        return true;
    }

    public boolean wallInFrustum(ArrayList<? extends Vector3> points) {
        if (points == null) {
            return false;
        }
        this.rebuild();
        int len = points.size();
        block0: for (int i = 0; i < this.planes.length; ++i) {
            Plane plane = this.planes[i];
            for (int p = 0; p < len; ++p) {
                if (plane.testPoint(points.get(p)) != Plane.PlaneSide.Back) continue block0;
            }
            return false;
        }
        return true;
    }

    public WallFrustum3d clone(Pool<WallFrustum3d> pool) {
        int i;
        WallFrustum3d frustum = pool.obtain();
        frustum.sectnum = this.sectnum;
        for (i = 0; i < this.planes.length; ++i) {
            frustum.planes[i].set(this.planes[i]);
        }
        for (i = 0; i < this.bounds.length; ++i) {
            frustum.bounds[i].set(this.bounds[i]);
        }
        frustum.rebuildRequest = this.rebuildRequest;
        frustum.cam = this.cam;
        return frustum;
    }

    public WallFrustum3d build(BuildCamera cam, Pool<WallFrustum3d> pool, ArrayList<? extends Vector3> coords, int sectnum) {
        if (coords == null) {
            return null;
        }
        if (!(Engine.sector[sectnum].isParallaxCeiling() || Engine.sector[sectnum].isParallaxFloor() || this.wallInFrustum(coords))) {
            return null;
        }
        WallFrustum3d frustum = pool.obtain();
        for (int i = 0; i < coords.size(); ++i) {
            cam.project(coords.get(i));
        }
        frustum.sectnum = sectnum;
        frustum.calcBounds(coords);
        if (!frustum.clipBounds(this)) {
            return null;
        }
        frustum.rebuildRequest = true;
        frustum.cam = cam;
        return frustum;
    }

    private WallFrustum3d buildFrustum() {
        this.cam.unproject(tmpVec[0].set(this.bounds[0].x, this.bounds[0].y, 1.0f));
        this.cam.unproject(tmpVec[1].set(this.bounds[0].x, this.bounds[1].y, 1.0f));
        this.cam.unproject(tmpVec[2].set(this.bounds[1].x, this.bounds[1].y, 1.0f));
        this.cam.unproject(tmpVec[3].set(this.bounds[1].x, this.bounds[0].y, 1.0f));
        this.build(this.planes[0], tmpVec[1], tmpVec[0]);
        this.build(this.planes[1], tmpVec[2], tmpVec[1]);
        this.build(this.planes[2], tmpVec[3], tmpVec[2]);
        this.build(this.planes[3], tmpVec[0], tmpVec[3]);
        return this;
    }

    private void build(Plane p, Vector3 p1, Vector3 p2) {
        p.normal.set(Engine.globalposx, Engine.globalposy, Engine.globalposz).sub(p1).crs(p1.x - p2.x, p1.y - p2.y, p1.z - p2.z);
        p.d = -p.normal.dot(Engine.globalposx, Engine.globalposy, Engine.globalposz);
    }

    public WallFrustum3d expand(WallFrustum3d frustum) {
        float bminx = frustum.bounds[0].x;
        float bmaxx = frustum.bounds[1].x;
        float bminy = frustum.bounds[0].y;
        float bmaxy = frustum.bounds[1].y;
        WallFrustum3d n = this;
        do {
            if (n.intersects(frustum.bounds)) {
                float minx = n.bounds[0].x;
                float maxx = n.bounds[1].x;
                float miny = n.bounds[0].y;
                float maxy = n.bounds[1].y;
                if (bminx < minx) {
                    minx = bminx;
                }
                if (bmaxx > maxx) {
                    maxx = bmaxx;
                }
                if (bminy < miny) {
                    miny = bminy;
                }
                if (bmaxy > maxy) {
                    maxy = bmaxy;
                }
                if (minx < n.bounds[0].x || maxx > n.bounds[1].x || miny < n.bounds[0].y || maxy > n.bounds[1].y) {
                    n.handled = false;
                    n.setBounds(minx, miny, maxx, maxy);
                    n.rebuildRequest = true;
                    return n;
                }
                return null;
            }
            WallFrustum3d prev = n;
        } while ((n = n.next) != null);
        prev.next = frustum;
        return frustum;
    }

    private WallFrustum3d setBounds(float x1, float y1, float x2, float y2) {
        this.bounds[0].x = x1;
        this.bounds[0].y = y1;
        this.bounds[1].x = x2;
        this.bounds[1].y = y2;
        return this;
    }

    public boolean intersects(Vector3[] p) {
        return p[0].x <= this.bounds[1].x && p[1].x >= this.bounds[0].x && p[0].y <= this.bounds[1].y && p[1].y >= this.bounds[0].y;
    }

    private Vector3[] calcBounds(ArrayList<? extends Vector3> points) {
        this.bounds[0].x = this.bounds[1].x = points.get((int)0).x;
        this.bounds[0].y = this.bounds[1].y = points.get((int)0).y;
        for (int i = 1; i < points.size(); ++i) {
            Vector3 v = points.get(i);
            if (v.x < this.bounds[0].x) {
                this.bounds[0].x = v.x;
            }
            if (v.y < this.bounds[0].y) {
                this.bounds[0].y = v.y;
            }
            if (v.x > this.bounds[1].x) {
                this.bounds[1].x = v.x;
            }
            if (!(v.y > this.bounds[1].y)) continue;
            this.bounds[1].y = v.y;
        }
        this.bounds[0].x = (float)Math.floor(this.bounds[0].x);
        this.bounds[1].x = (float)Math.ceil(this.bounds[1].x);
        this.bounds[0].y = (float)Math.floor(this.bounds[0].y);
        this.bounds[1].y = (float)Math.ceil(this.bounds[1].y);
        this.bounds[0].x = Math.max(this.bounds[0].x, 0.0f);
        this.bounds[1].x = Math.min(this.bounds[1].x, (float)(Engine.windowx2 + 1));
        this.bounds[0].y = Math.max(this.bounds[0].y, 0.0f);
        this.bounds[1].y = Math.min(this.bounds[1].y, (float)(Engine.windowy2 + 1));
        return this.bounds;
    }

    public boolean clipBounds(WallFrustum3d viewport) {
        this.bounds[0].x = Math.max(viewport.bounds[0].x, this.bounds[0].x);
        this.bounds[1].x = Math.min(viewport.bounds[1].x, this.bounds[1].x);
        this.bounds[0].y = Math.max(viewport.bounds[0].y, this.bounds[0].y);
        this.bounds[1].y = Math.min(viewport.bounds[1].y, this.bounds[1].y);
        return !(this.bounds[1].x - this.bounds[0].x <= 0.0f) && !(this.bounds[1].y - this.bounds[0].y <= 0.0f);
    }

    public Plane[] getPlanes() {
        Vector3[] bounds = this.getBounds();
        float b0x = bounds[0].x;
        float b0y = bounds[0].y;
        float b1x = bounds[1].x;
        float b1y = bounds[1].y;
        this.cam.unproject(tmpVec[0].set(b0x, b0y, 1.0f));
        this.cam.unproject(tmpVec[1].set(b0x, b1y, 1.0f));
        this.cam.unproject(tmpVec[2].set(b1x, b1y, 1.0f));
        this.cam.unproject(tmpVec[3].set(b1x, b0y, 1.0f));
        this.build(clipPlanes[0], tmpVec[1], tmpVec[0]);
        this.build(clipPlanes[1], tmpVec[3], tmpVec[2]);
        return clipPlanes;
    }

    public Vector3[] getBounds() {
        float minx = this.bounds[0].x;
        float maxx = this.bounds[1].x;
        float miny = this.bounds[0].y;
        float maxy = this.bounds[1].y;
        WallFrustum3d n = this.next;
        while (n != null) {
            if (n.bounds[0].x < minx) {
                minx = n.bounds[0].x;
            }
            if (n.bounds[1].x > maxx) {
                maxx = n.bounds[1].x;
            }
            if (n.bounds[0].y < miny) {
                miny = n.bounds[0].y;
            }
            if (n.bounds[1].y > maxy) {
                maxy = n.bounds[1].y;
            }
            n = n.next;
        }
        tmpVec[0].set(minx, miny, 0.0f);
        tmpVec[1].set(maxx, maxy, 0.0f);
        return tmpVec;
    }

    @Override
    public void reset() {
        this.next = null;
        this.handled = false;
        this.rebuildRequest = false;
    }
}

