/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Shaders;

import com.badlogic.gdx.math.Matrix4;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.TextureHandle.IndexedShader;

public abstract class IndexedSkyShaderProgram
extends IndexedShader {
    protected int cameraloc;
    protected int projTransloc;
    protected int transformloc;
    protected int mirrorloc;

    public IndexedSkyShaderProgram() throws Exception {
        super("attribute vec4 a_position;\n\nuniform mat4 u_projTrans;\nuniform mat4 u_transform;\nuniform bool u_mirror;\nvarying vec4 v_pos;\n\nvoid main()\n{\n    v_pos = u_transform * a_position;\n    gl_Position = u_projTrans * v_pos;\n    if(u_mirror)\n        gl_Position.x *= -1.0;\n};\n", "uniform sampler2D u_sky;\nuniform sampler2D u_palette;\nuniform sampler2D u_palookup;\nuniform int u_numshades;\nuniform int u_shade;\nuniform float u_alpha;\nuniform vec3 u_camera;\nvarying vec4 v_pos;\nconst float PI = 3.1415926538;\n\nfloat getpalookup(int dashade) {\n    float shade = (min(max(float(dashade), 0.0), float(u_numshades - 1)));\n    return shade / 64.0;\n}\n\nvoid main()\n{\n    vec4 pix = normalize(v_pos - vec4(u_camera, 1.0));\n    vec2 uv = vec2((atan(pix.y, pix.x) + PI) / (2.0 * PI), pix.z / 2.0);\n    uv = uv + 0.5;\n    float fi = texture2D(u_sky, uv).r;\n    if(fi == 1.0) fi -= 0.5 / 256.0;\n    float index = texture2D(u_palookup, vec2(fi, getpalookup(u_shade))).r;\n    if(index == 1.0) index -= 0.5 / 256.0;\n    gl_FragColor = vec4(texture2D(u_palette, vec2(index, 0.0)).rgb, u_alpha);\n};");
    }

    @Override
    protected void init() throws Exception {
        if (!this.isCompiled()) {
            throw new Exception("Shader compile error: " + this.getLog());
        }
        this.paletteloc = this.getUniformLocation("u_palette");
        this.palookuploc = this.getUniformLocation("u_palookup");
        this.numshadesloc = this.getUniformLocation("u_numshades");
        this.shadeloc = this.getUniformLocation("u_shade");
        this.alphaloc = this.getUniformLocation("u_alpha");
        this.cameraloc = this.getUniformLocation("u_camera");
        this.projTransloc = this.getUniformLocation("u_projTrans");
        this.transformloc = this.getUniformLocation("u_transform");
        this.mirrorloc = this.getUniformLocation("u_mirror");
    }

    public void prepare(BuildCamera cam) {
        this.setUniformf(this.cameraloc, cam.position.x, cam.position.y, cam.position.z);
        this.setUniformMatrix(this.projTransloc, cam.combined);
    }

    public void transform(Matrix4 transform) {
        this.setUniformMatrix(this.transformloc, transform);
    }

    public void mirror(boolean mirror) {
        this.setUniformi(this.mirrorloc, mirror ? 1 : 0);
    }

    @Override
    public void setTextureParams(int pal, int shade) {
        this.setUniformi(this.numshadesloc, (int)Engine.numshades);
        this.bindPalette(33985);
        this.setUniformi(this.paletteloc, 1);
        this.bindPalookup(33986, pal);
        this.lastPal = pal;
        this.setUniformi(this.palookuploc, 2);
        this.setUniformi(this.shadeloc, shade);
        this.lastShade = shade;
        BuildGdx.gl.glActiveTexture(33984);
    }
}

