/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD2;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Frame;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Header;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Triangle;

public class MD2Builder {
    public final MD2Header header;
    public MD2Triangle[] triangles;
    public float[][] texCoords;
    public MD2Frame[] frames;
    public int[] glcmds;

    public MD2Builder(MD2Info md) {
        Resource bb = BuildGdx.cache.open(md.getFilename(), 0);
        this.header = md.header;
        this.triangles = this.loadTriangles(bb);
        this.texCoords = this.loadTexCoords(bb);
        this.frames = this.loadFrames(bb);
        this.glcmds = this.loadGLCommands(bb);
        bb.close();
    }

    private MD2Frame[] loadFrames(Resource bb) {
        bb.seek(this.header.offsetFrames, Resource.Whence.Set);
        MD2Frame[] frames = new MD2Frame[this.header.numFrames];
        for (int i = 0; i < this.header.numFrames; ++i) {
            MD2Frame frame = new MD2Frame();
            frame.vertices = new float[this.header.numVertices][3];
            float scaleX = bb.readFloat().floatValue();
            float scaleY = bb.readFloat().floatValue();
            float scaleZ = bb.readFloat().floatValue();
            float transX = bb.readFloat().floatValue();
            float transY = bb.readFloat().floatValue();
            float transZ = bb.readFloat().floatValue();
            frame.name = this.readString(bb, 16);
            for (int j = 0; j < this.header.numVertices; ++j) {
                float x = (float)(bb.readByte() & 0xFF) * scaleX + transX;
                float y = (float)(bb.readByte() & 0xFF) * scaleY + transY;
                float z = (float)(bb.readByte() & 0xFF) * scaleZ + transZ;
                bb.readByte();
                frame.vertices[j][0] = x;
                frame.vertices[j][1] = y;
                frame.vertices[j][2] = z;
            }
            frames[i] = frame;
        }
        return frames;
    }

    private MD2Triangle[] loadTriangles(Resource bb) {
        bb.seek(this.header.offsetTriangles, Resource.Whence.Set);
        MD2Triangle[] triangles = new MD2Triangle[this.header.numTriangles];
        for (int i = 0; i < this.header.numTriangles; ++i) {
            MD2Triangle triangle = new MD2Triangle();
            triangle.vertices[0] = bb.readShort();
            triangle.vertices[1] = bb.readShort();
            triangle.vertices[2] = bb.readShort();
            triangle.texCoords[0] = bb.readShort();
            triangle.texCoords[1] = bb.readShort();
            triangle.texCoords[2] = bb.readShort();
            triangles[i] = triangle;
        }
        return triangles;
    }

    private int[] loadGLCommands(Resource bb) {
        bb.seek(this.header.offsetGLCommands, Resource.Whence.Set);
        int[] glcmds = new int[this.header.numGLCommands];
        for (int i = 0; i < this.header.numGLCommands; ++i) {
            glcmds[i] = bb.readInt();
        }
        return glcmds;
    }

    private float[][] loadTexCoords(Resource bb) {
        bb.seek(this.header.offsetTexCoords, Resource.Whence.Set);
        float[][] texCoords = new float[this.header.numTexCoords][2];
        float width = this.header.skinWidth;
        float height = this.header.skinHeight;
        for (int i = 0; i < this.header.numTexCoords; ++i) {
            short u = bb.readShort();
            short v = bb.readShort();
            texCoords[i][0] = (float)u / width;
            texCoords[i][1] = (float)v / height;
        }
        return texCoords;
    }

    protected String readString(Resource bb, int len) {
        byte[] buf = new byte[len];
        bb.read(buf);
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != 0) continue;
            return new String(buf, 0, i);
        }
        return new String(buf);
    }
}

