/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD2;

import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Render.ModelHandle.MDInfo;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Header;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;

public class MD2Info
extends MDInfo {
    public final MD2Header header;

    public MD2Info(Resource res, String file) throws Exception {
        super(file, ModelInfo.Type.Md2);
        this.header = this.loadHeader(res);
        if (this.header.ident != 844121161 || this.header.version != 8) {
            throw new Exception();
        }
        res.seek(this.header.offsetFrames, Resource.Whence.Set);
        this.frames = new String[this.header.numFrames];
        this.numframes = this.header.numFrames;
        for (int i = 0; i < this.header.numFrames; ++i) {
            res.seek(24L, Resource.Whence.Current);
            this.frames[i] = this.readString(res, 16);
            res.seek(this.header.numVertices * 4, Resource.Whence.Current);
        }
    }

    protected MD2Header loadHeader(Resource res) {
        MD2Header header = new MD2Header();
        header.ident = res.readInt();
        header.version = res.readInt();
        header.skinWidth = res.readInt();
        header.skinHeight = res.readInt();
        header.frameSize = res.readInt();
        header.numSkins = res.readInt();
        header.numVertices = res.readInt();
        header.numTexCoords = res.readInt();
        header.numTriangles = res.readInt();
        header.numGLCommands = res.readInt();
        header.numFrames = res.readInt();
        header.offsetSkin = res.readInt();
        header.offsetTexCoords = res.readInt();
        header.offsetTriangles = res.readInt();
        header.offsetFrames = res.readInt();
        header.offsetGLCommands = res.readInt();
        header.offsetEnd = res.readInt();
        return header;
    }
}

