/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD3;

import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Builder;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Surface;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Vertice;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;

public abstract class MD3ModelGL10
extends MDModel {
    private final ShortBuffer indices;
    private final FloatBuffer vertices;
    private final MD3Surface[] surfaces;
    private final int numSurfaces;

    public MD3ModelGL10(MD3Info md) {
        super(md);
        MD3Builder builder = new MD3Builder(md);
        this.surfaces = builder.surfaces;
        this.numSurfaces = builder.head.numSurfaces;
        int maxtris = 0;
        int maxverts = 0;
        for (int i = 0; i < this.numSurfaces; ++i) {
            MD3Surface surf = this.surfaces[i];
            maxtris = Math.max(maxtris, surf.numtris);
            maxverts = Math.max(maxverts, surf.numverts);
        }
        this.indices = BufferUtils.newShortBuffer(maxtris * 3);
        this.vertices = BufferUtils.newFloatBuffer(maxverts * 3);
    }

    protected abstract int bindSkin(int var1, int var2, int var3);

    @Override
    public boolean render(int pal, int pad1, int skinnum, int pad2, float pad3) {
        boolean isRendered = false;
        for (int surfi = 0; surfi < this.numSurfaces; ++surfi) {
            int i;
            MD3Surface s = this.surfaces[surfi];
            int texunits = this.bindSkin(pal, skinnum, surfi);
            if (texunits == -1) break;
            this.vertices.clear();
            for (i = 0; i < s.numverts; ++i) {
                MD3Vertice v0 = s.xyzn[this.cframe][i];
                MD3Vertice v1 = s.xyzn[this.nframe][i];
                this.vertices.put((float)v0.x * this.cScale.x + (float)v1.x * this.nScale.x);
                this.vertices.put((float)v0.z * this.cScale.z + (float)v1.z * this.nScale.z);
                this.vertices.put((float)v0.y * this.cScale.y + (float)v1.y * this.nScale.y);
            }
            this.vertices.flip();
            this.indices.clear();
            for (i = s.numtris - 1; i >= 0; --i) {
                for (int j = 0; j < 3; ++j) {
                    this.indices.put((short)s.tris[i][j]);
                }
            }
            this.indices.flip();
            int l = 33984;
            do {
                BuildGdx.gl.glClientActiveTexture(l++);
                BuildGdx.gl.glEnableClientState(32888);
                BuildGdx.gl.glTexCoordPointer(2, 5126, 0, s.uv);
            } while (l <= texunits);
            BuildGdx.gl.glEnableClientState(32884);
            BuildGdx.gl.glVertexPointer(3, 5126, 0, this.vertices);
            BuildGdx.gl.glDrawElements(4, 0, 5123, this.indices);
            while (texunits > 33984) {
                BuildGdx.gl.glMatrixMode(5890);
                BuildGdx.gl.glLoadIdentity();
                BuildGdx.gl.glMatrixMode(5888);
                BuildGdx.gl.glTexEnvf(8960, 34163, 1.0f);
                BuildGdx.gl.glDisable(3553);
                BuildGdx.gl.glDisableClientState(32888);
                BuildGdx.gl.glClientActiveTexture(texunits - 1);
                BuildGdx.gl.glActiveTexture(--texunits);
            }
            BuildGdx.gl.glDisableClientState(32884);
            isRendered = true;
        }
        if (this.usesalpha) {
            BuildGdx.gl.glDisable(3008);
        }
        BuildGdx.gl.glDisable(2884);
        BuildGdx.gl.glLoadIdentity();
        return isRendered;
    }

    @Override
    public MDModel setScale(Vector3 cScale, Vector3 nScale) {
        this.cScale.set(cScale);
        this.nScale.set(nScale);
        this.cScale.scl(0.015625f);
        this.nScale.scl(0.015625f);
        return this;
    }

    @Override
    public void loadSkins(int pal, int skinnum) {
        for (int surfi = 0; surfi < this.numSurfaces; ++surfi) {
            this.getSkin(pal, skinnum, surfi);
        }
    }

    @Override
    public ModelInfo.Type getType() {
        return ModelInfo.Type.Md3;
    }

    @Override
    public ShaderProgram getShader() {
        return null;
    }
}

