/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.Voxel;

import ru.m210projects.Build.FileHandle.Resource;

public class VoxelData {
    public static final int MAXVOXMIPS = 5;
    public int[] xsiz;
    public int[] ysiz;
    public int[] zsiz;
    public int[] xpiv;
    public int[] ypiv;
    public int[] zpiv;
    public short[][][] xyoffs;
    public int[][] slabxoffs;
    public byte[][] data;
    public int[] pal;

    public VoxelData(Resource dat) throws Exception {
        int mip = 0;
        this.xsiz = new int[5];
        this.ysiz = new int[5];
        this.zsiz = new int[5];
        this.xpiv = new int[5];
        this.ypiv = new int[5];
        this.zpiv = new int[5];
        this.xyoffs = new short[5][][];
        this.slabxoffs = new int[5][];
        this.data = new byte[5][];
        while (dat.position() < dat.size() - 768) {
            int i;
            int mip1leng = dat.readInt();
            int xs = this.xsiz[mip] = dat.readInt().intValue();
            int ys = this.ysiz[mip] = dat.readInt().intValue();
            this.zsiz[mip] = dat.readInt();
            this.xpiv[mip] = dat.readInt();
            this.ypiv[mip] = dat.readInt();
            this.zpiv[mip] = dat.readInt();
            int offset = (xs + 1 << 2) + (xs * (ys + 1) << 1);
            this.slabxoffs[mip] = new int[xs + 1];
            for (i = 0; i <= xs; ++i) {
                this.slabxoffs[mip][i] = dat.readInt() - offset;
            }
            this.xyoffs[mip] = new short[xs][ys + 1];
            for (i = 0; i < xs; ++i) {
                for (int j = 0; j <= ys; ++j) {
                    this.xyoffs[mip][i][j] = dat.readShort();
                }
            }
            i = dat.size() - dat.position() - 768;
            if (i < mip1leng - (24 + offset)) break;
            this.data[mip] = new byte[mip1leng - (24 + offset)];
            dat.read(this.data[mip]);
            ++mip;
        }
        if (mip == 0) {
            throw new Exception("Can't load voxel");
        }
        this.pal = new int[256];
        dat.seek(dat.size() - 768, Resource.Whence.Set);
        byte[] buf = new byte[768];
        dat.read(buf);
        for (int i = 0; i < 256; ++i) {
            this.pal[i] = (buf[3 * i + 0] << 18) + (buf[3 * i + 1] << 10) + (buf[3 * i + 2] << 2) + (i << 24);
        }
    }
}

