/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.Voxel;

import com.badlogic.gdx.graphics.Mesh;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Render.ModelHandle.Voxel.GLVoxel;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelBuilder;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Render.TextureHandle.GLTile;

public abstract class VoxelGL20
extends GLVoxel {
    private final Mesh mesh;

    public VoxelGL20(VoxelData vox, int voxmip, int flags) {
        super(flags);
        VoxelBuilder builder = new VoxelBuilder(vox, voxmip);
        float[] vertices = builder.getVertices();
        short[] indices = builder.getIndices();
        this.xsiz = builder.xsiz;
        this.ysiz = builder.ysiz;
        this.zsiz = builder.zsiz;
        this.xpiv = (float)vox.xpiv[voxmip] / 256.0f;
        this.ypiv = (float)vox.ypiv[voxmip] / 256.0f;
        this.zpiv = (float)vox.zpiv[voxmip] / 256.0f;
        int size = builder.getVertexSize();
        this.mesh = new Mesh(true, vertices.length / size, indices.length, builder.getAttributes());
        this.mesh.setVertices(vertices);
        this.mesh.setIndices(indices);
        this.skinData = builder.getTexture();
    }

    @Override
    public boolean render(int pal, int shade, int pad, int visibility, float alpha) {
        GLTile skin = this.getSkin(pal);
        if (skin == null) {
            return false;
        }
        if (alpha != 1.0f) {
            BuildGdx.gl.glEnable(3042);
        } else {
            BuildGdx.gl.glDisable(3042);
        }
        skin.bind();
        this.setTextureParameters(skin, pal, shade, visibility, alpha);
        this.mesh.render(this.getShader(), 4);
        return true;
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
        this.clearSkins();
    }
}

