/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Polymost;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.ModelHandle.GLModel;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.ModelHandle.Voxel.GLVoxel;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.Types.GL10;
import ru.m210projects.Build.Render.Types.Palette;
import ru.m210projects.Build.Render.Types.Spriteext;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.Tile;

public class PolymostModelRenderer {
    private final Polymost parent;
    private final Engine engine;
    private GL10 gl;
    private final Color polyColor = new Color();
    private final float[][] matrix = new float[4][4];
    private final Vector3 dvoxm0 = new Vector3();
    private final Vector3 modela0 = new Vector3();
    private final Vector3 cScale = new Vector3();
    private final Vector3 nScale = new Vector3();

    public PolymostModelRenderer(Polymost parent) {
        this.parent = parent;
        this.engine = parent.engine;
    }

    public void init() {
        this.gl = this.parent.gl;
    }

    public int voxdraw(GLVoxel m, SPRITE tspr) {
        if (m == null) {
            return 0;
        }
        if ((Engine.sprite[tspr.owner].cstat & 0x30) == 32) {
            return 0;
        }
        int globalorientation = this.parent.globalorientation;
        boolean xflip = (globalorientation & 4) != 0;
        boolean yflip = (globalorientation & 8) != 0;
        this.dvoxm0.x = m.getScale();
        this.dvoxm0.y = m.getScale();
        this.dvoxm0.z = m.getScale();
        this.modela0.z = 0.0f;
        this.modela0.y = 0.0f;
        this.modela0.x = 0.0f;
        float f = (float)tspr.xrepeat * 0.8f / 64.0f;
        if ((Engine.sprite[tspr.owner].cstat & 0x30) == 16) {
            f *= 1.25f;
        }
        if ((Engine.sprite[tspr.owner].cstat & 0x30) == 32) {
            f *= 1.25f;
        }
        this.dvoxm0.x *= f;
        this.modela0.x *= f;
        f = -f;
        this.dvoxm0.y *= f;
        this.modela0.y *= f;
        f = (float)tspr.yrepeat / 64.0f;
        this.dvoxm0.z *= f;
        this.modela0.z *= f;
        float x0 = tspr.x;
        float k0 = tspr.z;
        float xoff = tspr.xoffset;
        float yoff = tspr.yoffset;
        if (yflip) {
            yoff = -yoff;
        }
        if ((globalorientation & 0x80) == 0) {
            k0 -= (float)(m.zsiz * tspr.yrepeat << 1);
        }
        if (yflip && (globalorientation & 0x10) == 0) {
            k0 += ((float)this.engine.getTile(tspr.picnum).getHeight() * 0.5f - m.zpiv) * (float)tspr.yrepeat * 8.0f;
        }
        f = 3.3554432E7f / (float)(Engine.xdimen * Engine.viewingrange);
        float g = 32.0f / (float)((double)Engine.xdimen * this.parent.gxyaspect);
        this.dvoxm0.y *= f;
        if ((Engine.sprite[tspr.owner].cstat & 0x30) == 32) {
            this.dvoxm0.y *= -1.0f;
        }
        this.modela0.y = ((x0 - (float)Engine.globalposx) / 1024.0f + this.modela0.y) * f;
        this.dvoxm0.x *= -f;
        if ((Engine.sprite[tspr.owner].cstat & 0x30) == 32) {
            this.dvoxm0.x *= -1.0f;
        }
        if (xflip) {
            this.dvoxm0.x *= -1.0f;
        }
        this.modela0.x = ((float)(tspr.y - Engine.globalposy) / -1024.0f + this.modela0.x) * -f;
        this.dvoxm0.z *= g;
        if (yflip) {
            this.dvoxm0.z *= -1.0f;
        }
        this.modela0.z = ((k0 - (float)Engine.globalposz) / -16384.0f + this.modela0.z) * g;
        if (this.parent.grhalfxdown10x >= 0.0f ^ yflip ^ xflip) {
            this.gl.glFrontFace(2304);
        } else {
            this.gl.glFrontFace(2305);
        }
        this.gl.glEnable(2884);
        this.gl.glCullFace(1029);
        this.gl.glEnable(3553);
        this.gl.glMatrixMode(5888);
        boolean newmatrix = false;
        if (!newmatrix) {
            this.md3_vox_calcmat_common(tspr, this.modela0, f, this.matrix);
        } else {
            this.md3_vox_calcmat_common(tspr, this.modela0);
        }
        if (!newmatrix) {
            this.matrix[2][3] = 0.0f;
            this.matrix[1][3] = 0.0f;
            this.matrix[0][3] = 0.0f;
            this.matrix[3][3] = 1.0f;
            this.gl.glLoadMatrixf(this.matrix);
        }
        this.gl.glScalef(this.dvoxm0.x / 64.0f, this.dvoxm0.z / 64.0f, this.dvoxm0.y / 64.0f);
        this.gl.glTranslatef(-xoff, yoff, 0.0f);
        if (m.isRotating()) {
            this.gl.glRotatef(Engine.totalclock % 360, 0.0f, 1.0f, 0.0f);
        }
        if ((tspr.cstat & 0x30) == 32) {
            this.gl.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
            this.gl.glTranslatef(-m.xpiv, -m.ypiv, -m.zpiv);
            this.gl.glRotatef(90.0f, -1.0f, 0.0f, 0.0f);
            this.gl.glTranslatef(0.0f, -m.ypiv, -m.zpiv);
        } else {
            this.gl.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
            this.gl.glTranslatef(-m.xpiv, -m.ypiv, -m.zpiv);
        }
        this.parent.globalfog.apply();
        this.polyColor.g = this.polyColor.b = ((float)Engine.numshades - Math.min(Math.max((float)Engine.globalshade * this.parent.shadescale, 0.0f), (float)Engine.numshades)) / (float)Engine.numshades;
        this.polyColor.r = this.polyColor.b;
        if (this.parent.defs != null) {
            Palette p = this.parent.defs.texInfo.getTints(Engine.globalpal);
            this.polyColor.r *= (float)p.r / 255.0f;
            this.polyColor.g *= (float)p.g / 255.0f;
            this.polyColor.b *= (float)p.b / 255.0f;
        }
        this.polyColor.a = (tspr.cstat & 2) != 0 ? ((tspr.cstat & 0x200) == 0 ? Engine.TRANSLUSCENT1 : Engine.TRANSLUSCENT2) : 1.0f;
        m.setColor(this.polyColor.r, this.polyColor.g, this.polyColor.b, this.polyColor.a);
        boolean rendered = m.render(Engine.globalpal, Engine.globalshade, 0, (int)this.parent.globalfog.combvis, this.polyColor.a);
        this.gl.glDisable(2884);
        this.gl.glLoadIdentity();
        return rendered ? 1 : 0;
    }

    private void modelPrepare(MDModel m, SPRITE tspr) {
        Tile pic = this.engine.getTile(tspr.picnum);
        float f = m.interpol;
        float g = 1.0f - f;
        float mscale = 0.01f;
        if (m.getType() == ModelInfo.Type.Md2) {
            this.cScale.set(mscale, mscale, mscale);
        } else {
            this.cScale.set(mscale, -mscale, mscale);
        }
        this.cScale.scl(g, g, g);
        if (m.getType() == ModelInfo.Type.Md2) {
            this.nScale.set(mscale, mscale, mscale);
        } else {
            this.nScale.set(mscale, -mscale, mscale);
        }
        this.nScale.scl(f, f, f);
        int globalorientation = this.parent.globalorientation;
        this.modela0.y = 0.0f;
        this.modela0.x = 0.0f;
        this.modela0.z = m.getYOffset(true) * mscale;
        float posx = tspr.x;
        float posz = tspr.z;
        if ((globalorientation & 0x80) != 0 && (globalorientation & 0x30) != 32) {
            posz += (float)(pic.getHeight() * tspr.yrepeat << 1);
        }
        if ((globalorientation & 8) != 0) {
            this.cScale.scl(1.0f, 1.0f, -1.0f);
            this.nScale.scl(1.0f, 1.0f, -1.0f);
            this.modela0.z = -this.modela0.z;
            posz -= (float)(pic.getHeight() * tspr.yrepeat << 2);
        }
        if ((globalorientation & 4) != 0) {
            this.cScale.scl(1.0f, -1.0f, 1.0f);
            this.nScale.scl(1.0f, -1.0f, 1.0f);
            this.modela0.y = -this.modela0.y;
        }
        posx += (float)(tspr.xrepeat >> 2);
        posz -= (float)(tspr.yrepeat << 2);
        this.modela0.z += m.getYOffset(false) * mscale;
        f = (float)tspr.xrepeat / 64.0f * m.getScale();
        float z = (float)tspr.yrepeat / 64.0f * m.getScale();
        this.cScale.scl(-f, f, z);
        this.nScale.scl(-f, f, z);
        this.modela0.scl(f, -f, z);
        float posy = tspr.y;
        if ((globalorientation & 0x30) == 32) {
            this.cScale.scl(1.0f, -1.0f, -1.0f);
            this.nScale.scl(1.0f, -1.0f, -1.0f);
            this.modela0.scl(1.0f, -1.0f, -1.0f);
            f = this.modela0.x;
            this.modela0.x = this.modela0.z;
            this.modela0.z = f;
            posy += (float)(pic.getHeight() * tspr.yrepeat >> 3);
        }
        f = 3.3554432E7f / (float)(Engine.xdimen * Engine.viewingrange);
        g = (float)(32.0 / ((double)Engine.xdimen * this.parent.gxyaspect));
        this.cScale.scl(f, -f, g);
        this.nScale.scl(f, -f, g);
        this.modela0.y = ((posx - (float)Engine.globalposx) / 1024.0f + this.modela0.y) * f;
        this.modela0.x = ((posy - (float)Engine.globalposy) / 1024.0f + this.modela0.x) * f;
        this.modela0.z = ((posz - (float)Engine.globalposz) / -16384.0f + this.modela0.z) * g;
        this.md3_vox_calcmat_common(tspr, this.modela0, f, this.matrix);
        if ((globalorientation & 0x30) == 32) {
            f = this.matrix[1][0];
            this.matrix[1][0] = this.matrix[2][0] * 16.0f;
            this.matrix[2][0] = -f * 0.0625f;
            f = this.matrix[1][1];
            this.matrix[1][1] = this.matrix[2][1] * 16.0f;
            this.matrix[2][1] = -f * 0.0625f;
            f = this.matrix[1][2];
            this.matrix[1][2] = this.matrix[2][2] * 16.0f;
            this.matrix[2][2] = -f * 0.0625f;
        }
        this.matrix[2][3] = 0.0f;
        this.matrix[1][3] = 0.0f;
        this.matrix[0][3] = 0.0f;
        this.matrix[3][3] = 1.0f;
        this.gl.glMatrixMode(5888);
        this.gl.glLoadMatrixf(this.matrix);
        this.gl.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        if (m.isRotating()) {
            this.gl.glRotatef(Engine.totalclock % 360, 0.0f, 1.0f, 0.0f);
        }
        if (this.parent.grhalfxdown10x >= 0.0f ^ (globalorientation & 8) != 0 ^ (globalorientation & 4) != 0) {
            this.gl.glFrontFace(2304);
        } else {
            this.gl.glFrontFace(2305);
        }
        this.gl.glEnable(2884);
        if (m.getType() == ModelInfo.Type.Md2) {
            this.gl.glCullFace(1028);
        } else {
            this.gl.glCullFace(1029);
        }
        this.gl.glEnable(3553);
        this.polyColor.g = this.polyColor.b = ((float)Engine.numshades - Math.min(Math.max((float)Engine.globalshade * this.parent.shadescale + m.getShadeOff(), 0.0f), (float)Engine.numshades)) / (float)Engine.numshades;
        this.polyColor.r = this.polyColor.b;
        DefScript defs = this.parent.defs;
        if (defs != null && (m.isTintAffected() || tspr.owner < Engine.MAXSPRITES && Engine.sector[Engine.sprite[tspr.owner].sectnum].floorpal != 0)) {
            Palette p = defs.texInfo.getTints(Engine.globalpal);
            this.polyColor.r *= (float)p.r / 255.0f;
            this.polyColor.g *= (float)p.g / 255.0f;
            this.polyColor.b *= (float)p.b / 255.0f;
            Palette pdetail = defs.texInfo.getTints(255);
            if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                this.polyColor.r *= (float)pdetail.r / 255.0f;
                this.polyColor.g *= (float)pdetail.g / 255.0f;
                this.polyColor.b *= (float)pdetail.b / 255.0f;
            }
        }
        this.polyColor.a = (tspr.cstat & 2) != 0 ? ((tspr.cstat & 0x200) == 0 ? Engine.TRANSLUSCENT1 : Engine.TRANSLUSCENT2) : 1.0f;
        if (m.usesalpha) {
            float al = 0.0f;
            if (this.parent.alphahackarray[tspr.picnum] != 0.0f) {
                al = this.parent.alphahackarray[tspr.picnum];
            }
            this.gl.glEnable(3042);
            this.gl.glEnable(3008);
            this.gl.glAlphaFunc(516, al);
        } else if ((tspr.cstat & 2) != 0) {
            this.gl.glEnable(3042);
        }
        this.gl.glColor4f(this.polyColor.r, this.polyColor.g, this.polyColor.b, this.polyColor.a);
    }

    public boolean mddraw(MDModel m, SPRITE tspr) {
        DefScript defs = this.parent.defs;
        m.updateanimation(defs.mdInfo, tspr);
        this.modelPrepare(m, tspr);
        int skinnum = defs.mdInfo.getParams((int)tspr.picnum).skinnum;
        this.parent.globalfog.apply();
        m.setScale(this.cScale, this.nScale);
        return m.render(Engine.globalpal, Engine.globalshade, skinnum, Engine.globalvisibility, 1.0f);
    }

    public int mddraw(GLModel vm, SPRITE tspr, int xoff, int yoff) {
        if (vm == null) {
            return 0;
        }
        if (vm.getType() == ModelInfo.Type.Voxel) {
            return this.voxdraw((GLVoxel)vm, tspr);
        }
        if (vm.getType() == ModelInfo.Type.Md2 || vm.getType() == ModelInfo.Type.Md3) {
            return this.mddraw((MDModel)vm, tspr) ? 1 : 0;
        }
        return 0;
    }

    public void md3_vox_calcmat_common(SPRITE tspr, Vector3 a0, float f, float[][] mat) {
        float gcosang2 = this.parent.gcosang2;
        float gsinang2 = this.parent.gsinang2;
        float gshang = this.parent.gshang;
        float gstang = this.parent.gstang;
        float gctang = this.parent.gctang;
        float gchang = this.parent.gchang;
        float gsinang = this.parent.gsinang;
        float gcosang = this.parent.gcosang;
        float k0 = (float)(tspr.x - Engine.globalposx) * f / 1024.0f;
        float k1 = (float)(tspr.y - Engine.globalposy) * f / 1024.0f;
        f = gcosang2 * gshang;
        float g = gsinang2 * gshang;
        Spriteext sprext = this.parent.defs.mapInfo.getSpriteInfo(tspr.owner);
        float k4 = (float)Engine.sintable[tspr.ang + (sprext != null ? sprext.angoff : (short)0) + 1024 & 0x7FF] / 16384.0f;
        float k5 = (float)Engine.sintable[tspr.ang + (sprext != null ? sprext.angoff : (short)0) + 512 & 0x7FF] / 16384.0f;
        float k2 = k0 * (1.0f - k4) + k1 * k5;
        float k3 = k1 * (1.0f - k4) - k0 * k5;
        float k6 = f * gstang - gsinang * gctang;
        float k7 = g * gstang + gcosang * gctang;
        if (this.parent.grhalfxdown10x < 0.0f) {
            k6 = -k6;
            k7 = -k7;
        }
        mat[0][0] = k4 * k6 + k5 * k7;
        mat[1][0] = gchang * gstang;
        mat[2][0] = k4 * k7 - k5 * k6;
        mat[3][0] = k2 * k6 + k3 * k7;
        k6 = f * gctang + gsinang * gstang;
        k7 = g * gctang - gcosang * gstang;
        mat[0][1] = k4 * k6 + k5 * k7;
        mat[1][1] = gchang * gctang;
        mat[2][1] = k4 * k7 - k5 * k6;
        mat[3][1] = k2 * k6 + k3 * k7;
        k6 = gcosang2 * gchang;
        k7 = gsinang2 * gchang;
        mat[0][2] = k4 * k6 + k5 * k7;
        mat[1][2] = -gshang;
        mat[2][2] = k4 * k7 - k5 * k6;
        mat[3][2] = k2 * k6 + k3 * k7;
        float[] fArray = mat[3];
        fArray[0] = fArray[0] + (a0.y * mat[0][0] + a0.z * mat[1][0] + a0.x * mat[2][0]);
        float[] fArray2 = mat[3];
        fArray2[1] = fArray2[1] + (a0.y * mat[0][1] + a0.z * mat[1][1] + a0.x * mat[2][1]);
        float[] fArray3 = mat[3];
        fArray3[2] = fArray3[2] + (a0.y * mat[0][2] + a0.z * mat[1][2] + a0.x * mat[2][2]);
    }

    public void md3_vox_calcmat_common(SPRITE tspr, Vector3 a0, float f, Matrix4 mat) {
        float yaw = Engine.globalang / 5.688889f - 90.0f;
        float roll = this.parent.gtang * 57.3f;
        Spriteext sprext = this.parent.defs.mapInfo.getSpriteInfo(tspr.owner);
        float spriteang = (float)(tspr.ang + (sprext != null ? sprext.angoff : (short)0) + 512 & 0x7FF) / 5.688889f;
        mat.idt();
        mat.rotate(0.0f, 0.0f, -1.0f, roll);
        mat.rotate(-1.0f, 0.0f, 0.0f, Engine.pitch);
        mat.rotate(0.0f, -1.0f, 0.0f, yaw);
        mat.scale(-0.0625f, 1.0f, 0.0625f);
        mat.translate(a0.y, a0.z, a0.x);
        mat.rotate(0.0f, -1.0f, 0.0f, spriteang);
    }

    public void md3_vox_calcmat_common(SPRITE tspr, Vector3 a0) {
        float yaw = Engine.globalang / 5.688889f - 90.0f;
        float roll = this.parent.gtang * 57.3f;
        Spriteext sprext = this.parent.defs.mapInfo.getSpriteInfo(tspr.owner);
        float spriteang = (float)(tspr.ang + (sprext != null ? sprext.angoff : (short)0) + 512 & 0x7FF) / 5.688889f;
        this.gl.glLoadIdentity();
        this.gl.glRotatef(roll, 0.0f, 0.0f, -1.0f);
        this.gl.glRotatef(Engine.pitch, -1.0f, 0.0f, 0.0f);
        this.gl.glRotatef(yaw, 0.0f, -1.0f, 0.0f);
        this.gl.glScalef(-0.0625f, 1.0f, 0.0625f);
        this.gl.glTranslatef(a0.y, a0.z, a0.x);
        this.gl.glRotatef(spriteang, 0.0f, -1.0f, 0.0f);
    }
}

