/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.graphics.Pixmap;
import java.nio.ByteBuffer;
import ru.m210projects.Build.Render.TextureHandle.TileData;

public class PixmapTileData
extends TileData {
    private Pixmap pixmap;
    private final boolean clamped;
    private final int width;
    private final int height;

    public PixmapTileData(Pixmap pixmap, boolean clamped, int expflag) {
        if (pixmap.getFormat() == Pixmap.Format.Alpha || pixmap.getFormat() == Pixmap.Format.Intensity || pixmap.getFormat() == Pixmap.Format.LuminanceAlpha) {
            pixmap = this.convert(pixmap);
        }
        this.pixmap = pixmap;
        this.clamped = clamped;
        this.width = pixmap.getWidth();
        this.height = pixmap.getHeight();
        int xsiz = this.width;
        int ysiz = this.height;
        if ((expflag & 1) != 0) {
            xsiz = this.calcSize(this.width);
        }
        if ((expflag & 2) != 0) {
            ysiz = this.calcSize(this.height);
        }
        if (xsiz != this.width || ysiz != this.height) {
            Pixmap npix = new Pixmap(xsiz, ysiz, !clamped ? pixmap.getFormat() : Pixmap.Format.RGBA8888);
            npix.setFilter(Pixmap.Filter.NearestNeighbour);
            if (!clamped) {
                for (int x = 0; x < xsiz; x += this.width) {
                    for (int y = 0; y < ysiz; y += this.height) {
                        npix.drawPixmap(pixmap, x, y);
                    }
                }
            } else {
                npix.drawPixmap(pixmap, 0, 0);
            }
            pixmap.dispose();
            this.pixmap = npix;
        }
    }

    private Pixmap convert(Pixmap pixmap) {
        int width = pixmap.getWidth();
        int height = pixmap.getHeight();
        Pixmap npix = new Pixmap(width, height, Pixmap.Format.RGBA8888);
        ByteBuffer pixels = pixmap.getPixels();
        boolean bytes2 = pixmap.getFormat() == Pixmap.Format.LuminanceAlpha;
        for (int i = 0; i < width * height; ++i) {
            float c = (float)(pixels.get() & 0xFF) / 255.0f;
            float a = 1.0f;
            if (bytes2) {
                a = (float)(pixels.get() & 0xFF) / 255.0f;
            }
            npix.setColor(c, c, c, a);
            int row = (int)Math.floor(i / width);
            int col = i % width;
            npix.drawPixel(col, row);
        }
        pixmap.dispose();
        return npix;
    }

    @Override
    public boolean hasAlpha() {
        return this.pixmap.getFormat() == Pixmap.Format.RGBA4444 || this.pixmap.getFormat() == Pixmap.Format.RGBA8888;
    }

    @Override
    public boolean isClamped() {
        return this.clamped;
    }

    public int getTileWidth() {
        return this.width;
    }

    public int getTileHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.pixmap.getWidth();
    }

    @Override
    public int getHeight() {
        return this.pixmap.getHeight();
    }

    @Override
    public ByteBuffer getPixels() {
        return this.pixmap.getPixels();
    }

    @Override
    public int getGLType() {
        return this.pixmap.getGLType();
    }

    @Override
    public int getGLInternalFormat() {
        return this.pixmap.getGLInternalFormat();
    }

    @Override
    public int getGLFormat() {
        return this.pixmap.getGLFormat();
    }

    @Override
    public boolean isHighTile() {
        return true;
    }

    @Override
    public TileData.PixelFormat getPixelFormat() {
        return TileData.PixelFormat.Rgb;
    }

    @Override
    public void dispose() {
        this.pixmap.dispose();
    }
}

