/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Types;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import ru.m210projects.Build.Architecture.BuildGdx;

public abstract class FadeEffect {
    public int sfactor;
    public int dfactor;
    public int r;
    public int g;
    public int b;
    public int a;
    public static Mesh mesh;
    public static final float[] vertices;

    private static Mesh buildMesh() {
        return new Mesh(true, 3, 0, new VertexAttribute(1, 2, "a_position")).setVertices(vertices);
    }

    public FadeEffect(int sfactor, int dfactor) {
        this.sfactor = sfactor;
        this.dfactor = dfactor;
    }

    public static void uninit() {
        if (mesh != null) {
            mesh.dispose();
            mesh = null;
        }
    }

    public abstract void update(int var1);

    public static void setParams(FadeShader shader, int r, int g, int b, int a, int sfactor, int dfactor) {
        BuildGdx.gl.glBlendFunc(sfactor, dfactor);
        if (shader == null) {
            BuildGdx.gl.glColor4ub(r, g, b, a);
        } else {
            shader.setColor(r, g, b, a);
        }
    }

    public static void render(FadeShader shader) {
        if (shader == null) {
            FadeEffect.gl10draw();
            return;
        }
        if (mesh == null) {
            mesh = FadeEffect.buildMesh();
        }
        mesh.render(shader, 4);
    }

    public void draw(FadeShader shader) {
        FadeEffect.setParams(shader, this.r, this.g, this.b, this.a, this.sfactor, this.dfactor);
        FadeEffect.render(shader);
    }

    protected static void gl10draw() {
        BuildGdx.gl.glBegin(4);
        for (int i = 0; i < 6; i += 2) {
            BuildGdx.gl.glVertex2f(vertices[i], vertices[i + 1]);
        }
        BuildGdx.gl.glEnd();
    }

    static {
        vertices = new float[]{-2.5f, 1.0f, 2.5f, 1.0f, 0.0f, -2.5f};
    }

    public static class FadeShader
    extends ShaderProgram {
        public static final String vertexShader = "attribute vec4 a_position;\nvoid main()\n{\n   gl_Position =  a_position;\n}\n";
        public static final String fragmentShader = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nuniform vec4 u_color;\nvoid main()\n{\n\tgl_FragColor = u_color;\n}\n";
        public final int color = this.getUniformLocation("u_color");

        public FadeShader() {
            super(vertexShader, fragmentShader);
        }

        public void setColor(int r, int g, int b, int a) {
            this.setUniformf(this.color, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }
    }
}

