/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Script;

import java.util.HashMap;
import java.util.Map;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Script.Scriptfile;
import ru.m210projects.Build.Strhandler;

public class CueScript
extends Scriptfile {
    private final int T_FILE = 1;
    private final int T_TRACK = 2;
    private final int T_MP3 = 3;
    private final int T_AUDIO = 4;
    private final int T_INDEX = 5;
    private final int T_ERROR = 6;
    private final int T_EOF = 7;
    private final Map<String, Integer> basetokens = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("file", 1);
            this.put("track", 2);
            this.put("mp3", 3);
            this.put("audio", 4);
            this.put("index", 5);
        }
    };
    private int nTracks = 0;
    private final Map<Integer, String> pTrackList = new HashMap<Integer, String>();

    public CueScript(String filename, byte[] data) throws RuntimeException {
        super(filename, data);
        this.process();
    }

    private int gettoken(Map<String, Integer> list) {
        int tok = this.gettoken();
        if (tok == -2) {
            return 7;
        }
        Integer out = list.get(Strhandler.toLowerCase(this.textbuf.substring(tok, this.textptr)));
        if (out != null) {
            return out;
        }
        this.errorptr = this.textptr;
        return 6;
    }

    private Integer getValue() {
        String txt = this.getstring();
        if (txt == null) {
            return null;
        }
        txt = txt.replaceAll("[^0-9]", "");
        try {
            return Integer.parseInt(txt);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void process() {
        while (!this.eof()) {
            int line = this.getlinum(this.textptr);
            if (this.textptr < this.lineoffs[0]) {
                --line;
            }
            int tokn = this.gettoken(this.basetokens);
            switch (tokn) {
                case 6: {
                    Console.Println("Error on line " + this.filename + ":" + line + ", skipping...", Console.OSDTEXT_RED);
                    if (line >= this.linenum) break;
                    this.textptr = this.lineoffs[line - 1];
                    break;
                }
                case 7: {
                    break;
                }
                case 1: {
                    String path = this.getstring();
                    this.getstring();
                    if (this.gettoken(this.basetokens) != 2) break;
                    ++this.nTracks;
                    int nTrack = this.getValue();
                    int nTrackType = this.gettoken(this.basetokens);
                    if (nTrackType == 4) {
                        this.pTrackList.put(nTrack, FileUtils.getCorrectPath(path));
                    }
                    int oldptr = this.textptr;
                    if (this.gettoken(this.basetokens) == 5) {
                        this.getstring();
                        this.getstring();
                        break;
                    }
                    this.textptr = oldptr;
                }
            }
        }
    }

    public String[] getTracks() {
        String[] out = new String[this.nTracks];
        for (int i = 1; i <= this.nTracks; ++i) {
            out[i - 1] = this.pTrackList.get(i);
        }
        return out;
    }
}

