/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Script;

import com.badlogic.gdx.graphics.Pixmap;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Render.ModelHandle.MDInfo;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Info;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Render.ModelHandle.VoxelInfo;
import ru.m210projects.Build.Script.AudioInfo;
import ru.m210projects.Build.Script.MapHackInfo;
import ru.m210projects.Build.Script.ModelsInfo;
import ru.m210projects.Build.Script.Scriptfile;
import ru.m210projects.Build.Script.TextureHDInfo;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.Tile;

public class DefScript {
    protected boolean disposable;
    public final TextureHDInfo texInfo;
    public final ModelsInfo mdInfo;
    public final AudioInfo audInfo;
    public final MapHackInfo mapInfo;
    protected final Engine engine;
    protected FileEntry currentAddon;
    protected HashMap<String, List<String>> addonsIncludes;
    protected DefTile[] tiles = new DefTile[Engine.MAXTILES];
    private final Map<String, Token> basetokens = new HashMap<String, Token>(){
        private static final long serialVersionUID = 1L;
        {
            Token tok = new IncludeToken();
            this.put("#include", tok);
            this.put("include", tok);
            this.put("defineskybox", new DefineSkyboxToken());
            this.put("definetint", new DefineTint());
            this.put("model", new ModelToken());
            this.put("voxel", new VoxelToken());
            this.put("skybox", new SkyboxToken());
            this.put("tint", new TintToken());
            tok = new TextureToken();
            this.put("tile", tok);
            this.put("texture", tok);
            this.put("tilefromtexture", new TileFromTextureToken());
            this.put("animtilerange", new AnimRangeToken());
            this.put("mapinfo", new MaphackToken());
            tok = new AudioToken();
            this.put("sound", tok);
            this.put("music", tok);
            this.put("includeif", new AddonToken());
            this.put("echo", new EchoToken());
        }
    };

    public DefScript(DefScript src, FileEntry addon) {
        this.disposable = true;
        this.texInfo = new TextureHDInfo(src.texInfo);
        this.mdInfo = new ModelsInfo(src.mdInfo, src.disposable);
        this.audInfo = new AudioInfo(src.audInfo);
        this.mapInfo = this.createMapHackInfo(src.mapInfo);
        this.engine = src.engine;
        for (int i = 0; i < Engine.MAXTILES; ++i) {
            if (src.tiles[i] == null) continue;
            this.tiles[i] = new DefTile(src.tiles[i]);
        }
        if (src.addonsIncludes != null) {
            this.addonsIncludes = new HashMap();
            for (String key : src.addonsIncludes.keySet()) {
                List<String> list = src.addonsIncludes.get(key);
                ArrayList<String> clone = new ArrayList<String>(list.size());
                clone.addAll(list);
                this.addonsIncludes.put(key, clone);
            }
        }
        this.currentAddon = addon;
    }

    public DefScript(BuildEngine engine, boolean disposable) {
        this.disposable = disposable;
        this.texInfo = new TextureHDInfo();
        this.mdInfo = new ModelsInfo();
        this.audInfo = new AudioInfo();
        this.mapInfo = this.createMapHackInfo(null);
        this.engine = engine;
    }

    protected MapHackInfo createMapHackInfo(MapHackInfo src) {
        if (src != null) {
            return new MapHackInfo(src);
        }
        return new MapHackInfo();
    }

    public boolean loadScript(FileEntry file) {
        if (file == null) {
            Console.Println("Def error: script not found", Console.OSDTEXT_RED);
            return false;
        }
        FileResource res = BuildGdx.compat.open(file);
        byte[] data = res.getBytes();
        res.close();
        if (data == null) {
            Console.Println("File is exists, but data == null! Path:" + file.getPath());
            return false;
        }
        Scriptfile script = new Scriptfile(file.getPath(), data);
        script.path = file.getParent().getRelativePath();
        try {
            this.defsparser(script);
        }
        catch (Exception e) {
            e.printStackTrace();
            Console.Println("Def error: the script " + file.getPath() + " has errors", Console.OSDTEXT_RED);
            return false;
        }
        return true;
    }

    public boolean loadScript(String name, byte[] buf) {
        if (buf == null) {
            Console.Println("Def error: script not found", Console.OSDTEXT_RED);
            return false;
        }
        try {
            this.defsparser(new Scriptfile(name, buf));
        }
        catch (Exception e) {
            e.printStackTrace();
            Console.Println("Def error: the script " + name + " has errors", Console.OSDTEXT_RED);
            return false;
        }
        return true;
    }

    protected void addToken(String name, Token token) {
        this.basetokens.put(name, token);
    }

    protected boolean addDefTile(DefTile texstatus, int tile) {
        DefTile def = this.tiles[tile];
        if (def != null && def.crc32 != 0L) {
            if (texstatus.crc32 == 0L) {
                texstatus.next = def;
                this.tiles[tile] = texstatus;
            } else if (def.crc32 != texstatus.crc32) {
                def = this.tiles[tile].getLast();
                def.next = texstatus;
            } else if (def.internal || this.disposable) {
                this.tiles[tile] = texstatus;
            }
        } else if (def == null || def.internal || this.disposable) {
            this.tiles[tile] = texstatus;
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void defsparser(Scriptfile script) {
        Console.Println("Loading " + script.filename + "...");
        while (true) {
            Token basetoken;
            if ((basetoken = (Token)this.gettoken(script, this.basetokens)) == null) {
                continue;
            }
            if (basetoken == BaseToken.EOF) {
                return;
            }
            Object object = Engine.lock;
            synchronized (object) {
                basetoken.parse(script);
            }
        }
    }

    protected Object gettoken(Scriptfile sf, Map<String, ?> list) {
        if (sf == null) {
            return BaseToken.Error;
        }
        int tok = sf.gettoken();
        if (tok == -2) {
            return BaseToken.EOF;
        }
        Object out = list.get(Strhandler.toLowerCase(sf.textbuf.substring(tok, sf.textptr)));
        if (out != null) {
            return out;
        }
        sf.errorptr = sf.textptr;
        return BaseToken.Error;
    }

    protected String getFile(Scriptfile script) {
        String fn = script.getstring();
        if (fn == null) {
            return null;
        }
        fn = FileUtils.getCorrectPath(fn);
        if (script.path != null) {
            fn = script.path + File.separator + fn;
        }
        return fn;
    }

    protected boolean check_tile(String defcmd, int tile, Scriptfile script, int cmdtokptr) {
        if (tile >= Engine.MAXTILES) {
            Console.Println("Error: " + defcmd + ": Invalid tile number on line " + script.filename + ":" + script.getlinum(cmdtokptr), Console.OSDTEXT_RED);
            return true;
        }
        return false;
    }

    protected boolean check_tile_range(String defcmd, int tilebeg, int tileend, Scriptfile script, int cmdtokptr) {
        if (tileend < tilebeg) {
            Console.Println("Warning: " + defcmd + ": backwards tile range on line " + script.filename + ":" + script.getlinum(cmdtokptr), Console.OSDTEXT_YELLOW);
            int tmp = tilebeg;
            tilebeg = tileend;
            tileend = tmp;
        }
        if (tilebeg >= Engine.MAXTILES || tileend >= Engine.MAXTILES) {
            Console.Println("Error: " + defcmd + ": Invalid tile range on line " + script.filename + ":" + script.getlinum(cmdtokptr), Console.OSDTEXT_RED);
            return true;
        }
        return false;
    }

    protected int getPtr(Scriptfile script, int line) {
        if (line <= 2) {
            return script.lineoffs[0];
        }
        if (line <= script.linenum) {
            return script.lineoffs[line - 2];
        }
        return script.eof;
    }

    public void dispose() {
        if (!this.disposable) {
            return;
        }
        this.engine.loadpics();
        for (int i = 0; i < Engine.MAXTILES; ++i) {
            if (this.tiles[i] == null) continue;
            this.texInfo.remove(i, 0);
            this.engine.getTile((int)i).data = null;
            this.tiles[i] = null;
        }
        this.mdInfo.dispose();
    }

    public void apply() {
        int i;
        List<String> defs;
        if (this.addonsIncludes != null && this.currentAddon != null && (defs = this.addonsIncludes.get(this.currentAddon.getName())) != null) {
            for (i = 0; i < defs.size() / 2; ++i) {
                String fn = defs.get(2 * i + 1);
                Resource res = BuildGdx.cache.open(fn, 0);
                if (res == null) {
                    Console.Println("Warning: Failed including " + fn + " as module", Console.OSDTEXT_RED);
                    continue;
                }
                Scriptfile included = new Scriptfile(fn, res.getBytes());
                included.path = defs.get(2 * i);
                this.defsparser(included);
                res.close();
            }
        }
        for (i = 0; i < Engine.MAXTILES; ++i) {
            if (this.tiles[i] == null) continue;
            DefTile tile = this.tiles[i];
            Tile pic = this.engine.getTile(i);
            if (tile.crc32 != 0L) {
                long crc32;
                byte[] data = pic.data;
                if (data == null) {
                    data = this.engine.loadtile(i);
                }
                long l = crc32 = data != null ? CRC32.getChecksum(data) : -1L;
                if (crc32 != tile.crc32) {
                    boolean found = false;
                    while (tile.next != null) {
                        tile = tile.next;
                        if (tile.crc32 != 0L && crc32 != tile.crc32) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
            }
            if (tile.waloff == null) continue;
            this.engine.getrender().invalidatetile(i, -1, -1);
            pic.data = new byte[tile.waloff.length];
            System.arraycopy(tile.waloff, 0, pic.data, 0, tile.waloff.length);
            pic.setWidth(tile.sizx);
            pic.setHeight(tile.sizy);
            pic.anm &= 0xFF0000FF;
            pic.anm |= (tile.xoffset & 0xFF) << 8;
            pic.anm |= (tile.yoffset & 0xFF) << 16;
            this.engine.setpicsiz(i);
            this.texInfo.addTexture(i, 0, tile.hrp, (float)(255 - (tile.alphacut & 0xFF)) * 0.003921569f, 1.0f, 1.0f, 1.0f, 1.0f, 0);
        }
    }

    protected boolean checkErrorToken(Scriptfile script, Object tk) {
        if (tk instanceof BaseToken) {
            int line = script.getlinum(script.ltextptr);
            Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(this.getPtr(script, line), this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
            return true;
        }
        return false;
    }

    protected static class DefTile {
        public long crc32;
        public byte[] waloff;
        public short sizx;
        public short sizy;
        public byte xoffset;
        public byte yoffset;
        public String hrp;
        public byte alphacut;
        public final boolean internal;
        public int optional;
        public DefTile next;

        public DefTile(DefTile src) {
            this.crc32 = src.crc32;
            this.waloff = src.waloff;
            this.sizx = src.sizx;
            this.sizy = src.sizy;
            this.xoffset = src.xoffset;
            this.yoffset = src.yoffset;
            this.hrp = src.hrp;
            this.alphacut = src.alphacut;
            this.internal = src.internal;
            this.optional = src.optional;
            if (src.next != null) {
                this.next = new DefTile(src.next);
            }
        }

        public DefTile(int sizx, int sizy, long crc32, boolean internal) {
            this.sizx = (short)sizx;
            this.sizy = (short)sizy;
            this.crc32 = crc32;
            this.internal = internal;
        }

        public DefTile getLast() {
            DefTile out = this;
            DefTile n;
            while ((n = out.next) != null) {
                out = n;
            }
            return out;
        }
    }

    public static interface Token {
        public BaseToken parse(Scriptfile var1);
    }

    public static enum BaseToken implements Token
    {
        Ok,
        Warning,
        Error,
        EOF;


        @Override
        public BaseToken parse(Scriptfile script) {
            return this;
        }
    }

    protected class AudioToken
    implements Token {
        private final Map<String, AudioTokens> sound_musictokens = new HashMap<String, AudioTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("id", AudioTokens.ID);
                this.put("midi", AudioTokens.ID);
                this.put("map", AudioTokens.ID);
                this.put("file", AudioTokens.FILE);
            }
        };

        protected AudioToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            String t_id = null;
            String t_file = null;
            int dummy = script.getbraces();
            if (dummy == -1) {
                return BaseToken.Error;
            }
            block4: while (script.textptr < dummy) {
                Object tk = DefScript.this.gettoken(script, this.sound_musictokens);
                if (tk instanceof BaseToken) {
                    int line = script.getlinum(script.ltextptr);
                    Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                    continue;
                }
                switch ((AudioTokens)((Object)tk)) {
                    default: {
                        continue block4;
                    }
                    case ID: {
                        String t = script.getstring();
                        if (t == null) continue block4;
                        t_id = t.trim();
                        continue block4;
                    }
                    case FILE: 
                }
                t_file = DefScript.this.getFile(script);
            }
            script.skipbrace(dummy);
            DefScript.this.audInfo.addDigitalInfo(t_id, t_file);
            return BaseToken.Ok;
        }
    }

    public static enum AudioTokens {
        ID,
        FILE;

    }

    protected class TintToken
    implements Token {
        private final Map<String, TintTokens> tinttokens = new HashMap<String, TintTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("pal", TintTokens.PAL);
                this.put("red", TintTokens.RED);
                this.put("green", TintTokens.GREEN);
                this.put("blue", TintTokens.BLUE);
                this.put("flags", TintTokens.FLAGS);
            }
        };

        protected TintToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            int pal = -1;
            int r = 255;
            int g = 255;
            int b = 255;
            int f = 0;
            int send = script.getbraces();
            if (send == -1) {
                return BaseToken.Error;
            }
            while (script.textptr < send) {
                try {
                    Object tk = DefScript.this.gettoken(script, this.tinttokens);
                    if (tk instanceof BaseToken) {
                        int line = script.getlinum(script.ltextptr);
                        Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                        continue;
                    }
                    switch ((TintTokens)((Object)tk)) {
                        case PAL: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            pal = ivalue;
                            break;
                        }
                        case RED: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            r = ivalue;
                            break;
                        }
                        case GREEN: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            g = ivalue;
                            break;
                        }
                        case BLUE: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            b = ivalue;
                            break;
                        }
                        case FLAGS: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            f = ivalue;
                            break;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            script.skipbrace(send);
            if (pal == -1) {
                Console.Println("Tint palette is not found!", Console.OSDTEXT_RED);
                return BaseToken.Error;
            }
            Console.Println("Loading tint " + pal);
            DefScript.this.texInfo.setPaletteTint(pal, r, g, b, f);
            return BaseToken.Ok;
        }
    }

    protected static enum TintTokens {
        PAL,
        RED,
        GREEN,
        BLUE,
        FLAGS;

    }

    protected class DefineTint
    implements Token {
        protected DefineTint() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            Integer pal = script.getsymbol();
            if (pal == null) {
                return BaseToken.Error;
            }
            Integer r = script.getsymbol();
            if (r == null) {
                return BaseToken.Error;
            }
            Integer g = script.getsymbol();
            if (g == null) {
                return BaseToken.Error;
            }
            Integer b = script.getsymbol();
            if (b == null) {
                return BaseToken.Error;
            }
            Integer f = script.getsymbol();
            if (f == null) {
                return BaseToken.Error;
            }
            Console.Println("Loading tint " + pal);
            DefScript.this.texInfo.setPaletteTint(pal, r, g, b, f);
            return BaseToken.Ok;
        }
    }

    protected class DefineSkyboxToken
    extends SkyboxToken {
        protected DefineSkyboxToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            int stile = -1;
            int spal = 0;
            String[] sfn = new String[6];
            Integer ivalue = script.getsymbol();
            if (ivalue != null) {
                stile = ivalue;
            }
            if ((ivalue = script.getsymbol()) != null) {
                spal = ivalue;
            }
            script.getsymbol();
            sfn[0] = DefScript.this.getFile(script);
            sfn[1] = DefScript.this.getFile(script);
            sfn[2] = DefScript.this.getFile(script);
            sfn[3] = DefScript.this.getFile(script);
            sfn[4] = DefScript.this.getFile(script);
            sfn[5] = DefScript.this.getFile(script);
            if (this.addSkybox(script, stile, spal, sfn)) {
                return BaseToken.Ok;
            }
            return BaseToken.Error;
        }
    }

    protected class SkyboxToken
    implements Token {
        private final String[] skyfaces = new String[]{"front face", "right face", "back face", "left face", "top face", "bottom face"};
        private final Map<String, SkyboxTokens> skyboxtokens = new HashMap<String, SkyboxTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("tile", SkyboxTokens.TILE);
                this.put("pal", SkyboxTokens.PAL);
                this.put("ft", SkyboxTokens.FRONT);
                this.put("front", SkyboxTokens.FRONT);
                this.put("forward", SkyboxTokens.FRONT);
                this.put("rt", SkyboxTokens.RIGHT);
                this.put("right", SkyboxTokens.RIGHT);
                this.put("bk", SkyboxTokens.BACK);
                this.put("back", SkyboxTokens.BACK);
                this.put("lf", SkyboxTokens.LEFT);
                this.put("left", SkyboxTokens.LEFT);
                this.put("lt", SkyboxTokens.LEFT);
                this.put("up", SkyboxTokens.TOP);
                this.put("top", SkyboxTokens.TOP);
                this.put("ceiling", SkyboxTokens.TOP);
                this.put("ceil", SkyboxTokens.TOP);
                this.put("dn", SkyboxTokens.BOTTOM);
                this.put("bottom", SkyboxTokens.BOTTOM);
                this.put("floor", SkyboxTokens.BOTTOM);
                this.put("down", SkyboxTokens.BOTTOM);
                this.put("nocompress", SkyboxTokens.NOCOMPRESS);
                this.put("nodownsize", SkyboxTokens.NODOWNSIZE);
            }
        };

        protected SkyboxToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            int stile = -1;
            int spal = 0;
            String[] sfn = new String[6];
            int sskyend = script.getbraces();
            if (sskyend == -1) {
                return BaseToken.Error;
            }
            while (script.textptr < sskyend) {
                try {
                    Object tk = DefScript.this.gettoken(script, this.skyboxtokens);
                    if (tk instanceof BaseToken) {
                        int line = script.getlinum(script.ltextptr);
                        Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                        continue;
                    }
                    switch ((SkyboxTokens)((Object)tk)) {
                        case TILE: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            stile = ivalue;
                            break;
                        }
                        case PAL: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            spal = ivalue;
                            break;
                        }
                        case FRONT: {
                            sfn[0] = DefScript.this.getFile(script);
                            break;
                        }
                        case RIGHT: {
                            sfn[1] = DefScript.this.getFile(script);
                            break;
                        }
                        case BACK: {
                            sfn[2] = DefScript.this.getFile(script);
                            break;
                        }
                        case LEFT: {
                            sfn[3] = DefScript.this.getFile(script);
                            break;
                        }
                        case TOP: {
                            sfn[4] = DefScript.this.getFile(script);
                            break;
                        }
                        case BOTTOM: {
                            sfn[5] = DefScript.this.getFile(script);
                            break;
                        }
                        case NOCOMPRESS: {
                            break;
                        }
                        case NODOWNSIZE: {
                            break;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            script.skipbrace(sskyend);
            if (this.addSkybox(script, stile, spal, sfn)) {
                return BaseToken.Ok;
            }
            return BaseToken.Error;
        }

        public boolean addSkybox(Scriptfile script, int stile, int spal, String[] sfn) {
            if (stile < 0) {
                Console.Println("Error: skybox: missing 'tile number' near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                return false;
            }
            for (int i = 0; i < 6; ++i) {
                if (sfn[i] == null) {
                    Console.Println("Error: skybox: missing " + this.skyfaces[i] + " filename' near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                    return false;
                }
                if (BuildGdx.cache.contains(sfn[i], 0)) continue;
                Console.Println("Error: file \"" + sfn[i] + "\" does not exist", Console.OSDTEXT_RED);
                return false;
            }
            DefScript.this.texInfo.addSkybox(stile, spal, sfn);
            return true;
        }
    }

    public static enum SkyboxTokens {
        TILE,
        PAL,
        FRONT,
        RIGHT,
        BACK,
        LEFT,
        TOP,
        BOTTOM,
        NOCOMPRESS,
        NODOWNSIZE;

    }

    protected class VoxelToken
    implements Token {
        private final Map<String, VoxelTokens> voxeltokens = new HashMap<String, VoxelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("tile", VoxelTokens.TILE);
                this.put("tile0", VoxelTokens.TILE0);
                this.put("tile1", VoxelTokens.TILE1);
                this.put("scale", VoxelTokens.SCALE);
                this.put("rotate", VoxelTokens.ROTATE);
            }
        };

        protected VoxelToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            double vscale = 1.0;
            int tile0 = Engine.MAXTILES;
            int tile1 = -1;
            boolean vrotate = false;
            String fn = DefScript.this.getFile(script);
            if (fn == null) {
                return BaseToken.Error;
            }
            int vmodelend = script.getbraces();
            if (vmodelend == -1) {
                return BaseToken.Error;
            }
            Resource res = BuildGdx.cache.open(fn, 0);
            if (res == null) {
                Console.Println("Warning: File not found" + fn, Console.OSDTEXT_YELLOW);
                script.textptr = vmodelend + 1;
                return BaseToken.Warning;
            }
            VoxelInfo vox = null;
            try {
                vox = new VoxelInfo(new VoxelData(res));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            res.close();
            if (vox == null) {
                Console.Println("Warning: Failed loading voxel model " + fn, Console.OSDTEXT_YELLOW);
                script.textptr = vmodelend + 1;
                return BaseToken.Warning;
            }
            while (script.textptr < vmodelend) {
                Object tk = DefScript.this.gettoken(script, this.voxeltokens);
                if (tk instanceof BaseToken) {
                    int line = script.getlinum(script.ltextptr);
                    Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                    continue;
                }
                switch ((VoxelTokens)((Object)tk)) {
                    case TILE: {
                        int tilex = script.getsymbol();
                        if (DefScript.this.check_tile("voxel", tilex, script, script.ltextptr)) break;
                        DefScript.this.mdInfo.addVoxelInfo(vox, tilex);
                        break;
                    }
                    case TILE0: {
                        Integer ivalue = script.getsymbol();
                        if (ivalue == null) break;
                        tile0 = ivalue;
                        break;
                    }
                    case TILE1: {
                        int tilex;
                        Integer ivalue = script.getsymbol();
                        if (ivalue != null) {
                            tile1 = ivalue;
                        }
                        if (DefScript.this.check_tile_range("voxel", tile0, tile1, script, script.ltextptr)) break;
                        for (tilex = tile0; tilex <= tile1; ++tilex) {
                            DefScript.this.mdInfo.addVoxelInfo(vox, tilex);
                        }
                        break;
                    }
                    case SCALE: {
                        Double dvalue = script.getdouble();
                        if (dvalue == null) break;
                        vscale = dvalue;
                        break;
                    }
                    case ROTATE: {
                        vrotate = true;
                        break;
                    }
                }
            }
            script.skipbrace(vmodelend);
            vox.setMisc((float)vscale * 65536.0f, 0.0f, 0.0f, vrotate ? 2 : 0);
            return BaseToken.Ok;
        }
    }

    public static enum VoxelTokens {
        TILE,
        TILE0,
        TILE1,
        SCALE,
        ROTATE;

    }

    protected class TextureToken
    implements Token {
        private final Map<String, TextureTokens> texturetokens = new HashMap<String, TextureTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("pal", TextureTokens.PAL);
                this.put("detail", TextureTokens.DETAIL);
                this.put("glow", TextureTokens.GLOW);
                this.put("specular", TextureTokens.SPECULAR);
                this.put("normal", TextureTokens.NORMAL);
                this.put("file", TextureTokens.FILE);
                this.put("name", TextureTokens.FILE);
                this.put("alphacut", TextureTokens.ALPHACUT);
                this.put("detailscale", TextureTokens.XSCALE);
                this.put("scale", TextureTokens.XSCALE);
                this.put("xscale", TextureTokens.XSCALE);
                this.put("intensity", TextureTokens.XSCALE);
                this.put("yscale", TextureTokens.YSCALE);
                this.put("specpower", TextureTokens.SPECPOWER);
                this.put("specularpower", TextureTokens.SPECPOWER);
                this.put("parallaxscale", TextureTokens.PARALLAXSCALE);
                this.put("specfactor", TextureTokens.SPECFACTOR);
                this.put("specularfactor", TextureTokens.SPECFACTOR);
                this.put("parallaxbias", TextureTokens.PARALLAXBIAS);
                this.put("nocompress", TextureTokens.NOCOMPRESS);
                this.put("nodownsize", TextureTokens.NODOWNSIZE);
            }
        };

        protected TextureToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            Integer ttile = script.getsymbol();
            if (ttile == null) {
                return BaseToken.Error;
            }
            int textureend = script.getbraces();
            if (textureend == -1) {
                return BaseToken.Error;
            }
            block22: while (script.textptr < textureend) {
                int palend;
                Object tk = DefScript.this.gettoken(script, this.texturetokens);
                if (tk instanceof BaseToken) {
                    int line = script.getlinum(script.ltextptr);
                    Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                    continue;
                }
                TextureTokens token = (TextureTokens)((Object)tk);
                switch (token) {
                    default: {
                        continue block22;
                    }
                    case PAL: 
                    case DETAIL: 
                    case GLOW: 
                    case SPECULAR: 
                    case NORMAL: 
                }
                Integer tpal = -1;
                String tfn = null;
                double alphacut = -1.0;
                double xscale = 1.0;
                double yscale = 1.0;
                double specpower = 1.0;
                double specfactor = 1.0;
                int flags = 0;
                if (token == TextureTokens.PAL && (tpal = script.getsymbol()) == null || (palend = script.getbraces()) == -1) continue;
                block23: while (script.textptr < palend) {
                    tk = DefScript.this.gettoken(script, this.texturetokens);
                    if (tk instanceof BaseToken) {
                        int line = script.getlinum(script.ltextptr);
                        Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                        continue;
                    }
                    switch ((TextureTokens)((Object)tk)) {
                        default: {
                            continue block23;
                        }
                        case FILE: {
                            tfn = DefScript.this.getFile(script);
                            continue block23;
                        }
                        case ALPHACUT: {
                            Double dvalue;
                            if (token != TextureTokens.PAL || (dvalue = script.getdouble()) == null) continue block23;
                            alphacut = dvalue;
                            continue block23;
                        }
                        case XSCALE: {
                            Double dvalue = script.getdouble();
                            if (dvalue == null) continue block23;
                            xscale = dvalue;
                            continue block23;
                        }
                        case YSCALE: {
                            Double dvalue = script.getdouble();
                            if (dvalue == null) continue block23;
                            yscale = dvalue;
                            continue block23;
                        }
                        case SPECPOWER: {
                            Double dvalue = script.getdouble();
                            if (dvalue == null) continue block23;
                            specpower = dvalue;
                            continue block23;
                        }
                        case SPECFACTOR: {
                            Double dvalue = script.getdouble();
                            if (dvalue == null) continue block23;
                            specfactor = dvalue;
                            continue block23;
                        }
                        case PARALLAXSCALE: {
                            script.getdouble();
                            continue block23;
                        }
                        case PARALLAXBIAS: {
                            script.getdouble();
                            continue block23;
                        }
                        case NOCOMPRESS: {
                            flags |= 1;
                            continue block23;
                        }
                        case NODOWNSIZE: 
                    }
                    flags |= 0x10;
                }
                script.skipbrace(palend);
                switch (token) {
                    default: {
                        break;
                    }
                    case PAL: {
                        xscale = 1.0 / xscale;
                        yscale = 1.0 / yscale;
                        break;
                    }
                    case DETAIL: {
                        tpal = 255;
                        xscale = 1.0 / xscale;
                        yscale = 1.0 / yscale;
                        break;
                    }
                    case GLOW: {
                        tpal = 254;
                        break;
                    }
                    case SPECULAR: {
                        tpal = 253;
                        break;
                    }
                    case NORMAL: {
                        tpal = 252;
                    }
                }
                if (ttile >= Engine.MAXTILES) continue;
                if (token == TextureTokens.PAL && tpal >= 252) {
                    Console.Println("Error: missing or invalid 'palette number' for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                    return BaseToken.Error;
                }
                if (tfn == null) {
                    Console.Println("Error: missing 'file name' for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                    return BaseToken.Error;
                }
                if (!BuildGdx.cache.contains(tfn, 0)) {
                    Console.Println("Error: file \"" + tfn + "\" not found for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                    return BaseToken.Error;
                }
                DefScript.this.texInfo.addTexture(ttile, tpal, tfn, (float)alphacut, (float)xscale, (float)yscale, (float)specpower, (float)specfactor, flags);
            }
            script.skipbrace(textureend);
            if (ttile >= Engine.MAXTILES) {
                Console.Println("Error: missing or invalid 'tile number' for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                return BaseToken.Error;
            }
            return BaseToken.Ok;
        }
    }

    protected static enum TextureTokens {
        FILE,
        PAL,
        DETAIL,
        GLOW,
        SPECULAR,
        NORMAL,
        ALPHACUT,
        XSCALE,
        YSCALE,
        SPECPOWER,
        SPECFACTOR,
        NOCOMPRESS,
        NODOWNSIZE,
        PARALLAXBIAS,
        PARALLAXSCALE;

    }

    protected class ModelToken
    implements Token {
        protected int modelskin = -1;
        protected int lastmodelskin = -1;
        protected int seenframe = 0;
        protected final Map<String, ModelTokens> modeltokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("scale", ModelTokens.SCALE);
                this.put("shade", ModelTokens.SHADE);
                this.put("zadd", ModelTokens.ZADD);
                this.put("frame", ModelTokens.FRAME);
                this.put("anim", ModelTokens.ANIM);
                this.put("skin", ModelTokens.SKIN);
                this.put("detail", ModelTokens.DETAIL);
                this.put("glow", ModelTokens.GLOW);
                this.put("specular", ModelTokens.SPECULAR);
                this.put("normal", ModelTokens.NORMAL);
                this.put("hud", ModelTokens.HUD);
                this.put("flags", ModelTokens.FLAGS);
            }
        };
        private final Map<String, ModelTokens> modelframetokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("frame", ModelTokens.FRAME);
                this.put("name", ModelTokens.FRAME);
                this.put("tile", ModelTokens.TILE);
                this.put("tile0", ModelTokens.TILE0);
                this.put("tile1", ModelTokens.TILE1);
                this.put("smoothduration", ModelTokens.SMOOTHDURATION);
                this.put("pal", ModelTokens.PAL);
            }
        };
        private final Map<String, ModelTokens> modelanimtokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("frame0", ModelTokens.FRAME0);
                this.put("frame1", ModelTokens.FRAME1);
                this.put("fps", ModelTokens.FPS);
                this.put("flags", ModelTokens.FLAGS);
            }
        };
        private final Map<String, ModelTokens> modelskintokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("pal", ModelTokens.PAL);
                this.put("file", ModelTokens.FILE);
                this.put("surf", ModelTokens.SURF);
                this.put("surface", ModelTokens.SURF);
                this.put("specpower", ModelTokens.SPECPOWER);
                this.put("specfactor", ModelTokens.SPECFACTOR);
                this.put("parallaxscale", ModelTokens.PARALLAXSCALE);
                this.put("parallaxbias", ModelTokens.PARALLAXBIAS);
            }
        };
        private final Map<String, ModelTokens> modelhudtokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("tile", ModelTokens.TILE);
                this.put("tile0", ModelTokens.TILE0);
                this.put("tile1", ModelTokens.TILE1);
                this.put("xadd", ModelTokens.XADD);
                this.put("yadd", ModelTokens.YADD);
                this.put("zadd", ModelTokens.ZADD);
                this.put("fov", ModelTokens.FOV);
                this.put("angadd", ModelTokens.ANGADD);
                this.put("hide", ModelTokens.HIDE);
                this.put("nobob", ModelTokens.NOBOB);
                this.put("flipped", ModelTokens.FLIPPED);
                this.put("nodepth", ModelTokens.NODEPTH);
            }
        };

        protected ModelToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            double mdscale = 1.0;
            double mzadd = 0.0;
            double myoffset = 0.0;
            int mdflags = 0;
            int mdpal = 0;
            boolean model_ok = true;
            this.lastmodelskin = 0;
            this.modelskin = 0;
            this.seenframe = 0;
            String modelfn = script.getstring();
            if (modelfn == null) {
                return BaseToken.Error;
            }
            int modelend = script.getbraces();
            if (modelend == -1) {
                return BaseToken.Error;
            }
            Resource res = BuildGdx.cache.open(modelfn, 0);
            if (res == null) {
                Console.Println("Warning: File not found" + modelfn, Console.OSDTEXT_YELLOW);
                script.textptr = modelend + 1;
                return BaseToken.Warning;
            }
            ModelInfo m = null;
            try {
                int sign = res.readInt();
                res.seek(0L, Resource.Whence.Set);
                switch (sign) {
                    case 844121161: {
                        m = new MD2Info(res, modelfn);
                        break;
                    }
                    case 860898377: {
                        m = new MD3Info(res, modelfn);
                        break;
                    }
                    default: {
                        if (res.getExtension().equals("kvx")) {
                            m = new ModelInfo(modelfn, ModelInfo.Type.Voxel);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            res.close();
            if (m == null) {
                Console.Println("Warning: Failed loading model " + modelfn, Console.OSDTEXT_YELLOW);
                script.textptr = modelend + 1;
                return BaseToken.Warning;
            }
            block73: while (script.textptr < modelend) {
                Object tk = DefScript.this.gettoken(script, this.modeltokens);
                if (tk instanceof BaseToken) {
                    int line = script.getlinum(script.ltextptr);
                    Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                    continue;
                }
                ModelTokens token = (ModelTokens)((Object)tk);
                block5 : switch (token) {
                    default: {
                        break;
                    }
                    case SCALE: {
                        Double dvalue = script.getdouble();
                        if (dvalue == null) continue block73;
                        mdscale = dvalue;
                        break;
                    }
                    case SHADE: {
                        Integer ivalue = script.getsymbol();
                        if (ivalue == null) continue block73;
                        break;
                    }
                    case ZADD: {
                        Double dvalue = script.getdouble();
                        if (dvalue == null) continue block73;
                        mzadd = dvalue;
                        break;
                    }
                    case FLAGS: {
                        Integer ivalue = script.getsymbol();
                        if (ivalue == null) continue block73;
                        mdflags = ivalue;
                        break;
                    }
                    case FRAME: {
                        Integer ivalue;
                        Double dvalue;
                        int frametokptr = script.ltextptr;
                        boolean happy = true;
                        String framename = null;
                        int ftilenume = -1;
                        int ltilenume = -1;
                        double smoothduration = 0.1;
                        int frameend = script.getbraces();
                        if (frameend == -1) break;
                        block74: while (script.textptr < frameend) {
                            tk = DefScript.this.gettoken(script, this.modelframetokens);
                            if (tk instanceof BaseToken) {
                                int line = script.getlinum(script.ltextptr);
                                Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                                continue;
                            }
                            switch ((ModelTokens)((Object)tk)) {
                                default: {
                                    continue block74;
                                }
                                case PAL: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block74;
                                    mdpal = ivalue;
                                    continue block74;
                                }
                                case FRAME: {
                                    framename = script.getstring();
                                    continue block74;
                                }
                                case TILE: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block74;
                                    ltilenume = ftilenume = ivalue.intValue();
                                    continue block74;
                                }
                                case TILE0: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block74;
                                    ftilenume = ivalue;
                                    continue block74;
                                }
                                case TILE1: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block74;
                                    ltilenume = ivalue;
                                    continue block74;
                                }
                                case SMOOTHDURATION: 
                            }
                            dvalue = script.getdouble();
                            if (dvalue == null) continue;
                            smoothduration = dvalue;
                        }
                        script.skipbrace(frameend);
                        if (DefScript.this.check_tile_range("model: frame", ftilenume, ltilenume, script, frametokptr)) {
                            model_ok = false;
                            break;
                        }
                        for (int tilex = ftilenume; tilex <= ltilenume && happy; ++tilex) {
                            switch (DefScript.this.mdInfo.addModelInfo(m, tilex, framename, Math.max(0, this.modelskin), (float)smoothduration, mdpal)) {
                                case -1: {
                                    happy = false;
                                    break;
                                }
                                case -2: {
                                    Console.Println("Invalid tile number on line " + script.filename + ":" + script.getlinum(frametokptr), Console.OSDTEXT_RED);
                                    happy = false;
                                    break;
                                }
                                case -3: {
                                    Console.Println("Invalid frame name on line " + script.filename + ":" + script.getlinum(frametokptr), Console.OSDTEXT_RED);
                                    happy = false;
                                    break;
                                }
                            }
                            model_ok &= happy;
                        }
                        this.seenframe = 1;
                        break;
                    }
                    case ANIM: {
                        Integer ivalue;
                        Double dvalue;
                        int animtokptr = script.ltextptr;
                        boolean happy = true;
                        String startframe = null;
                        String endframe = null;
                        int flags = 0;
                        double dfps = 1.0;
                        int animend = script.getbraces();
                        if (animend == -1) break;
                        block76: while (script.textptr < animend) {
                            tk = DefScript.this.gettoken(script, this.modelanimtokens);
                            if (tk instanceof BaseToken) {
                                int line = script.getlinum(script.ltextptr);
                                Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                                continue;
                            }
                            switch ((ModelTokens)((Object)tk)) {
                                default: {
                                    continue block76;
                                }
                                case FRAME0: {
                                    startframe = script.getstring();
                                    continue block76;
                                }
                                case FRAME1: {
                                    endframe = script.getstring();
                                    continue block76;
                                }
                                case FPS: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block76;
                                    dfps = dvalue;
                                    continue block76;
                                }
                                case FLAGS: 
                            }
                            ivalue = script.getsymbol();
                            if (ivalue == null) continue;
                            flags = ivalue;
                        }
                        script.skipbrace(animend);
                        if (startframe == null) {
                            Console.Println("Error: missing 'start frame' for anim definition near line " + script.filename + ":" + script.getlinum(animtokptr), Console.OSDTEXT_RED);
                            happy = false;
                        }
                        if (endframe == null) {
                            Console.Println("Error: missing 'end frame' for anim definition near line " + script.filename + ":" + script.getlinum(animtokptr), Console.OSDTEXT_RED);
                            happy = false;
                        }
                        model_ok &= happy;
                        if (!happy) continue block73;
                        if (m.getType() == ModelInfo.Type.Voxel) break;
                        switch (((MDInfo)m).setAnimation(startframe, endframe, (int)(dfps * 65.536), flags)) {
                            case -2: {
                                Console.Println("Invalid starting frame name on line " + script.filename + ":" + script.getlinum(animtokptr), Console.OSDTEXT_RED);
                                model_ok = false;
                                break block5;
                            }
                            case -3: {
                                Console.Println("Invalid ending frame name on line " + script.filename + ":" + script.getlinum(animtokptr), Console.OSDTEXT_RED);
                                model_ok = false;
                            }
                        }
                        break;
                    }
                    case DETAIL: 
                    case GLOW: 
                    case SPECULAR: 
                    case NORMAL: 
                    case SKIN: {
                        Integer ivalue;
                        Double dvalue;
                        int skintokptr = script.ltextptr;
                        String skinfn = null;
                        int palnum = 0;
                        int surfnum = 0;
                        double param = 1.0;
                        double specpower = 1.0;
                        double specfactor = 1.0;
                        int skinend = script.getbraces();
                        if (skinend == -1) break;
                        block77: while (script.textptr < skinend) {
                            tk = DefScript.this.gettoken(script, this.modelskintokens);
                            if (tk instanceof BaseToken) {
                                int line = script.getlinum(script.ltextptr);
                                Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                                continue;
                            }
                            switch ((ModelTokens)((Object)tk)) {
                                default: {
                                    continue block77;
                                }
                                case PAL: {
                                    palnum = script.getsymbol();
                                    continue block77;
                                }
                                case PARAM: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block77;
                                    param = dvalue;
                                    continue block77;
                                }
                                case PARALLAXSCALE: {
                                    script.getdouble();
                                    continue block77;
                                }
                                case PARALLAXBIAS: {
                                    script.getdouble();
                                    continue block77;
                                }
                                case SPECPOWER: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block77;
                                    specpower = dvalue;
                                    continue block77;
                                }
                                case SPECFACTOR: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block77;
                                    specfactor = dvalue;
                                    continue block77;
                                }
                                case FILE: {
                                    skinfn = DefScript.this.getFile(script);
                                    continue block77;
                                }
                                case SURF: 
                            }
                            ivalue = script.getsymbol();
                            if (ivalue == null) continue;
                            surfnum = ivalue;
                        }
                        script.skipbrace(skinend);
                        if (skinfn == null) {
                            Console.Println("Error: missing 'skin filename' for skin definition near line " + script.filename + ":" + script.getlinum(skintokptr), Console.OSDTEXT_RED);
                            model_ok = false;
                            break;
                        }
                        if (this.seenframe != 0) {
                            this.modelskin = ++this.lastmodelskin;
                        }
                        this.seenframe = 0;
                        switch (token) {
                            default: {
                                break;
                            }
                            case DETAIL: {
                                palnum = 255;
                                param = 1.0 / param;
                                break;
                            }
                            case GLOW: {
                                palnum = 254;
                                break;
                            }
                            case SPECULAR: {
                                palnum = 253;
                                break;
                            }
                            case NORMAL: {
                                palnum = 252;
                            }
                        }
                        if (!BuildGdx.cache.contains(skinfn, 0)) continue block73;
                        if (m.getType() == ModelInfo.Type.Voxel) break;
                        switch (((MDInfo)m).setSkin(skinfn, palnum, Math.max(0, this.modelskin), surfnum, param, specpower, specfactor)) {
                            case -2: {
                                Console.Println("Invalid skin filename on line " + script.filename + ":" + script.getlinum(skintokptr), Console.OSDTEXT_RED);
                                model_ok = false;
                                break block5;
                            }
                            case -3: {
                                Console.Println("Invalid palette number on line " + script.filename + ":" + script.getlinum(skintokptr), Console.OSDTEXT_RED);
                                model_ok = false;
                            }
                        }
                        break;
                    }
                    case HUD: {
                        Integer ivalue;
                        Double dvalue;
                        int hudtokptr = script.ltextptr;
                        boolean happy = true;
                        int ftilenume = -1;
                        int ltilenume = -1;
                        int flags = 0;
                        int fov = -1;
                        double xadd = 0.0;
                        double yadd = 0.0;
                        double zadd = 0.0;
                        double angadd = 0.0;
                        int frameend = script.getbraces();
                        if (frameend == -1) break;
                        block78: while (script.textptr < frameend) {
                            tk = DefScript.this.gettoken(script, this.modelhudtokens);
                            if (tk instanceof BaseToken) {
                                int line = script.getlinum(script.ltextptr);
                                Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                                continue;
                            }
                            switch ((ModelTokens)((Object)tk)) {
                                default: {
                                    continue block78;
                                }
                                case TILE: {
                                    ivalue = script.getsymbol();
                                    if (ivalue != null) {
                                        ftilenume = ivalue;
                                    }
                                    ltilenume = ftilenume;
                                    continue block78;
                                }
                                case TILE0: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block78;
                                    ftilenume = ivalue;
                                    continue block78;
                                }
                                case TILE1: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block78;
                                    ltilenume = ivalue;
                                    continue block78;
                                }
                                case XADD: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block78;
                                    xadd = dvalue;
                                    continue block78;
                                }
                                case YADD: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block78;
                                    yadd = dvalue;
                                    continue block78;
                                }
                                case ZADD: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block78;
                                    zadd = dvalue;
                                    continue block78;
                                }
                                case ANGADD: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block78;
                                    angadd = dvalue;
                                    continue block78;
                                }
                                case FOV: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block78;
                                    fov = ivalue;
                                    continue block78;
                                }
                                case HIDE: {
                                    flags |= 1;
                                    continue block78;
                                }
                                case NOBOB: {
                                    flags |= 2;
                                    continue block78;
                                }
                                case FLIPPED: {
                                    flags |= 4;
                                    continue block78;
                                }
                                case NODEPTH: 
                            }
                            flags |= 8;
                        }
                        script.skipbrace(frameend);
                        if (DefScript.this.check_tile_range("hud", ftilenume, ltilenume, script, hudtokptr)) {
                            model_ok = false;
                            break;
                        }
                        for (int tilex = ftilenume; tilex <= ltilenume && happy; ++tilex) {
                            if (DefScript.this.mdInfo.addHudInfo(tilex, xadd, yadd, zadd, (short)angadd, flags, fov) == -2) {
                                Console.Println("Invalid tile number on line " + script.filename + ":" + script.getlinum(hudtokptr), Console.OSDTEXT_RED);
                                happy = false;
                            }
                            model_ok &= happy;
                        }
                        continue block73;
                    }
                }
            }
            script.skipbrace(modelend);
            if (!model_ok) {
                if (m != null) {
                    Console.Println("Removing model " + modelfn + " due to errors.", Console.OSDTEXT_YELLOW);
                    DefScript.this.mdInfo.removeModelInfo(m);
                }
                return BaseToken.Error;
            }
            m.setMisc((float)mdscale, (float)mzadd, (float)myoffset, mdflags);
            this.lastmodelskin = 0;
            this.modelskin = 0;
            this.seenframe = 0;
            return BaseToken.Ok;
        }
    }

    protected static enum ModelTokens {
        SCALE,
        SHADE,
        XADD,
        YADD,
        ZADD,
        FRAME,
        FRAME0,
        FRAME1,
        ANIM,
        SKIN,
        HUD,
        TILE,
        TILE0,
        TILE1,
        FPS,
        FLAGS,
        PAL,
        FILE,
        SURF,
        ANGADD,
        FOV,
        HIDE,
        NOBOB,
        FLIPPED,
        NODEPTH,
        DETAIL,
        NORMAL,
        SPECULAR,
        GLOW,
        SPECPOWER,
        SPECFACTOR,
        PARAM,
        PARALLAXSCALE,
        PARALLAXBIAS,
        SMOOTHDURATION;

    }

    protected class TileFromTextureToken
    implements Token {
        protected final Map<String, TileTextureTokens> tilefromtexturetokens = new HashMap<String, TileTextureTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("file", TileTextureTokens.FILE);
                this.put("name", TileTextureTokens.FILE);
                this.put("alphacut", TileTextureTokens.ALPHACUT);
                this.put("xoffset", TileTextureTokens.XOFFSET);
                this.put("xoff", TileTextureTokens.XOFFSET);
                this.put("yoffset", TileTextureTokens.YOFFSET);
                this.put("yoff", TileTextureTokens.YOFFSET);
                this.put("texture", TileTextureTokens.TEXTURE);
                this.put("ifcrc", TileTextureTokens.CRC);
            }
        };

        protected TileFromTextureToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            DefScript def = DefScript.this;
            int ttexturetokptr = script.ltextptr;
            String fn = null;
            int talphacut = 255;
            Byte xoffset = null;
            Byte yoffset = null;
            long tilecrc = 0L;
            boolean istexture = false;
            Integer tile = script.getsymbol();
            if (tile == null) {
                return BaseToken.Error;
            }
            int ttextureend = script.getbraces();
            if (ttextureend == -1) {
                return BaseToken.Error;
            }
            block12: while (script.textptr < ttextureend) {
                Object tk = def.gettoken(script, this.tilefromtexturetokens);
                if (tk instanceof BaseToken) {
                    int line = script.getlinum(script.ltextptr);
                    Console.Println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                    continue;
                }
                switch ((TileTextureTokens)((Object)tk)) {
                    default: {
                        continue block12;
                    }
                    case FILE: {
                        fn = def.getFile(script);
                        continue block12;
                    }
                    case ALPHACUT: {
                        Integer value = script.getsymbol();
                        if (value != null) {
                            talphacut = value;
                        }
                        talphacut = Gameutils.BClipRange(talphacut, 0, 255);
                        continue block12;
                    }
                    case XOFFSET: {
                        String xoffs = script.getstring();
                        if (xoffs.equalsIgnoreCase("ART")) {
                            xoffset = DefScript.this.engine.getTile(tile).getOffsetX();
                            continue block12;
                        }
                        try {
                            xoffset = Byte.parseByte(xoffs);
                        }
                        catch (Exception e) {
                            Console.Println("Xoffset value out of range. Value: \"" + xoffs + "\" was disabled.", Console.OSDTEXT_RED);
                        }
                        continue block12;
                    }
                    case YOFFSET: {
                        String yoffs = script.getstring();
                        if (yoffs.equalsIgnoreCase("ART")) {
                            yoffset = DefScript.this.engine.getTile(tile).getOffsetY();
                            continue block12;
                        }
                        try {
                            yoffset = Byte.parseByte(yoffs);
                        }
                        catch (Exception e) {
                            Console.Println("Yoffset value out of range. Value: \"" + yoffs + "\" was disabled.", Console.OSDTEXT_RED);
                        }
                        continue block12;
                    }
                    case TEXTURE: {
                        istexture = true;
                        continue block12;
                    }
                    case CRC: 
                }
                tilecrc = (long)script.getsymbol().intValue() & 0xFFFFFFFFL;
            }
            script.skipbrace(ttextureend);
            if (this.addTile(script, fn, tile, xoffset, yoffset, tilecrc, talphacut, istexture, ttexturetokptr) != null) {
                return BaseToken.Ok;
            }
            return BaseToken.Error;
        }

        protected DefTile addTile(Scriptfile script, String fn, Integer tile, Byte xoffset, Byte yoffset, long tilecrc, int talphacut, boolean istexture, int ttexturetokptr) {
            DefScript def = DefScript.this;
            if (tile < 0 || tile >= Engine.MAXTILES) {
                Console.Println("Error: missing or invalid 'tile number' for texture definition near line " + script.filename + ":" + script.getlinum(ttexturetokptr), Console.OSDTEXT_RED);
                return null;
            }
            if (fn == null) {
                String ext = FileUtils.getExtension(script.filename);
                DefTile deftile = new DefTile(DefScript.this.engine.getTile(tile).getWidth(), DefScript.this.engine.getTile(tile).getHeight(), tilecrc, ext != null && ext.equals("dat"));
                if (xoffset != null) {
                    deftile.xoffset = xoffset;
                }
                if (yoffset != null) {
                    deftile.yoffset = yoffset;
                }
                if (xoffset == null && yoffset == null) {
                    Console.Println("Error: missing 'file name' for tilefromtexture definition near line " + script.filename + ":" + script.getlinum(ttexturetokptr), Console.OSDTEXT_RED);
                }
                if (def.addDefTile(deftile, tile)) {
                    return deftile;
                }
                return null;
            }
            String ext = FileUtils.getExtension(script.filename);
            DefTile texstatus = this.ImportTileFromTexture(fn, tile, tilecrc, talphacut, istexture, ext != null && ext.equals("dat"));
            if (texstatus == null) {
                return null;
            }
            if (xoffset != null) {
                texstatus.xoffset = xoffset;
            }
            if (yoffset != null) {
                texstatus.yoffset = yoffset;
            }
            if (!def.addDefTile(texstatus, tile)) {
                Console.Println("Error: \"" + fn + "\" has more than one tile, in tilefromtexture definition near line " + script.filename + ":" + script.getlinum(ttexturetokptr), Console.OSDTEXT_RED);
                return null;
            }
            return texstatus;
        }

        protected DefTile ImportTileFromTexture(String fn, int tile, long crc32, int alphacut, boolean istexture, boolean internal) {
            Pixmap pix;
            DefScript def = DefScript.this;
            byte[] data = BuildGdx.cache.getBytes(fn, 0);
            if (data == null) {
                Console.Println("ImportTileFromTexture error: file " + fn + " not found!", Console.OSDTEXT_RED);
                return null;
            }
            try {
                pix = new Pixmap(data, 0, data.length);
            }
            catch (Throwable e) {
                Console.Println("ImportTileFromTexture error: " + e.getMessage(), Console.OSDTEXT_RED);
                return null;
            }
            pix.setFilter(Pixmap.Filter.NearestNeighbour);
            Pixmap.Format fmt = pix.getFormat();
            int xsiz = pix.getWidth();
            int ysiz = pix.getHeight();
            DefTile deftile = new DefTile(xsiz, ysiz, crc32, internal);
            deftile.waloff = new byte[xsiz * ysiz];
            ByteBuffer bb = pix.getPixels();
            byte[] waloff = deftile.waloff;
            for (int y = 0; y < ysiz; ++y) {
                for (int x = 0; x < xsiz; ++x) {
                    int r = (bb.get() & 0xFF) >> 2;
                    int g = (bb.get() & 0xFF) >> 2;
                    int b = (bb.get() & 0xFF) >> 2;
                    if (fmt == Pixmap.Format.RGBA4444 || fmt == Pixmap.Format.RGBA8888) {
                        if (bb.get() == 0) {
                            waloff[x * ysiz + y] = -1;
                            continue;
                        }
                        waloff[x * ysiz + y] = def.engine.getclosestcol(Engine.palette, r, g, b);
                        continue;
                    }
                    waloff[x * ysiz + y] = def.engine.getclosestcol(Engine.palette, r, g, b);
                }
            }
            if (istexture) {
                deftile.hrp = fn;
                deftile.alphacut = (byte)alphacut;
            }
            return deftile;
        }
    }

    public static enum TileTextureTokens {
        FILE,
        ALPHACUT,
        XOFFSET,
        YOFFSET,
        TEXTURE,
        CRC;

    }

    protected class AnimRangeToken
    implements Token {
        protected AnimRangeToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            Integer tile0 = script.getsymbol();
            if (tile0 == null) {
                return BaseToken.Error;
            }
            Integer tile1 = script.getsymbol();
            if (tile1 == null) {
                return BaseToken.Error;
            }
            Integer speed = script.getsymbol();
            if (speed == null) {
                return BaseToken.Error;
            }
            Integer anm = script.getsymbol();
            if (anm == null) {
                return BaseToken.Error;
            }
            int length = tile1 - tile0;
            if (length <= 0) {
                Console.Println("Warning: Animation lenght < 0, skipping", Console.OSDTEXT_RED);
                return BaseToken.Warning;
            }
            Tile pic = DefScript.this.engine.getTile(tile0);
            pic.anm &= 0xF0FFFF00;
            pic.anm |= (anm & 3) << 6 | (speed & 0xF) << 24 | length & 0x3F;
            return BaseToken.Ok;
        }
    }

    protected class EchoToken
    implements Token {
        protected EchoToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            String message = script.getstring();
            if (message != null) {
                Console.Println(message, Console.OSDTEXT_GOLD);
            } else {
                Console.Println("");
            }
            return BaseToken.Ok;
        }
    }

    protected class AddonToken
    implements Token {
        protected AddonToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            String fn;
            String addon;
            DefScript def = DefScript.this;
            if (def.addonsIncludes == null) {
                def.addonsIncludes = new HashMap();
            }
            if ((addon = script.getstring()) != null && (fn = def.getFile(script)) != null) {
                if (def.addonsIncludes.get(addon) == null) {
                    ArrayList list = new ArrayList();
                    def.addonsIncludes.put(addon, list);
                }
                def.addonsIncludes.get(addon).add(script.path);
                def.addonsIncludes.get(addon).add(fn);
            }
            return BaseToken.Ok;
        }
    }

    protected class IncludeToken
    implements Token {
        protected IncludeToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            String fn = DefScript.this.getFile(script);
            if (fn == null) {
                return BaseToken.Warning;
            }
            this.include(DefScript.this, fn, script, script.ltextptr);
            return BaseToken.Ok;
        }

        private void include(DefScript def, String fn, Scriptfile script, int cmdtokptr) {
            byte[] data = BuildGdx.cache.getBytes(fn, 0);
            if (data == null) {
                if (cmdtokptr == 0) {
                    Console.Println("Warning: Failed including " + fn + " as module", Console.OSDTEXT_YELLOW);
                } else {
                    Console.Println("Warning: Failed including " + fn + " on line " + script.filename + ":" + script.getlinum(cmdtokptr), Console.OSDTEXT_YELLOW);
                }
                return;
            }
            Scriptfile included = new Scriptfile(fn, data);
            included.path = script.path;
            def.defsparser(included);
        }
    }

    protected class MaphackToken
    implements Token {
        private final Map<String, MapHackTokens> maptokens = new HashMap<String, MapHackTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("mapfile", MapHackTokens.FILE);
                this.put("mhkfile", MapHackTokens.MHK);
                this.put("mapmd4", MapHackTokens.MD4);
                this.put("maptitle", MapHackTokens.TITLE);
            }
        };

        protected MaphackToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            int end = script.getbraces();
            if (end == -1) {
                return BaseToken.Error;
            }
            String file = null;
            String mhk = null;
            String md4 = null;
            block6: while (script.textptr < end) {
                Object tk = DefScript.this.gettoken(script, this.maptokens);
                if (DefScript.this.checkErrorToken(script, tk)) continue;
                switch ((MapHackTokens)((Object)tk)) {
                    default: {
                        continue block6;
                    }
                    case TITLE: {
                        script.getstring();
                        continue block6;
                    }
                    case FILE: {
                        file = DefScript.this.getFile(script);
                        continue block6;
                    }
                    case MHK: {
                        mhk = DefScript.this.getFile(script);
                        continue block6;
                    }
                    case MD4: 
                }
                md4 = script.getstring();
            }
            if (DefScript.this.mapInfo.addMapInfo(file, mhk, md4)) {
                return BaseToken.Ok;
            }
            return BaseToken.Error;
        }
    }

    public static enum MapHackTokens {
        FILE,
        MHK,
        MD4,
        TITLE;

    }
}

