/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Script;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.ModelHandle.MDInfo;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.ModelHandle.VoxelInfo;
import ru.m210projects.Build.Render.Types.Hudtyp;
import ru.m210projects.Build.Render.Types.Tile2model;

public class ModelsInfo {
    private final Tile2model[] cache = new Tile2model[Engine.MAXTILES];
    private final Hudtyp[][] hudInfo = new Hudtyp[2][Engine.MAXTILES];
    private final Spritesmooth[] spritesmooth = new Spritesmooth[Engine.MAXSPRITES + 256];
    private final SpriteAnim[] spriteanim = new SpriteAnim[Engine.MAXSPRITES + 256];

    public ModelsInfo() {
        int i;
        for (i = 0; i < this.spritesmooth.length; ++i) {
            this.spritesmooth[i] = new Spritesmooth();
        }
        for (i = 0; i < this.spriteanim.length; ++i) {
            this.spriteanim[i] = new SpriteAnim();
        }
    }

    public ModelsInfo(ModelsInfo src, boolean disposable) {
        int i;
        for (i = 0; i < this.cache.length; ++i) {
            if (src.cache[i] == null) continue;
            this.cache[i] = src.cache[i].clone(disposable);
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < Engine.MAXTILES; ++j) {
                if (src.hudInfo[i] == null || src.hudInfo[i][j] == null) continue;
                this.hudInfo[i][j] = src.hudInfo[i][j].clone();
            }
        }
        for (i = 0; i < this.spritesmooth.length; ++i) {
            this.spritesmooth[i] = new Spritesmooth();
        }
        for (i = 0; i < this.spriteanim.length; ++i) {
            this.spriteanim[i] = new SpriteAnim();
        }
    }

    public Spritesmooth getSmoothParams(int i) {
        return this.spritesmooth[i];
    }

    public SpriteAnim getAnimParams(int i) {
        return this.spriteanim[i];
    }

    public ModelInfo getModelInfo(int picnum) {
        if (this.cache[picnum] != null) {
            return this.cache[picnum].model;
        }
        return null;
    }

    public VoxelInfo getVoxelInfo(int picnum) {
        if (this.cache[picnum] != null) {
            return this.cache[picnum].voxel;
        }
        return null;
    }

    public int getTile(ModelInfo model) {
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            if (this.cache[i] == null || this.cache[i].model != model) continue;
            return i;
        }
        return -1;
    }

    public Tile2model getParams(int picnum) {
        if (this.cache[picnum] != null) {
            return this.cache[picnum];
        }
        return null;
    }

    public Hudtyp getHudInfo(int picnum, int flags) {
        if (this.hudInfo[flags >> 2 & 1] != null) {
            return this.hudInfo[flags >> 2 & 1][picnum];
        }
        return null;
    }

    protected Tile2model getCache(int picnum, int pal) {
        if (this.cache[picnum] == null) {
            this.cache[picnum] = new Tile2model();
            this.cache[picnum].palette = pal;
            return this.cache[picnum];
        }
        if (this.cache[picnum].palette == pal) {
            return this.cache[picnum];
        }
        Tile2model n = this.cache[picnum];
        while (n.next != null) {
            n = n.next;
            if (n.palette != pal) continue;
            return n;
        }
        Tile2model current = n.next = new Tile2model();
        current.palette = pal;
        return current;
    }

    public int addModelInfo(ModelInfo md, int picnum, String framename, int skinnum, float smooth, int pal) {
        if (picnum >= Engine.MAXTILES) {
            return -2;
        }
        if (md == null) {
            return -1;
        }
        int i = -3;
        switch (md.getType()) {
            case Voxel: {
                i = 0;
                skinnum = 0;
                smooth = 0;
                break;
            }
            case Md2: 
            case Md3: {
                if (framename == null) {
                    return -3;
                }
                i = ((MDInfo)md).getFrameIndex(framename);
            }
        }
        Tile2model current = this.getCache(picnum, pal);
        current.model = md;
        current.framenum = i;
        current.skinnum = skinnum;
        current.smoothduration = smooth;
        return i;
    }

    public int addVoxelInfo(VoxelInfo md, int picnum) {
        if (picnum >= Engine.MAXTILES) {
            return -2;
        }
        if (md == null) {
            return -1;
        }
        if (this.cache[picnum] == null) {
            this.cache[picnum] = new Tile2model();
        }
        this.cache[picnum].voxel = md;
        return 0;
    }

    public void removeModelInfo(ModelInfo md) {
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            if (this.cache[i] == null || this.cache[i].model != md) continue;
            this.cache[i].model = null;
        }
    }

    public int addHudInfo(int tilex, double xadd, double yadd, double zadd, short angadd, int flags, int fov) {
        if (tilex >= Engine.MAXTILES) {
            return -2;
        }
        if (this.hudInfo[flags >> 2 & 1] == null || this.hudInfo[flags >> 2 & 1][tilex] == null) {
            this.hudInfo[flags >> 2 & 1][tilex] = new Hudtyp();
        }
        Hudtyp hud = this.hudInfo[flags >> 2 & 1][tilex];
        hud.xadd = (float)xadd;
        hud.yadd = (float)yadd;
        hud.zadd = (float)zadd;
        hud.angadd = (short)(angadd | 0x800);
        hud.flags = (short)flags;
        hud.fov = (short)fov;
        return 0;
    }

    public void dispose() {
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            if (this.cache[i] == null || !this.cache[i].disposable) continue;
            this.cache[i] = null;
        }
    }

    public static class Spritesmooth {
        public float smoothduration;
        public short mdcurframe;
        public short mdoldframe;
        public short mdsmooth;
    }

    public static class SpriteAnim {
        public long mdanimtims;
        public short mdanimcur;
    }
}

