/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.Input.ButtonMap;
import ru.m210projects.Build.Input.Keymap;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.Tools.IniFile;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Strhandler;

public abstract class BuildConfig
extends IniFile {
    public static final int MINFOV = 60;
    public static final int MAXFOV = 140;
    public final int cfgVersion = 1901;
    public boolean isInited;
    public KeyType[] joymap = new KeyType[]{MenuKeys.Menu_Enter.setJoyNum(0), MenuKeys.Menu_Cancel.setJoyNum(1), MenuKeys.Menu_Up.setJoyNum(2), MenuKeys.Menu_Down.setJoyNum(3), MenuKeys.Menu_Left.setJoyNum(4), MenuKeys.Menu_Right.setJoyNum(5)};
    public String path;
    public String cfgPath;
    public File soundBank;
    public int version;
    public boolean startup = true;
    public boolean autoloadFolder = true;
    public boolean userfolder = false;
    public boolean checkVersion = true;
    public int fullscreen = 0;
    public int ScreenWidth = 640;
    public int ScreenHeight = 400;
    public boolean gVSync = false;
    public int fpslimit = 0;
    public boolean borderless = false;
    public int snddrv = 1;
    public int middrv = 1;
    public int midiSynth = 0;
    protected int paletteGamma = 0;
    protected float fgamma = 1.0f;
    public float gFpsScale = 1.0f;
    public KeyType[] keymap;
    public int[] primarykeys;
    public int[] secondkeys;
    public int[] mousekeys;
    public int[] gpadkeys;
    public int gJoyMoveAxis = 0;
    public int gJoyStrafeAxis = 1;
    public int gJoyLookAxis = 2;
    public int gJoyTurnAxis = 3;
    public int gJoyTurnSpeed = 65536;
    public int gJoyLookSpeed = 65536;
    public int gJoyDeadZone = 6144;
    public boolean gJoyInvert = false;
    public int gJoyDevice = -1;
    public int[] gJoyMenukeys = new int[this.joymap.length];
    public boolean useMouse = true;
    public boolean menuMouse = true;
    public int gSensitivity = 69632;
    public int gMouseTurnSpeed = 65536;
    public int gMouseLookSpeed = 65536;
    public int gMouseMoveSpeed = 65536;
    public int gMouseStrafeSpeed = 131072;
    public int gMouseCursor = 0;
    public int gMouseCursorSize = 65536;
    public boolean gMouseAim = true;
    public boolean gInvertmouse = false;
    public static final int AXISLEFT = 0;
    public static final int AXISRIGHT = 1;
    public static final int AXISUP = 2;
    public static final int AXISDOWN = 3;
    public int[] mouseaxis = new int[4];
    public float soundVolume = 1.0f;
    public float musicVolume = 1.0f;
    public boolean noSound = false;
    public boolean muteMusic = false;
    public int resampler_num = 0;
    public int maxvoices = 32;
    public int musicType = 0;
    protected boolean paletteEmulation = true;
    protected int glanisotropy = 0;
    public int widescreen = 1;
    protected int glfilter = 0;
    public boolean gShowFPS = true;
    public int gFov = 90;
    public String pName;
    public String mAddress = "localhost";
    public int mPort = 23513;
    public Renderer.RenderType renderType = Renderer.RenderType.Polymost;
    public boolean gPrecache = true;

    public BuildConfig(String path, String name) {
        this.cfgPath = path;
        this.keymap = this.getKeyMap();
        this.name = Strhandler.toLowerCase(name);
        byte[] data = null;
        try {
            RandomAccessFile raf = new RandomAccessFile(path + this.name, "r");
            data = new byte[(int)raf.length()];
            raf.read(data);
            this.init(data);
            raf.close();
        }
        catch (FileNotFoundException e) {
            Console.Println("File not found: " + path + this.name, Console.OSDTEXT_YELLOW);
        }
        catch (IOException e) {
            Console.Println("Read file error: " + e.getMessage(), Console.OSDTEXT_YELLOW);
        }
        this.primarykeys = new int[this.keymap.length];
        this.secondkeys = new int[this.keymap.length];
        this.mousekeys = new int[this.keymap.length];
        this.gpadkeys = new int[this.keymap.length];
        Arrays.fill(this.mouseaxis, -1);
        Arrays.fill(this.gpadkeys, -1);
        Arrays.fill(this.gJoyMenukeys, -1);
        this.LoadMain();
        if (this.version != 1901 && data != null) {
            try {
                int index = name.lastIndexOf(".");
                String cfgname = name.substring(0, index);
                RandomAccessFile raf = new RandomAccessFile(path + cfgname + ".old", "rw");
                raf.write(data);
                raf.close();
            }
            catch (Exception e) {
                Console.Println("Old config file error: " + e.getMessage(), Console.OSDTEXT_YELLOW);
            }
        }
    }

    public boolean isExist() {
        return this.data != null && this.version == 1901;
    }

    public void LoadMain() {
        if (this.data != null) {
            if (this.set("Main")) {
                File fbank;
                String bank;
                int afolder;
                this.version = this.GetKeyInt("ConfigVersion");
                this.startup = this.GetKeyInt("Startup") == 1;
                int check = this.GetKeyInt("CheckNewVersion");
                if (check != -1) {
                    boolean bl = this.checkVersion = check == 1;
                }
                if ((afolder = this.GetKeyInt("AutoloadFolder")) != -1) {
                    this.autoloadFolder = afolder == 1;
                }
                this.userfolder = this.GetKeyInt("UseHomeFolder") == 1;
                String respath = this.GetKeyString("Path");
                if (respath != null && !respath.isEmpty()) {
                    this.path = respath;
                }
                if ((bank = this.GetKeyString("SoundBank")) != null && !bank.isEmpty() && (fbank = new File(bank)).exists()) {
                    this.soundBank = fbank;
                }
            }
            if (this.version != 1901) {
                return;
            }
            if (this.set("ScreenSetup")) {
                int value;
                String render = this.GetKeyString("Render");
                if (render != null) {
                    if (render.equals("Classic")) {
                        this.renderType = Renderer.RenderType.Software;
                    } else {
                        Renderer.RenderType ren = Renderer.RenderType.valueOf(render);
                        if (ren != null) {
                            this.renderType = ren;
                        }
                    }
                }
                if ((value = this.GetKeyInt("Fullscreen")) != -1) {
                    this.fullscreen = value;
                }
                if ((value = this.GetKeyInt("ScreenWidth")) >= 640) {
                    this.ScreenWidth = value;
                }
                if ((value = this.GetKeyInt("ScreenHeight")) >= 400) {
                    this.ScreenHeight = value;
                }
                this.borderless = this.GetKeyInt("BorderlessMode") == 1;
                this.gVSync = this.GetKeyInt("VSync") == 1;
                value = this.GetKeyInt("FPSLimit");
                if (value != -1) {
                    this.fpslimit = value;
                }
                if ((value = this.GetKeyInt("GLFilterMode")) != -1) {
                    this.glfilter = value;
                }
                if ((value = this.GetKeyInt("GLAnisotropy")) != -1) {
                    this.glanisotropy = value;
                }
                if ((value = this.GetKeyInt("WideScreen")) != -1) {
                    this.widescreen = value;
                }
                if ((value = this.GetKeyInt("FieldOfView")) != -1 && value >= 60 && value <= 140) {
                    this.gFov = value;
                }
                if ((value = this.GetKeyInt("Palette_Emulation")) != -1) {
                    boolean bl = this.paletteEmulation = value == 1;
                }
            }
            if (this.set("SoundSetup")) {
                int type;
                int mids;
                int mid;
                this.noSound = this.GetKeyInt("NoSound") == 1;
                this.muteMusic = this.GetKeyInt("NoMusic") == 1;
                int snd = this.GetKeyInt("SoundDriver");
                if (snd != -1) {
                    this.snddrv = snd;
                }
                if ((mid = this.GetKeyInt("MidiDriver")) != -1) {
                    this.middrv = mid;
                }
                if ((mids = this.GetKeyInt("MidiSynth")) != -1) {
                    this.midiSynth = mids;
                }
                if ((type = this.GetKeyInt("MusicType")) != -1) {
                    this.musicType = type;
                }
            }
        }
        this.isInited = false;
    }

    public void LoadCommon(char[] defkeys, char[] defclassickeys) {
        int value;
        if (this.set("Main")) {
            String ip;
            String name;
            value = this.GetKeyInt("OSDTextScale");
            if (value != -1) {
                Console.setTextScale(value);
            }
            if ((value = this.GetKeyInt("UseVoxels")) != -1) {
                BuildSettings.useVoxels.set(value == 1);
            }
            if ((value = this.GetKeyInt("UseModels")) != -1) {
                GLSettings.useModels.set(value == 1);
            }
            if ((value = this.GetKeyInt("UseHightiles")) != -1) {
                GLSettings.useHighTile.set(value == 1);
            }
            if ((value = this.GetKeyInt("UsePrecache")) != -1) {
                boolean bl = this.gPrecache = value == 1;
            }
            if ((name = this.GetKeyString("Player_name")) != null) {
                this.pName = name;
            }
            if ((ip = this.GetKeyString("IP_Address")) != null) {
                this.mAddress = ip;
            }
            if ((value = this.GetKeyInt("Port")) != -1) {
                this.mPort = value;
            }
        }
        if (this.set("ScreenSetup")) {
            int gm;
            this.gVSync = this.GetKeyInt("VSync") == 1;
            value = this.GetKeyInt("FpsScale");
            if (value != -1) {
                this.gFpsScale = (float)value / 65536.0f;
            }
            if ((gm = this.GetKeyInt("GLGamma")) != -1) {
                GLSettings.gamma.set(gm);
            }
            if ((value = this.GetKeyInt("PaletteGamma")) != -1) {
                BuildSettings.paletteGamma.set(value);
            }
            boolean bl = this.gShowFPS = this.GetKeyInt("ShowFPS") == 1;
        }
        if (this.set("SoundSetup")) {
            int resampler;
            int voices;
            float value2 = (float)this.GetKeyInt("SoundVolume") / 256.0f;
            if (value2 >= 0.0f && (double)value2 < 1.0) {
                this.soundVolume = value2;
            }
            if ((voices = this.GetKeyInt("MaxVoices")) >= 0 && voices <= 256) {
                this.maxvoices = voices;
            }
            if ((resampler = this.GetKeyInt("Resampler")) != -1) {
                this.resampler_num = resampler;
            }
            if ((value2 = (float)this.GetKeyInt("MusicVolume") / 256.0f) >= 0.0f && (double)value2 < 1.0) {
                this.musicVolume = value2;
            }
        }
        if (this.set("KeyDefinitions")) {
            String down;
            String up;
            String right;
            String left;
            for (int i = 0; i < this.keymap.length; ++i) {
                this.primarykeys[i] = defkeys[i];
                this.secondkeys[i] = 0;
                this.mousekeys[i] = 0;
                this.gpadkeys[i] = -1;
                String primary = this.GetKeyString(this.keymap[i].getName(), 0);
                String secondary = this.GetKeyString(this.keymap[i].getName(), 1);
                String mouse = this.GetKeyString(this.keymap[i].getName(), 2);
                String joystick = this.GetKeyString(this.keymap[i].getName(), 3);
                if (primary != null) {
                    this.primarykeys[i] = Keymap.valueOf(primary);
                }
                if (secondary != null) {
                    this.secondkeys[i] = Keymap.valueOf(secondary);
                }
                if (mouse != null) {
                    this.mousekeys[i] = Keymap.valueOf(mouse);
                }
                if (joystick == null) continue;
                this.gpadkeys[i] = ButtonMap.valueOf(joystick);
            }
            if (this.primarykeys[GameKeys.Menu_Toggle.getNum()] == 0) {
                this.primarykeys[GameKeys.Menu_Toggle.getNum()] = defclassickeys[GameKeys.Menu_Toggle.getNum()];
            }
            if ((left = this.GetKeyString("MouseDigitalAxes0_0")) != null) {
                this.mouseaxis[0] = this.getKeyIndex(left);
            }
            if ((right = this.GetKeyString("MouseDigitalAxes0_1")) != null) {
                this.mouseaxis[1] = this.getKeyIndex(right);
            }
            if ((up = this.GetKeyString("MouseDigitalAxes1_0")) != null) {
                this.mouseaxis[2] = this.getKeyIndex(up);
            }
            if ((down = this.GetKeyString("MouseDigitalAxes1_1")) != null) {
                this.mouseaxis[3] = this.getKeyIndex(down);
            }
        }
        if (this.set("JoyDefinitions")) {
            for (int i = 0; i < this.joymap.length; ++i) {
                this.gJoyMenukeys[((MenuKeys)this.joymap[i]).getJoyNum()] = -1;
                String joymenu = this.GetKeyString(this.joymap[i].getName(), 0);
                if (joymenu == null) continue;
                this.gJoyMenukeys[((MenuKeys)this.joymap[i]).getJoyNum()] = ButtonMap.valueOf(joymenu);
            }
        }
        if (this.set("Controls")) {
            int value3 = this.GetKeyInt("UseMouse");
            if (value3 != -1) {
                boolean bl = this.useMouse = value3 == 1;
            }
            if ((value3 = this.GetKeyInt("UseMouseInMenu")) != -1) {
                boolean bl = this.menuMouse = value3 == 1;
            }
            if ((value3 = this.GetKeyInt("MouseSensitivity")) != -1) {
                this.gSensitivity = value3;
            }
            if ((value3 = this.GetKeyInt("MouseAiming")) != -1) {
                boolean bl = this.gMouseAim = value3 == 1;
            }
            if ((value3 = this.GetKeyInt("MouseAimingFlipped")) != -1) {
                boolean bl = this.gInvertmouse = value3 == 1;
            }
            if ((value3 = this.GetKeyInt("MouseTurnSpeed")) != -1) {
                this.gMouseTurnSpeed = value3;
            }
            if ((value3 = this.GetKeyInt("MouseLookSpeed")) != -1) {
                this.gMouseLookSpeed = value3;
            }
            if ((value3 = this.GetKeyInt("MouseMoveSpeed")) != -1) {
                this.gMouseMoveSpeed = value3;
            }
            if ((value3 = this.GetKeyInt("MouseStrafeSpeed")) != -1) {
                this.gMouseStrafeSpeed = value3;
            }
            if ((value3 = this.GetKeyInt("MouseCursor")) != -1) {
                this.gMouseCursor = value3;
            }
            if ((value3 = this.GetKeyInt("MouseCursorSize")) != -1) {
                this.gMouseCursorSize = value3;
            }
            if ((value3 = this.GetKeyInt("JoyDevice")) != -1) {
                this.gJoyDevice = value3;
            }
            if ((value3 = this.GetKeyInt("JoyTurnAxis")) != -1) {
                this.gJoyTurnAxis = value3;
            }
            if ((value3 = this.GetKeyInt("JoyMoveAxis")) != -1) {
                this.gJoyMoveAxis = value3;
            }
            if ((value3 = this.GetKeyInt("JoyStrafeAxis")) != -1) {
                this.gJoyStrafeAxis = value3;
            }
            if ((value3 = this.GetKeyInt("JoyLookAxis")) != -1) {
                this.gJoyLookAxis = value3;
            }
            if ((value3 = this.GetKeyInt("JoyTurnSpeed")) != -1) {
                this.gJoyTurnSpeed = value3;
            }
            if ((value3 = this.GetKeyInt("JoyLookSpeed")) != -1) {
                this.gJoyLookSpeed = value3;
            }
            if ((value3 = this.GetKeyInt("JoyInvertLook")) != -1) {
                boolean bl = this.gJoyInvert = value3 == 1;
            }
            if ((value3 = this.GetKeyInt("JoyDeadZone")) != -1) {
                this.gJoyDeadZone = value3;
            }
        }
    }

    public void saveConfig(Compat compat, String path) {
        if (!this.isInited) {
            FileResource fil = compat.open(this.cfgPath + this.name, Compat.Path.Absolute, FileResource.Mode.Write);
            if (fil != null) {
                this.SaveUninited(fil);
                fil.close();
            }
            return;
        }
        FileResource fil = compat.open(this.cfgPath + this.name, Compat.Path.Absolute, FileResource.Mode.Write);
        if (fil != null) {
            this.SaveMain(fil, path);
            this.SaveCommon(fil);
            this.SaveConfig(fil);
            fil.close();
        }
    }

    public void SaveCommon(FileResource fil) {
        String line;
        int i;
        this.saveString(fil, "[KeyDefinitions]\r\n");
        for (i = 0; i < this.keymap.length; ++i) {
            line = this.keymap[i] + " = \"" + Keymap.toString(this.primarykeys[i]) + "\", \"" + Keymap.toString(this.secondkeys[i]) + "\", \"" + Keymap.toString(this.mousekeys[i]) + "\", \"" + ButtonMap.buttonName(this.gpadkeys[i]) + "\"\r\n";
            this.saveString(fil, line);
        }
        this.saveString(fil, ";\r\n");
        this.saveString(fil, "MouseDigitalAxes0_0 " + (this.mouseaxis[0] != -1 ? "= " + this.keymap[this.mouseaxis[0]] : "= \"N/A\"") + "\r\n");
        this.saveString(fil, "MouseDigitalAxes0_1 " + (this.mouseaxis[1] != -1 ? "= " + this.keymap[this.mouseaxis[1]] : "= \"N/A\"") + "\r\n");
        this.saveString(fil, "MouseDigitalAxes1_0 " + (this.mouseaxis[2] != -1 ? "= " + this.keymap[this.mouseaxis[2]] : "= \"N/A\"") + "\r\n");
        this.saveString(fil, "MouseDigitalAxes1_1 " + (this.mouseaxis[3] != -1 ? "= " + this.keymap[this.mouseaxis[3]] : "= \"N/A\"") + "\r\n");
        this.saveString(fil, ";\r\n");
        this.saveString(fil, "[JoyDefinitions]\r\n");
        for (i = 0; i < this.joymap.length; ++i) {
            line = this.joymap[i] + " = \"" + ButtonMap.buttonName(this.gJoyMenukeys[((MenuKeys)this.joymap[i]).getJoyNum()]) + "\"\r\n";
            this.saveString(fil, line);
        }
        this.saveString(fil, ";\r\n;\r\n");
        this.saveString(fil, "[Controls]\r\n");
        this.saveBoolean(fil, "UseMouse", this.useMouse);
        this.saveBoolean(fil, "UseMouseInMenu", this.menuMouse);
        this.saveInteger(fil, "MouseSensitivity", this.gSensitivity);
        this.saveBoolean(fil, "MouseAiming", this.gMouseAim);
        this.saveBoolean(fil, "MouseAimingFlipped", this.gInvertmouse);
        this.saveInteger(fil, "MouseTurnSpeed", this.gMouseTurnSpeed);
        this.saveInteger(fil, "MouseLookSpeed", this.gMouseLookSpeed);
        this.saveInteger(fil, "MouseMoveSpeed", this.gMouseMoveSpeed);
        this.saveInteger(fil, "MouseStrafeSpeed", this.gMouseStrafeSpeed);
        this.saveInteger(fil, "MouseCursor", this.gMouseCursor);
        this.saveInteger(fil, "MouseCursorSize", this.gMouseCursorSize);
        this.saveInteger(fil, "JoyDevice", this.gJoyDevice);
        this.saveInteger(fil, "JoyTurnAxis", this.gJoyTurnAxis);
        this.saveInteger(fil, "JoyMoveAxis", this.gJoyMoveAxis);
        this.saveInteger(fil, "JoyStrafeAxis", this.gJoyStrafeAxis);
        this.saveInteger(fil, "JoyLookAxis", this.gJoyLookAxis);
        this.saveInteger(fil, "JoyTurnSpeed", this.gJoyTurnSpeed);
        this.saveInteger(fil, "JoyLookSpeed", this.gJoyLookSpeed);
        this.saveBoolean(fil, "JoyInvertLook", this.gJoyInvert);
        this.saveInteger(fil, "JoyDeadZone", this.gJoyDeadZone);
        this.saveString(fil, ";\r\n;\r\n");
    }

    public void SaveMain(FileResource fil, String path) {
        this.saveString(fil, "[Main]\r\n");
        this.saveInteger(fil, "ConfigVersion", 1901);
        this.saveBoolean(fil, "Startup", this.startup);
        this.saveBoolean(fil, "CheckNewVersion", this.checkVersion);
        this.saveBoolean(fil, "AutoloadFolder", this.autoloadFolder);
        this.saveBoolean(fil, "UseHomeFolder", this.userfolder);
        this.saveString(fil, "Path = ");
        byte[] buf = path.getBytes();
        fil.writeBytes(buf, buf.length);
        if (this.soundBank != null) {
            this.saveString(fil, "\r\nSoundBank = " + this.soundBank.getAbsolutePath() + "\r\n");
        } else {
            this.saveString(fil, "\r\nSoundBank = \r\n");
        }
        this.saveInteger(fil, "OSDTextScale", Console.getTextScale());
        this.saveBoolean(fil, "UseVoxels", BuildSettings.useVoxels.get());
        this.saveBoolean(fil, "UseModels", GLSettings.useModels.get());
        this.saveBoolean(fil, "UseHightiles", GLSettings.useHighTile.get());
        this.saveBoolean(fil, "UsePrecache", this.gPrecache);
        this.saveString(fil, "Player_name", this.pName);
        this.saveString(fil, "IP_Address", this.mAddress);
        this.saveInteger(fil, "Port", this.mPort);
        this.saveString(fil, ";\r\n;\r\n");
        this.saveString(fil, "[ScreenSetup]\r\n");
        this.saveString(fil, "Render", this.renderType.getName());
        this.saveInteger(fil, "Fullscreen", this.fullscreen);
        this.saveInteger(fil, "ScreenWidth", this.ScreenWidth);
        this.saveInteger(fil, "ScreenHeight", this.ScreenHeight);
        this.saveBoolean(fil, "BorderlessMode", this.borderless);
        this.saveBoolean(fil, "VSync", this.gVSync);
        this.saveInteger(fil, "FPSLimit", this.fpslimit);
        this.saveInteger(fil, "GLFilterMode", this.glfilter);
        this.saveInteger(fil, "GLAnisotropy", this.glanisotropy);
        this.saveInteger(fil, "WideScreen", this.widescreen);
        this.saveInteger(fil, "FieldOfView", this.gFov);
        this.saveInteger(fil, "FpsScale", (int)(this.gFpsScale * 65536.0f));
        this.saveBoolean(fil, "Palette_Emulation", this.paletteEmulation);
        this.saveInteger(fil, "GLGamma", GLSettings.gamma.get());
        this.saveInteger(fil, "PaletteGamma", BuildSettings.paletteGamma.get());
        this.saveBoolean(fil, "ShowFPS", this.gShowFPS);
        this.saveString(fil, ";\r\n;\r\n");
        this.saveString(fil, "[SoundSetup]\r\n");
        this.saveBoolean(fil, "NoSound", this.noSound);
        this.saveBoolean(fil, "NoMusic", this.muteMusic);
        this.saveInteger(fil, "SoundDriver", this.snddrv);
        this.saveInteger(fil, "MidiDriver", this.middrv);
        this.saveInteger(fil, "MidiSynth", this.midiSynth);
        this.saveInteger(fil, "MusicType", this.musicType);
        this.saveInteger(fil, "SoundVolume", (int)(this.soundVolume * 256.0f));
        this.saveInteger(fil, "MaxVoices", this.maxvoices);
        this.saveInteger(fil, "Resampler", this.resampler_num);
        this.saveInteger(fil, "MusicVolume", (int)(this.musicVolume * 256.0f));
        this.saveString(fil, ";\r\n;\r\n");
    }

    public abstract void SaveConfig(FileResource var1);

    public abstract boolean InitConfig(boolean var1);

    public void InitKeymap() {
        for (int i = 0; i < this.keymap.length; ++i) {
            this.keymap[i].setNum(i);
        }
    }

    public abstract KeyType[] getKeyMap();

    public void setKey(int index, int keyId) {
        int i;
        if (this.primarykeys[index] == 0 && this.secondkeys[index] == 0) {
            this.primarykeys[index] = keyId;
        } else if (this.primarykeys[index] != 0 && this.secondkeys[index] == 0) {
            if (keyId != this.primarykeys[index]) {
                this.secondkeys[index] = this.primarykeys[index];
                this.primarykeys[index] = keyId;
            } else {
                this.secondkeys[index] = 0;
            }
        } else if (keyId == this.primarykeys[index] || keyId == this.secondkeys[index]) {
            this.primarykeys[index] = keyId;
            this.secondkeys[index] = 0;
        } else {
            this.secondkeys[index] = this.primarykeys[index];
            this.primarykeys[index] = keyId;
        }
        for (i = 0; i < this.primarykeys.length; ++i) {
            if (i == index || keyId != this.primarykeys[i]) continue;
            if (this.primarykeys[i] != 0 && this.secondkeys[i] != 0) {
                this.primarykeys[i] = this.secondkeys[i];
                this.secondkeys[i] = 0;
                continue;
            }
            this.primarykeys[i] = 0;
        }
        for (i = 0; i < this.secondkeys.length; ++i) {
            if (i == index || keyId != this.secondkeys[i]) continue;
            this.secondkeys[i] = 0;
        }
    }

    public void setButton(KeyType key, int button) {
        if (key instanceof MenuKeys) {
            MenuKeys mk = (MenuKeys)key;
            this.gJoyMenukeys[mk.getJoyNum()] = button;
        } else {
            this.gpadkeys[key.getNum()] = button;
        }
    }

    public int getKeyIndex(String keyname) {
        keyname = keyname.replaceAll("[^a-zA-Z_-]", "");
        for (int i = 0; i < this.keymap.length; ++i) {
            if (!keyname.equals(this.keymap[i].getName())) continue;
            return i;
        }
        return -1;
    }

    public void saveBoolean(FileResource fil, String name, boolean var) {
        String line = name + " = " + (var ? 1 : 0) + "\r\n";
        fil.writeBytes(line.toCharArray(), line.length());
    }

    public void saveInteger(FileResource fil, String name, int var) {
        String line = name + " = " + var + "\r\n";
        fil.writeBytes(line.toCharArray(), line.length());
    }

    public void saveString(FileResource fil, String text) {
        fil.writeBytes(text.toCharArray(), text.length());
    }

    public void saveString(FileResource fil, String name, String var) {
        String line = name + " = " + var + "\r\n";
        fil.writeBytes(line.toCharArray(), line.length());
    }

    public void SaveUninited(FileResource fil) {
        if (this.data == null) {
            return;
        }
        this.set("Main");
        this.saveString(fil, "[Main]\r\n");
        this.saveInteger(fil, "ConfigVersion", 1901);
        this.saveBoolean(fil, "Startup", this.startup);
        this.saveBoolean(fil, "CheckNewVersion", this.checkVersion);
        this.saveBoolean(fil, "AutoloadFolder", this.autoloadFolder);
        this.saveBoolean(fil, "UseHomeFolder", this.userfolder);
        this.saveString(fil, "Path = ");
        if (this.path != null) {
            byte[] buf = this.path.getBytes();
            fil.writeBytes(buf, buf.length);
        }
        if (this.soundBank != null) {
            this.saveString(fil, "\r\nSoundBank = " + this.soundBank.getAbsolutePath() + "\r\n");
        } else {
            this.saveString(fil, "\r\nSoundBank = \r\n");
        }
        this.saveInteger(fil, "OSDTextScale", this.GetKeyInt("OSDTextScale"));
        this.saveBoolean(fil, "UseVoxels", this.GetKeyInt("UseVoxels") == 1);
        this.saveBoolean(fil, "UseModels", this.GetKeyInt("UseModels") == 1);
        this.saveBoolean(fil, "UseHightiles", this.GetKeyInt("UseHightiles") == 1);
        this.saveString(fil, "Player_name", this.GetKeyString("Player_name"));
        this.saveString(fil, "IP_Address", this.GetKeyString("IP_Address"));
        this.saveInteger(fil, "Port", this.GetKeyInt("Port"));
        this.saveString(fil, ";\r\n;\r\n");
        this.set("ScreenSetup");
        this.saveString(fil, "[ScreenSetup]\r\n");
        this.saveString(fil, "Render", this.renderType.getName());
        this.saveInteger(fil, "Fullscreen", this.fullscreen);
        this.saveInteger(fil, "ScreenWidth", this.ScreenWidth);
        this.saveInteger(fil, "ScreenHeight", this.ScreenHeight);
        this.saveBoolean(fil, "BorderlessMode", this.borderless);
        this.saveBoolean(fil, "VSync", this.GetKeyInt("VSync") == 1);
        this.saveInteger(fil, "FPSLimit", this.GetKeyInt("FPSLimit"));
        this.saveInteger(fil, "GLFilterMode", this.GetKeyInt("GLFilterMode"));
        this.saveInteger(fil, "GLAnisotropy", this.GetKeyInt("GLAnisotropy"));
        this.saveInteger(fil, "WideScreen", this.GetKeyInt("WideScreen"));
        this.saveInteger(fil, "FieldOfView", this.GetKeyInt("FieldOfView"));
        this.saveInteger(fil, "FpsScale", this.GetKeyInt("FpsScale"));
        this.saveBoolean(fil, "Palette_Emulation", this.GetKeyInt("Palette_Emulation") == 1);
        this.saveInteger(fil, "GLGamma", this.GetKeyInt("GLGamma"));
        this.saveInteger(fil, "GLBrightness", this.GetKeyInt("GLBrightness"));
        this.saveInteger(fil, "GLContrast", this.GetKeyInt("GLContrast"));
        this.saveInteger(fil, "PaletteGamma", this.GetKeyInt("PaletteGamma"));
        this.saveBoolean(fil, "ShowFPS", this.GetKeyInt("ShowFPS") == 1);
        this.saveString(fil, ";\r\n;\r\n");
        this.set("SoundSetup");
        this.saveString(fil, "[SoundSetup]\r\n");
        this.saveBoolean(fil, "NoSound", this.GetKeyInt("NoSound") == 1);
        this.saveBoolean(fil, "NoMusic", this.GetKeyInt("NoMusic") == 1);
        this.saveInteger(fil, "SoundDriver", this.snddrv);
        this.saveInteger(fil, "MidiDriver", this.middrv);
        this.saveInteger(fil, "MidiSynth", this.midiSynth);
        this.saveInteger(fil, "MusicType", this.GetKeyInt("MusicType"));
        this.saveInteger(fil, "SoundVolume", this.GetKeyInt("SoundVolume"));
        this.saveInteger(fil, "MaxVoices", this.GetKeyInt("MaxVoices"));
        this.saveInteger(fil, "Resampler", this.GetKeyInt("Resampler"));
        this.saveInteger(fil, "MusicVolume", this.GetKeyInt("MusicVolume"));
        this.saveString(fil, ";\r\n;\r\n");
        String gamePart = new String(this.data);
        int index = gamePart.indexOf("[KeyDefinitions]");
        if (index != -1) {
            gamePart = gamePart.substring(index);
            fil.writeBytes(gamePart.toCharArray(), gamePart.length());
        }
    }

    public static interface KeyType {
        public int getNum();

        public KeyType setNum(int var1);

        public String getName();
    }

    public static enum MenuKeys implements KeyType
    {
        Menu_Enter,
        Menu_Cancel,
        Menu_Up,
        Menu_Down,
        Menu_Left,
        Menu_Right;

        private int num = -1;
        private int joynum = -1;

        @Override
        public int getNum() {
            return this.num;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public KeyType setNum(int num) {
            this.num = num;
            return this;
        }

        public int getJoyNum() {
            return this.joynum;
        }

        public KeyType setJoyNum(int num) {
            this.joynum = num;
            return this;
        }
    }

    public static enum GameKeys implements KeyType
    {
        Move_Forward,
        Move_Backward,
        Turn_Left,
        Turn_Right,
        Turn_Around,
        Strafe,
        Strafe_Left,
        Strafe_Right,
        Jump,
        Crouch,
        Run,
        Open,
        Weapon_Fire,
        Next_Weapon,
        Previous_Weapon,
        Look_Up,
        Look_Down,
        Map_Toggle,
        Enlarge_Screen,
        Shrink_Screen,
        Send_Message,
        Mouse_Aiming,
        Menu_Toggle,
        Show_Console;

        private int num = -1;
        private String name;

        @Override
        public int getNum() {
            return this.num;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name != null ? this.name : this.name();
        }

        @Override
        public KeyType setNum(int num) {
            this.num = num;
            return this;
        }
    }
}

