/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public class LinkedList<T>
implements Iterable<T> {
    private LinkedListIterator it;
    protected Node<T> head;
    protected Node<T> tail;
    protected int size;

    public void clear() {
        Node<T> node = this.head;
        while (node != null) {
            node.prev = null;
            node.next = null;
            node = node.next;
        }
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean remove(Node<T> item) {
        if (this.size == 0) {
            return false;
        }
        if (item.equals(this.tail)) {
            this.removeLast();
            return true;
        }
        if (item.equals(this.head)) {
            this.removeFirst();
            return true;
        }
        Node<T> node = this.head;
        while (node != null) {
            if (item.equals(node)) {
                node.unlink();
                --this.size;
                return true;
            }
            node = node.next;
        }
        return false;
    }

    public void removeFirst() {
        this.head = this.head.unlink();
        if (--this.size == 0) {
            this.tail = null;
        }
    }

    public void removeLast() {
        Node prev = this.tail.prev;
        this.tail.unlink();
        this.tail = prev;
        if (--this.size == 0) {
            this.head = null;
        }
    }

    public void add(Node<T> item, Comparator<T> c) {
        if (item.next != null || item.prev != null) {
            return;
        }
        this.insertBefore(this.compare(item, c), item);
    }

    public void add(Node<T> node) {
        if (node == null || node.equals(this.tail) || node.equals(this.head)) {
            return;
        }
        if (this.tail != null) {
            this.tail.next = node;
            node.prev = this.tail;
        } else {
            this.head = node;
        }
        this.tail = node;
        ++this.size;
    }

    public Node<T> compare(Node<T> item, Comparator<T> c) {
        Node<T> node;
        for (node = this.head; node != null && c.compare(item.getValue(), node.getValue()) >= 0; node = node.next()) {
        }
        return node;
    }

    public void insertBefore(Node<T> node, Node<T> item) {
        if (node == null) {
            this.add(item);
            return;
        }
        node.insertBefore(item);
        if (node.equals(this.head)) {
            this.head = item;
        }
        ++this.size;
    }

    public void insertAfter(Node<T> node, Node<T> item) {
        if (node == null) {
            this.add(item);
            return;
        }
        node.insertAfter(item);
        if (node.equals(this.tail)) {
            this.tail = item;
        }
        ++this.size;
    }

    public T next(Node<T> node) {
        if (node.next != null) {
            return node.next.getValue();
        }
        return null;
    }

    public T prev(Node<T> node) {
        if (node.prev != null) {
            return node.prev.getValue();
        }
        return null;
    }

    public T getFirst() {
        if (this.head != null) {
            return this.head.getValue();
        }
        return null;
    }

    public T getLast() {
        if (this.tail != null) {
            return this.tail.getValue();
        }
        return null;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.it == null) {
            this.it = new LinkedListIterator();
        }
        return this.it.init();
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Node<T> x = this.head;
        while (x != null) {
            result[i++] = x;
            x = x.next;
        }
        return result;
    }

    public void sort(Comparator<T> c) {
        if (this.size == 0) {
            return;
        }
        Object[] a = this.toArray();
        Arrays.sort(a, c);
        this.head = (Node)a[0];
        this.tail = (Node)a[this.size - 1];
        Node<T> node = this.head;
        Node<T> prev = null;
        for (int i = 1; i < this.size; ++i) {
            node.next = (Node)a[i];
            node.prev = prev;
            prev = node;
            node = node.next;
        }
        node.next = null;
        node.prev = prev;
    }

    public String toString() {
        Iterator<T> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            T e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public static abstract class Node<T> {
        protected Node<T> next;
        protected Node<T> prev;

        public final Node<T> unlink() {
            Node<T> t = this.next;
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            this.prev = null;
            this.next = null;
            return t;
        }

        protected final void insertAfter(Node<T> node) {
            if (node.equals(this)) {
                return;
            }
            node.next = this.next;
            node.prev = this;
            if (this.next != null) {
                this.next.prev = node;
            }
            this.next = node;
        }

        protected final void insertBefore(Node<T> node) {
            if (node.equals(this)) {
                return;
            }
            node.next = this;
            node.prev = this.prev;
            if (this.prev != null) {
                this.prev.next = node;
            }
            this.prev = node;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Node<T> next() {
            return this.next;
        }

        public Node<T> prev() {
            return this.prev;
        }

        public abstract T getValue();
    }

    private final class LinkedListIterator
    implements Iterator<T> {
        Node<T> node;

        private LinkedListIterator() {
            this.node = LinkedList.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public T next() {
            Node node = this.node;
            this.node = node.next;
            return node.getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public Iterator<T> init() {
            this.node = LinkedList.this.head;
            return this;
        }
    }
}

