/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import ru.m210projects.Build.Types.QuickSort;

public class RuntimeArray<E>
extends AbstractList<E> {
    private static final Object[] EMPTY_ELEMENTDATA = new Object[0];
    protected E[] elementData = EMPTY_ELEMENTDATA;
    protected int size;

    @Override
    public boolean add(E e) {
        this.ensureExplicitCapacity(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.ensureExplicitCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    @Override
    public E get(int index) {
        return this.elementData[index];
    }

    @Override
    public E set(int index, E element) {
        E oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public E remove(int index) {
        E oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
        return oldValue;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public E[] getArray() {
        return this.elementData;
    }

    @Override
    public void sort(Comparator<? super E> c) {
        QuickSort.sort(this.elementData, this.size, c);
    }

    private void ensureExplicitCapacity(int minCapacity) {
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }
}

