/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Types.TileFont;

public class SmallTextFont
extends TileFont {
    public SmallTextFont() {
        super(TileFont.FontType.Bitmap, Engine.smalltextfont, 4, 6, 16, 16);
        this.sizx = 128;
        this.sizy = 128;
    }

    @Override
    public GLTile getGL(TextureManager textureCache, TileData.PixelFormat fmt, int col) {
        if (this.atlas == null || this.atlas.getTextureObjectHandle() == 0) {
            this.init(textureCache);
        }
        return this.atlas;
    }

    private GLTile init(TextureManager textureCache) {
        TileFont.TileFontData dat = new TileFont.TileFontData(this.sizx, this.sizy){

            @Override
            public ByteBuffer buildAtlas(ByteBuffer data) {
                for (int h = 0; h < 256; ++h) {
                    int tptr = h % 16 * 8 + h / 16 * SmallTextFont.this.sizx * 8;
                    for (int i = 1; i < 7; ++i) {
                        for (int j = 2; j < 6; ++j) {
                            data.put(tptr + j - 2, (Engine.smalltextfont[h * 8 + i] & Engine.pow2char[7 - j]) != 0 ? (byte)-1 : 0);
                        }
                        tptr += SmallTextFont.this.sizx;
                    }
                }
                return data;
            }

            @Override
            public int getGLInternalFormat() {
                return 6406;
            }

            @Override
            public int getGLFormat() {
                return 6406;
            }
        };
        this.atlas = textureCache.newTile(dat, 0, false);
        this.atlas.setupTextureFilter(GLSettings.glfiltermodes[0], 1);
        return this.atlas;
    }
}

