/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.AWT;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.utils.Array;
import java.awt.DisplayMode;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import ru.m210projects.Build.Architecture.BuildConfiguration;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Render.Types.GL10;
import ru.m210projects.Build.desktop.AWT.JDisplay;
import ru.m210projects.Build.desktop.AWT.Sync;

public class AWTGraphics
extends BuildGraphics {
    protected JDisplay display;
    private final BuildConfiguration config;

    public AWTGraphics(BuildConfiguration config) {
        this.config = config;
    }

    @Override
    public Graphics.GraphicsType getType() {
        return null;
    }

    @Override
    protected int getRefreshRate() {
        return this.display.getDesktopDisplayMode().getRefreshRate();
    }

    @Override
    protected boolean isDirty() {
        return false;
    }

    @Override
    protected void sync(int fps) {
        Sync.sync(fps);
    }

    @Override
    protected void init() throws Exception {
        this.display = new JDisplay(this.config.width, this.config.height, this.config.borderless);
        try {
            Array<String> iconPaths = this.config.getIconPaths();
            if (iconPaths.size > 0) {
                ArrayList<Image> icons = new ArrayList<Image>();
                int n = iconPaths.size;
                for (int i = 0; i < n; ++i) {
                    FileHandle file = BuildGdx.files.getFileHandle(iconPaths.get(i), this.config.getIconFileTypes().get(i));
                    ImageIcon icon = new ImageIcon(file.readBytes());
                    icons.add(icon.getImage());
                }
                this.display.setIcon(icons);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.display.setTitle(this.config.title);
        this.display.setResizable(this.config.resizable);
        this.display.setLocation(this.config.x, this.config.y);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (((AWTGraphics)AWTGraphics.this).config.fullscreen) {
                    Graphics.DisplayMode bestMode = null;
                    for (Graphics.DisplayMode mode : AWTGraphics.this.getDisplayModes()) {
                        if (mode.width != ((AWTGraphics)AWTGraphics.this).config.width || mode.height != ((AWTGraphics)AWTGraphics.this).config.height || bestMode != null && bestMode.refreshRate >= mode.refreshRate) continue;
                        bestMode = mode;
                    }
                    if (bestMode == null) {
                        bestMode = AWTGraphics.this.getDesktopDisplayMode();
                    }
                    AWTGraphics.this.setFullscreenMode(bestMode);
                }
                AWTGraphics.this.display.m_frame.setVisible(true);
                AWTGraphics.this.display.getCanvas().setFocusable(true);
                AWTGraphics.this.display.getCanvas().requestFocus();
            }
        });
    }

    @Override
    protected void update() {
        this.display.update();
    }

    @Override
    protected void updateSize(int width, int height) {
        this.display.updateSize(width, height);
    }

    @Override
    protected boolean wasResized() {
        return this.display.wasResized();
    }

    @Override
    protected int getX() {
        return this.display.getX();
    }

    @Override
    protected int getY() {
        return this.display.getY();
    }

    @Override
    protected boolean isActive() {
        return this.display.isActive();
    }

    @Override
    protected boolean isCloseRequested() {
        return this.display.isCloseRequested();
    }

    @Override
    protected void dispose() {
        this.display.dispose();
    }

    @Override
    public int getWidth() {
        return this.display.getWidth();
    }

    @Override
    public int getHeight() {
        return this.display.getHeight();
    }

    @Override
    public void setFramesPerSecond(int fps) {
        this.config.foregroundFPS = fps;
        this.config.backgroundFPS = fps;
    }

    @Override
    public BuildFrame.FrameType getFrameType() {
        return BuildFrame.FrameType.Canvas;
    }

    @Override
    public boolean supportsDisplayModeChange() {
        return true;
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes() {
        DisplayMode[] availableDisplayModes = this.display.getDisplayModes();
        Graphics.DisplayMode[] modes = new Graphics.DisplayMode[availableDisplayModes.length];
        int idx = 0;
        for (DisplayMode mode : availableDisplayModes) {
            modes[idx++] = new SoftDisplayMode(mode.getWidth(), mode.getHeight(), mode.getRefreshRate(), mode.getBitDepth(), mode);
        }
        return modes;
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        return this.getDisplayModes();
    }

    @Override
    public Graphics.DisplayMode getDisplayMode() {
        return this.getDesktopDisplayMode();
    }

    @Override
    public Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        return this.getDisplayMode();
    }

    @Override
    public Graphics.DisplayMode getDesktopDisplayMode() {
        DisplayMode mode = this.display.getDesktopDisplayMode();
        return new SoftDisplayMode(mode.getWidth(), mode.getHeight(), mode.getRefreshRate(), mode.getBitDepth(), mode);
    }

    @Override
    public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
        DisplayMode mode = ((SoftDisplayMode)displayMode).mode;
        if (this.display.setFullscreenMode(mode)) {
            this.config.width = mode.getWidth();
            this.config.height = mode.getHeight();
            this.resize = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean setWindowedMode(int width, int height) {
        if (this.getWidth() == width && this.getHeight() == height && !this.display.isFullscreen()) {
            return true;
        }
        DisplayMode targetDisplayMode = new DisplayMode(width, height, this.display.getDesktopDisplayMode().getRefreshRate(), this.display.getDesktopDisplayMode().getBitDepth());
        this.display.setWindowedMode(targetDisplayMode);
        this.display.setResizable(this.config.resizable);
        this.config.width = targetDisplayMode.getWidth();
        this.config.height = targetDisplayMode.getHeight();
        this.resize = true;
        return true;
    }

    @Override
    public void setTitle(String title) {
        this.display.setTitle(title);
    }

    @Override
    public void setUndecorated(boolean undecorated) {
        this.display.setUndecorated(undecorated);
    }

    @Override
    public void setResizable(boolean resizable) {
        this.display.setResizable(resizable);
    }

    @Override
    public void setVSync(boolean vsync) {
        this.vsync = vsync;
    }

    @Override
    public boolean isFullscreen() {
        return this.display.isFullscreen();
    }

    @Override
    public Cursor newCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        return null;
    }

    @Override
    public void setCursor(Cursor cursor) {
    }

    @Override
    public void setSystemCursor(Cursor.SystemCursor systemCursor) {
    }

    @Override
    public boolean isGL30Available() {
        return false;
    }

    @Override
    public GL20 getGL20() {
        return null;
    }

    @Override
    public GL30 getGL30() {
        return null;
    }

    @Override
    public void setGL20(GL20 gl20) {
    }

    @Override
    public void setGL30(GL30 gl30) {
    }

    @Override
    public GLVersion getGLVersion() {
        return null;
    }

    @Override
    public Graphics.Monitor getPrimaryMonitor() {
        return null;
    }

    @Override
    public Graphics.Monitor getMonitor() {
        return null;
    }

    @Override
    public Graphics.Monitor[] getMonitors() {
        return null;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return false;
    }

    @Override
    public GL10 getGL10() {
        return null;
    }

    @Override
    public Graphics.BufferFormat getBufferFormat() {
        return null;
    }

    @Override
    public Object extra(BuildGraphics.Option opt, Object ... obj) {
        switch (opt) {
            case SWGetFrame: {
                return this.display.getCanvas().getFrame();
            }
            case SWChangePalette: {
                byte[] palette = (byte[])obj[0];
                if (palette.length != 768) {
                    throw new UnsupportedOperationException("The array should be 256 bytes!");
                }
                this.display.getCanvas().changepalette(palette);
                break;
            }
            default: {
                throw new UnsupportedOperationException("not implemented");
            }
        }
        return null;
    }

    private class SoftDisplayMode
    extends Graphics.DisplayMode {
        DisplayMode mode;

        public SoftDisplayMode(int width, int height, int refreshRate, int bitsPerPixel, DisplayMode mode) {
            super(width, height, refreshRate, bitsPerPixel);
            this.mode = mode;
        }
    }
}

