/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.AWT;

import com.badlogic.gdx.backends.lwjgl.LwjglNativesLoader;
import java.awt.Canvas;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.lwjgl.opengl.Display;
import ru.m210projects.Build.Architecture.BuildApplication;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.desktop.AWT.AWTMouse;
import ru.m210projects.Build.desktop.AWT.JDisplay;

public class LwjglMouse
extends AWTMouse {
    private final Method moveMouse;
    private final Method grabMouse;
    private final Method ungrabMouse;
    private final Object displayImpl;
    private long handle;
    public static final boolean IS_WINDOWS = BuildGdx.app.getPlatform() == BuildApplication.Platform.Windows;

    public LwjglMouse(JDisplay display) throws Exception {
        super(display);
        this.robot = null;
        Method getImplementation = Display.class.getDeclaredMethod("getImplementation", new Class[0]);
        getImplementation.setAccessible(true);
        LwjglNativesLoader.load();
        this.displayImpl = getImplementation.invoke(null, (Object[])null);
        this.setWindowHandle();
        if (this.handle == -1L || !IS_WINDOWS) {
            throw new UnsupportedOperationException("not implemented");
        }
        display.setRebuildCallback(new Runnable(){

            @Override
            public void run() {
                LwjglMouse.this.setWindowHandle();
            }
        });
        this.moveMouse = this.displayImpl.getClass().getDeclaredMethod("setCursorPosition", Integer.TYPE, Integer.TYPE);
        this.moveMouse.setAccessible(true);
        this.grabMouse = this.displayImpl.getClass().getDeclaredMethod("setupCursorClipping", Long.TYPE);
        this.grabMouse.setAccessible(true);
        this.ungrabMouse = this.displayImpl.getClass().getDeclaredMethod("resetCursorClipping", new Class[0]);
        this.ungrabMouse.setAccessible(true);
    }

    private void setImplementVariable(String name, Object value) throws Exception {
        Field field = this.displayImpl.getClass().getDeclaredField(name);
        field.setAccessible(true);
        field.set(this.displayImpl, value);
    }

    @Override
    public void setWindowHandle() {
        try {
            this.handle = this.getWindowHandle(this.display.getCanvas());
            this.setImplementVariable(IS_WINDOWS ? "hwnd" : "parent_window", this.handle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long getWindowHandle(Canvas canvas) throws Exception {
        boolean IS_MAC = System.getProperty("os.name").toLowerCase().contains("mac");
        if (IS_MAC) {
            return 0L;
        }
        Method gethwnd = this.displayImpl.getClass().getDeclaredMethod(IS_WINDOWS ? "getHwnd" : "getHandle", Canvas.class);
        gethwnd.setAccessible(true);
        return (Long)gethwnd.invoke(this.displayImpl, canvas);
    }

    @Override
    public void showCursor(boolean visible) {
        super.showCursor(visible);
        try {
            if (!visible && this.catched && this.display.isActive()) {
                this.grabMouse.invoke(this.displayImpl, this.handle);
            } else {
                this.ungrabMouse.invoke(this.displayImpl, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setCursorPosition(int x, int y) {
        try {
            this.x = x;
            this.y = y;
            this.moveMouse.invoke(this.displayImpl, x, y - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

