/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Menus;

import java.util.Arrays;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Duke3D.Factory.DukeMenuHandler;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Menus.DUserContent;
import ru.m210projects.Duke3D.Menus.DukeTitle;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Types.GameInfo;

public class NetworkMenu
extends BuildMenu {
    private final Main app;
    private int mGameType = 1;
    private int mEpisodeId = 0;
    private int mLevelId = 0;
    private int mDifficulty = 2;
    private int mMonsters = 0;
    private int mFFire = 0;
    private int mMarkers = 1;
    private String mContent;
    private Object currentFile;
    private final int[] netEpisodeInfo = new int[5];
    private final MenuProc mLevelsUpdate;
    private final MenuConteiner mMenuLevel;
    private final MenuConteiner mMenuEpisode;
    private final MenuConteiner mMenuDifficulty;

    public NetworkMenu(final Main app) {
        this.app = app;
        final DukeMenuHandler menu = app.menu;
        this.addItem(new DukeTitle("NETWORK GAME"), false);
        MenuConteiner pItem = new MenuConteiner("Content", app.getFont(2), 20, 45, 280, new String[]{""}, 0, null){

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                switch (opt) {
                    case ENTER: 
                    case LMB: {
                        DUserContent usercont = (DUserContent)menu.mMenus[16];
                        if (!usercont.showmain) {
                            usercont.setShowMain(true);
                        }
                        Sounds.StopAllSounds();
                        handler.mOpen(usercont, -1);
                        return false;
                    }
                }
                return this.m_pMenu.mNavigation(opt);
            }

            @Override
            public void open() {
                if (!app.isCurrentScreen(Main.gGameScreen)) {
                    NetworkMenu.this.setEpisode(Globals.defGame);
                }
            }

            @Override
            public void draw(MenuHandler handler) {
                this.list[0] = Strhandler.toCharArray(NetworkMenu.this.mContent);
                super.draw(handler);
            }
        };
        pItem.listFont = app.getFont(1);
        MenuConteiner mMenuGame = new MenuConteiner("GAME TYPE", app.getFont(1), 20, 70, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                NetworkMenu.this.mGameType = item.num;
            }
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[3][];
                    this.list[0] = "DUKEMATCH (SPAWN)".toCharArray();
                    this.list[1] = "COOPERATIVE PLAY".toCharArray();
                    this.list[2] = "DUKEMATCH (NO SPAWN)".toCharArray();
                }
                this.num = NetworkMenu.this.mGameType;
            }
        };
        this.mLevelsUpdate = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                if (NetworkMenu.this.currentFile instanceof GameInfo) {
                    GameInfo mGameInfo = (GameInfo)NetworkMenu.this.currentFile;
                    int size = mGameInfo.episodes[((NetworkMenu)NetworkMenu.this).netEpisodeInfo[((NetworkMenu)NetworkMenu.this).mEpisodeId]].nMaps;
                    if (item.list == null || item.list.length != size) {
                        item.list = new char[size][];
                    }
                    for (int i = 0; i < size; ++i) {
                        item.list[i] = mGameInfo.episodes[((NetworkMenu)NetworkMenu.this).netEpisodeInfo[((NetworkMenu)NetworkMenu.this).mEpisodeId]].gMapInfo[i].title.toCharArray();
                    }
                } else {
                    item.list = new char[1][];
                    item.list[0] = "None".toCharArray();
                }
                item.num = 0;
                NetworkMenu.this.mLevelId = 0;
            }
        };
        this.mMenuLevel = new MenuConteiner("LEVEL", app.getFont(1), 20, 90, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                NetworkMenu.this.mLevelId = item.num;
            }
        }){

            @Override
            public void open() {
                this.num = NetworkMenu.this.mLevelId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(NetworkMenu.this.currentFile instanceof GameInfo);
                super.draw(handler);
            }
        };
        this.mMenuEpisode = new MenuConteiner("EPISODE", app.getFont(1), 20, 80, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                NetworkMenu.this.mEpisodeId = item.num;
                NetworkMenu.this.mLevelsUpdate.run(menu, NetworkMenu.this.mMenuLevel);
            }
        }){

            @Override
            public void open() {
                this.num = NetworkMenu.this.mEpisodeId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(NetworkMenu.this.currentFile instanceof GameInfo);
                super.draw(handler);
            }
        };
        int pos = 90;
        this.mMenuDifficulty = new MenuConteiner("MONSTERS", app.getFont(1), 20, pos += 12, 280, null, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                if (item.num == 0) {
                    NetworkMenu.this.mMonsters = 1;
                } else {
                    NetworkMenu.this.mMonsters = 0;
                }
                NetworkMenu.this.mDifficulty = item.num - 1;
            }
        }){

            @Override
            public void open() {
                this.num = NetworkMenu.this.mDifficulty + 1;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(NetworkMenu.this.currentFile instanceof GameInfo);
                super.draw(handler);
            }
        };
        MenuSwitch mMenuMarkers = new MenuSwitch("MARKERS", app.getFont(1), 20, pos += 12, 280, this.mMarkers == 1, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                NetworkMenu.this.mMarkers = sw.value ? 1 : 0;
            }
        }, "Yes", "No");
        MenuSwitch mMenuFFire = new MenuSwitch("FRIENDLY FIRE", app.getFont(1), 20, pos += 12, 280, this.mFFire == 1, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                NetworkMenu.this.mFFire = sw.value ? 1 : 0;
            }
        }, "Yes", "No"){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(NetworkMenu.this.mGameType == 1);
                super.draw(handler);
            }
        };
        MenuProc mNetStart = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                Globals.pNetInfo.nGameType = NetworkMenu.this.mGameType;
                Globals.pNetInfo.nEpisode = NetworkMenu.this.currentFile instanceof FileEntry ? NetworkMenu.this.mEpisodeId : NetworkMenu.this.netEpisodeInfo[NetworkMenu.this.mEpisodeId];
                Globals.pNetInfo.nLevel = NetworkMenu.this.mLevelId;
                Globals.pNetInfo.nDifficulty = NetworkMenu.this.mDifficulty;
                Globals.pNetInfo.nMonsters = NetworkMenu.this.mMonsters;
                Globals.pNetInfo.nRespawnMonsters = 0;
                Globals.pNetInfo.nRespawnInventory = 0;
                Globals.pNetInfo.nRespawnItem = 0;
                Globals.pNetInfo.nMarkers = NetworkMenu.this.mMarkers;
                Globals.pNetInfo.nFriendlyFire = NetworkMenu.this.mFFire;
                System.err.println("nNetType " + Globals.pNetInfo.nGameType);
                System.err.println("nNetDifficulty " + Globals.pNetInfo.nDifficulty);
                System.err.println("nNetMonsters " + Globals.pNetInfo.nMonsters);
                System.err.println("nNetMarkers " + Globals.pNetInfo.nMarkers);
                System.err.println("nNetFFire " + Globals.pNetInfo.nFriendlyFire);
                if (Mmulti.numplayers >= 2) {
                    byte[] packbuf = app.net.packbuf;
                    packbuf[0] = -4;
                    int ptr = 1;
                    LittleEndian.putInt(packbuf, ptr, Mmulti.myconnectindex);
                    LittleEndian.putInt(packbuf, ptr += 4, app.net.nNetVersion);
                    System.arraycopy(Globals.pNetInfo.getBytes(), 0, packbuf, ptr += 4, Globals.pNetInfo.sizeof);
                    ptr += Globals.pNetInfo.sizeof;
                    short i = Mmulti.connecthead;
                    while (i >= 0) {
                        if (i != Mmulti.myconnectindex) {
                            Mmulti.sendpacket(i, packbuf, ptr);
                        }
                        if (Mmulti.myconnectindex != Mmulti.connecthead) break;
                        i = Mmulti.connectpoint2[i];
                    }
                }
                if (app.net.WaitForAllPlayers(0)) {
                    Main.gGameScreen.newgame(true, NetworkMenu.this.currentFile, NetworkMenu.this.netEpisodeInfo[NetworkMenu.this.mEpisodeId], NetworkMenu.this.mLevelId, NetworkMenu.this.mDifficulty);
                }
            }
        };
        MenuButton mStart = new MenuButton("START GAME", app.getFont(2), 20, pos += 15, 280, 1, 0, null, -1, mNetStart, 0){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(Mmulti.myconnectindex == Mmulti.connecthead && NetworkMenu.this.currentFile != null);
                super.draw(handler);
            }
        };
        this.addItem(pItem, true);
        this.addItem(mMenuGame, false);
        this.addItem(this.mMenuEpisode, false);
        this.addItem(this.mMenuLevel, false);
        this.addItem(this.mMenuDifficulty, false);
        this.addItem(mMenuMarkers, false);
        this.addItem(mMenuFFire, false);
        this.addItem(mStart, false);
    }

    private void updateUserEpisodeList(GameInfo gInfo) {
        int i;
        Arrays.fill(this.netEpisodeInfo, -1);
        int nEpisodes = 0;
        for (i = 0; i < 5; ++i) {
            if (gInfo.episodes[i] == null || gInfo.episodes[i].nMaps == 0) continue;
            this.netEpisodeInfo[nEpisodes++] = i;
        }
        if (this.mMenuEpisode.list == null || this.mMenuEpisode.list.length != nEpisodes) {
            this.mMenuEpisode.list = new char[nEpisodes][];
        }
        for (i = 0; i < nEpisodes; ++i) {
            this.mMenuEpisode.list[i] = gInfo.episodes[this.netEpisodeInfo[i]].Title.toCharArray();
        }
        if (this.mMenuDifficulty.list == null) {
            this.mMenuDifficulty.list = new char[5][];
        }
        this.mMenuDifficulty.list[0] = "NONE".toCharArray();
        for (i = 0; i < 4; ++i) {
            this.mMenuDifficulty.list[1 + i] = gInfo.skillnames[i].toCharArray();
        }
    }

    public Object getFile() {
        return this.currentFile;
    }

    public void setEpisode(GameInfo ini) {
        if (ini == null || this.currentFile == ini) {
            return;
        }
        String path = ini.getFile().getPath();
        if (ini.isPackage()) {
            path = path + ":" + ini.ConName;
        }
        long crc32 = 0L;
        if (Mmulti.numplayers > 1) {
            crc32 = ini.getFile().getChecksum();
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(path, crc32, 0)) {
            String msg = "";
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.app.net.gContentFound[i] != 1) {
                    msg = this.app.net.gContentFound[i] == 2 ? msg + Globals.ud.user_name[i] + "(wrong checksum), " : msg + Globals.ud.user_name[i] + ", ";
                }
                i = Mmulti.connectpoint2[i];
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = msg + "  is missing content: " + ini.Title;
            Console.Println(msg, Console.OSDTEXT_RED);
            if (!Console.IsShown()) {
                Console.toggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = ini;
        this.mContent = ini.Title;
        this.mEpisodeId = 0;
        this.mMenuEpisode.num = 0;
        this.updateUserEpisodeList(ini);
        this.mLevelsUpdate.run(this.app.pMenu, this.mMenuLevel);
    }

    public void setMap(FileEntry map) {
        if (map == null || this.currentFile == map) {
            return;
        }
        long crc32 = 0L;
        if (Mmulti.numplayers > 1) {
            crc32 = map.getChecksum();
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(map.getPath(), crc32, 0)) {
            String msg = "";
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.app.net.gContentFound[i] != 1) {
                    msg = this.app.net.gContentFound[i] == 2 ? msg + Globals.ud.user_name[i] + "(wrong checksum), " : msg + Globals.ud.user_name[i] + ", ";
                }
                i = Mmulti.connectpoint2[i];
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = msg + " haven't content: " + map.getName();
            Console.Println(msg, Console.OSDTEXT_RED);
            if (!Console.IsShown()) {
                Console.toggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = map;
        this.mContent = map.getName();
        if (this.mMenuEpisode.list != null) {
            this.mMenuEpisode.list[0] = "None".toCharArray();
        }
        this.mMenuEpisode.num = 0;
        this.mEpisodeId = 0;
        if (this.mMenuLevel.list != null) {
            this.mMenuLevel.list[0] = "Usermap".toCharArray();
        }
        this.mMenuLevel.num = 0;
        this.mLevelId = 0;
        if (this.mMenuDifficulty.list == null) {
            this.mMenuDifficulty.list = new char[5][];
        }
        this.mMenuDifficulty.list[0] = "NONE".toCharArray();
        for (int i = 0; i < 4; ++i) {
            this.mMenuDifficulty.list[1 + i] = Globals.defGame.skillnames[i].toCharArray();
        }
    }
}

