/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Screens;

import java.io.FileNotFoundException;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.InvalidVersionException;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.Animate;
import ru.m210projects.Duke3D.Config;
import ru.m210projects.Duke3D.Factory.DukeMenuHandler;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Input;
import ru.m210projects.Duke3D.LoadSave;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Player;
import ru.m210projects.Duke3D.Premap;
import ru.m210projects.Duke3D.ResourceHandler;
import ru.m210projects.Duke3D.Screen;
import ru.m210projects.Duke3D.Sector;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Spawn;
import ru.m210projects.Duke3D.Types.DemoFile;
import ru.m210projects.Duke3D.Types.GameInfo;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.Types.RTS;
import ru.m210projects.Duke3D.View;
import ru.m210projects.Duke3D.Weapons;

public class GameScreen
extends GameAdapter {
    private int nonsharedtimer;
    private final Main game;

    public GameScreen(Main game) {
        super(game, Main.gLoadingScreen);
        this.game = game;
        for (int i = 0; i < 16; ++i) {
            Globals.sync[i] = new Input();
        }
    }

    @Override
    public void hide() {
        Sounds.StopCommentary(Sounds.pCommentary);
    }

    @Override
    public void PostFrame(BuildNet net) {
        if (LoadSave.gQuickSaving) {
            if (this.captBuffer != null) {
                LoadSave.savegame("[quicksave_" + LoadSave.quickslot + "]", "quicksav" + LoadSave.quickslot + ".sav");
                LoadSave.quickslot ^= 1;
                LoadSave.gQuickSaving = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
        if (LoadSave.gAutosaveRequest) {
            if (this.captBuffer != null) {
                LoadSave.savegame("[autosave]", "autosave.sav");
                LoadSave.gAutosaveRequest = false;
            } else {
                Main.gGameScreen.capture(160, 100);
            }
        }
    }

    @Override
    public void ProcessFrame(BuildNet net) {
        Globals.ud.camerasprite = -1;
        Globals.everyothertime = (char)(Globals.everyothertime + '\u0001');
        short i = Mmulti.connecthead;
        while (i >= 0) {
            Globals.sync[i].Copy(net.gFifoInput[net.gNetFifoTail & 0xFF][i]);
            i = Mmulti.connectpoint2[i];
        }
        ++net.gNetFifoTail;
        int j = -1;
        int i2 = Mmulti.connecthead;
        while (i2 >= 0) {
            this.cheatkeys(i2);
            if (this == Main.gDemoScreen || (Globals.sync[i2].bits & 0x4000000) == 0) {
                j = i2;
            } else {
                if (Globals.ud.rec != null) {
                    Globals.ud.rec.close();
                }
                if (i2 == Mmulti.myconnectindex) {
                    this.game.gExit = true;
                }
                if (Globals.screenpeek == i2 && (Globals.screenpeek = Mmulti.connectpoint2[i2]) < 0) {
                    Globals.screenpeek = Mmulti.connecthead;
                }
                if (i2 == Mmulti.connecthead) {
                    Mmulti.connecthead = Mmulti.connectpoint2[Mmulti.connecthead];
                } else {
                    Mmulti.connectpoint2[j] = Mmulti.connectpoint2[i2];
                }
                Mmulti.numplayers = (short)(Mmulti.numplayers - 1);
                --Globals.ud.multimode;
                if (Mmulti.numplayers < 2) {
                    Sounds.sound(177);
                }
                Player.quickkill(Globals.ps[i2]);
                Main.engine.deletesprite(Globals.ps[i2].i);
                Strhandler.buildString(Globals.buf, 0, Globals.ud.user_name[i2], " is history!");
                View.adduserquote(Globals.buf);
                Screen.vscrn(Globals.ud.screen_size);
                if (j < 0) {
                    this.game.show();
                    Console.Println(" \nThe 'MASTER/First player' just quit the game.  All\nplayers are returned from the game.");
                    return;
                }
            }
            i2 = Mmulti.connectpoint2[i2];
        }
        net.CalcChecksum();
        Globals.lockclock += 4;
        if (this.game.gPaused || Globals.ud.recstat != 2 && Globals.ud.multimode < 2 && this != Main.gDemoScreen && (this.game.menu.gShowMenu || Console.IsShown())) {
            return;
        }
        if (Globals.ud.recstat == 1 && Globals.ud.rec != null) {
            Globals.ud.rec.record();
        }
        if (Globals.earthquaketime > 0) {
            Globals.earthquaketime = (short)(Globals.earthquaketime - 1);
        }
        if (RTS.rtsplaying > '\u0000') {
            RTS.rtsplaying = (char)(RTS.rtsplaying - '\u0001');
        }
        for (i2 = 0; i2 < 4; ++i2) {
            if (View.user_quote_time[i2] == 0) continue;
            int n = i2;
            View.user_quote_time[n] = (short)(View.user_quote_time[n] - 1);
        }
        View.quotebot = Pragmas.klabs(View.quotebotgoal - View.quotebot) <= 16 && Globals.ud.screen_size <= 2 ? (View.quotebot += Pragmas.ksgn(View.quotebotgoal - View.quotebot)) : View.quotebotgoal;
        if (View.fta > 0 && (View.fta = (short)(View.fta - 1)) == 0) {
            View.ftq = 0;
        }
        if (Engine.totalclock < View.lastvisinc) {
            if (Pragmas.klabs(Globals.gVisibility - Globals.currentGame.getCON().const_visibility) > 8) {
                Globals.gVisibility += Globals.currentGame.getCON().const_visibility - Globals.gVisibility >> 2;
            }
        } else {
            Globals.gVisibility = Globals.currentGame.getCON().const_visibility;
        }
        Globals.global_random = (short)Main.engine.krand();
        Actors.movedummyplayers();
        i2 = Mmulti.connecthead;
        while (i2 >= 0) {
            Globals.ps[i2].UpdatePlayerLoc();
            Player.processinput(i2);
            Sector.checksectors(i2);
            i2 = Mmulti.connectpoint2[i2];
        }
        Actors.movefta();
        Weapons.moveweapons();
        Actors.movetransports();
        Actors.moveplayers();
        Actors.movefallers();
        Actors.moveexplosions();
        Actors.moveactors();
        Actors.moveeffectors();
        Actors.movestandables();
        Animate.doanimations();
        Actors.movefx();
        net.CorrectPrediction();
        Sounds.MusicUpdate();
        if ((Globals.everyothertime & '\u0001') == 0) {
            Sector.animatewalls();
            Actors.movecyclers();
            Sounds.pan3dsound();
        }
        if ((Globals.uGameFlags & 1) == 1) {
            this.game.pNet.ready2send = false;
            if (this == Main.gDemoScreen) {
                return;
            }
            if (Globals.ud.eog == 1) {
                Globals.ud.eog = 0;
                Globals.uGameFlags |= 2;
                switch (Globals.ud.volume_number) {
                    case 0: {
                        Main.gEndScreen.episode1();
                        break;
                    }
                    case 1: {
                        Main.gEndScreen.episode2();
                        break;
                    }
                    case 2: {
                        Main.gEndScreen.episode3();
                        break;
                    }
                    case 3: {
                        Main.gEndScreen.episode4();
                        break;
                    }
                    case 4: {
                        Main.gEndScreen.episode5();
                        break;
                    }
                    default: {
                        BuildGdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                GameScreen.this.game.show();
                            }
                        });
                        break;
                    }
                }
            } else {
                BuildGdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        GameScreen.this.game.changeScreen(Main.gStatisticScreen);
                    }
                });
            }
        }
    }

    @Override
    public void DrawWorld(float smooth) {
        View.displayrooms(Globals.screenpeek, (int)smooth);
    }

    @Override
    public void DrawHud(float smooth) {
        View.displayrest((int)smooth);
        if (this.game.net.bOutOfSync) {
            this.game.getFont(1).drawText(160, 20, Strhandler.toCharArray("Out of sync!"), 0, 12, BuildFont.TextAlign.Center, 2, false);
            switch (this.game.net.bOutOfSyncByte / 4) {
                case 0: {
                    this.game.getFont(1).drawText(160, 30, Strhandler.toCharArray("seed checksum error"), 0, 12, BuildFont.TextAlign.Center, 2, false);
                    break;
                }
                case 1: {
                    this.game.getFont(1).drawText(160, 30, Strhandler.toCharArray("player struct checksum error"), 0, 12, BuildFont.TextAlign.Center, 2, false);
                    break;
                }
                case 2: {
                    this.game.getFont(1).drawText(160, 30, Strhandler.toCharArray("player sprite checksum error"), 0, 12, BuildFont.TextAlign.Center, 2, false);
                }
            }
        }
    }

    @Override
    protected void startboard(Runnable startboard) {
        Main.gPrecacheScreen.init(false, startboard);
        this.game.changeScreen(Main.gPrecacheScreen);
    }

    @Override
    public void KeyHandler() {
        DukeMenuHandler menu = this.game.menu;
        if (menu.gShowMenu) {
            Main.engine.handleevents();
            menu.mKeyHandler(this.game.pInput, BuildGdx.graphics.getDeltaTime());
            return;
        }
        if (Console.IsShown() || Globals.MODE_TYPE) {
            return;
        }
        BuildControls input = this.game.pInput;
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Menu_Toggle, true)) {
            menu.mOpen(menu.mMenus[1], -1);
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Show_Help, true)) {
            menu.mOpen(menu.mMenus[6], -1);
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Show_Savemenu, true)) {
            if (Mmulti.numplayers > 1 || Globals.mFakeMultiplayer) {
                return;
            }
            if (Engine.sprite[Globals.ps[Mmulti.myconnectindex].i].extra > 0) {
                Main.gGameScreen.capture(160, 100);
                menu.mOpen(menu.mMenus[8], -1);
            }
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Show_Loadmenu, true)) {
            if (Mmulti.numplayers > 1 || Globals.mFakeMultiplayer) {
                return;
            }
            menu.mOpen(menu.mMenus[7], -1);
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.See_Chase_View, true)) {
            if (View.over_shoulder_on != 0) {
                View.over_shoulder_on = 0;
            } else {
                View.over_shoulder_on = 1;
                View.cameradist = 0;
                View.cameraclock = Engine.totalclock;
            }
            View.FTA(109 + View.over_shoulder_on, Globals.ps[Mmulti.myconnectindex]);
        }
        if (Globals.ud.overhead_on != 0) {
            int j = Engine.totalclock - this.nonsharedtimer;
            this.nonsharedtimer += j;
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Enlarge_Screen, false)) {
                View.zoom = (short)(View.zoom + Pragmas.mulscale(j, Math.max(View.zoom, 256), 6));
            }
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Shrink_Screen, false)) {
                View.zoom = (short)(View.zoom - Pragmas.mulscale(j, Math.max(View.zoom, 256), 6));
            }
            if (View.zoom > 2048) {
                View.zoom = (short)2048;
            }
            if (View.zoom < 48) {
                View.zoom = (short)48;
            }
            if (input.ctrlGetInputKey(Config.DukeKeys.Map_Follow_Mode, true)) {
                boolean bl = Globals.ud.scrollmode = !Globals.ud.scrollmode;
                if (Globals.ud.scrollmode) {
                    Globals.ud.folx = Globals.ps[Mmulti.myconnectindex].oposx;
                    Globals.ud.foly = Globals.ps[Mmulti.myconnectindex].oposy;
                    Globals.ud.fola = (int)Globals.ps[Mmulti.myconnectindex].oang;
                }
                View.FTA(83 + (Globals.ud.scrollmode ? 1 : 0), Globals.ps[Mmulti.myconnectindex]);
            }
        } else {
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Enlarge_Screen, true) && Globals.ud.screen_size > 0) {
                Sounds.sound(158);
                this.enlargeScreen();
            }
            if (input.ctrlGetInputKey(BuildConfig.GameKeys.Shrink_Screen, true) && Globals.ud.screen_size < 3) {
                Sounds.sound(158);
                this.shrinkScreen();
            }
        }
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Map_Toggle, true)) {
            if (Globals.ud.last_overhead != Globals.ud.overhead_on && Globals.ud.last_overhead != 0) {
                Globals.ud.overhead_on = Globals.ud.last_overhead;
                Globals.ud.last_overhead = 0;
            } else {
                ++Globals.ud.overhead_on;
                if (Globals.ud.overhead_on == 3) {
                    Globals.ud.overhead_on = 0;
                }
                Globals.ud.last_overhead = Globals.ud.overhead_on;
            }
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.AutoRun, true)) {
            Globals.ud.auto_run ^= 1;
            View.FTA(85 + Globals.ud.auto_run, Globals.ps[Mmulti.myconnectindex]);
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Toggle_Crosshair, true)) {
            Globals.ud.crosshair ^= 1;
            View.FTA(21 - Globals.ud.crosshair, Globals.ps[Mmulti.myconnectindex]);
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Show_Opp_Weapon, true)) {
            Globals.ud.showweapons ^= 1;
            View.FTA(82 - Globals.ud.showweapons, Globals.ps[Mmulti.myconnectindex]);
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Show_Sounds, true)) {
            menu.mOpen(menu.mMenus[3], -1);
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Show_Options, true)) {
            menu.mOpen(menu.mMenus[15], -1);
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Gamma, true)) {
            this.openGamma(menu);
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Quicksave, true)) {
            LoadSave.quicksave();
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Messages, true)) {
            Globals.ud.fta_on ^= 1;
            if (Globals.ud.fta_on != 0) {
                View.FTA(23, Globals.ps[Mmulti.myconnectindex]);
            } else {
                Globals.ud.fta_on = 1;
                View.FTA(24, Globals.ps[Mmulti.myconnectindex]);
                Globals.ud.fta_on = 0;
            }
        }
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Send_Message, false)) {
            Sounds.spritesound(92, Globals.ps[Mmulti.myconnectindex].i);
            Globals.MODE_TYPE = true;
            Engine.getInput().initMessageInput(null);
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Quickload, true)) {
            LoadSave.quickload();
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.See_Coop_View, true) && (Globals.ud.coop == 1 || Globals.mFakeMultiplayer)) {
            if ((Globals.screenpeek = Mmulti.connectpoint2[Globals.screenpeek]) < 0) {
                Globals.screenpeek = Mmulti.connecthead;
            }
            Screen.changepalette = 1;
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Quit, true)) {
            menu.mOpen(menu.mMenus[9], -1);
        }
        if (input.ctrlGetInputKey(Config.DukeKeys.Screenshot, true)) {
            this.makeScreenshot();
        }
    }

    public boolean shrinkScreen() {
        ++Globals.ud.screen_size;
        if (!Main.engine.getTile(9219).isLoaded() && !Main.engine.getTile(9218).isLoaded() && Globals.ud.screen_size == 2) {
            ++Globals.ud.screen_size;
        }
        if (Globals.ud.screen_size > 3) {
            Globals.ud.screen_size = 3;
        }
        Screen.vscrn(Globals.ud.screen_size);
        return true;
    }

    public boolean enlargeScreen() {
        --Globals.ud.screen_size;
        if (!Main.engine.getTile(9219).isLoaded() && !Main.engine.getTile(9218).isLoaded() && Globals.ud.screen_size == 2) {
            --Globals.ud.screen_size;
        }
        if (Globals.ud.screen_size < 0) {
            Globals.ud.screen_size = 0;
        }
        Screen.vscrn(Globals.ud.screen_size);
        return true;
    }

    protected void openGamma(DukeMenuHandler menu) {
        menu.mOpen(menu.mMenus[13], -1);
    }

    @Override
    public void sndHandlePause(boolean pause) {
        Sounds.sndHandlePause(pause);
    }

    @Override
    protected boolean prepareboard(String map) {
        View.gNameShowTime = 500;
        Premap.checknextlevel();
        if (this != Main.gDemoScreen && Globals.ud.recstat == 2) {
            Globals.ud.recstat = 0;
        }
        BuildPos out = null;
        try {
            out = Main.engine.loadboard(map);
        }
        catch (FileNotFoundException | RuntimeException | InvalidVersionException e) {
            this.game.GameMessage(e.getMessage());
            return false;
        }
        Globals.ps[0].posx = out.x;
        Globals.ps[0].posy = out.y;
        Globals.ps[0].posz = out.z;
        Globals.ps[0].ang = out.ang;
        Globals.ps[0].cursectnum = out.sectnum;
        Arrays.fill(Engine.gotpic, (byte)0);
        Arrays.fill(Premap.rorsector, (short)-1);
        Arrays.fill(Premap.rortype, (byte)-1);
        Premap.rorcnt = 0;
        Premap.prelevel();
        Sector.allignwarpelevators();
        Premap.resetpspritevars();
        Engine.automapping = 0;
        View.ftq = 0;
        View.fta = 0;
        Arrays.fill(View.loogiex, 0);
        Arrays.fill(View.loogiey, 0);
        if (Globals.ud.recstat != 2) {
            Sounds.sndStopMusic();
        }
        if (Globals.ud.recstat != 2) {
            Globals.musicvolume = Globals.ud.volume_number;
            Globals.musiclevel = Globals.ud.level_number;
            Sounds.sndPlayMusic(Globals.currentGame.getCON().music_fn[Globals.musicvolume][Globals.musiclevel]);
        }
        if (Globals.ud.recstat == 1) {
            Globals.ud.rec = new DemoFile(147);
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            if (Engine.sprite[Globals.ps[i].i].sectnum != 1024) {
                switch (Engine.sector[Engine.sprite[Globals.ps[i].i].sectnum].floorpicnum) {
                    case 200: 
                    case 859: 
                    case 1082: {
                        Premap.resetweapons(i);
                        Premap.resetinventory(i);
                        Globals.ps[i].gotweapon[1] = false;
                        Globals.ps[i].ammo_amount[1] = 0;
                        Globals.ps[i].curr_weapon = 0;
                        Globals.ps[i].kickback_pic = 0;
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
        Globals.ps[Mmulti.myconnectindex].palette = Engine.palette;
        Player.setpal(Globals.ps[Mmulti.myconnectindex]);
        Globals.everyothertime = '\u0000';
        Globals.global_random = 0;
        Globals.ud.last_level = Globals.ud.level_number + 1;
        Screen.changepalette = 1;
        this.game.net.WaitForAllPlayers(0);
        Main.engine.sampletimer();
        Screen.palto(0, 0, 0, 0);
        if (!this.game.menu.gShowMenu) {
            Screen.vscrn(Globals.ud.screen_size);
        }
        Main.engine.clearview(0);
        View.over_shoulder_on = 0;
        Arrays.fill(View.user_quote_time, (short)0);
        this.game.net.predict.reset();
        Premap.clearfrags();
        System.err.println("New level " + map);
        if ((Globals.uGameFlags & 1) == 1 && this.game.nNetMode == BuildGame.NetMode.Single) {
            LoadSave.gAutosaveRequest = true;
        }
        Globals.uGameFlags &= 0xFFFFFFFC;
        return !Globals.kGameCrash;
    }

    protected void makeScreenshot() {
        String filename;
        FileEntry map;
        String name = "scrxxxx.png";
        if (Main.mUserFlag == Main.UserFlag.UserMap && (map = BuildGdx.compat.checkFile(Globals.boardfilename)) != null) {
            name = "scr-" + map.getName() + "-xxxx.png";
        }
        if (Main.mUserFlag != Main.UserFlag.UserMap && Globals.currentGame != null) {
            name = "scr-e" + (Globals.ud.volume_number + 1) + "m" + (Globals.ud.level_number + 1) + "[" + Globals.currentGame.getFile().getName() + "]-xxxx.png";
        }
        if ((filename = this.pEngine.screencapture(name)) != null) {
            Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[103], 0, filename, " saved");
        } else {
            Strhandler.buildString(Globals.currentGame.getCON().fta_quotes[103], 0, "Screenshot not saved. Access denied!");
        }
        View.FTA(103, Globals.ps[Mmulti.myconnectindex]);
    }

    public void newgame(final boolean isMultiplayer, final Object item, final int nEpisode, final int nLevel, final int nDifficulty) {
        if (Globals.ud.recstat == 1 && Globals.ud.rec != null) {
            Globals.ud.rec.close();
        }
        this.pNet.ready2send = false;
        this.game.changeScreen(this.load);
        this.load.init(new Runnable(){

            @Override
            public void run() {
                String title;
                if (!isMultiplayer) {
                    Globals.ud.multimode = 1;
                    Globals.mFakeMultiplayer = false;
                    if (Mmulti.numplayers > 1) {
                        GameScreen.this.pNet.NetDisconnect(Mmulti.myconnectindex);
                    }
                    Globals.ud.monsters_off = false;
                    Globals.ud.respawn_monsters = false;
                    Globals.ud.respawn_items = false;
                    Globals.ud.respawn_inventory = false;
                    Mmulti.connecthead = 0;
                    Mmulti.connectpoint2[0] = -1;
                    ((GameScreen)GameScreen.this).game.nNetMode = BuildGame.NetMode.Single;
                } else {
                    if (Globals.mFakeMultiplayer) {
                        Globals.ud.multimode = Globals.nFakePlayers;
                        Mmulti.connecthead = 0;
                        for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
                            Mmulti.connectpoint2[i] = (short)(i + 1);
                        }
                        Mmulti.connectpoint2[Globals.ud.multimode - 1] = -1;
                    } else {
                        Globals.ud.multimode = Mmulti.numplayers;
                    }
                    if (GameScreen.this != Main.gDemoScreen) {
                        Globals.ud.coop = Globals.pNetInfo.nGameType == 1 ? 1 : 0;
                        Globals.ud.monsters_off = Globals.pNetInfo.nMonsters == 1;
                        Globals.ud.respawn_monsters = false;
                        Globals.ud.respawn_inventory = true;
                        Globals.ud.respawn_items = Globals.pNetInfo.nGameType == 0;
                        Globals.ud.marker = Globals.pNetInfo.nMarkers;
                        Globals.ud.ffire = Globals.pNetInfo.nFriendlyFire;
                    }
                    Globals.ud.god = false;
                    ((GameScreen)GameScreen.this).game.nNetMode = BuildGame.NetMode.Multiplayer;
                    short c = Mmulti.connecthead;
                    while (c >= 0) {
                        Premap.resetweapons(c);
                        Premap.resetinventory(c);
                        c = Mmulti.connectpoint2[c];
                    }
                }
                Main.UserFlag flag = Main.UserFlag.None;
                if (item instanceof GameInfo && !item.equals(Globals.defGame)) {
                    flag = Main.UserFlag.Addon;
                    GameInfo game = (GameInfo)item;
                    ResourceHandler.checkEpisodeResources(game);
                    Console.Println("Start user episode: " + game.Title);
                } else {
                    ResourceHandler.resetEpisodeResources();
                }
                if (item instanceof FileEntry) {
                    flag = Main.UserFlag.UserMap;
                    Globals.boardfilename = ((FileEntry)item).getPath();
                    Globals.ud.level_number = 7;
                    Globals.ud.volume_number = 0;
                    Console.Println("Start user map: " + ((FileEntry)item).getName());
                }
                Main.mUserFlag = flag;
                if (GameScreen.this != Main.gDemoScreen) {
                    if (!isMultiplayer) {
                        Source skillvoice = null;
                        switch (nDifficulty) {
                            case 0: {
                                skillvoice = Sounds.sound(227);
                                break;
                            }
                            case 1: {
                                skillvoice = Sounds.sound(195);
                                break;
                            }
                            case 2: {
                                skillvoice = Sounds.sound(107);
                                break;
                            }
                            case 3: {
                                skillvoice = Sounds.sound(226);
                            }
                        }
                        while (skillvoice != null && skillvoice.isActive()) {
                        }
                    }
                    if (Main.mUserFlag != Main.UserFlag.UserMap) {
                        Globals.ud.level_number = nLevel;
                        Globals.ud.volume_number = nEpisode;
                    }
                    Globals.ud.player_skill = nDifficulty + 1;
                    Globals.ud.respawn_monsters = Globals.ud.player_skill == 4;
                }
                Globals.uGameFlags = 0;
                Globals.ud.secretlevel = 0;
                Globals.ud.from_bonus = 0;
                Engine.parallaxyscale = 0;
                Globals.ud.last_level = -1;
                LoadSave.lastload = null;
                if (!isMultiplayer) {
                    PlayerStruct p = Globals.ps[Mmulti.myconnectindex];
                    if (Globals.ud.coop != 1) {
                        p.curr_weapon = 1;
                        p.gotweapon[1] = true;
                        p.gotweapon[0] = true;
                        p.ammo_amount[1] = 48;
                        p.gotweapon[10] = true;
                        p.last_weapon = (short)-1;
                    }
                    p.last_used_weapon = 0;
                }
                Globals.display_mirror = '\u0000';
                View.zoom = (short)768;
                if (flag == Main.UserFlag.Addon && nEpisode != 3 && ((GameScreen)GameScreen.this).game.nNetMode == BuildGame.NetMode.Single && GameScreen.this != Main.gDemoScreen && nLevel == 0) {
                    byte[] currentAnm = BuildGdx.cache.getBytes("logo.anm", 0);
                    byte[] defAnm = BuildGdx.cache.getBytes("logo.anm", 1);
                    if (currentAnm != null && defAnm != null && CRC32.getChecksum(currentAnm) != CRC32.getChecksum(defAnm) && ((GameScreen)GameScreen.this).game.nNetMode == BuildGame.NetMode.Single && Main.gAnmScreen.init("logo.anm", 5)) {
                        GameScreen.this.game.changeScreen(Main.gAnmScreen.setCallback(new Runnable(){

                            @Override
                            public void run() {
                                GameScreen.this.enterlevel(GameScreen.this.getTitle(), Globals.ud.volume_number, Globals.ud.level_number);
                            }
                        }).escSkipping(true));
                        return;
                    }
                }
                if (!GameScreen.this.checkCutscene(title = GameScreen.this.getTitle())) {
                    GameScreen.this.enterlevel(title, Globals.ud.volume_number, Globals.ud.level_number);
                }
            }
        });
    }

    public boolean enterlevel(String title, int vol, int lev) {
        if (title == null) {
            return false;
        }
        String map = Main.mUserFlag == Main.UserFlag.UserMap ? Globals.boardfilename : Globals.currentGame.episodes[vol].gMapInfo[lev].path;
        if (this != Main.gDemoScreen) {
            Globals.ud.recstat = Globals.ud.m_recstat;
        }
        this.loadboard(map, null).setTitle(title);
        return true;
    }

    private boolean checkCutscene(final String loadTitle) {
        if (this.game.nNetMode != BuildGame.NetMode.Single || Main.mUserFlag == Main.UserFlag.UserMap || Globals.ud.level_number != 0 || Globals.ud.volume_number != 3 || Globals.ud.lockout != 0 || this == Main.gDemoScreen) {
            return false;
        }
        if (Main.gAnmScreen.init("vol41a.anm", 6)) {
            Sounds.sndPlayMusic(Globals.currentGame.getCON().env_music_fn[1]);
            Main.gAnmScreen.setCallback(new Runnable(){

                @Override
                public void run() {
                    GameScreen.this.enterlevel(loadTitle, Globals.ud.volume_number, Globals.ud.level_number);
                }
            }).escSkipping(true);
            this.game.changeScreen(Main.gAnmScreen.escSkipping(true));
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTitle() {
        String title = null;
        if (Main.mUserFlag != Main.UserFlag.UserMap) {
            if (Globals.ud.volume_number < 5 && Globals.currentGame.episodes[Globals.ud.volume_number].gMapInfo[Globals.ud.level_number] != null) {
                return Globals.currentGame.episodes[Globals.ud.volume_number].gMapInfo[Globals.ud.level_number].title;
            }
            this.game.GameCrash("MapInfo not found! Episode: " + Globals.ud.volume_number + " Level: " + Globals.ud.level_number + " nMaps: " + (Globals.ud.volume_number < 5 ? Globals.currentGame.episodes[Globals.ud.volume_number].nMaps : 0));
            return null;
        }
        FileEntry file = BuildGdx.compat.checkFile(Globals.boardfilename);
        if (file != null) {
            return file.getName();
        }
        this.game.GameCrash("Map " + Globals.boardfilename + " not found!");
        return null;
    }

    public void cheatkeys(int snum) {
        int sb_snum = Globals.sync[snum].bits;
        PlayerStruct p = Globals.ps[snum];
        if (p.cheat_phase == 1) {
            return;
        }
        int i = p.aim_mode;
        p.aim_mode = sb_snum >> 23 & 1;
        if (!(p.aim_mode >= i || this.game.nNetMode == BuildGame.NetMode.Single && this.pMenu.gShowMenu)) {
            p.return_to_center = (short)9;
        }
        if ((sb_snum & 0x400000) != 0 && p.quick_kick == 0 && (p.curr_weapon != 0 || p.kickback_pic == 0)) {
            p.quick_kick = (short)14;
            View.FTA(80, p);
        }
        if ((sb_snum & 0xFB799F00) == 0) {
            p.interface_toggle_flag = 0;
        } else if (p.interface_toggle_flag == 0 && (sb_snum & 0x20000) == 0) {
            int j;
            int k;
            p.interface_toggle_flag = 1;
            if ((sb_snum & 0x200000) != 0) {
                boolean bl = this.game.gPaused = !this.game.gPaused;
                if (this.game.gPaused) {
                    this.sndHandlePause(true);
                } else if (!Main.cfg.muteMusic && Sounds.currMusic != null) {
                    Sounds.currMusic.resume();
                }
            }
            if (this.game.gPaused) {
                return;
            }
            if (Engine.sprite[p.i].extra <= 0) {
                return;
            }
            if ((sb_snum & 0x40000000) != 0 && p.newowner == -1) {
                switch (p.inven_icon) {
                    case 4: {
                        sb_snum |= 0x2000000;
                        break;
                    }
                    case 3: {
                        sb_snum |= 0x1000000;
                        break;
                    }
                    case 5: {
                        sb_snum |= 0x8000;
                        break;
                    }
                    case 1: {
                        sb_snum |= 0x10000;
                        break;
                    }
                    case 2: {
                        sb_snum |= 0x1000;
                    }
                }
            }
            if ((sb_snum & 0x8000) != 0 && p.heat_amount > 0) {
                p.heat_on = (short)(p.heat_on ^ 1);
                Player.setpal(p);
                p.inven_icon = 5;
                Sounds.spritesound(213, p.i);
                View.FTA(106 + (p.heat_on == 0 ? 1 : 0), p);
            }
            if ((sb_snum & 0x1000) != 0) {
                if (p.steroids_amount == 400) {
                    p.steroids_amount = (short)(p.steroids_amount - 1);
                    Sounds.spritesound(217, p.i);
                    p.inven_icon = 2;
                    View.FTA(12, p);
                }
                return;
            }
            if (p.newowner == -1 && ((sb_snum & 0x100000) != 0 || (sb_snum & 0x8000000) != 0 || p.refresh_inventory)) {
                boolean CHECKINV;
                p.invdisptime = 52;
                k = (sb_snum & 0x8000000) != 0 ? 1 : 0;
                if (p.refresh_inventory) {
                    p.refresh_inventory = false;
                }
                int dainv = p.inven_icon;
                i = 0;
                do {
                    CHECKINV = false;
                    if (i < 9) {
                        ++i;
                        switch (dainv) {
                            case 4: {
                                if (p.jetpack_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 5 : 3;
                                CHECKINV = true;
                                break;
                            }
                            case 6: {
                                if (p.scuba_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 7 : 5;
                                CHECKINV = true;
                                break;
                            }
                            case 2: {
                                if (p.steroids_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 3 : 1;
                                CHECKINV = true;
                                break;
                            }
                            case 3: {
                                if (p.holoduke_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 4 : 2;
                                CHECKINV = true;
                                break;
                            }
                            case 0: 
                            case 1: {
                                if (p.firstaid_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 2 : 7;
                                CHECKINV = true;
                                break;
                            }
                            case 5: {
                                if (p.heat_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 6 : 4;
                                CHECKINV = true;
                                break;
                            }
                            case 7: {
                                if (p.boot_amount > 0 && i > 1) break;
                                dainv = k != 0 ? 1 : 6;
                                CHECKINV = true;
                            }
                        }
                    } else {
                        dainv = 0;
                    }
                    p.inven_icon = dainv;
                } while (CHECKINV);
                switch (dainv) {
                    case 1: {
                        View.FTA(3, p);
                        break;
                    }
                    case 2: {
                        View.FTA(90, p);
                        break;
                    }
                    case 3: {
                        View.FTA(91, p);
                        break;
                    }
                    case 4: {
                        View.FTA(88, p);
                        break;
                    }
                    case 5: {
                        View.FTA(101, p);
                        break;
                    }
                    case 6: {
                        View.FTA(89, p);
                        break;
                    }
                    case 7: {
                        View.FTA(6, p);
                    }
                }
            }
            if ((j = ((sb_snum & 0xF00) >> 8) - 1) <= 0 || p.kickback_pic > 0) {
                // empty if block
            }
            if (p.last_pissed_time <= 5668 && p.show_empty_weapon == 0 && p.kickback_pic == 0 && p.quick_kick == 0 && Engine.sprite[p.i].xrepeat > 32 && p.access_incs == 0 && p.knee_incs == 0) {
                if (!this.IsOriginalGame() || p.weapon_pos == 0 || p.holster_weapon != 0 && p.weapon_pos == -9) {
                    if (j == 12) {
                        j = p.curr_weapon;
                        if (p.last_used_weapon == 0) {
                            j = p.last_used_weapon;
                        } else if (p.gotweapon[p.last_used_weapon] && p.ammo_amount[p.last_used_weapon] > 0) {
                            j = p.last_used_weapon;
                        }
                    }
                    if (j == 10 || j == 11) {
                        k = p.curr_weapon;
                        j = j == 10 ? -1 : 1;
                        i = 0;
                        while (k >= 0 && k < 10 || Globals.currentGame.getCON().PLUTOPAK && k == 11 && (p.subweapon & 0x800) != 0 || Globals.currentGame.getCON().type == 20 && k == 12 && (p.subweapon & 0x1000) != 0) {
                            switch (k) {
                                case 12: {
                                    if (j == -1) {
                                        k = 8;
                                        break;
                                    }
                                    k = 1;
                                    break;
                                }
                                case 11: {
                                    if (j == -1) {
                                        k = 5;
                                        break;
                                    }
                                    k = 7;
                                    break;
                                }
                                default: {
                                    if ((k += j) == 6 && (p.subweapon & 0x800) != 0) {
                                        k = 11;
                                    }
                                    if (k != 9 || (p.subweapon & 0x1000) == 0) break;
                                    k = 12;
                                }
                            }
                            if (k == -1) {
                                k = 9;
                            } else if (k == 10) {
                                k = 0;
                            }
                            if (p.gotweapon[k] && p.ammo_amount[k] > 0) {
                                if (Globals.currentGame.getCON().PLUTOPAK && k == 6 && (p.subweapon & 0x800) != 0) {
                                    k = 11;
                                }
                                if (Globals.currentGame.getCON().type == 20 && k == 9 && (p.subweapon & 0x1000) != 0) {
                                    k = 12;
                                }
                                j = k;
                                break;
                            }
                            if (Globals.currentGame.getCON().PLUTOPAK && k == 11 && p.ammo_amount[11] == 0 && p.gotweapon[6] && p.ammo_amount[6] > 0) {
                                j = 6;
                                p.subweapon = (short)(p.subweapon & 0xFFFFF7FF);
                                break;
                            }
                            if (Globals.currentGame.getCON().PLUTOPAK && k == 6 && p.ammo_amount[6] == 0 && p.gotweapon[11] && p.ammo_amount[11] > 0) {
                                j = 11;
                                p.subweapon = (short)(p.subweapon | 0x800);
                                break;
                            }
                            if (Globals.currentGame.getCON().type == 20 && k == 12 && p.ammo_amount[12] == 0 && p.gotweapon[9] && p.ammo_amount[9] > 0) {
                                j = 9;
                                p.subweapon = (short)(p.subweapon & 0xFFFFEFFF);
                                break;
                            }
                            if (Globals.currentGame.getCON().type == 20 && k == 9 && p.ammo_amount[9] == 0 && p.gotweapon[12] && p.ammo_amount[12] > 0) {
                                j = 12;
                                p.subweapon = (short)(p.subweapon | 0x1000);
                                break;
                            }
                            if (++i != 10) continue;
                            Weapons.addweapon(p, 0);
                            break;
                        }
                    }
                    k = -1;
                    if (j == 5 && p.ammo_amount[5] == 0) {
                        k = Engine.headspritestat[1];
                        while (k >= 0) {
                            if (Engine.sprite[k].picnum == 26 && Engine.sprite[k].owner == p.i) {
                                p.gotweapon[5] = true;
                                j = 10;
                                break;
                            }
                            k = Engine.nextspritestat[k];
                        }
                    }
                    if (j == 9 && Globals.currentGame.getCON().type == 20) {
                        if (p.curr_weapon != 12 && p.curr_weapon != 9) {
                            if (p.ammo_amount[12] > 0) {
                                if ((p.subweapon & 0x1000) == 4096) {
                                    j = 12;
                                } else if (p.ammo_amount[9] == 0) {
                                    j = 12;
                                    p.subweapon = (short)(p.subweapon | 0x1000);
                                }
                            } else if (p.ammo_amount[9] > 0) {
                                p.subweapon = (short)(p.subweapon & 0xFFFFEFFF);
                            }
                        } else if (p.curr_weapon == 9) {
                            p.subweapon = (short)(p.subweapon | 0x1000);
                            j = 12;
                        } else {
                            p.subweapon = (short)(p.subweapon & 0xFFFFEFFF);
                        }
                    } else if (j == 6 && Globals.currentGame.getCON().PLUTOPAK) {
                        if (p.curr_weapon != 11 && p.curr_weapon != 6) {
                            if (p.ammo_amount[11] > 0) {
                                if ((p.subweapon & 0x800) == 2048) {
                                    j = 11;
                                } else if (p.ammo_amount[6] == 0) {
                                    j = 11;
                                    p.subweapon = (short)(p.subweapon | 0x800);
                                }
                            } else if (p.ammo_amount[6] > 0) {
                                p.subweapon = (short)(p.subweapon & 0xFFFFF7FF);
                            }
                        } else if (p.curr_weapon == 6) {
                            p.subweapon = (short)(p.subweapon | 0x800);
                            j = 11;
                        } else {
                            p.subweapon = (short)(p.subweapon & 0xFFFFF7FF);
                        }
                    }
                    if (p.holster_weapon != 0) {
                        sb_snum |= 0x80000;
                        p.weapon_pos = (short)-9;
                    } else if (j >= 0 && j < 13 && p.gotweapon[j] && p.curr_weapon != j) {
                        switch (j) {
                            case 0: {
                                Weapons.addweapon(p, 0);
                                break;
                            }
                            case 1: {
                                if (p.ammo_amount[1] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, 1);
                                break;
                            }
                            case 2: {
                                if (p.ammo_amount[2] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, 2);
                                break;
                            }
                            case 3: {
                                if (p.ammo_amount[3] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, 3);
                                break;
                            }
                            case 4: {
                                if (p.ammo_amount[4] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, 4);
                                break;
                            }
                            case 7: {
                                if (p.ammo_amount[7] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, 7);
                                break;
                            }
                            case 9: 
                            case 12: {
                                if (p.ammo_amount[j] == 0 && p.show_empty_weapon == 0) {
                                    p.last_full_weapon = p.curr_weapon;
                                    p.show_empty_weapon = (short)32;
                                }
                                Weapons.addweapon(p, j);
                                break;
                            }
                            case 6: 
                            case 11: {
                                if (p.ammo_amount[j] == 0 && p.show_empty_weapon == 0) {
                                    p.show_empty_weapon = (short)32;
                                    p.last_full_weapon = p.curr_weapon;
                                }
                                Weapons.addweapon(p, j);
                                break;
                            }
                            case 10: {
                                if (k < 0) break;
                                p.curr_weapon = (short)10;
                                p.last_weapon = (short)-1;
                                p.weapon_pos = (short)10;
                                break;
                            }
                            case 5: {
                                if (p.ammo_amount[5] <= 0 || !p.gotweapon[5]) break;
                                Weapons.addweapon(p, 5);
                                break;
                            }
                            case 8: {
                                if (p.ammo_amount[8] <= 0 || !p.gotweapon[8]) break;
                                Weapons.addweapon(p, 8);
                            }
                        }
                    }
                }
                if ((sb_snum & 0x80000) != 0 && p.curr_weapon > 0) {
                    if (p.holster_weapon == 0 && p.weapon_pos == 0) {
                        p.holster_weapon = 1;
                        p.weapon_pos = (short)-1;
                        View.FTA(73, p);
                    } else if (p.holster_weapon == 1 && p.weapon_pos == -9) {
                        p.holster_weapon = 0;
                        p.weapon_pos = (short)10;
                        View.FTA(74, p);
                    }
                }
            }
            if ((sb_snum & 0x1000000) != 0 && p.newowner == -1) {
                if (p.holoduke_on == -1) {
                    if (p.holoduke_amount > 0) {
                        p.inven_icon = 3;
                        short s = Spawn.EGS(p.cursectnum, p.posx, p.posy, p.posz + 7680, 1405, -64, 0, 0, (short)p.ang, 0, 0, -1, (short)10);
                        i = s;
                        p.holoduke_on = s;
                        Globals.hittype[i].temp_data[4] = 0;
                        Globals.hittype[i].temp_data[3] = 0;
                        Engine.sprite[i].yvel = (short)snum;
                        Engine.sprite[i].extra = 0;
                        View.FTA(47, p);
                        Sounds.spritesound(70, p.holoduke_on);
                    } else {
                        View.FTA(49, p);
                    }
                } else {
                    Sounds.spritesound(70, p.holoduke_on);
                    p.holoduke_on = (short)-1;
                    View.FTA(48, p);
                }
            }
            if ((sb_snum & 0x10000) != 0 && p.firstaid_amount > 0 && Engine.sprite[p.i].extra < Globals.currentGame.getCON().max_player_health) {
                j = Globals.currentGame.getCON().max_player_health - Engine.sprite[p.i].extra;
                if (p.firstaid_amount > j) {
                    p.firstaid_amount = (short)(p.firstaid_amount - j);
                    Engine.sprite[p.i].extra = (short)Globals.currentGame.getCON().max_player_health;
                    p.inven_icon = 1;
                } else {
                    Engine.sprite[p.i].extra = (short)(Engine.sprite[p.i].extra + p.firstaid_amount);
                    p.firstaid_amount = 0;
                    Player.checkavailinven(p);
                }
                Sounds.spritesound(216, p.i);
            }
            if ((sb_snum & 0x2000000) != 0 && p.newowner == -1) {
                if (p.jetpack_amount > 0) {
                    int n = p.jetpack_on = p.jetpack_on != 0 ? 0 : 1;
                    if (p.jetpack_on != 0) {
                        p.inven_icon = 4;
                        if (p.scream_voice != null) {
                            p.scream_voice.dispose();
                            p.scream_voice = null;
                        }
                        Sounds.spritesound(49, p.i);
                        View.FTA(52, p);
                    } else {
                        p.hard_landing = 0;
                        p.poszv = 0;
                        Sounds.spritesound(51, p.i);
                        Sounds.stopsound(50, p.i);
                        Sounds.stopsound(49, p.i);
                        View.FTA(53, p);
                    }
                } else {
                    View.FTA(50, p);
                }
            }
            if ((sb_snum & 0x10000000) != 0 && p.one_eighty_count == 0) {
                p.one_eighty_count = (short)-1024;
            }
        }
    }

    public boolean IsOriginalGame() {
        return Globals.ud.recstat == 1 && Globals.ud.rec != null && Globals.ud.rec.recversion <= 127;
    }
}

