/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.LZWDecoder;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Input;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.ResourceHandler;
import ru.m210projects.Duke3D.Types.GameInfo;

public class DemoFile {
    public int rcnt = 0;
    public Input[][] recsync;
    public static Resource recfilep;
    public static LZWDecoder recorder;
    private final boolean unpacked = false;
    public int reccnt;
    public int version;
    public int volume_number;
    public int level_number;
    public int player_skill;
    public int coop;
    public int ffire;
    public int multimode;
    public boolean monsters_off;
    public boolean respawn_monsters;
    public boolean respawn_items;
    public boolean respawn_inventory;
    public int playerai;
    public String[] user_name = new String[16];
    public int auto_run;
    public String boardfilename;
    public int[] aim_mode = new int[16];
    public int[] auto_aim = new int[16];
    public GameInfo addon;
    public int totalreccnt;
    public int recversion;
    public byte[] recbuf;

    public DemoFile(String filename) throws Exception {
        this.rcnt = 0;
        this.recversion = -1;
        Globals.ud.rec = null;
        recfilep = BuildGdx.cache.open(filename, Globals.loadfromgrouponly);
        if (recfilep == null) {
            throw new Exception("File not found");
        }
        this.reccnt = recfilep.readInt();
        this.version = recfilep.readByte() & 0xFF;
        if (this.version != 116 && this.version != 117 && this.version != 127 && this.version != 147) {
            recfilep.close();
            throw new Exception("Wrong version!");
        }
        this.volume_number = recfilep.readByte().byteValue();
        this.level_number = recfilep.readByte().byteValue();
        this.player_skill = recfilep.readByte().byteValue();
        this.coop = recfilep.readByte().byteValue();
        this.ffire = recfilep.readByte().byteValue();
        this.multimode = recfilep.readShort().shortValue();
        this.monsters_off = recfilep.readShort() == 1;
        this.respawn_monsters = recfilep.readInt() == 1;
        this.respawn_items = recfilep.readInt() == 1;
        this.respawn_inventory = recfilep.readInt() == 1;
        this.playerai = recfilep.readInt();
        for (int i = 0; i < 16; ++i) {
            recfilep.read(Globals.tempbuf, 0, 32);
            this.user_name[i] = new String(Globals.tempbuf, 0, 32).trim();
        }
        this.auto_run = recfilep.readInt();
        int MAX_PATH = 128;
        if (this.version >= 127) {
            MAX_PATH = 260;
        }
        recfilep.read(Globals.tempbuf, 0, MAX_PATH);
        String name = FileUtils.getCorrectPath(new String(Globals.tempbuf, 0, MAX_PATH).trim());
        if (!name.isEmpty() && BuildGdx.compat.checkFile(name) != null) {
            this.boardfilename = name;
            this.level_number = 7;
            this.volume_number = 0;
        }
        if (this.version >= 147) {
            recfilep.read(Globals.tempbuf, 0, 144);
            String addonName = Strhandler.toLowerCase(new String(Globals.tempbuf).trim());
            this.addon = ResourceHandler.levelGetEpisode(addonName);
        }
        for (int i = 0; i < this.multimode; ++i) {
            this.aim_mode[i] = recfilep.readByte().byteValue();
            if (this.version < 127) continue;
            this.auto_aim[i] = recfilep.readByte().byteValue();
        }
        this.recsync = new Input[this.reccnt][16];
        int dasizeof = Input.sizeof(this.version) * this.multimode;
        byte[] recsyncbuf = new byte[dasizeof * 2520];
        LZWDecoder decoder = null;
        decoder = new LZWDecoder(recfilep, dasizeof);
        int rccnt = 0;
        for (int c = 0; c <= this.reccnt / 2520; ++c) {
            int l = Math.min(this.reccnt - rccnt, 2520);
            if (decoder != null) {
                decoder.read(recsyncbuf, l / this.multimode);
            } else {
                recfilep.read(recsyncbuf, 0, Input.sizeof(this.version) * l);
            }
            ByteBuffer bb = ByteBuffer.wrap(recsyncbuf);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            for (int rcnt = rccnt; rcnt < rccnt + l; rcnt += this.multimode) {
                for (int i = 0; i < this.multimode; ++i) {
                    this.recsync[rcnt / this.multimode][i] = new Input(bb, this.version);
                }
            }
            rccnt += 2520;
        }
        if (decoder != null) {
            decoder.close();
        } else {
            recfilep.close();
        }
    }

    public DemoFile(int nVersion) {
        if (Globals.ud.recstat == 2) {
            recfilep.close();
        }
        int democount = 0;
        String fn = null;
        while (true) {
            if (democount > 9999) {
                return;
            }
            int a = democount / 1000 % 10;
            int b = democount / 100 % 10;
            int c = democount / 10 % 10;
            int d = democount % 10;
            fn = "demo" + a + b + c + d + ".dmo";
            if (BuildGdx.compat.checkFile(fn) == null) break;
            ++democount;
        }
        if (fn == null || (recfilep = BuildGdx.compat.open(fn, Compat.Path.Game, FileResource.Mode.Write)) == null) {
            return;
        }
        Console.Println("Start recording to " + fn);
        FileResource res = (FileResource)recfilep;
        res.writeInt(0);
        res.writeByte(nVersion);
        res.writeByte(Globals.ud.volume_number);
        res.writeByte(Globals.ud.level_number);
        res.writeByte(Globals.ud.player_skill);
        res.writeByte(Globals.ud.coop);
        res.writeByte(Globals.ud.ffire);
        res.writeShort(Globals.ud.multimode);
        res.writeShort(Globals.ud.monsters_off ? 1 : 0);
        res.writeInt(Globals.ud.respawn_monsters ? 1 : 0);
        res.writeInt(Globals.ud.respawn_items ? 1 : 0);
        res.writeInt(Globals.ud.respawn_inventory ? 1 : 0);
        res.writeInt(Globals.ud.playerai);
        for (int i = 0; i < 16; ++i) {
            Strhandler.buildString(Globals.buf, 0, Globals.ud.user_name[i]);
            res.writeBytes(Globals.buf, 32);
        }
        res.writeInt(Globals.ud.auto_run);
        int MAX_PATH = 128;
        if (nVersion >= 127) {
            MAX_PATH = 260;
        }
        if (this.boardfilename != null) {
            res.writeBytes(this.boardfilename.toCharArray(), MAX_PATH);
        } else {
            res.writeBytes(new byte[MAX_PATH], MAX_PATH);
        }
        if (nVersion >= 147) {
            byte[] name = new byte[144];
            if (Main.mUserFlag == Main.UserFlag.Addon && Globals.currentGame != null) {
                String path;
                FileEntry addon = Globals.currentGame.getFile();
                if (addon != null) {
                    path = addon.getPath();
                    path = path + ":" + Globals.currentGame.ConName;
                } else {
                    path = Globals.currentGame.getDirectory().checkFile(Globals.currentGame.ConName).getPath();
                }
                System.arraycopy(path.getBytes(), 0, name, 0, Math.min(path.length(), 144));
            }
            res.writeBytes(name, name.length);
        }
        for (int i = 0; i < Globals.ud.multimode; ++i) {
            res.writeByte(Globals.ps[i].aim_mode);
            if (nVersion < 127) continue;
            res.writeByte(Globals.ps[i].auto_aim);
        }
        this.totalreccnt = 0;
        this.reccnt = 0;
        this.recversion = nVersion;
        this.recbuf = new byte[2520 * Input.sizeof(147)];
        recorder = new LZWDecoder(res, Input.sizeof(this.recversion) * Globals.ud.multimode);
        Main.gDemoScreen.demofiles.add(fn);
    }

    public void record() {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            int len = Input.sizeof(this.recversion);
            System.arraycopy(Globals.sync[i].getBytes(this.recversion), 0, this.recbuf, this.reccnt * len, len);
            ++this.reccnt;
            ++this.totalreccnt;
            if (this.reccnt >= 2520) {
                if (recorder != null) {
                    try {
                        recorder.write(this.recbuf, this.reccnt / Globals.ud.multimode);
                    }
                    catch (Exception e) {
                        Console.Println(e.getMessage(), Console.OSDTEXT_RED);
                        this.close();
                    }
                } else {
                    ((FileResource)recfilep).writeBytes(this.recbuf, this.reccnt * len);
                }
                this.reccnt = 0;
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    public void close() {
        if (Globals.ud.recstat == 1) {
            try {
                if (this.reccnt > 0) {
                    int len = Input.sizeof(this.recversion);
                    if (recorder != null) {
                        recorder.write(this.recbuf, this.reccnt / Globals.ud.multimode);
                    } else {
                        ((FileResource)recfilep).writeBytes(this.recbuf, this.reccnt * len);
                    }
                }
                recfilep.seek(0L, Resource.Whence.Set);
                ((FileResource)recfilep).writeInt(this.totalreccnt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Console.Println("Stop recording");
            Globals.ud.m_recstat = 0;
            Globals.ud.recstat = 0;
            Globals.ud.rec = null;
            this.recversion = 0;
            if (recorder != null) {
                recorder.close();
            } else {
                recfilep.close();
            }
        }
    }
}

