/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Types;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.Script.Scriptfile;
import ru.m210projects.Build.Strhandler;

public class DevCommScript
extends Scriptfile {
    private final int T_DEF = 1;
    private final int T_SOUND = 2;
    private final int T_PATH = 3;
    private final int T_NUM = 4;
    private final int T_ERROR = 5;
    private final int T_EOF = 6;
    private final Map<String, Integer> basetokens = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("def", 1);
            this.put("sound", 2);
            this.put("path:", 3);
            this.put("num:", 4);
        }
    };
    private Map<Integer, String> commentaries;

    public DevCommScript(FileEntry file) {
        super(file.getName(), BuildGdx.compat.getBytes(file));
        int tokn = this.gettoken(this.basetokens);
        int end = -1;
        if (tokn != 1 || !this.getstring().equals("developercommentary") || (end = this.getbraces()) == -1) {
            return;
        }
        this.commentaries = new HashMap<Integer, String>();
        while (this.textptr < end) {
            this.process();
        }
    }

    public Map<Integer, String> getCommentaries() {
        return this.commentaries;
    }

    private int gettoken(Map<String, Integer> list) {
        int tok = this.gettoken();
        if (tok == -2) {
            return 6;
        }
        Integer out = list.get(Strhandler.toLowerCase(this.textbuf.substring(tok, this.textptr)));
        if (out != null) {
            return out;
        }
        this.errorptr = this.textptr;
        return 5;
    }

    private Integer getValue() {
        String txt = this.getstring();
        if (txt == null) {
            return null;
        }
        txt = txt.replaceAll("[^0-9]", "");
        try {
            return Integer.parseInt(txt);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getPath() {
        int out = this.gettoken();
        if (out == -1) {
            return null;
        }
        String txt = this.textbuf.substring(out, this.textptr - 1);
        txt = txt.replaceAll("\"", "");
        txt = txt.replace("/", File.separator);
        return Strhandler.toLowerCase(txt);
    }

    private void process() {
        int tokn = this.gettoken(this.basetokens);
        switch (tokn) {
            case 1: {
                int sndtokn = this.gettoken(this.basetokens);
                int sndend = -1;
                int num = -1;
                String path = null;
                if (sndtokn != 2) break;
                sndend = this.getbraces();
                if (sndend == -1) {
                    return;
                }
                while (this.textptr < sndend) {
                    switch (this.gettoken(this.basetokens)) {
                        case 3: {
                            path = this.getPath();
                            break;
                        }
                        case 4: {
                            num = this.getValue();
                        }
                    }
                }
                if (path == null || num == -1) break;
                this.commentaries.put(num, path);
                break;
            }
        }
    }
}

