/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Types;

import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Duke3D.Gamedef;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Types.EpisodeInfo;
import ru.m210projects.Duke3D.Types.MapInfo;
import ru.m210projects.Duke3D.Types.Script;

public class GameInfo {
    public DirectoryEntry resDir;
    public String Title;
    public EpisodeInfo[] episodes;
    public String[] skillnames;
    public int nEpisodes;
    public String ConName;
    private Script ConScr;
    public boolean isInited = false;
    private int nMaps;
    private FileEntry file;
    private boolean pack;
    private int textptr;
    private final char[] tempbuf = new char[2048];

    public GameInfo(FileEntry file, String mainCon) {
        this.ConName = mainCon;
        this.Title = mainCon;
        this.resDir = file.getParent();
        this.file = file;
        this.skillnames = new String[5];
        this.episodes = new EpisodeInfo[5];
        this.isInited = false;
    }

    public GameInfo(Group res, FileEntry file, String mainCon) {
        if (mainCon.equalsIgnoreCase("eduke.con")) {
            this.isInited = false;
            return;
        }
        this.ConName = mainCon;
        this.Title = file.getName() + ":" + mainCon;
        this.skillnames = new String[5];
        this.episodes = new EpisodeInfo[5];
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.ConName);
            for (int i = 0; i < list.size(); ++i) {
                this.InitTree(list, res, (String)list.get(i));
            }
            this.nMaps = 0;
            this.nEpisodes = 0;
            for (String s : list) {
                GroupResource fil = res.open(s);
                if (fil == null) continue;
                byte[] data = Gamedef.preparescript(fil.getBytes());
                this.findSkillNames(data);
                this.findVolumes(data);
                this.findMaps(data, res);
                fil.close();
            }
            if (this.nEpisodes != 0 && this.nMaps != 0) {
                this.isInited = true;
            }
            this.checkEpisodes();
            this.pack = true;
            this.file = file;
        }
        catch (Exception e) {
            e.printStackTrace();
            Console.Println("Build addon: " + this.Title + " failed!", Console.OSDTEXT_RED);
            this.isInited = false;
        }
    }

    public FileEntry getFile() {
        return this.file;
    }

    public boolean isPackage() {
        return this.pack;
    }

    public void setPackage(boolean pack) {
        this.pack = pack;
    }

    public void setDirectory(DirectoryEntry resDir) {
        this.resDir = resDir;
    }

    public DirectoryEntry getDirectory() {
        return this.resDir;
    }

    public Script getCON() {
        return this.ConScr;
    }

    public void setCON(Script con) {
        this.ConScr = con;
    }

    public void init() {
        try {
            ArrayList<FileEntry> list = new ArrayList<FileEntry>();
            list.add(this.resDir.checkFile(this.ConName));
            for (int i = 0; i < list.size(); ++i) {
                this.InitTree(list, (FileEntry)list.get(i));
            }
            this.nMaps = 0;
            this.nEpisodes = 0;
            for (FileEntry scriptfile : list) {
                if (scriptfile == null) continue;
                byte[] data = Gamedef.preparescript(BuildGdx.compat.getBytes(scriptfile));
                this.findSkillNames(data);
                this.findVolumes(data);
                this.findMaps(data, null);
            }
            if (this.nEpisodes != 0 && this.nMaps != 0) {
                this.isInited = true;
            }
            this.checkEpisodes();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isInited = false;
        }
    }

    private void checkEpisodes() {
        int sum = 0;
        for (int e = 0; e < this.nEpisodes; ++e) {
            if (this.episodes[e] == null) continue;
            if (this.episodes[e].gMapInfo[0] == null) {
                this.episodes[e].nMaps = 0;
            }
            sum += this.episodes[e].nMaps;
        }
        if (sum == 0) {
            this.isInited = false;
        } else if (Globals.defGame != null && this.skillnames[0] == null) {
            Console.Println("Appling default skill names for " + this.Title);
            for (int i = 0; i < Globals.defGame.getCON().nSkills; ++i) {
                this.skillnames[i] = new String(Globals.defGame.getCON().skill_names[i]).trim();
            }
        }
    }

    private void InitTree(List<FileEntry> list, FileEntry confile) {
        if (confile == null) {
            return;
        }
        byte[] buf = Gamedef.preparescript(BuildGdx.compat.getBytes(confile));
        int index = -1;
        while ((index = Strhandler.indexOf("include ", buf, index + 1)) != -1) {
            int textptr = index + 7;
            while (!Gamedef.isaltok(buf[textptr]) && buf[++textptr] != 0) {
            }
            int i = 0;
            while (textptr + i < buf.length && Gamedef.isaltok(buf[textptr + i])) {
                ++i;
            }
            String name = new String(buf, textptr, i);
            list.add(this.resDir.checkFile(name));
        }
    }

    private void InitTree(List<String> list, Group res, String filename) {
        GroupResource fil = res.open(filename);
        if (fil != null) {
            byte[] buf = Gamedef.preparescript(fil.getBytes());
            int index = -1;
            while ((index = Strhandler.indexOf("include ", buf, index + 1)) != -1) {
                int textptr = index + 7;
                while (!Gamedef.isaltok(buf[textptr]) && buf[++textptr] != 0) {
                }
                int i = 0;
                while (textptr + i < buf.length && Gamedef.isaltok(buf[textptr + i])) {
                    ++i;
                }
                String name = new String(buf, textptr, i);
                list.add(name);
            }
            fil.close();
        }
    }

    private boolean findVolumes(byte[] buf) {
        int index = -1;
        while ((index = Strhandler.indexOf("definevolumename ", buf, index + 1)) != -1) {
            this.textptr = index + 16;
            Integer j = this.transnum(buf);
            if (j == null) continue;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            int i = 0;
            int startptr = this.textptr;
            while (buf[this.textptr + i] != 10) {
                ++i;
            }
            this.episodes[j.intValue()] = new EpisodeInfo(new String(buf, startptr, i - 1).toUpperCase());
            this.nEpisodes = Math.max(this.nEpisodes, j + 1);
        }
        return this.nEpisodes != 0;
    }

    private void findMaps(byte[] buf, Group res) {
        int index = -1;
        while ((index = Strhandler.indexOf("definelevelname ", buf, index + 1)) != -1) {
            Integer mapnum;
            this.textptr = index + 15;
            Integer epnum = this.transnum(buf);
            if (epnum == null || (mapnum = this.transnum(buf)) == null) continue;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            int i = 0;
            int ptr = this.textptr;
            while (buf[this.textptr] != 32 && buf[this.textptr] != 10) {
                ++this.textptr;
                ++i;
            }
            String path = FileUtils.getCorrectPath(Strhandler.toLowerCase(new String(buf, ptr, i)));
            boolean mapFound = false;
            String mapPath = path;
            if (res == null) {
                FileEntry mapFile = this.resDir.checkFile(path);
                boolean bl = mapFound = mapFile != null;
                if (mapFound) {
                    mapPath = mapFile.getPath();
                }
            } else {
                mapFound = res.contains(path);
                mapPath = path;
            }
            if (!mapFound || this.episodes[epnum] == null) continue;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            int partime = ((buf[this.textptr] - 48) * 10 + (buf[this.textptr + 1] - 48)) * 26 * 60 + ((buf[this.textptr + 3] - 48) * 10 + (buf[this.textptr + 4] - 48)) * 26;
            this.textptr += 5;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            int designertime = ((buf[this.textptr] - 48) * 10 + (buf[this.textptr + 1] - 48)) * 26 * 60 + ((buf[this.textptr + 3] - 48) * 10 + (buf[this.textptr + 4] - 48)) * 26;
            this.textptr += 5;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            i = 0;
            while (buf[this.textptr + i] != 10) {
                ++i;
            }
            String title = new String(buf, this.textptr, i - 1);
            this.episodes[epnum.intValue()].gMapInfo[mapnum.intValue()] = new MapInfo(mapPath, title, partime, designertime);
            this.episodes[epnum.intValue()].nMaps = Math.max(this.episodes[epnum.intValue()].nMaps, mapnum + 1);
            ++this.nMaps;
        }
    }

    private boolean findSkillNames(byte[] buf) {
        int index = -1;
        int size = 0;
        while ((index = Strhandler.indexOf("defineskillname ", buf, index + 1)) != -1) {
            this.textptr = index + 15;
            Integer j = this.transnum(buf);
            if (j == null) continue;
            while (buf[this.textptr] == 32) {
                ++this.textptr;
            }
            int i = 0;
            while (buf[this.textptr + i] != 10) {
                ++i;
            }
            this.skillnames[j.intValue()] = new String(buf, this.textptr, i - 1).toUpperCase();
            size = Math.max(size, j + 1);
        }
        return size != 0;
    }

    private Integer transnum(byte[] text) {
        int i;
        while (!Gamedef.isaltok(text[this.textptr])) {
            ++this.textptr;
            if (text[this.textptr] != 0) continue;
            return null;
        }
        int l = 0;
        while (Gamedef.isaltok(text[this.textptr + l])) {
            this.tempbuf[l] = (char)text[this.textptr + l];
            ++l;
        }
        this.tempbuf[l] = '\u0000';
        for (i = 0; i < Gamedef.NUMKEYWORDS; ++i) {
            if (Strhandler.Bstrcmp(Gamedef.label, Gamedef.labelcnt << 6, Gamedef.keyw[i], 0) != 0) continue;
            ++Gamedef.error;
            Console.Println("  * ERROR! Symbol '" + Gamedef.label[Gamedef.labelcnt << 6] + "' is a key word.");
            this.textptr += l;
        }
        for (i = 0; i < Gamedef.labelcnt; ++i) {
            if (Strhandler.Bstrcmp(this.tempbuf, 0, Gamedef.label, i << 6) != 0) continue;
            this.textptr += l;
            return Gamedef.labelcode.get(i);
        }
        if (!Character.isDigit(text[this.textptr]) && text[this.textptr] != 45) {
            Console.Println("  * ERROR! Parameter '" + new String(this.tempbuf, 0, l) + "' is undefined.");
            ++Gamedef.error;
            this.textptr += l;
            return null;
        }
        String number = new String(text, this.textptr, l);
        this.textptr += l;
        return Integer.parseInt(number);
    }
}

