/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Types;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Types.LumpInfo;

public class RTS {
    public static int numlumps;
    public static LumpInfo[] lumpinfo;
    public static byte[][] lumpcache;
    public static boolean RTS_Started;
    public static char rtsplaying;
    public static byte[] lumplockbyte;

    public static boolean RTS_AddFile(String filename) {
        Resource handle = BuildGdx.cache.open(filename, 0);
        if (handle == null) {
            Console.Println("RTS file " + filename + " was not found", Console.OSDTEXT_RED);
            return false;
        }
        int startlump = numlumps;
        Console.Println("    Adding " + filename);
        byte[] data = new byte[16];
        handle.read(data, 0, 12);
        String identification = new String(data, 0, 4);
        int infonumlumps = LittleEndian.getInt(data, 4);
        int infotableofs = LittleEndian.getInt(data, 8);
        if (!identification.equalsIgnoreCase("IWAD")) {
            Console.Println("RTS file " + filename + " doesn't have IWAD id", Console.OSDTEXT_RED);
            handle.close();
            return false;
        }
        numlumps += infonumlumps;
        lumpinfo = new LumpInfo[infonumlumps];
        handle.seek(infotableofs, Resource.Whence.Set);
        for (int i = startlump; i < numlumps; ++i) {
            handle.read(data, 0, 16);
            int filepos = LittleEndian.getInt(data);
            int size = LittleEndian.getInt(data, 4);
            String name = new String(data, 8, 8);
            RTS.lumpinfo[i] = new LumpInfo();
            RTS.lumpinfo[i].handle = handle;
            RTS.lumpinfo[i].position = filepos;
            RTS.lumpinfo[i].size = size;
            RTS.lumpinfo[i].name = name;
        }
        return true;
    }

    public static void RTS_Init(String filename) {
        numlumps = 0;
        lumpinfo = null;
        Console.Println("RTS Manager Started.");
        if (!RTS.RTS_AddFile(filename)) {
            return;
        }
        if (numlumps == 0) {
            return;
        }
        lumpcache = new byte[numlumps][];
        RTS_Started = true;
    }

    public static int RTS_NumSounds() {
        return numlumps - 1;
    }

    public static int RTS_SoundLength(int lump) {
        if (++lump >= numlumps) {
            Main.game.dassert("RTS_SoundLength: " + lump + " >= numlumps");
        }
        return RTS.lumpinfo[lump].size;
    }

    public static String RTS_GetSoundName(int i) {
        if (++i >= numlumps) {
            Main.game.dassert("RTS_GetSoundName: " + i + " >= numlumps");
        }
        return RTS.lumpinfo[i].name;
    }

    public static void RTS_ReadLump(int lump, byte[] dest) {
        if (lump >= numlumps) {
            Main.game.dassert("RTS_ReadLump: " + lump + " >= numlumps");
        }
        if (lump < 0) {
            Main.game.dassert("RTS_ReadLump: " + lump + " < 0");
        }
        LumpInfo l = lumpinfo[lump];
        l.handle.seek(l.position, Resource.Whence.Set);
        l.handle.read(dest, 0, l.size);
    }

    public static byte[] RTS_GetSound(int lump) {
        if (++lump >= numlumps) {
            Main.game.dassert("RTS_GetSound: " + lump + " >= " + numlumps);
        }
        if (lumpcache == null) {
            Main.game.dassert("RTS_GetSound: lumpcache == null");
        }
        if (lumpcache[lump] == null) {
            RTS.lumplockbyte[lump] = -56;
            RTS.lumpcache[lump] = new byte[RTS.RTS_SoundLength(lump - 1)];
            RTS.RTS_ReadLump(lump, lumpcache[lump]);
        } else if ((lumplockbyte[lump] & 0xFF) < 200) {
            RTS.lumplockbyte[lump] = -56;
        } else {
            int n = lump;
            lumplockbyte[n] = (byte)(lumplockbyte[n] + 1);
        }
        return lumpcache[lump];
    }

    static {
        RTS_Started = false;
        lumplockbyte = new byte[13];
    }
}

