/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Settings.BuildConfig;

public class Config
extends BuildConfig {
    public boolean gAutoRun;
    public int gOverlayMap;
    public boolean gShowMessages;
    public boolean gCrosshair;
    public int gCrossSize;
    public int gShowStat;
    public int gHUDSize;
    public int showMapInfo;
    public boolean bHeadBob;
    public boolean bOriginal;
    public boolean bShowExit;
    public static final char[] defclassickeys = new char[]{'\u0013', '\u0014', '\u0015', '\u0016', 'C', '9', '7', '8', '\u001d', '6', '\u0000', '>', '\u0081', '\u0083', '\b', '\t', '\n', 'J', 'K', '\u0000', '\\', ']', '1', ';', '\u00ee', '=', 'F', 'E', 'D', '\"', '%', '\u00fc', '\u00f9', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00fd', '\u00fe', '\u00ff'};
    public static char[] defkeys = new char[]{'3', '/', '\u0015', '\u0016', 'C', '9', '\u001d', ' ', '>', '\u0081', '\u0000', '!', '\u0000', '\u0083', '\b', '\t', '\n', 'J', 'K', '-', '\\', ']', '1', ';', '\u00ee', '=', 'F', 'E', 'D', '\"', '%', '\u00fc', '\u00f9', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00fd', '\u00fe', '\u00ff'};

    public Config(String path, String name) {
        super(path, name);
    }

    @Override
    public void SaveConfig(FileResource fil) {
        if (fil != null) {
            this.saveString(fil, "[Options]\r\n");
            this.saveBoolean(fil, "AutoRun", this.gAutoRun);
            this.saveInteger(fil, "OverlayMap", this.gOverlayMap);
            this.saveBoolean(fil, "ShowMessages", this.gShowMessages);
            this.saveBoolean(fil, "Crosshair", this.gCrosshair);
            this.saveInteger(fil, "CrossSize", this.gCrossSize);
            this.saveInteger(fil, "ShowStat", this.gShowStat);
            this.saveInteger(fil, "HUDSize", this.gHUDSize);
            this.saveInteger(fil, "showMapInfo", this.showMapInfo);
            this.saveBoolean(fil, "HeadBob", this.bHeadBob);
            this.saveBoolean(fil, "ProjectileSpam", this.bOriginal);
            this.saveBoolean(fil, "ShowExits", this.bShowExit);
        }
    }

    @Override
    public boolean InitConfig(boolean isDefault) {
        this.gAutoRun = false;
        this.gOverlayMap = 2;
        this.gShowMessages = true;
        this.gCrosshair = true;
        this.gCrossSize = 65536;
        this.gShowStat = 0;
        this.gHUDSize = 65536;
        this.showMapInfo = 1;
        this.bHeadBob = true;
        this.bShowExit = false;
        if (!isDefault) {
            this.LoadCommon(defkeys, defclassickeys);
            if (this.set("Options")) {
                this.gAutoRun = this.GetKeyInt("AutoRun") == 1;
                int value = this.GetKeyInt("OverlayMap");
                if (value != -1) {
                    this.gOverlayMap = value;
                }
                this.gShowMessages = this.GetKeyInt("ShowMessages") == 1;
                this.gCrosshair = this.GetKeyInt("Crosshair") == 1;
                value = this.GetKeyInt("CrossSize");
                if (value != -1) {
                    this.gCrossSize = Gameutils.BClipLow(value, 16384);
                }
                if ((value = this.GetKeyInt("ShowStat")) != -1) {
                    this.gShowStat = value;
                }
                if ((value = this.GetKeyInt("HUDSize")) != -1) {
                    this.gHUDSize = Gameutils.BClipLow(value, 16384);
                }
                if ((value = this.GetKeyInt("showMapInfo")) != -1) {
                    this.showMapInfo = value;
                }
                this.bHeadBob = this.GetKeyInt("HeadBob") == 1;
                value = this.GetKeyInt("ProjectileSpam");
                if (value != -1) {
                    boolean bl = this.bOriginal = value == 1;
                }
                if ((value = this.GetKeyInt("ShowExits")) != -1) {
                    this.bShowExit = value == 1;
                }
            }
            this.close();
        } else {
            Console.Println("Config file not found, using default settings", Console.OSDTEXT_YELLOW);
            for (int i = 0; i < this.keymap.length; ++i) {
                this.primarykeys[i] = defkeys[i];
            }
            this.mousekeys[BuildConfig.GameKeys.Weapon_Fire.getNum()] = 226;
            this.mousekeys[BuildConfig.GameKeys.Open.getNum()] = 227;
            this.mousekeys[BuildConfig.GameKeys.Next_Weapon.getNum()] = 224;
            this.mousekeys[BuildConfig.GameKeys.Previous_Weapon.getNum()] = 225;
        }
        boolean mouseset = true;
        for (int i = 0; i < this.mousekeys.length; ++i) {
            if (this.mousekeys[i] == 0) continue;
            mouseset = false;
            break;
        }
        if (mouseset) {
            this.mousekeys[BuildConfig.GameKeys.Weapon_Fire.getNum()] = 226;
            this.mousekeys[BuildConfig.GameKeys.Open.getNum()] = 227;
            this.mousekeys[BuildConfig.GameKeys.Next_Weapon.getNum()] = 224;
            this.mousekeys[BuildConfig.GameKeys.Previous_Weapon.getNum()] = 225;
        }
        this.musicType = Gameutils.BClipRange(this.musicType, 0, 1);
        return true;
    }

    @Override
    public BuildConfig.KeyType[] getKeyMap() {
        BuildConfig.KeyType[] keymap = new BuildConfig.KeyType[]{BuildConfig.GameKeys.Move_Forward, BuildConfig.GameKeys.Move_Backward, BuildConfig.GameKeys.Turn_Left, BuildConfig.GameKeys.Turn_Right, BuildConfig.GameKeys.Turn_Around, BuildConfig.GameKeys.Strafe, BuildConfig.GameKeys.Strafe_Left, BuildConfig.GameKeys.Strafe_Right, BuildConfig.GameKeys.Jump, BuildConfig.GameKeys.Crouch, LSPKeys.Crouch_toggle, BuildConfig.GameKeys.Open, BuildConfig.GameKeys.Weapon_Fire, BuildConfig.GameKeys.Menu_Toggle, LSPKeys.Weapon_1, LSPKeys.Weapon_2, LSPKeys.Weapon_3, BuildConfig.GameKeys.Previous_Weapon, BuildConfig.GameKeys.Next_Weapon, LSPKeys.Last_Used_Weapon, BuildConfig.GameKeys.Look_Up, BuildConfig.GameKeys.Look_Down, BuildConfig.GameKeys.Mouse_Aiming, BuildConfig.GameKeys.Run, LSPKeys.AutoRun, BuildConfig.GameKeys.Map_Toggle, BuildConfig.GameKeys.Enlarge_Screen, BuildConfig.GameKeys.Shrink_Screen, BuildConfig.GameKeys.Show_Console, LSPKeys.Map_Follow_Mode, LSPKeys.Toggle_Crosshair, LSPKeys.Quickload, LSPKeys.Quicksave, LSPKeys.Show_Savemenu, LSPKeys.Show_Loadmenu, LSPKeys.Show_Sounds, LSPKeys.Show_Options, LSPKeys.Quit, LSPKeys.Gamma, LSPKeys.Make_Screenshot};
        return keymap;
    }

    public static enum LSPKeys implements BuildConfig.KeyType
    {
        Weapon_1,
        Weapon_2,
        Weapon_3,
        Last_Used_Weapon,
        Map_Follow_Mode,
        Toggle_Crosshair,
        AutoRun,
        Quickload,
        Quicksave,
        Show_Savemenu,
        Show_Loadmenu,
        Show_Sounds,
        Show_Options,
        Quit,
        Gamma,
        Crouch_toggle,
        Make_Screenshot;

        private int num = -1;

        @Override
        public int getNum() {
            return this.num;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public BuildConfig.KeyType setNum(int num) {
            this.num = num;
            return this;
        }
    }
}

