/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;

public class Quotes {
    public static int showQuotes = 4;
    public static int quoteTime = 500;
    public static int nextTime;
    public static int nextY;
    public static int kMaxQuotes;
    public static int numQuotes;
    public static int hideQuotes;
    public static int totalQuotes;
    public static int QuotesY;
    public static QUOTE[] quotes;
    public static int yOffset;

    public static void InitQuotes() {
        for (int i = 0; i < kMaxQuotes; ++i) {
            Quotes.quotes[i] = new QUOTE();
        }
    }

    public static void resetQuotes() {
        numQuotes = 0;
        totalQuotes = 0;
        hideQuotes = 0;
    }

    public static QUOTE viewSetMessage(String message) {
        QUOTE quote = quotes[totalQuotes];
        quote.messageText = message;
        Console.Println(message);
        quote.messageTime = 4 * quoteTime + Globals.lockclock;
        ++totalQuotes;
        totalQuotes %= kMaxQuotes;
        if (++numQuotes > showQuotes) {
            ++hideQuotes;
            hideQuotes %= kMaxQuotes;
            nextTime = 0;
            numQuotes = showQuotes;
            nextY = yOffset;
        }
        return quote;
    }

    public static void viewDisplayMessage() {
        if (!Main.cfg.gShowMessages || Main.game.menu.gShowMenu) {
            return;
        }
        int x = Pragmas.scale(10L, Main.cfg.gHUDSize, 65536L);
        int y = Pragmas.scale(10L, Main.cfg.gHUDSize, 65536L);
        int nShade = Gameutils.BClipHigh(numQuotes << 3, 48);
        y += Pragmas.scale(nextY, Main.cfg.gHUDSize, 65536L);
        for (int i = 0; i < numQuotes; ++i) {
            QUOTE quote = quotes[(i + hideQuotes) % kMaxQuotes];
            if (Globals.lockclock < quote.messageTime) {
                int col = Math.max(16 + (32 - nShade), 0) * 255 / 48;
                byte palcol = Main.engine.getclosestcol(Engine.curpalette.getBytes(), col, col, col);
                Main.game.getFont(1).drawText(x + 1, y, quote.messageText, Main.cfg.gHUDSize, nShade, (int)palcol, BuildFont.TextAlign.Left, 264, true);
                y += Pragmas.scale(yOffset, Main.cfg.gHUDSize, 65536L);
                nShade = Gameutils.BClipLow(nShade - 64 / numQuotes, -128);
                continue;
            }
            --numQuotes;
            ++hideQuotes;
            hideQuotes %= kMaxQuotes;
        }
        if (nextY != 0) {
            nextY = nextTime * yOffset / 4;
        }
    }

    static {
        kMaxQuotes = 16;
        QuotesY = 1;
        quotes = new QUOTE[kMaxQuotes];
        yOffset = 11;
    }

    public static class QUOTE {
        public String messageText;
        public int messageTime;
    }
}

