/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.Components;

import com.badlogic.gdx.Graphics;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.VideoMode;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.desktop.DesktopFactory;
import ru.m210projects.Build.desktop.audio.midi.MidiMusicModule;
import ru.m210projects.Launcher.desktop.Components.FramePanel;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.JLauncher;

public class Settings
extends FramePanel {
    private static final long serialVersionUID = 1L;
    public GameEntry entry;
    public GameEntry portableEntry;
    public BuildConfig portableConfig;
    public JComboBox<String> comboSound;
    public JComboBox<String> comboResolution;
    public JComboBox<String> comboMidi;
    public JComboBox<String> comboRenderer;
    public JCheckBox chckbxFullscreen;
    public JCheckBox chckbxBorderless;
    public JCheckBox chckbxEnableAutoloadFolder;
    public JCheckBox chckbxCheckForUpdates;
    public JCheckBox chckbxUseHomeFolder;
    public JCheckBox chckbxAlwaysShowThis;
    public JButton btnOpenFolder;
    public JTextField Soundbox;

    public Settings(JLauncher main, GameEntry portableEntry) {
        super(true);
        this.portableEntry = portableEntry;
        if (portableEntry != null) {
            this.entry = portableEntry;
            this.portableConfig = portableEntry.getConfig();
            if (this.portableConfig.userfolder) {
                this.checkConfig(true);
            }
        }
    }

    @Override
    public void init() {
        DesktopFactory.InitVideoModes();
        this.setLayout(new MigLayout("", "[left][grow]", "[][][][][][][][]"));
        this.add((Component)new JLabel("Resolution:"), "cell 0 0");
        this.comboResolution = new JComboBox();
        for (int i = 0; i < VideoMode.validmodes.size(); ++i) {
            this.comboResolution.addItem(VideoMode.strvmodes[i]);
        }
        this.comboResolution.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Graphics.DisplayMode mode = VideoMode.getmode(Settings.this.comboResolution.getSelectedIndex());
                    Settings.this.entry.getConfig().ScreenWidth = mode.width;
                    Settings.this.entry.getConfig().ScreenHeight = mode.height;
                    Settings.this.chckbxFullscreen.setEnabled(true);
                }
            }
        });
        this.add(this.comboResolution, "cell 1 0,growx");
        this.add((Component)new JLabel("Renderer:"), "cell 0 1");
        this.comboRenderer = new JComboBox();
        this.comboRenderer.addItem(Renderer.RenderType.Software.getName());
        this.comboRenderer.addItem(Renderer.RenderType.Polymost.getName());
        this.comboRenderer.addItem(Renderer.RenderType.PolyGDX.getName());
        this.comboRenderer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    switch (Settings.this.comboRenderer.getSelectedIndex()) {
                        case 0: {
                            Settings.this.entry.getConfig().renderType = Renderer.RenderType.Software;
                            break;
                        }
                        case 1: {
                            Settings.this.entry.getConfig().renderType = Renderer.RenderType.Polymost;
                            break;
                        }
                        case 2: {
                            Settings.this.entry.getConfig().renderType = Renderer.RenderType.PolyGDX;
                        }
                    }
                }
            }
        });
        this.add(this.comboRenderer, "cell 1 1,growx");
        this.chckbxFullscreen = new JCheckBox("Fullscreen");
        this.chckbxFullscreen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Settings.this.entry.getConfig().fullscreen = e.getStateChange() == 1 ? 1 : 0;
            }
        });
        this.add((Component)this.chckbxFullscreen, "flowx,cell 1 2,alignx right");
        this.chckbxBorderless = new JCheckBox("Borderless");
        this.chckbxBorderless.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Settings.this.entry.getConfig().borderless = e.getStateChange() == 1;
            }
        });
        this.add((Component)this.chckbxBorderless, "cell 1 2,alignx right");
        this.add((Component)new JLabel("Sound:"), "cell 0 3");
        this.comboSound = new JComboBox();
        ArrayList<String> names = new ArrayList<String>();
        BuildAudio.getDeviceslList(BuildAudio.Driver.Sound, names);
        for (int i = 0; i < names.size(); ++i) {
            if (((String)names.get(i)).equals("Dummy sound")) {
                this.comboSound.addItem("None");
                continue;
            }
            this.comboSound.addItem((String)names.get(i));
        }
        this.comboSound.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Settings.this.entry.getConfig().snddrv = Settings.this.comboSound.getSelectedIndex();
                }
            }
        });
        this.add(this.comboSound, "cell 1 3,growx");
        this.add((Component)new JLabel("Midi:"), "cell 0 4");
        this.comboMidi = new JComboBox();
        this.comboMidi.addItem("None");
        List<MidiDevice> devices = MidiMusicModule.getDevices();
        for (int i = 0; i < devices.size(); ++i) {
            String name = devices.get(i).getDeviceInfo().getName();
            this.comboMidi.addItem(name);
        }
        this.comboMidi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int midiDevice = Settings.this.comboMidi.getSelectedIndex();
                    if (midiDevice != 0) {
                        Settings.this.entry.getConfig().midiSynth = midiDevice - 1;
                        Settings.this.entry.getConfig().middrv = 1;
                    } else {
                        Settings.this.entry.getConfig().midiSynth = 1;
                        Settings.this.entry.getConfig().middrv = 0;
                    }
                }
            }
        });
        this.add(this.comboMidi, "cell 1 4,growx");
        this.add((Component)new JLabel("SoundFont:"), "cell 0 5");
        this.Soundbox = new JTextField();
        this.Soundbox.setToolTipText("Path to soundbank file");
        this.Soundbox.setEditable(false);
        this.add((Component)this.Soundbox, "flowx,cell 1 5,growx");
        JButton browseSoundbox = new JButton("...");
        browseSoundbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                Settings.this.Soundbox.setText("");
                Settings.this.entry.getConfig().soundBank = null;
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.setCurrentDirectory(new File(GameEntry.getDirPath()));
                fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("SoundFont bank (*.sf2)", "sf2"));
                fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Downloadable Sounds bank (*.dls)", "dls"));
                int returnVal = fileChooser.showOpenDialog(null);
                if (returnVal == 0 && (file = fileChooser.getSelectedFile()) != null) {
                    Settings.this.Soundbox.setText(file.getAbsolutePath());
                    Settings.this.entry.getConfig().soundBank = file;
                }
            }
        });
        this.add((Component)browseSoundbox, "cell 1 5");
        JButton clearSoundbox = new JButton("x");
        clearSoundbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settings.this.Soundbox.setText("");
                Settings.this.entry.getConfig().soundBank = null;
            }
        });
        this.add((Component)clearSoundbox, "cell 1 5");
        this.btnOpenFolder = new JButton("Open folder...");
        this.btnOpenFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    File file = new File(Settings.this.entry.getConfig().cfgPath);
                    Desktop desktop = Desktop.getDesktop();
                    desktop.open(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.add((Component)this.btnOpenFolder, "flowx,cell 0 6 2 1,alignx left");
        this.chckbxUseHomeFolder = new JCheckBox("Use \"home\" directory");
        this.chckbxUseHomeFolder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Settings.this.checkConfig(e.getStateChange() == 1);
                Settings.this.update();
            }
        });
        this.add((Component)this.chckbxUseHomeFolder, "cell 0 6 2 1");
        Box settingsBox = Box.createVerticalBox();
        this.chckbxEnableAutoloadFolder = new JCheckBox("Enable \"autoload\" folder");
        this.chckbxEnableAutoloadFolder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Settings.this.entry.getConfig().autoloadFolder = e.getStateChange() == 1;
            }
        });
        settingsBox.add(this.chckbxEnableAutoloadFolder);
        this.chckbxCheckForUpdates = new JCheckBox("Check for updates on startup");
        this.chckbxCheckForUpdates.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Settings.this.entry.getConfig().checkVersion = e.getStateChange() == 1;
            }
        });
        settingsBox.add(this.chckbxCheckForUpdates);
        this.chckbxAlwaysShowThis = new JCheckBox("Always show this window at startup");
        this.chckbxAlwaysShowThis.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Settings.this.entry.getConfig().startup = e.getStateChange() == 1;
            }
        });
        settingsBox.add(this.chckbxAlwaysShowThis);
        this.add((Component)settingsBox, "cell 0 7 2 1");
    }

    public void checkConfig(boolean userHome) {
        if (this.portableEntry != null && this.portableEntry == this.entry) {
            if (this.portableConfig.userfolder != userHome) {
                this.portableConfig.userfolder = userHome;
                this.portableConfig.saveConfig(new Compat(null, null), this.portableConfig.path);
            }
            if (userHome) {
                BuildConfig cfg = this.portableEntry.buildConfig(this.portableEntry.getHomePath());
                cfg.userfolder = true;
            } else {
                this.portableEntry.setConfig(this.portableConfig);
            }
        }
    }

    @Override
    public void update() {
        BuildConfig cfg = this.entry.getConfig();
        int xdim = cfg.ScreenWidth;
        int ydim = cfg.ScreenHeight;
        int index = VideoMode.getmodeindex(xdim, ydim);
        if (index == -1) {
            this.comboResolution.setEditable(true);
            try {
                this.chckbxFullscreen.setEnabled(false);
                this.comboResolution.setSelectedItem(xdim + " x " + ydim + " 32bpp");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.comboResolution.setEditable(false);
        } else {
            this.comboResolution.setSelectedIndex(index);
            this.chckbxFullscreen.setEnabled(true);
        }
        if (cfg.renderType == Renderer.RenderType.Software) {
            this.comboRenderer.setSelectedIndex(0);
        } else if (cfg.renderType == Renderer.RenderType.Polymost) {
            this.comboRenderer.setSelectedIndex(1);
        } else if (cfg.renderType == Renderer.RenderType.PolyGDX) {
            this.comboRenderer.setSelectedIndex(2);
        } else {
            cfg.renderType = Renderer.RenderType.Software;
            this.comboRenderer.setSelectedIndex(0);
        }
        this.chckbxFullscreen.setSelected(cfg.fullscreen == 1);
        if (cfg.snddrv >= 0 && cfg.snddrv < this.comboSound.getItemCount()) {
            this.comboSound.setSelectedIndex(cfg.snddrv);
        } else {
            this.comboSound.setSelectedIndex(0);
        }
        if (cfg.middrv != 0) {
            if (cfg.midiSynth + 1 >= this.comboMidi.getItemCount()) {
                cfg.midiSynth = 0;
            }
            this.comboMidi.setSelectedIndex(cfg.midiSynth + 1);
        } else {
            this.comboMidi.setSelectedIndex(0);
        }
        this.chckbxEnableAutoloadFolder.setSelected(cfg.autoloadFolder);
        this.chckbxCheckForUpdates.setSelected(cfg.checkVersion);
        boolean canUseHomeFolder = this.portableEntry != null && this.portableEntry == this.entry;
        this.chckbxUseHomeFolder.setEnabled(canUseHomeFolder);
        this.chckbxUseHomeFolder.setSelected(this.portableEntry == null || canUseHomeFolder && this.portableConfig.userfolder);
        this.btnOpenFolder.setEnabled(!canUseHomeFolder || this.portableConfig.userfolder);
        if (!this.btnOpenFolder.isEnabled()) {
            this.btnOpenFolder.setText("Portable mode");
        } else {
            this.btnOpenFolder.setText("Open folder...");
        }
        this.chckbxAlwaysShowThis.setEnabled(this.portableEntry != null);
        this.chckbxAlwaysShowThis.setSelected(cfg.startup);
        this.chckbxBorderless.setSelected(cfg.borderless);
        if (cfg.soundBank != null) {
            this.Soundbox.setText(cfg.soundBank.getAbsolutePath());
        } else {
            this.Soundbox.setText("");
        }
    }

    public void setEntry(GameEntry entry) {
        this.entry = entry;
    }
}

