/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.GameEntries;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import ru.m210projects.Blood.Config;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Launcher.desktop.CheckFiles;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.GameEntries.ResFile;
import ru.m210projects.Launcher.desktop.Main;

public abstract class BloodEntry
extends GameEntry {
    public boolean isDemo = false;

    public BloodEntry() {
        super("BloodGDX", Main.appversion);
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headerblood.png");
    }

    @Override
    public URL getIcon16() {
        return this.getClass().getResource("/Games/Blood/blood16.png");
    }

    @Override
    public String[] getIcons() {
        String[] icons = new String[]{"Games/Blood/blood16.png", "Games/Blood/blood32.png", "Games/Blood/blood128.png"};
        return icons;
    }

    @Override
    public String getResourceName() {
        return "Blood";
    }

    @Override
    public ResFile[] getResourceFiles() {
        ResFile[] resources = new ResFile[]{new ResFile("blood.ini"), new ResFile("blood.rff"), new ResFile("sounds.rff"), new ResFile("tiles000.art"), new ResFile("tables.dat"), new ResFile("surface.dat")};
        return resources;
    }

    public ResFile[] getDemoResource() {
        ResFile[] resources = new ResFile[]{new ResFile("blood.ini"), new ResFile("blood.rff"), new ResFile("sounds.rff"), new ResFile("share000.art"), new ResFile("tables.dat"), new ResFile("surface.dat")};
        return resources;
    }

    @Override
    public CheckFiles checkResources(String path, boolean errorMessage) {
        int i;
        File directory = new File(path);
        File[] fList = directory.listFiles();
        if (fList == null) {
            return new CheckFiles(false, null);
        }
        HashMap<String, File> filesMap = new HashMap<String, File>();
        for (File file : fList) {
            filesMap.put(Strhandler.toLowerCase(file.getName()), file);
        }
        String missingFiles = "<html>";
        this.isDemo = false;
        boolean found = true;
        ResFile[] resources = this.getResourceFiles();
        for (i = 0; i < resources.length; ++i) {
            if (filesMap.get(resources[i].name) != null) continue;
            found = false;
            if (errorMessage) {
                Console.Println(this.appname + " error: " + resources[i].name + " is missing!");
            }
            missingFiles = missingFiles + resources[i].name.toUpperCase() + " is missing<br>";
        }
        if (found) {
            return new CheckFiles(true, null);
        }
        if (errorMessage) {
            Console.Println(this.appname + ": trying to find demo version");
        }
        found = true;
        this.isDemo = true;
        resources = this.getDemoResource();
        for (i = 0; i < resources.length; ++i) {
            if (filesMap.get(resources[i].name) != null) continue;
            found = false;
            if (!errorMessage) continue;
            Console.Println(this.appname + " error: " + resources[i].name + " is missing!");
        }
        if (found) {
            return new CheckFiles(true, null);
        }
        return new CheckFiles(false, missingFiles + "</html>");
    }

    @Override
    public BuildConfig buildConfig(String path) {
        this.currentConfig = new Config(path, this.appname + ".ini");
        return this.currentConfig;
    }

    @Override
    public BuildGame getGame(String[] args) {
        if (this.isDemo) {
            Console.Println("Demo version detected");
        }
        return new ru.m210projects.Blood.Main(this.getConfig(), this.appname, this.sversion, this.isDemo);
    }
}

