/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.GameEntries;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Duke3D.Config;
import ru.m210projects.Launcher.desktop.CheckFiles;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.GameEntries.ResFile;
import ru.m210projects.Launcher.desktop.Main;

public abstract class NamEntry
extends GameEntry {
    public NamEntry() {
        super("NamGDX", Main.appversion);
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headernam.png");
    }

    @Override
    public URL getIcon16() {
        return this.getClass().getResource("/Games/Nam/nam16.png");
    }

    @Override
    public String getResourceName() {
        return "NAM";
    }

    @Override
    public ResFile[] getResourceFiles() {
        ResFile[] resources = new ResFile[]{new ResFile("nam.grp"), new ResFile("game.con")};
        return resources;
    }

    public ResFile[] getNapalmFiles() {
        ResFile[] resources = new ResFile[]{new ResFile("napalm.grp"), new ResFile("game.con")};
        return resources;
    }

    @Override
    public CheckFiles checkResources(String path, boolean errorMessage) {
        int i;
        File directory = new File(path);
        File[] fList = directory.listFiles();
        if (fList == null) {
            return new CheckFiles(false, null);
        }
        HashMap<String, File> filesMap = new HashMap<String, File>();
        for (File file : fList) {
            filesMap.put(Strhandler.toLowerCase(file.getName()), file);
        }
        ResFile[] resources = this.getResourceFiles();
        String missingFiles = "<html>";
        boolean found = true;
        for (i = 0; i < resources.length; ++i) {
            if (filesMap.get(resources[i].name) != null) continue;
            found = false;
            if (errorMessage) {
                Console.Println(this.appname + " error: " + resources[i].name + " is missing!");
            }
            missingFiles = missingFiles + resources[i].name.toUpperCase() + " is missing<br>";
        }
        if (found) {
            return new CheckFiles(true, null);
        }
        if (errorMessage) {
            Console.Println(this.appname + ": trying to find another version");
        }
        resources = this.getNapalmFiles();
        found = true;
        for (i = 0; i < resources.length; ++i) {
            if (filesMap.get(resources[i].name) != null) continue;
            found = false;
            if (errorMessage) {
                Console.Println(this.appname + " error: " + resources[i].name + " is missing!");
            }
            missingFiles = missingFiles + resources[i].name.toUpperCase() + " is missing<br>";
        }
        if (found) {
            return new CheckFiles(true, null);
        }
        return new CheckFiles(false, missingFiles + "</html>");
    }

    @Override
    public String[] getIcons() {
        String[] icons = new String[]{"Games/Nam/nam16.png", "Games/Nam/nam32.png", "Games/Nam/nam128.png"};
        return icons;
    }

    @Override
    public BuildConfig buildConfig(String path) {
        this.currentConfig = new Config(path, this.appname + ".ini");
        return this.currentConfig;
    }

    @Override
    public BuildGame getGame(String[] args) {
        return new ru.m210projects.Duke3D.Main(this.getConfig(), this.appname, this.sversion, 1, true);
    }
}

