/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.Sprites;

public class Enemy {
    public static int MoveCreature(int nSprite) {
        return Main.engine.movesprite((short)nSprite, Engine.sprite[nSprite].xvel << 8, Engine.sprite[nSprite].yvel << 8, Engine.sprite[nSprite].zvel, 15360, -5120, 0);
    }

    public static int MoveCreatureWithCaution(int nSprite) {
        int x = Engine.sprite[nSprite].x;
        int y = Engine.sprite[nSprite].y;
        int z = Engine.sprite[nSprite].z;
        short nOldSector = Engine.sprite[nSprite].sectnum;
        int hitMove = Enemy.MoveCreature(nSprite);
        short nSector = Engine.sprite[nSprite].sectnum;
        if (nSector != nOldSector && (Pragmas.klabs(Engine.sector[nOldSector].floorz - Engine.sector[nSector].floorz) > 15360 || (Globals.SectFlag[nSector] & 0x2000) != 0 || Globals.SectBelow[nSector] > -1 && Globals.SectFlag[Globals.SectBelow[nSector]] != 0 || Globals.SectDamage[nSector] != 0)) {
            Engine.sprite[nSprite].x = x;
            Engine.sprite[nSprite].y = y;
            Engine.sprite[nSprite].z = z;
            Main.engine.mychangespritesect((short)nSprite, nOldSector);
            Engine.sprite[nSprite].ang = (short)(Engine.sprite[nSprite].ang + 256 & 0x7FF);
            Engine.sprite[nSprite].xvel = (short)(Engine.sintable[Engine.sprite[nSprite].ang + 512 & 0x7FF] >> 2);
            Engine.sprite[nSprite].yvel = (short)(Engine.sintable[Engine.sprite[nSprite].ang & 0x7FF] >> 2);
            return 0;
        }
        return hitMove;
    }

    public static void DropMagic(int nSprite) {
        if (Globals.lFinaleStart == 0 && --Globals.nMagicCount <= 0) {
            int v1 = Anim.BuildAnim(-1, 64, 0, Engine.sprite[nSprite].x, Engine.sprite[nSprite].y, Engine.sprite[nSprite].z, Engine.sprite[nSprite].sectnum, 48, 4);
            int spr = Anim.GetAnimSprite(v1);
            Engine.sprite[spr].owner = (short)v1;
            Light.AddFlash(Engine.sprite[spr].sectnum, Engine.sprite[spr].x, Engine.sprite[spr].y, Engine.sprite[spr].z, 128);
            Main.engine.changespritestat((short)spr, 950);
            Globals.nMagicCount = Random.RandomSize(2);
        }
    }

    public static int UpdateEnemy(int nTarget) {
        if (nTarget >= 0) {
            if ((Engine.sprite[nTarget].cstat & 0x101) == 0) {
                nTarget = -1;
            }
            return nTarget;
        }
        return -1;
    }

    public static int PlotCourseToSprite(int a1, int a2) {
        if (a1 >= 0 && a2 >= 0) {
            SPRITE v3 = Engine.sprite[a1];
            SPRITE v4 = Engine.sprite[a2];
            int dx = v4.x - v3.x;
            int dy = v4.y - v3.y;
            v3.ang = Main.engine.GetMyAngle(dx, dy);
            return Main.engine.ksqrt(dx * dx + dy * dy);
        }
        return -1;
    }

    public static int FindPlayer(int nDude, int dist) {
        boolean bCourse = true;
        if (nDude < 0) {
            nDude = -nDude;
            bCourse = false;
        }
        if (dist < 0) {
            dist = 100;
        }
        dist <<= 8;
        SPRITE pDude = Engine.sprite[nDude];
        int dz = pDude.z - Sprites.GetSpriteHeight(nDude);
        for (int i = 0; i < Mmulti.numplayers; ++i) {
            SPRITE pPlayer = Engine.sprite[Globals.PlayerList[i].spriteId];
            if ((pPlayer.cstat & 0x101) == 0 || (pPlayer.cstat & 0x8000) != 0 || Pragmas.klabs(pPlayer.x - pDude.x) >= dist || Pragmas.klabs(pPlayer.y - pDude.y) >= dist || !Main.engine.cansee(pPlayer.x, pPlayer.y, pPlayer.z - 7680, pPlayer.sectnum, pDude.x, pDude.y, dz, pDude.sectnum)) continue;
            if (bCourse) {
                Enemy.PlotCourseToSprite(nDude, Globals.PlayerList[i].spriteId);
            }
            return Globals.PlayerList[i].spriteId;
        }
        return -1;
    }

    public static class EnemyStruct {
        public static final int size = 16;
        public short nHealth;
        public short nSeq;
        public short nState;
        public short nSprite;
        public short nTarget;
        public short field_A;
        public short field_C;
        public short nFunc = (short)-1;

        public void save(ByteBuffer bb) {
            bb.putShort(this.nHealth);
            bb.putShort(this.nSeq);
            bb.putShort(this.nState);
            bb.putShort(this.nSprite);
            bb.putShort(this.nTarget);
            bb.putShort(this.field_A);
            bb.putShort(this.field_C);
            bb.putShort(this.nFunc);
        }

        public void load(Resource bb) {
            this.nHealth = bb.readShort();
            this.nSeq = bb.readShort();
            this.nState = bb.readShort();
            this.nSprite = bb.readShort();
            this.nTarget = bb.readShort();
            this.field_A = bb.readShort();
            this.field_C = bb.readShort();
            this.nFunc = bb.readShort();
        }

        public EnemyStruct copy(EnemyStruct src) {
            this.nHealth = src.nHealth;
            this.nSeq = src.nSeq;
            this.nState = src.nState;
            this.nSprite = src.nSprite;
            this.nTarget = src.nTarget;
            this.field_A = src.field_A;
            this.field_C = src.field_C;
            this.nFunc = src.nFunc;
            return this;
        }
    }
}

