/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class LavaDude {
    public static final int MAX_LAVAS = 20;
    private static int LavaCount;
    private static final short[][] ActionSeq_X_6;
    private static Enemy.EnemyStruct[] LavaList;

    public static void InitLava() {
        LavaCount = 0;
    }

    public static ByteBuffer saveLava() {
        ByteBuffer bb = ByteBuffer.allocate(LavaCount * 16 + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)LavaCount);
        for (int i = 0; i < LavaCount; ++i) {
            LavaList[i].save(bb);
        }
        return bb;
    }

    public static void loadLava(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.LavaCount = bb.readShort().shortValue();
            for (int i = 0; i < loader.LavaCount; ++i) {
                if (loader.LavaList[i] == null) {
                    loader.LavaList[i] = new Enemy.EnemyStruct();
                }
                loader.LavaList[i].load(bb);
            }
        } else {
            LavaCount = loader.LavaCount;
            for (int i = 0; i < loader.LavaCount; ++i) {
                if (LavaList[i] == null) {
                    LavaDude.LavaList[i] = new Enemy.EnemyStruct();
                }
                LavaList[i].copy(loader.LavaList[i]);
            }
        }
    }

    public static void BuildLava(int spr, int x, int y, int z, int sectnum, int ang, int channel) {
        int count;
        if ((count = LavaCount++) >= 20) {
            return;
        }
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)sectnum, 118);
        } else {
            x = Engine.sprite[spr].x;
            y = Engine.sprite[spr].y;
            sectnum = Engine.sprite[spr].sectnum;
            ang = Engine.sprite[spr].ang;
            Main.engine.changespritestat((short)spr, 118);
        }
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        Engine.sprite[spr].x = x;
        Engine.sprite[spr].y = y;
        Engine.sprite[spr].z = Engine.sector[sectnum].floorz;
        Engine.sprite[spr].cstat = Short.MIN_VALUE;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].picnum = Seq.GetSeqPicnum(42, ActionSeq_X_6[3][0], 0);
        Engine.sprite[spr].pal = Engine.sector[Engine.sprite[spr].sectnum].ceilingpal;
        Engine.sprite[spr].clipdist = 127;
        Engine.sprite[spr].ang = (short)ang;
        Engine.sprite[spr].xrepeat = (short)200;
        Engine.sprite[spr].yrepeat = (short)200;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        if (LavaList[count] == null) {
            LavaDude.LavaList[count] = new Enemy.EnemyStruct();
        }
        LavaDude.LavaList[count].nState = 0;
        LavaDude.LavaList[count].nHealth = (short)4000;
        LavaDude.LavaList[count].nSprite = (short)spr;
        LavaDude.LavaList[count].nTarget = (short)-1;
        LavaDude.LavaList[count].field_C = (short)channel;
        LavaDude.LavaList[count].nSeq = 0;
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x150000 | count);
        LavaDude.LavaList[count].nFunc = (short)RunList.AddRunRec(RunList.NewRun, 0x150000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncLava(int a1, int nDamage, int RunPtr) {
        short nLava = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nLava < 0 || nLava >= 20) {
            Main.game.ThrowError("Lava>=0 && Lava<MAX_LAVAS");
            return;
        }
        Enemy.EnemyStruct pLava = LavaList[nLava];
        short nSprite = pLava.nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nState = pLava.nState;
        int nTarget = pLava.nTarget;
        short nObject = (short)(a1 & 0xFFFF);
        boolean v57 = false;
        switch (a1 & 0x7F0000) {
            case 131072: {
                int nSeq = ActionSeq_X_6[nState][0] + Seq.SeqOffsets[42];
                pSprite.picnum = (short)Seq.GetSeqPicnum2(nSeq, pLava.nSeq);
                if (nState != 0) {
                    Seq.MoveSequence(nSprite, nSeq, pLava.nSeq);
                    pLava.nSeq = (short)(pLava.nSeq + 1);
                    if (pLava.nSeq >= Seq.SeqSize[nSeq]) {
                        pLava.nSeq = 0;
                        v57 = true;
                    }
                }
                short nFlags = Seq.FrameFlag[pLava.nSeq + Seq.SeqBase[nSeq]];
                if (nTarget >= 0 && nState < 4 && ((Engine.sprite[nTarget].cstat & 0x101) == 0 || Engine.sprite[nTarget].sectnum >= 1024)) {
                    nTarget = -1;
                    pLava.nTarget = (short)-1;
                }
                switch (nState) {
                    case 0: {
                        if ((nLava & 0x1F) == (Globals.totalmoves & 0x1F)) {
                            if (nTarget < 0) {
                                nTarget = Enemy.FindPlayer(nSprite, 76800);
                            }
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 0x7FF];
                            pSprite.yvel = Engine.sintable[pSprite.ang & 0x7FF];
                            if (nTarget >= 0 && Random.RandomSize(1) == 0) {
                                pLava.nTarget = (short)nTarget;
                                pLava.nState = (short)2;
                                pSprite.cstat = (short)257;
                                pLava.nSeq = 0;
                                break;
                            }
                        }
                        int sx = pSprite.x;
                        int sy = pSprite.y;
                        int sz = pSprite.z;
                        short ssec = pSprite.sectnum;
                        int hitMove = Main.engine.movesprite(nSprite, pSprite.xvel << 8, pSprite.yvel << 8, 0, 0, 0, 0);
                        if (ssec == pSprite.sectnum) {
                            if (hitMove == 0) break;
                            switch (hitMove & 0xC000) {
                                case 32768: {
                                    pSprite.ang = (short)(pSprite.ang + ((Random.RandomWord() & 0x300) + 1024) & 0x7FF);
                                    pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 0x7FF];
                                    pSprite.yvel = Engine.sintable[pSprite.ang & 0x7FF];
                                    pSprite.pal = 1;
                                    return;
                                }
                                case 49152: {
                                    if ((hitMove & 0x3FFF) == nTarget && Sprites.AngleDiff(pSprite.ang, Main.engine.getangle(Engine.sprite[nTarget].x - pSprite.x, Engine.sprite[nTarget].y - pSprite.y)) < 64) {
                                        pLava.nState = (short)2;
                                        pSprite.cstat = (short)257;
                                        pLava.nSeq = 0;
                                    }
                                    pSprite.pal = 1;
                                    return;
                                }
                            }
                        } else {
                            Main.engine.changespritesect(nSprite, ssec);
                            pSprite.x = sx;
                            pSprite.y = sy;
                            pSprite.z = sz;
                        }
                        pSprite.ang = (short)(pSprite.ang + ((Random.RandomWord() & 0x300) + 1024) & 0x7FF);
                        pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 0x7FF];
                        pSprite.yvel = Engine.sintable[pSprite.ang & 0x7FF];
                        break;
                    }
                    case 2: {
                        if (!v57) break;
                        pLava.nState = (short)3;
                        pLava.nSeq = 0;
                        Enemy.PlotCourseToSprite(nSprite, nTarget);
                        pSprite.cstat = (short)(pSprite.cstat | 0x101);
                        break;
                    }
                    case 3: {
                        if ((nFlags & 0x80) != 0 && nTarget > -1) {
                            Sprites.GetUpAngle(nSprite, -64000, nTarget, -(Sprites.GetSpriteHeight(nSprite) >> 1));
                            Bullet.BuildBullet(nSprite, 10, Engine.sintable[pSprite.ang + 512 & 0x7FF] << 8, Engine.sintable[pSprite.ang & 0x7FF] << 8, -1, pSprite.ang, nTarget + 10000, 1);
                            break;
                        }
                        if (!v57) break;
                        Enemy.PlotCourseToSprite(nSprite, nTarget);
                        pLava.nState = (short)7;
                        pLava.nSeq = 0;
                        break;
                    }
                    case 5: {
                        if ((nFlags & 0x40) != 0) {
                            Sound.D3PlayFX(Sound.StaticSound[26], LavaDude.BuildLavaLimb(nSprite, pLava.nSeq, 64000));
                        }
                        if (pLava.nSeq != 0) {
                            if ((nFlags & 0x80) == 0) break;
                            for (int i = 0; i < 20; ++i) {
                                LavaDude.BuildLavaLimb(nSprite, i, 64000);
                            }
                            RunList.ChangeChannel(pLava.field_C, 1);
                            break;
                        }
                        for (int i = 0; i < 20; ++i) {
                            LavaDude.BuildLavaLimb(nSprite, i, 256);
                        }
                        RunList.DoSubRunRec(pSprite.owner);
                        RunList.FreeRun(pSprite.lotag - 1);
                        RunList.SubRunRec(pLava.nFunc);
                        Main.engine.mydeletesprite(nSprite);
                        break;
                    }
                    case 4: {
                        if (!v57) break;
                        pLava.nState = (short)7;
                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                        break;
                    }
                    case 7: {
                        if (!v57) break;
                        pLava.nState = (short)8;
                        pLava.nSeq = 0;
                        break;
                    }
                    case 8: {
                        if (!v57) break;
                        pLava.nState = 0;
                        pLava.nSeq = 0;
                        pSprite.cstat = Short.MIN_VALUE;
                    }
                }
                pSprite.pal = 1;
                return;
            }
            case 589824: {
                Seq.PlotSequence(nObject, ActionSeq_X_6[nState][0] + Seq.SeqOffsets[42], pLava.nSeq, ActionSeq_X_6[nState][1]);
                Engine.tsprite[nObject].owner = (short)-1;
                return;
            }
            case 524288: {
                if (nDamage != 0 && pLava.nHealth > 0) {
                    pLava.nHealth = (short)(pLava.nHealth - nDamage);
                    if (pLava.nHealth <= 0) {
                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                        pLava.nHealth = 0;
                        pLava.nState = (short)5;
                        pLava.nSeq = 0;
                        --Globals.nCreaturesLeft;
                    } else {
                        if (nTarget >= 0 && Engine.sprite[nTarget].statnum < 199) {
                            pLava.nTarget = (short)nTarget;
                        }
                        if (nState == 3 && Random.RandomSize(2) == 0) {
                            pLava.nState = (short)4;
                            pLava.nSeq = 0;
                            pSprite.cstat = 0;
                        }
                        LavaDude.BuildLavaLimb(nSprite, Globals.totalmoves, 64000);
                    }
                }
                return;
            }
        }
    }

    public static int BuildLavaLimb(int nSprite, int a2, int a3) {
        short spr = Main.engine.insertsprite(Engine.sprite[nSprite].sectnum, 118);
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return -1;
        }
        Engine.sprite[spr].x = Engine.sprite[nSprite].x;
        Engine.sprite[spr].y = Engine.sprite[nSprite].y;
        Engine.sprite[spr].z = Engine.sprite[nSprite].z - Random.RandomLong() % a3;
        Engine.sprite[spr].cstat = 0;
        Engine.sprite[spr].shade = (byte)-127;
        Engine.sprite[spr].pal = 1;
        Engine.sprite[spr].xvel = (short)(Random.RandomSize(5) - 16 << 8);
        Engine.sprite[spr].yvel = (short)(Random.RandomSize(5) - 16 << 8);
        Engine.sprite[spr].zvel = (short)(2560 - (Random.RandomSize(5) << 8));
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].xrepeat = (short)90;
        Engine.sprite[spr].yrepeat = (short)90;
        Engine.sprite[spr].picnum = (short)((a2 & 3) % 3);
        Engine.sprite[spr].clipdist = 0;
        Engine.sprite[spr].extra = (short)-1;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x160000 | spr);
        Engine.sprite[spr].hitag = (short)RunList.AddRunRec(RunList.NewRun, 0x160000 | spr);
        return spr;
    }

    public static void FuncLavaLimb(int a1, int a2, int RunPtr) {
        short spr = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        SPRITE pSprite = Engine.sprite[spr];
        short nObject = (short)(a1 & 0xFFFF);
        switch (a1 & 0x7F0000) {
            case 131072: {
                pSprite.shade = (byte)(pSprite.shade + 3);
                if (Main.engine.movesprite(spr, pSprite.xvel << 12, pSprite.yvel << 12, pSprite.zvel, 2560, -2560, 1) != 0 || pSprite.shade > 100) {
                    pSprite.xvel = 0;
                    pSprite.yvel = 0;
                    pSprite.zvel = 0;
                    RunList.DoSubRunRec(pSprite.owner);
                    RunList.FreeRun(pSprite.lotag - 1);
                    RunList.SubRunRec(pSprite.hitag);
                    Main.engine.mydeletesprite(spr);
                }
                return;
            }
            case 589824: {
                Seq.PlotSequence(nObject, pSprite.picnum + Seq.SeqOffsets[42] + 30, 0, 1);
                return;
            }
        }
    }

    static {
        ActionSeq_X_6 = new short[][]{{0, 1}, {0, 1}, {1, 0}, {10, 0}, {19, 0}, {28, 1}, {29, 1}, {33, 0}, {42, 1}};
        LavaList = new Enemy.EnemyStruct[20];
    }
}

