/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Mummy {
    public static final int MAX_MUMMIES = 150;
    private static final short[][] ActionSeq_X_4 = new short[][]{{8, 0}, {0, 0}, {16, 0}, {24, 0}, {32, 1}, {40, 1}, {48, 1}, {50, 0}};
    private static int MummyCount;
    private static Enemy.EnemyStruct[] MummyList;

    public static void InitMummy() {
        MummyCount = 0;
    }

    public static ByteBuffer saveMummy() {
        ByteBuffer bb = ByteBuffer.allocate(MummyCount * 16 + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)MummyCount);
        for (int i = 0; i < MummyCount; ++i) {
            MummyList[i].save(bb);
        }
        return bb;
    }

    public static void loadMummy(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.MummyCount = bb.readShort().shortValue();
            for (int i = 0; i < loader.MummyCount; ++i) {
                if (loader.MummyList[i] == null) {
                    loader.MummyList[i] = new Enemy.EnemyStruct();
                }
                loader.MummyList[i].load(bb);
            }
        } else {
            MummyCount = loader.MummyCount;
            for (int i = 0; i < loader.MummyCount; ++i) {
                if (MummyList[i] == null) {
                    Mummy.MummyList[i] = new Enemy.EnemyStruct();
                }
                MummyList[i].copy(loader.MummyList[i]);
            }
        }
    }

    public static void BuildMummy(int spr, int x, int y, int z, int sectnum, int ang) {
        int count;
        if ((count = MummyCount++) >= 150) {
            return;
        }
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)sectnum, 102);
        } else {
            y = Engine.sprite[spr].y;
            z = Engine.sprite[spr].z;
            x = Engine.sprite[spr].x;
            Main.engine.changespritestat((short)spr, 102);
            ang = Engine.sprite[spr].ang;
        }
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        Engine.sprite[spr].x = x;
        Engine.sprite[spr].y = y;
        Engine.sprite[spr].z = z;
        Engine.sprite[spr].cstat = (short)257;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].clipdist = 32;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].xrepeat = (short)42;
        Engine.sprite[spr].yrepeat = (short)42;
        Engine.sprite[spr].pal = Engine.sector[Engine.sprite[spr].sectnum].ceilingpal;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].ang = (short)ang;
        Engine.sprite[spr].picnum = 1;
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0xE0000 | count);
        if (MummyList[count] == null) {
            Mummy.MummyList[count] = new Enemy.EnemyStruct();
        }
        Mummy.MummyList[count].nHealth = (short)640;
        Mummy.MummyList[count].nSeq = 0;
        Mummy.MummyList[count].nState = 0;
        Mummy.MummyList[count].nSprite = (short)spr;
        Mummy.MummyList[count].nTarget = (short)-1;
        Mummy.MummyList[count].field_A = (short)count;
        Mummy.MummyList[count].field_C = 0;
        Mummy.MummyList[count].nFunc = (short)RunList.AddRunRec(RunList.NewRun, 0xE0000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncMummy(int a1, int a2, int RunPtr) {
        short nMummy = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nMummy < 0 || nMummy >= 150) {
            Main.game.ThrowError("Mummy>=0 && Mummy<MAX_MUMMIES");
            return;
        }
        short nSprite = Mummy.MummyList[nMummy].nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        int damage = a2;
        short plr = (short)(a1 & 0xFFFF);
        int nTarget = Enemy.UpdateEnemy(Mummy.MummyList[nMummy].nTarget);
        short nState = Mummy.MummyList[nMummy].nState;
        switch (a1 & 0x7F0000) {
            case 131072: {
                Sprites.Gravity(nSprite);
                int v10 = ActionSeq_X_4[nState][0] + Seq.SeqOffsets[10];
                short v13 = Mummy.MummyList[nMummy].nSeq;
                pSprite.picnum = (short)Seq.GetSeqPicnum2(v10, v13);
                short flags = Seq.FrameFlag[v13 + Seq.SeqBase[v10]];
                Seq.MoveSequence(nSprite, v10, v13);
                Mummy.MummyList[nMummy].nSeq = (short)(Mummy.MummyList[nMummy].nSeq + 1);
                boolean v18 = false;
                if (Mummy.MummyList[nMummy].nSeq >= Seq.SeqSize[v10]) {
                    Mummy.MummyList[nMummy].nSeq = 0;
                    v18 = true;
                }
                if (nTarget != -1 && nState < 4 && Engine.sprite[nTarget].cstat == 0 && nState != 0) {
                    Mummy.MummyList[nMummy].nState = 0;
                    Mummy.MummyList[nMummy].nSeq = 0;
                    pSprite.yvel = 0;
                    pSprite.xvel = 0;
                }
                int v17 = Enemy.MoveCreatureWithCaution(nSprite);
                switch (Mummy.MummyList[nMummy].nState) {
                    case 0: {
                        if ((Mummy.MummyList[nMummy].field_A & 0x1F) == (Globals.totalmoves & 0x1F)) {
                            pSprite.cstat = (short)257;
                            if (nTarget < 0 && (nTarget = Enemy.FindPlayer(nSprite, 100)) >= 0) {
                                Sound.D3PlayFX(Sound.StaticSound[7], nSprite);
                                Mummy.MummyList[nMummy].nSeq = 0;
                                Mummy.MummyList[nMummy].nTarget = (short)nTarget;
                                Mummy.MummyList[nMummy].nState = 1;
                                pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 2);
                                pSprite.yvel = (short)(Engine.sintable[pSprite.ang] >> 2);
                                Mummy.MummyList[nMummy].field_C = (short)90;
                            }
                        }
                        return;
                    }
                    case 1: {
                        short v20 = Mummy.MummyList[nMummy].field_C;
                        if (v20 > 0) {
                            Mummy.MummyList[nMummy].field_C = (short)(Mummy.MummyList[nMummy].field_C - 1);
                        }
                        if ((Globals.totalmoves & 0x1F) == (Mummy.MummyList[nMummy].field_A & 0x1F)) {
                            pSprite.cstat = (short)257;
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            if (Mummy.MummyList[nMummy].nState == 1 && Random.RandomBit() != 0) {
                                SPRITE pTarget;
                                SPRITE sPRITE = pTarget = nTarget != -1 ? Engine.sprite[nTarget] : null;
                                if (pTarget != null && Main.engine.cansee(pSprite.x, pSprite.y, pSprite.z - Sprites.GetSpriteHeight(nSprite), pSprite.sectnum, pTarget.x, pTarget.y, pTarget.z - Sprites.GetSpriteHeight(nTarget), pTarget.sectnum)) {
                                    Mummy.MummyList[nMummy].nState = (short)3;
                                    Mummy.MummyList[nMummy].nSeq = 0;
                                    pSprite.yvel = 0;
                                    pSprite.xvel = 0;
                                    return;
                                }
                            }
                        }
                        if (Mummy.MummyList[nMummy].nSeq == 0) {
                            pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 1);
                            pSprite.yvel = (short)(Engine.sintable[pSprite.ang & 0x7FF] >> 1);
                        }
                        if (pSprite.xvel != 0 && pSprite.yvel != 0) {
                            pSprite.xvel = pSprite.xvel > 0 ? (short)Gameutils.BClipLow(pSprite.xvel - 1024, 0) : (short)Gameutils.BClipHigh(pSprite.xvel + 1024, 0);
                            pSprite.yvel = pSprite.yvel > 0 ? (short)Gameutils.BClipLow(pSprite.yvel - 1024, 0) : (short)Gameutils.BClipHigh(pSprite.yvel + 1024, 0);
                        }
                        if (v17 != 0) {
                            switch (v17 & 0xC000) {
                                case 32768: {
                                    pSprite.ang = (short)(pSprite.ang + (Random.RandomWord() & 0x300) + 1024 & 0x7FF);
                                    pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 2);
                                    pSprite.yvel = (short)(Engine.sintable[pSprite.ang] >> 2);
                                    break;
                                }
                                case 49152: {
                                    if ((v17 & 0x3FFF) != nTarget || Sprites.AngleDiff(pSprite.ang, Main.engine.getangle(Engine.sprite[nTarget].x - pSprite.x, Engine.sprite[nTarget].y - pSprite.y)) >= 64) break;
                                    Mummy.MummyList[nMummy].nState = (short)2;
                                    Mummy.MummyList[nMummy].nSeq = 0;
                                    pSprite.yvel = 0;
                                    pSprite.xvel = 0;
                                }
                            }
                        }
                        return;
                    }
                    case 2: {
                        if (nTarget == -1) {
                            Mummy.MummyList[nMummy].nState = 0;
                        } else {
                            if (Enemy.PlotCourseToSprite(nSprite, nTarget) < 1024) {
                                if ((flags & 0x80) != 0) {
                                    Sprites.DamageEnemy(nTarget, nSprite, 5);
                                }
                                return;
                            }
                            Mummy.MummyList[nMummy].nState = 1;
                        }
                        Mummy.MummyList[nMummy].nSeq = 0;
                        return;
                    }
                    case 3: {
                        if (v18) {
                            Mummy.MummyList[nMummy].nSeq = 0;
                            Mummy.MummyList[nMummy].nState = 0;
                            Mummy.MummyList[nMummy].field_C = (short)100;
                            Mummy.MummyList[nMummy].nTarget = (short)-1;
                        } else if ((flags & 0x80) != 0) {
                            Object.SetQuake(nSprite, 100);
                            int nBullet = Bullet.BuildBullet(nSprite, 9, 0, 0, -15360, pSprite.ang, nTarget + 10000, 1);
                            Mummy.CheckMummyRevive(nMummy);
                            if (nBullet > -1 && Random.RandomSize(3) == 0) {
                                Bullet.SetBulletEnemy((short)(nBullet >> 16 & 0xFFFF), nTarget);
                                Engine.sprite[nBullet & 0xFFFF].pal = (short)5;
                            }
                        }
                        return;
                    }
                    case 4: {
                        if (v18) {
                            Mummy.MummyList[nMummy].nSeq = 0;
                            Mummy.MummyList[nMummy].nState = (short)5;
                        }
                        return;
                    }
                    case 5: {
                        Mummy.MummyList[nMummy].nSeq = 0;
                        return;
                    }
                    case 6: {
                        if (v18) {
                            Mummy.MummyList[nMummy].nState = 0;
                            pSprite.cstat = (short)257;
                            Mummy.MummyList[nMummy].nHealth = (short)300;
                            Mummy.MummyList[nMummy].nTarget = (short)-1;
                            ++Globals.nCreaturesLeft;
                        }
                        return;
                    }
                    case 7: {
                        if ((v17 & 0x20000) != 0) {
                            pSprite.xvel = (short)(pSprite.xvel >> 1);
                            pSprite.yvel = (short)(pSprite.yvel >> 1);
                        }
                        if (v18) {
                            pSprite.yvel = 0;
                            pSprite.xvel = 0;
                            Mummy.MummyList[nMummy].nState = 0;
                            Mummy.MummyList[nMummy].nSeq = 0;
                            pSprite.cstat = (short)257;
                            Mummy.MummyList[nMummy].nTarget = (short)-1;
                        }
                        return;
                    }
                }
                return;
            }
            case 589824: {
                Seq.PlotSequence(plr, ActionSeq_X_4[nState][0] + Seq.SeqOffsets[10], Mummy.MummyList[nMummy].nSeq, ActionSeq_X_4[nState][1]);
                return;
            }
            case 655360: {
                if (Mummy.MummyList[nMummy].nHealth <= 0) {
                    return;
                }
                damage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (damage != 0 && Mummy.MummyList[nMummy].nHealth > 0) {
                    Mummy.MummyList[nMummy].nHealth = (short)(Mummy.MummyList[nMummy].nHealth - damage);
                    if (Mummy.MummyList[nMummy].nHealth > 0) {
                        if (Random.RandomSize(2) == 0) {
                            Mummy.MummyList[nMummy].nState = (short)7;
                            Mummy.MummyList[nMummy].nSeq = 0;
                            pSprite.xvel = 0;
                            pSprite.yvel = 0;
                        }
                    } else {
                        Mummy.MummyList[nMummy].nHealth = 0;
                        pSprite.cstat = (short)(pSprite.cstat & 0xFEFE);
                        Enemy.DropMagic(nSprite);
                        Mummy.MummyList[nMummy].nSeq = 0;
                        Mummy.MummyList[nMummy].nState = (short)4;
                        pSprite.zvel = 0;
                        pSprite.yvel = 0;
                        pSprite.xvel = 0;
                        pSprite.z = Engine.sector[pSprite.sectnum].floorz;
                        --Globals.nCreaturesLeft;
                    }
                }
                return;
            }
        }
    }

    private static void CheckMummyRevive(int nMummy) {
        SPRITE pSprite = Engine.sprite[Mummy.MummyList[nMummy].nSprite];
        for (int i = 0; i < MummyCount; ++i) {
            Enemy.EnemyStruct pOther = MummyList[i];
            if (i == nMummy) continue;
            SPRITE v3 = Engine.sprite[pOther.nSprite];
            if (v3.statnum != 102 || pOther.nState != 5 || Pragmas.klabs(v3.x - pSprite.x) >> 8 > 20 || Pragmas.klabs(v3.y - pSprite.y) >> 8 > 20 || !Main.engine.cansee(pSprite.x, pSprite.y, pSprite.z - 8192, pSprite.sectnum, v3.x, v3.y, v3.z - 8192, v3.sectnum)) continue;
            v3.cstat = 0;
            Mummy.MummyList[i].nState = (short)6;
            Mummy.MummyList[i].nSeq = 0;
        }
    }

    static {
        MummyList = new Enemy.EnemyStruct[150];
    }
}

