/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Rex {
    public static final int MAX_REX = 50;
    private static int RexCount;
    private static Enemy.EnemyStruct[] RexList;
    private static short[] RexChan;
    private static final short[][] ActionSeq_X_8;

    public static void InitRexs() {
        RexCount = 50;
    }

    public static ByteBuffer saveRex() {
        int i;
        ByteBuffer bb = ByteBuffer.allocate((50 - RexCount) * 16 + 2 + 100);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)RexCount);
        for (i = RexCount; i < 50; ++i) {
            RexList[i].save(bb);
        }
        for (i = 0; i < 50; ++i) {
            bb.putShort(RexChan[i]);
        }
        return bb;
    }

    public static void loadRex(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i;
            for (i = loader.RexCount = (int)bb.readShort().shortValue(); i < 50; ++i) {
                if (loader.RexList[i] == null) {
                    loader.RexList[i] = new Enemy.EnemyStruct();
                }
                loader.RexList[i].load(bb);
            }
            for (i = 0; i < 50; ++i) {
                loader.RexChan[i] = bb.readShort();
            }
        } else {
            RexCount = loader.RexCount;
            for (int i = loader.RexCount; i < 50; ++i) {
                if (RexList[i] == null) {
                    Rex.RexList[i] = new Enemy.EnemyStruct();
                }
                RexList[i].copy(loader.RexList[i]);
            }
            System.arraycopy(loader.RexChan, 0, RexChan, 0, 50);
        }
    }

    public static void BuildRex(int spr, int x, int y, int z, int sectnum, int ang, int channel) {
        int count;
        if ((count = --RexCount) < 0) {
            return;
        }
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)sectnum, 119);
        } else {
            x = Engine.sprite[spr].x;
            y = Engine.sprite[spr].y;
            z = Engine.sector[Engine.sprite[spr].sectnum].floorz;
            ang = Engine.sprite[spr].ang;
            Main.engine.changespritestat((short)spr, 119);
        }
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        Engine.sprite[spr].x = x;
        Engine.sprite[spr].y = y;
        Engine.sprite[spr].z = z;
        Engine.sprite[spr].cstat = (short)257;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].picnum = 1;
        Engine.sprite[spr].pal = Engine.sector[Engine.sprite[spr].sectnum].ceilingpal;
        Engine.sprite[spr].clipdist = 80;
        Engine.sprite[spr].ang = (short)ang;
        Engine.sprite[spr].xrepeat = (short)64;
        Engine.sprite[spr].yrepeat = (short)64;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        if (RexList[count] == null) {
            Rex.RexList[count] = new Enemy.EnemyStruct();
        }
        Rex.RexList[count].nState = 0;
        Rex.RexList[count].nHealth = (short)4000;
        Rex.RexList[count].nSeq = 0;
        Rex.RexList[count].nSprite = (short)spr;
        Rex.RexList[count].nTarget = (short)-1;
        Rex.RexList[count].field_A = 0;
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x180000 | count);
        RunList.AddRunRec(RunList.NewRun, 0x180000 | count);
        Rex.RexChan[count] = (short)channel;
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncRex(int a1, int nDamage, int RunPtr) {
        short nRex = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nRex < 0 || nRex >= 50) {
            Main.game.ThrowError("rex>=0 && rex<MAX_REX");
            return;
        }
        Enemy.EnemyStruct pRex = RexList[nRex];
        short nSprite = pRex.nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nState = pRex.nState;
        short nTarget = pRex.nTarget;
        boolean v67 = false;
        short nObject = (short)(a1 & 0xFFFF);
        block0 : switch (a1 & 0x7F0000) {
            case 131072: {
                Sprites.Gravity(nSprite);
                int nSeq = ActionSeq_X_8[nState][0] + Seq.SeqOffsets[47];
                pSprite.picnum = (short)Seq.GetSeqPicnum2(nSeq, pRex.nSeq);
                int loops = 1;
                if (nState == 2) {
                    loops = 2;
                }
                for (int i = 0; i < loops; ++i) {
                    Seq.MoveSequence(nSprite, nSeq, pRex.nSeq);
                    pRex.nSeq = (short)(pRex.nSeq + 1);
                    if (pRex.nSeq < Seq.SeqSize[nSeq]) continue;
                    pRex.nSeq = 0;
                    v67 = true;
                }
                short nFlags = Seq.FrameFlag[pRex.nSeq + Seq.SeqBase[nSeq]];
                block6 : switch (nState) {
                    case 0: {
                        if (pRex.field_A != 0) {
                            pRex.field_A = (short)(pRex.field_A - 1);
                            if (pRex.field_A <= 0) {
                                pRex.nState = 1;
                                pRex.nSeq = 0;
                                pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 2);
                                pSprite.yvel = (short)(Engine.sintable[pSprite.ang & 0x7FF] >> 2);
                                Sound.D3PlayFX(Sound.StaticSound[48], nSprite);
                                pRex.field_A = (short)30;
                            }
                        } else if ((nRex & 0x1F) == (Globals.totalmoves & 0x1F)) {
                            if (nTarget >= 0) {
                                pRex.field_A = (short)60;
                            } else {
                                short v17 = Engine.sprite[nSprite].ang;
                                pRex.nTarget = (short)Enemy.FindPlayer(nSprite, 60);
                                Engine.sprite[nSprite].ang = v17;
                            }
                        }
                        return;
                    }
                    case 2: {
                        pRex.field_A = (short)(pRex.field_A - 1);
                        if (pRex.field_A > 0) {
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 1);
                            pSprite.yvel = (short)(Engine.sintable[pSprite.ang & 0x7FF] >> 1);
                            int hitMove = Enemy.MoveCreatureWithCaution(nSprite);
                            switch (hitMove & 0xC000) {
                                case 32768: {
                                    Object.SetQuake(nSprite, 25);
                                    pRex.field_A = (short)60;
                                    break block6;
                                }
                                case 49152: {
                                    pRex.nState = (short)3;
                                    pRex.nSeq = 0;
                                    int spr = hitMove & 0x3FFF;
                                    if (Engine.sprite[spr].statnum != 0 && Engine.sprite[spr].statnum < 107) {
                                        Sprites.DamageEnemy(spr, nSprite, 15);
                                        int xvel = 15 * Engine.sintable[pSprite.ang + 512 & 0x7FF];
                                        int yvel = 15 * Engine.sintable[pSprite.ang & 0x7FF];
                                        if (Engine.sprite[spr].statnum == 100) {
                                            short v32;
                                            short s = v32 = Player.GetPlayerFromSprite(spr);
                                            Globals.nXDamage[s] = Globals.nXDamage[s] + 16 * xvel;
                                            short s2 = v32;
                                            Globals.nYDamage[s2] = Globals.nYDamage[s2] + 16 * yvel;
                                            Engine.sprite[spr].zvel = (short)-3584;
                                        } else {
                                            Engine.sprite[spr].xvel = (short)(Engine.sprite[spr].xvel + (xvel >> 3));
                                            Engine.sprite[spr].yvel = (short)(Engine.sprite[spr].yvel + (yvel >> 3));
                                            Engine.sprite[spr].zvel = (short)-2880;
                                        }
                                    }
                                    pRex.field_A = (short)(pRex.field_A >> 2);
                                }
                            }
                        } else {
                            pRex.nState = 1;
                            pRex.nSeq = 0;
                            pRex.field_A = (short)90;
                        }
                        return;
                    }
                    case 3: {
                        if (v67) {
                            pRex.nState = (short)2;
                        }
                        return;
                    }
                    case 1: {
                        if (pRex.field_A > 0) {
                            pRex.field_A = (short)(pRex.field_A - 1);
                        }
                        if ((Globals.totalmoves & 0xF) == (nRex & 0xF)) {
                            if (Random.RandomSize(1) == 0) {
                                pRex.nState = (short)5;
                                pRex.nSeq = 0;
                                pSprite.xvel = 0;
                                pSprite.yvel = 0;
                                return;
                            }
                            if (Enemy.PlotCourseToSprite(nSprite, nTarget) >> 8 < 60 && pRex.field_A <= 0) {
                                pRex.nState = (short)2;
                                pRex.field_A = (short)240;
                                Sound.D3PlayFX(Sound.StaticSound[48], nSprite);
                                pRex.nSeq = 0;
                                return;
                            }
                            pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 2);
                            pSprite.yvel = (short)(Engine.sintable[pSprite.ang] >> 2);
                        }
                        int hitMove = Enemy.MoveCreatureWithCaution(nSprite);
                        switch (hitMove & 0xC000) {
                            case 32768: {
                                break block6;
                            }
                            case 49152: {
                                if ((hitMove & 0x3FFF) != nTarget) break block6;
                                Enemy.PlotCourseToSprite(nSprite, nTarget);
                                pRex.nState = (short)4;
                                pRex.nSeq = 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    case 5: {
                        if (v67) {
                            pRex.nState = 1;
                            pRex.field_A = (short)15;
                        }
                        return;
                    }
                    case 4: {
                        if (nTarget == -1 || Enemy.PlotCourseToSprite(nSprite, nTarget) >= 768) {
                            pRex.nState = 1;
                            break block0;
                        }
                        if ((nFlags & 0x80) == 0) break block0;
                        Sprites.DamageEnemy(nTarget, nSprite, 15);
                        break block0;
                    }
                    case 6: {
                        if (v67) {
                            pRex.nState = (short)7;
                            pRex.nSeq = 0;
                            RunList.ChangeChannel(RexChan[nRex], 1);
                        }
                        return;
                    }
                    case 7: {
                        pSprite.cstat = (short)(pSprite.cstat & 0xFEFE);
                        return;
                    }
                    default: {
                        return;
                    }
                }
                pSprite.ang = (short)(pSprite.ang + 256 & 0x7FF);
                pSprite.xvel = (short)(Engine.sintable[pSprite.ang + 512 & 0x7FF] >> 2);
                pSprite.yvel = (short)(Engine.sintable[pSprite.ang] >> 2);
                pRex.nState = 1;
                nState = 1;
                pRex.nSeq = 0;
                break;
            }
            case 589824: {
                Seq.PlotSequence(nObject, ActionSeq_X_8[nState][0] + Seq.SeqOffsets[47], pRex.nSeq, ActionSeq_X_8[nState][1]);
                return;
            }
            case 655360: {
                if (nState == 5) {
                    nDamage = Sprites.CheckRadialDamage(nSprite);
                }
            }
            case 524288: {
                if (nDamage != 0) {
                    if (nTarget >= 0 && Engine.sprite[nTarget].statnum == 100) {
                        pRex.nTarget = nTarget;
                    }
                    if (pRex.nState == 5 && pRex.nHealth > 0) {
                        pRex.nHealth = (short)(pRex.nHealth - nDamage);
                        if (pRex.nHealth <= 0) {
                            pSprite.xvel = 0;
                            pSprite.yvel = 0;
                            pSprite.zvel = 0;
                            pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                            pRex.nHealth = 0;
                            --Globals.nCreaturesLeft;
                            if (pRex.nState < 6) {
                                pRex.nState = (short)6;
                                pRex.nSeq = 0;
                            }
                        }
                    }
                }
                return;
            }
        }
        if (nState > 0 && nTarget != -1 && (Engine.sprite[nTarget].cstat & 0x101) == 0) {
            pRex.nState = 0;
            pRex.nSeq = 0;
            pRex.field_A = 0;
            pRex.nTarget = (short)-1;
            pSprite.xvel = 0;
            pSprite.yvel = 0;
        }
    }

    static {
        RexList = new Enemy.EnemyStruct[50];
        RexChan = new short[50];
        ActionSeq_X_8 = new short[][]{{29, 0}, {0, 0}, {0, 0}, {37, 0}, {9, 0}, {18, 0}, {27, 1}, {28, 1}};
    }
}

