/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;

public class Palette {
    public static int nPalDiff;
    public static int nPalDelay;
    public static int rtint;
    public static int btint;
    public static int gtint;
    public static byte[] curpal;
    public static String[] cinpalfname;
    public static byte[] cinemapal;
    public static boolean bGreenPalette;

    public static void TintPalette(int r, int g, int b) {
        r = Gameutils.BClipRange(r, r != 0 && r < 5 ? 5 : 0, 63);
        g = Gameutils.BClipRange(g, g != 0 && g < 5 ? 5 : 0, 63);
        b = Gameutils.BClipRange(b, b != 0 && b < 5 ? 5 : 0, 63);
        if (g != 0 && gtint > 8) {
            return;
        }
        gtint += g;
        if (r != 0 && rtint > 64) {
            return;
        }
        rtint += r;
        btint += b;
        int nDiff = r;
        if (nDiff <= g) {
            nDiff = g;
        }
        if (nDiff <= b) {
            nDiff = b;
        }
        nPalDiff += nDiff;
        if (Main.engine.glrender() == null) {
            for (int i = 0; i < 256; ++i) {
                Palette.curpal[3 * i + 0] = (byte)Gameutils.BClipHigh((curpal[3 * i + 0] & 0xFF) + r, 63);
                Palette.curpal[3 * i + 1] = (byte)Gameutils.BClipHigh((curpal[3 * i + 1] & 0xFF) + g, 63);
                Palette.curpal[3 * i + 2] = (byte)Gameutils.BClipHigh((curpal[3 * i + 2] & 0xFF) + b, 63);
            }
        }
        nPalDelay = 0;
    }

    public static void LoadCinemaPalette(int pal) {
        int num = pal - 1;
        if (num >= 0 && num < 16) {
            System.arraycopy(BuildGdx.cache.getBytes(cinpalfname[num], 1), 0, cinemapal, 0, 768);
        }
    }

    public static void FixPalette() {
        if (nPalDiff == 0) {
            return;
        }
        if (nPalDelay-- > 0) {
            return;
        }
        nPalDelay = 5;
        if (Main.engine.glrender() == null) {
            for (int i = 0; i < 768; ++i) {
                int dP = (curpal[i] & 0xFF) - (Engine.palette[i] & 0xFF);
                if (dP <= 0) continue;
                if (dP <= 5) {
                    Palette.curpal[i] = Engine.palette[i];
                    continue;
                }
                int n = i;
                curpal[n] = (byte)(curpal[n] - 5);
            }
            Main.engine.setbrightness(BuildSettings.paletteGamma.get(), curpal, GLRenderer.GLInvalidateFlag.All);
        } else {
            Main.engine.setpalettefade(rtint <= 5 ? 0 : rtint, gtint <= 5 ? 0 : gtint, btint <= 5 ? 0 : btint, 0);
        }
        nPalDiff = Gameutils.BClipLow(nPalDiff - 5, 0);
        rtint = Gameutils.BClipLow(rtint - 5, 0);
        gtint = Gameutils.BClipLow(gtint - 5, 0);
        btint = Gameutils.BClipLow(btint - 5, 0);
    }

    public static void SetGreenPal() {
        if (bGreenPalette) {
            return;
        }
        for (int i = 0; i < 12; ++i) {
            Engine.palookup[i] = Engine.palookup[6];
        }
        Engine.palookup[5] = Globals.origpalookup[5];
        GLRenderer gl = Main.engine.glrender();
        if (gl != null) {
            gl.gltexinvalidateall(GLRenderer.GLInvalidateFlag.All);
        }
        bGreenPalette = true;
        System.err.println("SetGreen");
    }

    public static void RestoreGreenPal() {
        if (!bGreenPalette) {
            return;
        }
        for (int i = 0; i < 12; ++i) {
            Engine.palookup[i] = Globals.origpalookup[i];
        }
        GLRenderer gl = Main.engine.glrender();
        if (gl != null) {
            gl.gltexinvalidateall(GLRenderer.GLInvalidateFlag.All);
        }
        bGreenPalette = false;
        System.err.println("RestoreGreenPal");
    }

    public static void GrabPalette() {
        System.arraycopy(Engine.palette, 0, curpal, 0, 768);
        Main.engine.setbrightness(BuildSettings.paletteGamma.get(), curpal, GLRenderer.GLInvalidateFlag.All);
        nPalDiff = 0;
        nPalDelay = 0;
        btint = 0;
        gtint = 0;
        rtint = 0;
    }

    static {
        curpal = new byte[768];
        cinpalfname = new String[]{"3454.pal", "3452.pal", "3449.pal", "3445.pal", "set.pal", "3448.pal", "3446.pal", "hsc1.pal", "2972.pal", "2973.pal", "2974.pal", "2975.pal", "2976.pal", "heli.pal", "2978.pal", "terror.pal"};
        cinemapal = new byte[768];
    }
}

