/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import com.badlogic.gdx.math.Vector2;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Cinema;
import ru.m210projects.Powerslave.Enemies.Ra;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.LoadSave;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sector;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.SpiritHead;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.PlayerSave;
import ru.m210projects.Powerslave.Type.StatusAnim;
import ru.m210projects.Powerslave.View;
import ru.m210projects.Powerslave.Weapons;

public class Player {
    public static final String deathMessage1 = "or \"enter\" to load last saved game";
    public static final String deathMessage2 = "Press \"use\" to restart the level";
    public static final int MAXHORIZ = 300;
    public static final int MAXOHORIZ = 180;
    public static final int MINHORIZ = -130;
    public static final int MINOHORIZ = 0;
    public static Action[] ActionSeq = new Action[]{new Action(18, false), new Action(0, false), new Action(9, false), new Action(27, false), new Action(63, false), new Action(72, false), new Action(54, false), new Action(45, false), new Action(54, false), new Action(81, false), new Action(90, false), new Action(99, false), new Action(108, false), new Action(8, false), new Action(0, false), new Action(139, false), new Action(117, true), new Action(119, true), new Action(120, true), new Action(121, true), new Action(122, true)};
    public static short[] nActionEyeLevel = new short[]{-14080, -14080, -14080, -14080, -14080, -14080, -8320, -8320, -8320, -8320, -8320, -8320, -8320, -14080, -14080, -14080, -14080, -14080, -14080, -14080, -14080};
    public static int[] nHeightTemplate = new int[]{0, 0, 0, 0, 0, 0, 7, 7, 7, 9, 9, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0};
    public static short nLocalEyeSect;
    public static PlayerSave[] sPlayerSave;

    public static short GetPlayerFromSprite(int num) {
        return (short)(RunList.RunData[Engine.sprite[num].owner].RunEvent & 0xFFFF);
    }

    public static void InitPlayerKeys(int num) {
        Globals.PlayerList[num].KeysBitMask = 0;
    }

    public static void RestartPlayer(int num) {
        int floorspr;
        short dspr;
        short nSprite = Globals.PlayerList[num].spriteId;
        short nDopple = Globals.nDoppleSprite[num];
        if (nSprite > -1) {
            RunList.DoSubRunRec(Engine.sprite[nSprite].owner);
            RunList.FreeRun(Engine.sprite[nSprite].lotag - 1);
            Main.engine.changespritestat(nSprite, 0);
            Globals.PlayerList[num].spriteId = (short)-1;
            if (Globals.nPlayerFloorSprite[num] > -1) {
                Main.engine.mydeletesprite(Globals.nPlayerFloorSprite[num]);
            }
            if (nDopple > -1) {
                RunList.DoSubRunRec(Engine.sprite[nDopple].owner);
                RunList.FreeRun(Engine.sprite[nDopple].lotag - 1);
                Main.engine.mydeletesprite(nDopple);
            }
        }
        short spr = Sprites.GrabBody();
        PlayerSave pSave = sPlayerSave[num];
        Main.engine.changespritesect(spr, pSave.sect);
        Main.engine.changespritestat(spr, 100);
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
        }
        Globals.nDoppleSprite[num] = dspr = Main.engine.insertsprite(Engine.sprite[spr].sectnum, 100);
        if (dspr < 0 || dspr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("(dspr>=0) && (dspr<MAXSPRITES)");
        }
        SPRITE pSprite = Engine.sprite[spr];
        SPRITE pDSprite = Engine.sprite[dspr];
        if (Mmulti.numplayers <= 1) {
            pSprite.x = pSave.x;
            pSprite.y = pSave.y;
            pSprite.z = Engine.sector[pSave.sect].floorz;
            pSprite.ang = pSave.ang;
            Globals.PlayerList[num].ang = pSprite.ang;
            floorspr = -1;
        } else {
            short nNetStart = Globals.nNetStartSprite[Globals.nCurStartSprite++];
            SPRITE pNetStart = Engine.sprite[nNetStart];
            if (Globals.nCurStartSprite >= Globals.nNetStartSprites) {
                Globals.nCurStartSprite = 0;
            }
            pSprite.x = pNetStart.x;
            pSprite.y = pNetStart.y;
            pSprite.z = pNetStart.z;
            Main.engine.mychangespritesect(spr, pNetStart.sectnum);
            pSprite.ang = pNetStart.ang;
            Globals.PlayerList[num].ang = pSprite.ang;
            floorspr = Main.engine.insertsprite(pSprite.sectnum, 0);
            if (floorspr < 0 || floorspr >= Engine.MAXSPRITES) {
                Main.game.ThrowError("floorspr>=0 && floorspr<MAXSPRITES");
            }
            Engine.sprite[floorspr].x = pSprite.x;
            Engine.sprite[floorspr].y = pSprite.y;
            Engine.sprite[floorspr].z = pSprite.z;
            Engine.sprite[floorspr].yrepeat = (short)64;
            Engine.sprite[floorspr].xrepeat = (short)64;
            Engine.sprite[floorspr].cstat = (short)32;
            Engine.sprite[floorspr].picnum = (short)(num + 3571);
        }
        Globals.nPlayerFloorSprite[num] = (short)floorspr;
        pSprite.cstat = (short)257;
        pSprite.shade = (byte)-12;
        pSprite.clipdist = 58;
        pSprite.pal = 0;
        pSprite.xrepeat = (short)40;
        pSprite.yrepeat = (short)40;
        pSprite.xoffset = 0;
        pSprite.yoffset = 0;
        pSprite.picnum = Seq.GetSeqPicnum(25, 18, 0);
        Globals.nStandHeight = Sprites.GetSpriteHeight(spr);
        pSprite.xvel = 0;
        pSprite.yvel = 0;
        pSprite.zvel = 0;
        pSprite.lotag = (short)(RunList.HeadRun() + 1);
        pSprite.hitag = 0;
        pSprite.extra = (short)-1;
        pDSprite.x = pSprite.x;
        pDSprite.y = pSprite.y;
        pDSprite.z = pSprite.z;
        pDSprite.xrepeat = pSprite.xrepeat;
        pDSprite.yrepeat = pSprite.yrepeat;
        pDSprite.yoffset = 0;
        pDSprite.xoffset = 0;
        pDSprite.shade = pSprite.shade;
        pDSprite.ang = pSprite.ang;
        pDSprite.cstat = pSprite.cstat;
        pDSprite.lotag = (short)(RunList.HeadRun() + 1);
        Globals.PlayerList[num].anim_ = 0;
        Globals.PlayerList[num].animCount = 0;
        Globals.PlayerList[num].spriteId = spr;
        Globals.PlayerList[num].invisibility = 0;
        Globals.PlayerList[num].mummified = 0;
        Light.SetTorch(num, 0);
        Globals.nPlayerInvisible[num] = 0;
        Globals.PlayerList[num].weaponFire = 0;
        Globals.PlayerList[num].seqOffset = 0;
        Globals.nPlayerViewSect[num] = pSave.sect;
        Globals.PlayerList[num].weaponState = 0;
        Globals.nPlayerDouble[num] = 0;
        Globals.PlayerList[num].seq = (short)25;
        Globals.nPlayerPushSound[num] = -1;
        Globals.PlayerList[num].newWeapon = (short)-1;
        Globals.PlayerList[num].lastWeapon = 0;
        Globals.PlayerList[num].AirAmount = (short)100;
        Globals.nPlayerGrenade[num] = -1;
        Globals.nPlayerTorch[num] = 0;
        Globals.PlayerList[num].AirMaskAmount = 0;
        if (LoadSave.gClassicMode) {
            Globals.PlayerList[num].HealthAmount = (short)800;
            if (Globals.nNetPlayerCount != 0) {
                Globals.PlayerList[num].HealthAmount = (short)1600;
            }
            if (Globals.PlayerList[num].currentWeapon == 7) {
                Globals.PlayerList[num].currentWeapon = Globals.PlayerList[num].lastWeapon;
            }
        }
        if (Globals.levelnum <= 20) {
            if (!LoadSave.gClassicMode) {
                Weapons.RestoreMinAmmo(num);
            } else {
                Weapons.CheckClip(num);
            }
        } else {
            Weapons.ResetPlayerWeapons(num);
            Globals.PlayerList[num].MagicAmount = 0;
        }
        Globals.PlayerList[num].eyelevel = (short)-14080;
        Globals.dVertPan[num] = 0;
        Globals.nTemperature[num] = 0;
        Globals.nYDamage[num] = 0;
        Globals.nXDamage[num] = 0;
        Globals.PlayerList[num].horiz = 92.0f;
        Globals.nDestVertPan[num] = 92.0f;
        Globals.nBreathTimer[num] = 90;
        Globals.nTauntTimer[num] = (short)(Random.RandomSize(3) + 3);
        pDSprite.owner = (short)RunList.AddRunRec(pDSprite.lotag - 1, 0xA0000 | num);
        pSprite.owner = (short)RunList.AddRunRec(pSprite.lotag - 1, 0xA0000 | num);
        if (Globals.PlayerList[num].RunFunc < 0) {
            Globals.PlayerList[num].RunFunc = (short)RunList.AddRunRec(RunList.NewRun, 0xA0000 | num);
        }
        Ra.BuildRa(num);
        if (num == Globals.nLocalPlayer) {
            View.SetMagicFrame();
            Palette.RestoreGreenPal();
            Globals.bPlayerPan = false;
            Globals.bLockPan = false;
        }
        Globals.totalvel[num] = 0;
        Globals.nDeathType[num] = 0;
        Globals.nQuake[num] = 0;
        if (num == Globals.nLocalPlayer) {
            View.SetHealthFrame(0);
        }
    }

    public static void RestoreSavePoint(int num) {
        PlayerSave ps = sPlayerSave[num];
        Globals.initx = ps.x;
        Globals.inity = ps.y;
        Globals.initz = ps.z;
        Globals.initsect = ps.sect;
        Globals.inita = ps.ang;
        Globals.PlayerList[num].ang = Globals.inita;
    }

    public static PlayerSave SetSavePoint(int num, int x, int y, int z, int sect, int ang) {
        PlayerSave ps = sPlayerSave[num];
        ps.x = x;
        ps.y = y;
        ps.z = z;
        ps.sect = (short)sect;
        ps.ang = (short)ang;
        return ps;
    }

    public static int GrabPlayer() {
        if (Globals.PlayerCount >= 8) {
            return -1;
        }
        return Globals.PlayerCount++;
    }

    public static void InitPlayerInventory(int nPlayer) {
        Globals.PlayerList[nPlayer].reset();
        Globals.PlayerList[nPlayer].nPlayer = nPlayer;
        Globals.nPlayerItem[nPlayer] = -1;
        Globals.nPlayerSwear[nPlayer] = 4;
        Weapons.ResetPlayerWeapons(nPlayer);
        Globals.nPlayerLives[nPlayer] = LoadSave.gClassicMode ? 3 : 0;
        Globals.PlayerList[nPlayer].spriteId = (short)-1;
        Globals.PlayerList[nPlayer].RunFunc = (short)-1;
        Globals.nPistolClip[nPlayer] = 6;
        Globals.nPlayerClip[nPlayer] = 0;
        Globals.PlayerList[nPlayer].currentWeapon = 0;
        if (nPlayer == Globals.nLocalPlayer) {
            Globals.bMapMode = false;
        }
        Globals.nPlayerScore[nPlayer] = 0;
        Main.engine.loadtile(nPlayer + 3571);
    }

    public static void SetItemSeq() {
        short item = Globals.nPlayerItem[Globals.nLocalPlayer];
        if (item < 0) {
            Globals.nItemSeq = -1;
        } else {
            Globals.nItemAltSeq = Globals.nItemMagic[Globals.nPlayerItem[Globals.nLocalPlayer]] <= Globals.PlayerList[Globals.nLocalPlayer].MagicAmount ? (short)0 : (short)2;
            Globals.nItemFrame = 0;
            Globals.nItemSeq = Globals.nItemAltSeq + Globals.nItemSeqOffset[item];
            Globals.nItemFrames = Seq.SeqSize[Globals.nStatusSeqOffset + Globals.nItemSeq];
        }
    }

    public static void SetPlayerItem(int nPlayer, int nItem) {
        Globals.nPlayerItem[nPlayer] = (short)nItem;
        if (nPlayer == Globals.nLocalPlayer) {
            Player.SetItemSeq();
            if (nItem >= 0) {
                StatusAnim.BuildStatusAnim(2 * Globals.PlayerList[nPlayer].ItemsAmount[nItem] + 156, 0);
            }
        }
    }

    public static void FuncPlayer(int a1, int a2, int RunPtr) {
        short player = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (player < 0 || player >= 8) {
            Main.game.ThrowError("player>=0 && player<MAXPLAYER");
        }
        if (Globals.PlayerList[player].network == -1) {
            return;
        }
        boolean v233 = false;
        short spr = Globals.PlayerList[player].spriteId;
        short dspr = Globals.nDoppleSprite[player];
        SPRITE pDSprite = Engine.sprite[dspr];
        SPRITE pSprite = Engine.sprite[spr];
        int anim = Globals.PlayerList[player].anim_;
        int v229 = -1;
        switch (a1 & 0x7F0000) {
            case 131072: {
                boolean bViewUnderwater;
                short osect;
                boolean bUnderwater;
                short quake;
                short god;
                short invis;
                if ((Globals.sPlayerInput[player].bits & 0x200) != 0) {
                    Player.UseCurItem(player, Globals.nPlayerItem[player]);
                }
                if ((Globals.sPlayerInput[player].bits & 0x80) != 0) {
                    Player.SetPrevItem(player);
                }
                if ((Globals.sPlayerInput[player].bits & 0x100) != 0) {
                    Player.SetNextItem(player);
                }
                if ((Globals.sPlayerInput[player].bits & 0x80000) != 0) {
                    Player.UseCurItem(player, 3);
                }
                if ((Globals.sPlayerInput[player].bits & 0x100000) != 0) {
                    Player.UseCurItem(player, 4);
                }
                if ((Globals.sPlayerInput[player].bits & 0x200000) != 0) {
                    Player.UseCurItem(player, 5);
                }
                if ((Globals.sPlayerInput[player].bits & 0x400000) != 0) {
                    Player.UseCurItem(player, 0);
                }
                if ((Globals.sPlayerInput[player].bits & 0x800000) != 0) {
                    Player.UseCurItem(player, 2);
                }
                if ((Globals.sPlayerInput[player].bits & 0x1000000) != 0) {
                    Player.UseCurItem(player, 1);
                }
                int next_anim = Globals.PlayerList[player].anim_;
                pSprite.xvel = (short)(Globals.sPlayerInput[player].xvel >> 14);
                pSprite.yvel = (short)(Globals.sPlayerInput[player].yvel >> 14);
                if (Globals.sPlayerInput[player].field_F > -1) {
                    Player.UseItem(player, Globals.sPlayerInput[player].field_F);
                    Globals.sPlayerInput[player].field_F = (byte)-1;
                }
                pDSprite.picnum = pSprite.picnum = Seq.GetSeqPicnum(Globals.PlayerList[player].seq, Player.ActionSeq[Player.nHeightTemplate[anim]].seq, Globals.PlayerList[player].animCount);
                short torch = Globals.nPlayerTorch[player];
                if (torch > 0) {
                    Globals.nPlayerTorch[player] = (short)(torch - 1);
                    if (torch == 1) {
                        Light.SetTorch(player, 0);
                    } else if (player != Globals.nLocalPlayer) {
                        Light.nFlashDepth = 5;
                        Light.AddFlash(pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 0);
                        Light.nFlashDepth = 2;
                    }
                } else if (player == Globals.nLocalPlayer) {
                    Light.bTorch = 0;
                }
                short dble = Globals.nPlayerDouble[player];
                if (dble > 0) {
                    Globals.nPlayerDouble[player] = (short)(dble - 1);
                    if (Globals.nPlayerDouble[player] == 150 && player == Globals.nLocalPlayer) {
                        Player.PlayAlert("WEAPON POWER IS ABOUT TO EXPIRE", player);
                    }
                }
                if ((invis = Globals.nPlayerInvisible[player]) > 0) {
                    Globals.nPlayerInvisible[player] = (short)(invis - 1);
                    if (invis == 1) {
                        pSprite.cstat = (short)(pSprite.cstat & Short.MAX_VALUE);
                        short fl = Globals.nPlayerFloorSprite[player];
                        if (fl > -1) {
                            Engine.sprite[player].cstat = (short)(Engine.sprite[player].cstat & Short.MAX_VALUE);
                        }
                    } else if (Globals.nPlayerInvisible[player] == 150 && player == Globals.nLocalPlayer) {
                        Player.PlayAlert("INVISIBILITY IS ABOUT TO EXPIRE", player);
                    }
                }
                if ((god = Globals.PlayerList[player].invisibility) > 0) {
                    Globals.PlayerList[player].invisibility = (short)(god - 1);
                    if (Globals.PlayerList[player].invisibility == 150 && player == Globals.nLocalPlayer) {
                        Player.PlayAlert("INVINCIBILITY IS ABOUT TO EXPIRE", player);
                    }
                }
                if ((quake = Globals.nQuake[player]) != 0) {
                    Globals.nQuake[player] = -quake;
                    if (Globals.nQuake[player] >= 0 && Globals.nQuake[player] != 0) {
                        Globals.nQuake[player] = (short)(Globals.nQuake[player] - 512);
                        if (-quake - 512 < 0) {
                            Globals.nQuake[player] = 0;
                        }
                    }
                }
                Globals.PlayerList[player].ang = Gameutils.BClampAngle(Globals.PlayerList[player].ang + 4.0f * Globals.sPlayerInput[player].avel);
                pSprite.ang = (short)Globals.PlayerList[player].ang;
                short ozvel = pSprite.zvel;
                Sprites.Gravity(spr);
                if (pSprite.zvel >= 6500 && ozvel < 6500) {
                    Sound.D3PlayFX(Sound.StaticSound[17], spr);
                }
                short osectnum = pSprite.sectnum;
                boolean oUnderwater = (Globals.SectFlag[Globals.nPlayerViewSect[player]] & 0x2000) != 0;
                int sx = pSprite.x;
                int sy = pSprite.y;
                int sz = pSprite.z;
                int xvel = 4 * Globals.sPlayerInput[player].xvel >> 2;
                int yvel = 4 * Globals.sPlayerInput[player].yvel >> 2;
                int zvel = 4 * pSprite.zvel >> 2;
                if (pSprite.zvel > 8192) {
                    pSprite.zvel = (short)8192;
                }
                ozvel = pSprite.zvel;
                if (Globals.PlayerList[player].mummified != 0) {
                    xvel /= 2;
                    yvel /= 2;
                }
                int moveHit = 0;
                if (Globals.bSlipMode) {
                    pSprite.x += xvel >> 14;
                    pSprite.y += yvel >> 14;
                    Main.engine.setsprite(spr, pSprite.x, pSprite.y, pSprite.z);
                    pSprite.z = Engine.sector[pSprite.sectnum].floorz;
                } else {
                    moveHit = Main.engine.movesprite(spr, xvel, yvel, zvel, 5120, -5120, 0);
                    Main.engine.pushmove(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, 4 * pSprite.clipdist, 5120, -5120, 0);
                    pSprite.x = Engine.pushmove_x;
                    pSprite.y = Engine.pushmove_y;
                    pSprite.z = Engine.pushmove_z;
                    if (Gameutils.isValidSector(Engine.pushmove_sectnum) && pSprite.sectnum != Engine.pushmove_sectnum) {
                        Main.engine.mychangespritesect(spr, Engine.pushmove_sectnum);
                    }
                    if (Main.engine.inside(pSprite.x, pSprite.y, pSprite.sectnum) == 0) {
                        Main.engine.mychangespritesect(spr, osectnum);
                        pSprite.x = sx;
                        pSprite.y = sy;
                        if (ozvel < pSprite.zvel) {
                            pSprite.zvel = ozvel;
                        }
                    }
                }
                boolean bl = bUnderwater = (Globals.SectFlag[pSprite.sectnum] & 0x2000) != 0;
                if (bUnderwater) {
                    int v48 = Globals.nXDamage[player];
                    Globals.nXDamage[player] = v48 - (v48 & 0xFF00) >> 1;
                    int v49 = Globals.nYDamage[player];
                    Globals.nYDamage[player] = v49 - (v49 & 0xFF00) >> 1;
                }
                if ((Globals.SectFlag[pSprite.sectnum] & 0x8000) != 0 && Globals.bTouchFloor[0]) {
                    if (Mmulti.numplayers <= 1) {
                        pSprite.ang = Sprites.GetAngleToSprite(spr, SpiritHead.nSpiritSprite);
                        Globals.PlayerList[player].ang = pSprite.ang;
                        pSprite.zvel = 0;
                        pSprite.xvel = pSprite.yvel = 0;
                        if (Globals.nFreeze < 1) {
                            Globals.nFreeze = 1;
                            Sound.StopAllSounds();
                            Sound.StopLocalSound();
                            SpiritHead.InitSpiritHead();
                            Globals.nDestVertPan[player] = 92.0f;
                            Globals.nDestVertPan[player] = Globals.levelnum == 11 ? 138.0f : 103.0f;
                        }
                    } else {
                        Map.FinishLevel();
                    }
                    return;
                }
                if ((moveHit & 0x3C000) != 0) {
                    if (Globals.bTouchFloor[0]) {
                        int v53 = Globals.nXDamage[player];
                        Globals.nXDamage[player] = v53 - (v53 & 0xFF00) >> 1;
                        int v54 = Globals.nYDamage[player];
                        Globals.nYDamage[player] = v54 - (v54 & 0xFF00) >> 1;
                        if (player == Globals.nLocalPlayer && !Main.cfg.gMouseAim && Pragmas.klabs(ozvel) > 512) {
                            Globals.nDestVertPan[player] = 92.0f;
                        }
                        if (ozvel >= 6500) {
                            pSprite.xvel = (short)(pSprite.xvel >> 2);
                            pSprite.yvel = (short)(pSprite.yvel >> 2);
                            Sprites.DamageEnemy(spr, -1, (ozvel - 6500 >> 7) + 10);
                            if (Globals.PlayerList[player].HealthAmount > 0) {
                                Sound.D3PlayFX(Sound.StaticSound[27] | 0x2000, spr);
                            } else {
                                pSprite.yvel = 0;
                                pSprite.xvel = 0;
                                Sound.StopSpriteSound(spr);
                                Sound.PlayFXAtXYZ(Sound.StaticSound[60], pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum | 0x4000);
                            }
                        }
                    }
                    int hitobject = -1;
                    switch (moveHit & 0xC000) {
                        case 16384: {
                            hitobject = moveHit & 0x3FFF;
                            break;
                        }
                        case 32768: {
                            hitobject = Engine.wall[moveHit & 0x3FFF].nextsector;
                        }
                    }
                    if (hitobject >= 0 && Engine.sector[hitobject].hitag == 45 && Globals.bTouchFloor[0] && Pragmas.klabs(Sprites.AngleDiff(Main.engine.GetWallNormal(moveHit & 0x3FFF), pSprite.ang + 1024 & 0x7FF)) <= 256) {
                        Globals.nPlayerPushSect[player] = (short)hitobject;
                        int xv = Globals.sPlayerInput[player].xvel;
                        int yv = Globals.sPlayerInput[player].yvel;
                        Vector2 out = Sector.MoveSector(hitobject, Main.engine.GetMyAngle(xv, yv), xv, yv);
                        xv = (int)out.x;
                        yv = (int)out.y;
                        if (Globals.nPlayerPushSound[player] == -1) {
                            Globals.nPlayerPushSound[player] = Engine.sector[hitobject].extra;
                            Sound.D3PlayFX(Sound.StaticSound[23], Globals.sBlockInfo[Engine.sector[hitobject].extra].sprite | 0x4000);
                        } else {
                            pSprite.x = sx;
                            pSprite.y = sy;
                            pSprite.z = sz;
                            Main.engine.mychangespritesect(spr, osectnum);
                        }
                        Main.engine.movesprite(spr, xv, yv, zvel, 5120, -5120, 0);
                    } else if (Globals.nPlayerPushSound[player] != -1) {
                        if (Globals.nPlayerPushSect[player] != -1) {
                            Sound.StopSpriteSound(Globals.sBlockInfo[Globals.nPlayerPushSound[player]].sprite);
                        }
                        Globals.nPlayerPushSound[player] = -1;
                    }
                }
                if (!Globals.bPlayerPan && !Globals.bLockPan) {
                    int v74 = (sz - pSprite.z) / 32 + 92;
                    Globals.nDestVertPan[player] = (short)Gameutils.BClipRange(v74, 0, 183);
                }
                int dx = sx - pSprite.x;
                int dy = sy - pSprite.y;
                Globals.totalvel[player] = Main.engine.ksqrt(dx * dx + dy * dy);
                short sectnum = pSprite.sectnum;
                int z = Globals.nQuake[player] + pSprite.z + Globals.PlayerList[player].eyelevel;
                if (z < Engine.sector[sectnum].ceilingz && Globals.SectAbove[sectnum] > -1) {
                    sectnum = Globals.SectAbove[sectnum];
                }
                if (bUnderwater && sectnum != (osect = pSprite.sectnum) && (moveHit & 0xC000) == 32768) {
                    int ox = pSprite.x;
                    int oy = pSprite.y;
                    int oz = pSprite.z;
                    Main.engine.mychangespritesect(spr, sectnum);
                    pSprite.x = sx;
                    pSprite.y = sy;
                    int fz = pSprite.z = -5120 + Engine.sector[sectnum].floorz;
                    if ((Main.engine.movesprite(spr, xvel, yvel, 0, 5120, 0, 0) & 0xC000) == 32768) {
                        Main.engine.mychangespritesect(spr, osect);
                        pSprite.x = ox;
                        pSprite.y = oy;
                        pSprite.z = oz;
                    } else {
                        pSprite.z = fz - 256;
                        Sound.D3PlayFX(Sound.StaticSound[42], spr);
                    }
                }
                Globals.nPlayerViewSect[player] = sectnum;
                Globals.nPlayerDX[player] = pSprite.x - sx;
                Globals.nPlayerDY[player] = pSprite.y - sy;
                boolean bl2 = bViewUnderwater = (Globals.SectFlag[sectnum] & 0x2000) != 0;
                if (Globals.PlayerList[player].HealthAmount <= 0) {
                    if (!LoadSave.gClassicMode && anim >= 16) {
                        if (Globals.message_timer <= 0) {
                            if (Main.game.isCurrentScreen(Main.gGameScreen) && LoadSave.lastload != null && !LoadSave.lastload.isEmpty() && BuildGdx.compat.checkFile(LoadSave.lastload, Compat.Path.User) != null) {
                                View.StatusMessage(5000, deathMessage1, player);
                            } else {
                                View.StatusMessage(5000, deathMessage2, player);
                            }
                        }
                        if (Main.game.isCurrentScreen(Main.gGameScreen) && LoadSave.lastload != null && !LoadSave.lastload.isEmpty() && Main.game.pInput.ctrlKeyStatusOnce(66)) {
                            Main.game.changeScreen(Main.gLoadingScreen.setTitle(LoadSave.lastload));
                            Main.gLoadingScreen.init(new Runnable(){

                                @Override
                                public void run() {
                                    if (!LoadSave.loadgame(LoadSave.lastload)) {
                                        Main.game.GameMessage("Can't load game!");
                                        Main.game.show();
                                    }
                                }
                            });
                        }
                    }
                    if ((Globals.sPlayerInput[player].bits & 4) != 0 && anim >= 16) {
                        if (!LoadSave.gClassicMode) {
                            BuildGdx.app.postRunnable(new Runnable(){

                                @Override
                                public void run() {
                                    Main.gGameScreen.newgame(Globals.mUserFlag == Main.UserFlag.UserMap ? BuildGdx.compat.checkFile(Globals.boardfilename) : Globals.gCurrentEpisode, Globals.levelnum, false);
                                }
                            });
                            return;
                        }
                        if (player == Globals.nLocalPlayer) {
                            Sound.StopAllSounds();
                            Sound.StopLocalSound();
                            Palette.GrabPalette();
                        }
                        Globals.PlayerList[player].currentWeapon = Globals.nPlayerOldWeapon[player];
                        if (Globals.nPlayerLives[player] != 0 && Globals.nNetTime != 0) {
                            if (anim != 20) {
                                pSprite.picnum = Seq.GetSeqPicnum(25, 120, 0);
                                pSprite.cstat = 0;
                                pSprite.z = Engine.sector[pSprite.sectnum].floorz;
                            }
                            Player.RestartPlayer(player);
                            dspr = Globals.nDoppleSprite[player];
                            pSprite = Engine.sprite[Globals.PlayerList[player].spriteId];
                            pDSprite = Engine.sprite[Globals.nDoppleSprite[player]];
                        } else if (Globals.levelnum == 20) {
                            Cinema.DoFailedFinalScene();
                        } else {
                            Cinema.DoGameOverScene();
                        }
                    }
                } else {
                    if ((Globals.sPlayerInput[player].bits & 0x800) != 0 && Globals.PlayerList[player].turnAround == 0) {
                        Globals.PlayerList[player].turnAround = (short)-1024;
                    }
                    if (Globals.PlayerList[player].turnAround < 0) {
                        Globals.PlayerList[player].turnAround = (short)Gameutils.BClipHigh(Globals.PlayerList[player].turnAround + 128, 0);
                        Globals.PlayerList[player].ang = Gameutils.BClampAngle(Globals.PlayerList[player].ang + 128.0f);
                        pSprite.ang = (short)Globals.PlayerList[player].ang;
                    }
                    if (Globals.PlayerList[player].AirMaskAmount > 0) {
                        Globals.PlayerList[player].AirMaskAmount = (short)(Globals.PlayerList[player].AirMaskAmount - 1);
                        if (Globals.PlayerList[player].AirMaskAmount == 150 && player == Globals.nLocalPlayer) {
                            Player.PlayAlert("MASK IS ABOUT TO EXPIRE", player);
                        }
                    }
                    if (Globals.PlayerList[player].invisibility == 0) {
                        short s = player;
                        Globals.nBreathTimer[s] = (short)(Globals.nBreathTimer[s] - 1);
                        if (Globals.nBreathTimer[player] <= 0) {
                            Globals.nBreathTimer[player] = 90;
                            if (bViewUnderwater) {
                                if (Globals.PlayerList[player].AirMaskAmount <= 0) {
                                    Globals.PlayerList[player].AirAmount = (short)(Globals.PlayerList[player].AirAmount - 25);
                                    if (Globals.PlayerList[player].AirAmount <= 0) {
                                        Globals.PlayerList[player].HealthAmount = (short)(Globals.PlayerList[player].HealthAmount + 4 * Globals.PlayerList[player].AirAmount);
                                        if (Globals.PlayerList[player].HealthAmount <= 0) {
                                            Globals.PlayerList[player].HealthAmount = 0;
                                            Seq.StartDeathSeq(player, 0);
                                        }
                                        if (player == Globals.nLocalPlayer) {
                                            View.SetHealthFrame(-1);
                                        }
                                        Globals.PlayerList[player].AirAmount = 0;
                                        if (Globals.PlayerList[player].HealthAmount >= 300) {
                                            Sound.D3PlayFX(Sound.StaticSound[19], spr);
                                        } else {
                                            Sound.D3PlayFX(Sound.StaticSound[79], spr);
                                        }
                                    } else {
                                        Sound.D3PlayFX(Sound.StaticSound[25], spr);
                                    }
                                } else {
                                    if (player == Globals.nLocalPlayer) {
                                        StatusAnim.BuildStatusAnim(132, 0);
                                    }
                                    Sound.D3PlayFX(Sound.StaticSound[30] | 0x1000, spr);
                                    Globals.PlayerList[player].AirAmount = (short)100;
                                }
                                Sprites.DoBubbles(player);
                                View.SetAirFrame();
                            } else if (player == Globals.nLocalPlayer) {
                                StatusAnim.BuildStatusAnim(132, 0);
                            }
                        }
                    }
                    if (bViewUnderwater) {
                        if (Globals.nPlayerTorch[player] > 0) {
                            Globals.nPlayerTorch[player] = 0;
                            Light.SetTorch(player, 0);
                        }
                    } else {
                        if (Globals.totalvel[player] > 25 && pSprite.z > Engine.sector[pSprite.sectnum].floorz && Globals.SectDepth[pSprite.sectnum] != 0 && Globals.SectSpeed[pSprite.sectnum] == 0 && Globals.SectDamage[pSprite.sectnum] == 0) {
                            Sound.D3PlayFX(Sound.StaticSound[42], spr);
                        }
                        if (oUnderwater) {
                            if (Globals.PlayerList[player].AirAmount < 50) {
                                Sound.D3PlayFX(Sound.StaticSound[14], spr);
                            }
                            Globals.nBreathTimer[player] = 1;
                        }
                        short s = player;
                        Globals.nBreathTimer[s] = (short)(Globals.nBreathTimer[s] - 1);
                        if (Globals.nBreathTimer[player] <= 0) {
                            Globals.nBreathTimer[player] = 90;
                            if (player == Globals.nLocalPlayer) {
                                StatusAnim.BuildStatusAnim(132, Globals.nLocalPlayer ^ player);
                            }
                        }
                        if (Globals.PlayerList[player].AirAmount < 100) {
                            Globals.PlayerList[player].AirAmount = (short)100;
                            View.SetAirFrame();
                        }
                    }
                    if (Mmulti.numplayers > 1) {
                        SPRITE fspr = Engine.sprite[Globals.nPlayerFloorSprite[player]];
                        fspr.x = pSprite.x;
                        fspr.y = pSprite.y;
                        if (fspr.sectnum != pSprite.sectnum) {
                            Main.engine.mychangespritesect(Globals.nPlayerFloorSprite[player], pSprite.sectnum);
                        }
                        fspr.z = Engine.sector[pSprite.sectnum].floorz;
                    }
                    int flags = 0;
                    if (Globals.PlayerList[player].HealthAmount >= 800) {
                        flags = 2;
                    }
                    if (Globals.PlayerList[player].MagicAmount >= 1000) {
                        flags |= 1;
                    }
                    Main.engine.neartag(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, pSprite.ang, Engine.neartag, 1024, 2);
                    int v231 = Sector.feebtag(pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, flags, 768);
                    if (v231 >= 0) {
                        int nSnd = 9;
                        int tintGreen = 16;
                        int tintRed = 0;
                        int pickFlag = 0;
                        boolean magicPickuped = false;
                        int healthPickuped = -65536;
                        short statnum = Engine.sprite[v231].statnum;
                        if (statnum >= 900) {
                            int statBase = Engine.sprite[v231].statnum - 900;
                            switch (statnum - 906) {
                                case 0: {
                                    if (!Weapons.AddAmmo(player, 1, Engine.sprite[v231].hitag)) break;
                                    nSnd = Sound.StaticSound[69];
                                    pickFlag = 3;
                                    break;
                                }
                                case 1: {
                                    if (!Weapons.AddAmmo(player, 3, Engine.sprite[v231].hitag)) break;
                                    nSnd = Sound.StaticSound[69];
                                    pickFlag = 3;
                                    break;
                                }
                                case 2: {
                                    if (!Weapons.AddAmmo(player, 2, Engine.sprite[v231].hitag)) break;
                                    nSnd = Sound.StaticSound[69];
                                    pickFlag = 3;
                                    break;
                                }
                                case 4: 
                                case 9: 
                                case 10: 
                                case 18: 
                                case 25: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 45: 
                                case 52: {
                                    pickFlag = 3;
                                    break;
                                }
                                case 3: 
                                case 21: 
                                case 49: {
                                    if (!Weapons.AddAmmo(player, 4, 1)) break;
                                    nSnd = Sound.StaticSound[69];
                                    if ((Globals.nPlayerWeapons[player] & 0x10) == 0) {
                                        short s = player;
                                        Globals.nPlayerWeapons[s] = (short)(Globals.nPlayerWeapons[s] | 0x10);
                                        Weapons.SetNewWeaponIfBetter(player, 4);
                                    }
                                    if (statBase != 55) {
                                        pickFlag = 3;
                                        break;
                                    }
                                    Engine.sprite[v231].cstat = Short.MIN_VALUE;
                                    Sprites.DestroyItemAnim(v231);
                                    pickFlag = 2;
                                    break;
                                }
                                case 5: {
                                    Map.GrabMap();
                                    pickFlag = 3;
                                    break;
                                }
                                case 6: 
                                case 7: 
                                case 8: {
                                    if (Engine.sprite[v231].hitag == 0) break;
                                    nSnd = 20;
                                    int v123 = 40;
                                    int v115 = 1;
                                    switch (statnum - 906) {
                                        case 7: {
                                            v123 = 160;
                                            v115 = 1;
                                            break;
                                        }
                                        case 8: {
                                            v115 = -1;
                                            v123 = -200;
                                        }
                                    }
                                    if (v123 > 0 && (flags & 2) != 0) break;
                                    if (Globals.PlayerList[player].invisibility == 0 || v123 > 0) {
                                        Globals.PlayerList[player].HealthAmount = (short)(Globals.PlayerList[player].HealthAmount + v123);
                                        healthPickuped = v123;
                                        if (Globals.PlayerList[player].HealthAmount <= 800) {
                                            if (Globals.PlayerList[player].HealthAmount <= 0) {
                                                nSnd = -1;
                                                Seq.StartDeathSeq(player, 0);
                                            }
                                        } else {
                                            Globals.PlayerList[player].HealthAmount = (short)800;
                                        }
                                    }
                                    if (player == Globals.nLocalPlayer) {
                                        View.SetHealthFrame(v115);
                                    }
                                    if (statBase == 12) {
                                        Engine.sprite[v231].hitag = 0;
                                        Engine.sprite[v231].picnum = (short)(Engine.sprite[v231].picnum + 1);
                                        Main.engine.changespritestat((short)v231, 0);
                                        pickFlag = 2;
                                        break;
                                    }
                                    if (statBase == 14) {
                                        tintRed = tintGreen;
                                        tintGreen = 0;
                                        nSnd = 22;
                                    } else {
                                        nSnd = 21;
                                    }
                                    pickFlag = 3;
                                    break;
                                }
                                case 11: {
                                    Globals.PlayerList[player].AirAmount = (short)Gameutils.BClipHigh(Globals.PlayerList[player].AirAmount + 10, 100);
                                    View.SetAirFrame();
                                    if (Globals.nBreathTimer[player] < 89) {
                                        Sound.D3PlayFX(Sound.StaticSound[13], spr);
                                    }
                                    Globals.nBreathTimer[player] = 90;
                                    break;
                                }
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: {
                                    int v130 = 0;
                                    switch (statnum - 906) {
                                        case 13: {
                                            v130 = 1;
                                            break;
                                        }
                                        case 14: {
                                            v130 = 3;
                                            break;
                                        }
                                        case 15: {
                                            v130 = 4;
                                            break;
                                        }
                                        case 16: {
                                            v130 = 2;
                                            break;
                                        }
                                        case 17: {
                                            v130 = 5;
                                        }
                                    }
                                    if (!Sprites.GrabItem(player, v130)) break;
                                    pickFlag = 3;
                                    break;
                                }
                                case 19: {
                                    nSnd = -1;
                                    if (Globals.nPlayerLives[player] >= 5) break;
                                    short s = player;
                                    Globals.nPlayerLives[s] = (short)(Globals.nPlayerLives[s] + 1);
                                    if (player == Globals.nLocalPlayer) {
                                        StatusAnim.BuildStatusAnim(2 * (Globals.nPlayerLives[player] - 1) + 146, 0);
                                    }
                                    tintGreen = 32;
                                    tintRed = 32;
                                    pickFlag = 3;
                                    break;
                                }
                                case 20: 
                                case 22: 
                                case 23: 
                                case 24: 
                                case 26: 
                                case 27: 
                                case 46: 
                                case 47: 
                                case 48: 
                                case 50: 
                                case 51: {
                                    int v251 = 1;
                                    int v136 = 0;
                                    switch (statnum - 906) {
                                        case 20: {
                                            v136 = 0;
                                            v251 = 0;
                                            break;
                                        }
                                        case 22: 
                                        case 46: {
                                            v251 = 1;
                                            v136 = 6;
                                            break;
                                        }
                                        case 23: 
                                        case 47: {
                                            v136 = 24;
                                            v251 = 2;
                                            break;
                                        }
                                        case 24: 
                                        case 48: {
                                            v136 = 100;
                                            v251 = 3;
                                            break;
                                        }
                                        case 26: 
                                        case 50: {
                                            v136 = 20;
                                            v251 = 5;
                                            break;
                                        }
                                        case 27: 
                                        case 51: {
                                            v251 = 6;
                                            v136 = 2;
                                        }
                                    }
                                    int v261 = 1 << v251;
                                    if ((Globals.nPlayerWeapons[player] & 1 << v251) != 0) {
                                        if (Globals.levelnum > 20) {
                                            Weapons.AddAmmo(player, Weapons.weaponInfo[1].field_1A, v136);
                                        }
                                    } else {
                                        Weapons.SetNewWeaponIfBetter(player, v251);
                                        short s = player;
                                        Globals.nPlayerWeapons[s] = (short)(Globals.nPlayerWeapons[s] | v261);
                                        Weapons.AddAmmo(player, Weapons.weaponInfo[v251].field_1A, v136);
                                        nSnd = Sound.StaticSound[72];
                                    }
                                    if (v251 == 2) {
                                        Weapons.CheckClip(player);
                                    }
                                    if (statBase <= 50) {
                                        pickFlag = 3;
                                        break;
                                    }
                                    Engine.sprite[v231].cstat = Short.MIN_VALUE;
                                    Sprites.DestroyItemAnim(v231);
                                    pickFlag = 2;
                                    break;
                                }
                                case 31: {
                                    if (!Weapons.AddAmmo(player, 5, 1)) break;
                                    nSnd = Sound.StaticSound[69];
                                    pickFlag = 3;
                                    break;
                                }
                                case 32: {
                                    if (!Weapons.AddAmmo(player, 6, Engine.sprite[v231].hitag)) break;
                                    nSnd = Sound.StaticSound[69];
                                    pickFlag = 3;
                                    break;
                                }
                                case 39: 
                                case 40: 
                                case 41: 
                                case 42: {
                                    int v140 = 0;
                                    switch (statnum - 906) {
                                        case 39: {
                                            v140 = 0;
                                            break;
                                        }
                                        case 40: {
                                            v140 = 1;
                                            break;
                                        }
                                        case 41: {
                                            v140 = 2;
                                            break;
                                        }
                                        case 42: {
                                            v140 = 3;
                                        }
                                    }
                                    nSnd = -1;
                                    int v115 = v140 != 0 ? 4096 << v140 : 4096;
                                    if ((Globals.PlayerList[player].KeysBitMask & v115) != 0) break;
                                    if (player == Globals.nLocalPlayer) {
                                        StatusAnim.BuildStatusAnim(2 * v140 + 36, Globals.nLocalPlayer ^ player);
                                    }
                                    Globals.PlayerList[player].KeysBitMask = (short)(Globals.PlayerList[player].KeysBitMask | v115);
                                    if (Mmulti.numplayers <= 1) {
                                        pickFlag = 3;
                                        break;
                                    }
                                    pickFlag = 2;
                                    break;
                                }
                                case 43: 
                                case 44: {
                                    if (Globals.PlayerList[player].MagicAmount >= 1000) break;
                                    nSnd = Sound.StaticSound[67];
                                    Globals.PlayerList[player].MagicAmount = (short)Gameutils.BClipHigh(Globals.PlayerList[player].MagicAmount + 100, 1000);
                                    if (player == Globals.nLocalPlayer) {
                                        View.SetMagicFrame();
                                    }
                                    pickFlag = 3;
                                    magicPickuped = true;
                                    break;
                                }
                                case 53: {
                                    if (player == Globals.nLocalPlayer) {
                                        short v144 = Engine.sprite[v231].owner;
                                        Anim.AnimList[v144].nAction = (short)(Anim.AnimList[v144].nAction + 1);
                                        short s = v144;
                                        Anim.AnimFlags[s] = (byte)(Anim.AnimFlags[s] & 0xEF);
                                        Anim.AnimList[v144].nSeq = 0;
                                        Main.engine.changespritestat((short)v231, 899);
                                    }
                                    Player.SetSavePoint(player, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, pSprite.ang);
                                    break;
                                }
                                case 54: {
                                    if (!Globals.bInDemo) {
                                        Map.FinishLevel();
                                    }
                                    Sprites.DestroyItemAnim(v231);
                                    Main.engine.mydeletesprite((short)v231);
                                }
                            }
                            if ((pickFlag & 1) != 0) {
                                if (Globals.levelnum <= 20 || statBase == 25 || statBase == 50) {
                                    Sprites.DestroyItemAnim(v231);
                                    Main.engine.mydeletesprite((short)v231);
                                } else {
                                    Object.StartRegenerate(v231);
                                }
                            }
                            if ((pickFlag & 2) != 0 && player == Globals.nLocalPlayer) {
                                if (Globals.nItemText[statBase] > -1) {
                                    String message = Globals.gString[Globals.nItemText[statBase] + Globals.nItemTextIndex];
                                    if (magicPickuped) {
                                        message = message + " +10%";
                                    } else if (healthPickuped != -65536) {
                                        message = healthPickuped > 0 ? message + " +" : message + " ";
                                        message = message + healthPickuped * 100 / 800 + "%";
                                    }
                                    View.StatusMessage(400, message, player);
                                }
                                Palette.TintPalette(tintRed, tintGreen, 0);
                                if (nSnd > -1) {
                                    Sound.PlayLocalSound(nSnd, 0);
                                }
                            }
                        }
                    }
                    if (Globals.bTouchFloor[0] && Engine.sector[pSprite.sectnum].lotag > 0) {
                        RunList.SignalRun(Engine.sector[pSprite.sectnum].lotag - 1, 0x50000 | player);
                    }
                    if (osectnum != pSprite.sectnum) {
                        if (Engine.sector[osectnum].lotag > 0) {
                            RunList.SignalRun(Engine.sector[osectnum].lotag - 1, 0x70000 | player);
                        }
                        if (Engine.sector[pSprite.sectnum].lotag > 0) {
                            RunList.SignalRun(Engine.sector[pSprite.sectnum].lotag - 1, 0x60000 | player);
                        }
                    }
                    if (Globals.PlayerList[player].mummified != 0) {
                        if ((Globals.sPlayerInput[player].bits & 8) != 0) {
                            Weapons.FireWeapon(player);
                        }
                        if (anim != 15) {
                            next_anim = Globals.totalvel[player] <= 1 ? 13 : 14;
                        }
                    } else {
                        if ((Globals.sPlayerInput[player].bits & 4) != 0) {
                            if (Engine.neartag.tagwall >= 0 && Engine.wall[Engine.neartag.tagwall].lotag > 0) {
                                RunList.SignalRun(Engine.wall[Engine.neartag.tagwall].lotag - 1, 0x40000 | player);
                            }
                            if (Engine.neartag.tagsector >= 0 && Engine.sector[Engine.neartag.tagsector].lotag > 0) {
                                RunList.SignalRun(Engine.sector[Engine.neartag.tagsector].lotag - 1, 0x40000 | player);
                            }
                        }
                        if ((Globals.sPlayerInput[player].bits & 8) != 0) {
                            Weapons.FireWeapon(player);
                        } else {
                            Weapons.StopFiringWeapon(player);
                        }
                        if (Globals.nStandHeight > Engine.sector[pSprite.sectnum].floorz - Engine.sector[pSprite.sectnum].ceilingz) {
                            v233 = true;
                        }
                        if ((Globals.sPlayerInput[player].bits & 1) != 0) {
                            Globals.PlayerList[player].crouch_toggle = false;
                            if (bUnderwater) {
                                pSprite.zvel = (short)-2048;
                                next_anim = 10;
                            } else if (Globals.bTouchFloor[0] && (anim < 6 || anim > 8)) {
                                pSprite.zvel = (short)-3584;
                                next_anim = 3;
                            }
                        } else if ((Globals.sPlayerInput[player].bits & 0x10) != 0) {
                            if (bUnderwater) {
                                pSprite.zvel = (short)2048;
                                next_anim = 10;
                            } else {
                                short elev = Globals.PlayerList[player].eyelevel;
                                if (elev < -8320) {
                                    Globals.PlayerList[player].eyelevel = (short)((-8320 - elev >> 1) + elev);
                                }
                                next_anim = Globals.totalvel[player] >= 1 ? 7 : 6;
                            }
                        } else {
                            if (Globals.PlayerList[player].HealthAmount > 0) {
                                Globals.PlayerList[player].eyelevel = (short)(Globals.PlayerList[player].eyelevel + (nActionEyeLevel[anim] - Globals.PlayerList[player].eyelevel >> 1));
                                next_anim = bUnderwater ? (Globals.totalvel[player] <= 1 ? 9 : 10) : (v233 ? (Globals.totalvel[player] >= 1 ? 7 : 6) : (Globals.totalvel[player] <= 1 ? (bUnderwater ? 1 : 0) : (Globals.totalvel[player] <= 30 ? 2 : 1)));
                            }
                            if (!v233 && (Globals.sPlayerInput[player].bits & 8) != 0) {
                                if (bUnderwater) {
                                    next_anim = 11;
                                } else if (next_anim != 2 && next_anim != 1) {
                                    next_anim = 5;
                                }
                            }
                        }
                        int newWeapon = (Globals.sPlayerInput[player].bits >> 13 & 0xF) - 1;
                        if (newWeapon != -1) {
                            switch (newWeapon) {
                                case 9: {
                                    if ((1 << Globals.PlayerList[player].lastUsedWeapon & Globals.nPlayerWeapons[player]) == 0) break;
                                    Weapons.SetNewWeapon(player, Globals.PlayerList[player].lastUsedWeapon);
                                    break;
                                }
                                case 7: 
                                case 8: {
                                    int weap = Weapons.WeaponChange(player, newWeapon == 8);
                                    Weapons.SetNewWeapon(player, weap);
                                    break;
                                }
                                default: {
                                    if ((1 << newWeapon & Globals.nPlayerWeapons[player]) == 0) break;
                                    Weapons.SetNewWeapon(player, newWeapon);
                                }
                            }
                        }
                    }
                    if (next_anim != anim && anim != 4) {
                        anim = next_anim;
                        Globals.PlayerList[player].anim_ = (short)next_anim;
                        Globals.PlayerList[player].animCount = 0;
                    }
                    if (player == Globals.nLocalPlayer) {
                        int dVertPan;
                        if ((Globals.sPlayerInput[player].bits & 0x20) != 0) {
                            Globals.bLockPan = true;
                            float f = Globals.PlayerList[player].horiz;
                            int n = Globals.isOriginal() ? 180 : 300;
                            if (f >= (float)n) {
                                Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                            } else {
                                Globals.PlayerList[player].horiz += 4.0f;
                                Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                            }
                        } else if ((Globals.sPlayerInput[player].bits & 0x40) != 0) {
                            Globals.bLockPan = true;
                            Globals.bPlayerPan = true;
                            float f = Globals.PlayerList[player].horiz;
                            int n = Globals.isOriginal() ? 0 : -130;
                            if (f > (float)(n + 4)) {
                                Globals.PlayerList[player].horiz -= 4.0f;
                            }
                            Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                        } else if ((Globals.sPlayerInput[player].bits & 0x40000) != 0) {
                            Globals.bLockPan = false;
                            Globals.bPlayerPan = false;
                            float f = Globals.PlayerList[player].horiz;
                            int n = Globals.isOriginal() ? 0 : -130;
                            if (f > (float)(n + 4)) {
                                Globals.PlayerList[player].horiz -= 4.0f;
                            }
                            Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                        } else if ((Globals.sPlayerInput[player].bits & 0x20000) != 0) {
                            Globals.bLockPan = false;
                            Globals.bPlayerPan = false;
                            float f = Globals.PlayerList[player].horiz;
                            int n = Globals.isOriginal() ? 180 : 300;
                            if (f >= (float)n) {
                                Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                            } else {
                                Globals.PlayerList[player].horiz += 4.0f;
                                Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                            }
                        } else if ((Globals.sPlayerInput[player].bits & 0x1000) != 0) {
                            Globals.bLockPan = false;
                            Globals.bPlayerPan = false;
                            Globals.nDestVertPan[player] = 92.0f;
                        }
                        if (Globals.sPlayerInput[player].horiz != 0.0f) {
                            Globals.bLockPan = true;
                            Globals.bPlayerPan = true;
                            Globals.PlayerList[player].horiz = Globals.isOriginal() ? Gameutils.BClipRange(Globals.PlayerList[player].horiz + Globals.sPlayerInput[player].horiz, 0.0f, 180.0f) : Gameutils.BClipRange(Globals.PlayerList[player].horiz + Globals.sPlayerInput[player].horiz, -130.0f, 300.0f);
                            Globals.nDestVertPan[player] = Globals.PlayerList[player].horiz;
                        }
                        Globals.sPlayerInput[player].nWeaponAim = (short)Globals.PlayerList[player].horiz;
                        if (Globals.totalvel[player] > 20) {
                            Globals.bPlayerPan = false;
                        }
                        if ((dVertPan = (int)(Globals.nDestVertPan[player] - Globals.PlayerList[player].horiz)) != 0) {
                            int val = dVertPan / 4;
                            if (Pragmas.klabs(val) >= 4) {
                                if (val >= 4) {
                                    Globals.PlayerList[player].horiz += 4.0f;
                                } else if (val <= -4) {
                                    Globals.PlayerList[player].horiz -= 4.0f;
                                }
                            } else {
                                Globals.PlayerList[player].horiz += (float)dVertPan / 2.0f;
                            }
                        }
                    }
                }
                if (player == Globals.nLocalPlayer) {
                    nLocalEyeSect = Globals.nPlayerViewSect[Globals.nLocalPlayer];
                    Sound.CheckAmbience(nLocalEyeSect);
                }
                int seqBase = Player.ActionSeq[anim].seq + Seq.SeqOffsets[Globals.PlayerList[player].seq];
                Seq.MoveSequence(spr, seqBase, Globals.PlayerList[player].animCount);
                Globals.PlayerList[player].animCount = (short)(Globals.PlayerList[player].animCount + 1);
                if (Globals.PlayerList[player].animCount >= Seq.SeqSize[seqBase]) {
                    Globals.PlayerList[player].animCount = 0;
                    switch (Globals.PlayerList[player].anim_) {
                        case 3: {
                            Globals.PlayerList[player].animCount = (short)(Seq.SeqSize[seqBase] - 1);
                            break;
                        }
                        case 4: {
                            Globals.PlayerList[player].anim_ = 0;
                            break;
                        }
                        case 16: {
                            Globals.PlayerList[player].animCount = (short)(Seq.SeqSize[seqBase] - 1);
                            if (pSprite.z < Engine.sector[pSprite.sectnum].floorz) {
                                pSprite.z += 256;
                            }
                            if (Random.RandomSize(5) != 0) break;
                            int[] out = Sprites.WheresMyMouth(player);
                            Anim.BuildAnim(-1, 71, 0, out[0], out[1], pSprite.z + 3840, out[3], 75, -128);
                            break;
                        }
                        case 17: {
                            Globals.PlayerList[player].anim_ = (short)18;
                            break;
                        }
                        case 19: {
                            pSprite.cstat = (short)(pSprite.cstat | 0x8000);
                            Globals.PlayerList[player].anim_ = (short)20;
                        }
                    }
                }
                if (player == Globals.nLocalPlayer) {
                    Globals.initx = pSprite.x;
                    Globals.inity = pSprite.y;
                    Globals.initz = pSprite.z;
                    Globals.initsect = pSprite.sectnum;
                    Globals.inita = pSprite.ang;
                }
                if (Globals.PlayerList[player].HealthAmount == 0) {
                    Globals.nYDamage[player] = 0;
                    Globals.nXDamage[player] = 0;
                    if (Globals.PlayerList[player].eyelevel >= -2816) {
                        Globals.PlayerList[player].eyelevel = (short)-2816;
                        Globals.dVertPan[player] = 0;
                    } else if (Globals.PlayerList[player].horiz >= 92.0f) {
                        Globals.PlayerList[player].horiz += (float)Globals.dVertPan[player];
                        if (Globals.PlayerList[player].horiz < 200.0f) {
                            if (Globals.PlayerList[player].horiz <= 92.0f && (Globals.SectFlag[pSprite.sectnum] & 0x2000) == 0) {
                                Weapons.SetNewWeapon(player, Globals.nDeathType[player] + 8);
                            }
                        } else {
                            Globals.PlayerList[player].horiz = 199.0f;
                        }
                        short s = player;
                        Globals.dVertPan[s] = (short)(Globals.dVertPan[s] - 1);
                    } else {
                        Globals.PlayerList[player].horiz = 91.0f;
                        Globals.PlayerList[player].eyelevel = (short)(Globals.PlayerList[player].eyelevel - (Globals.dVertPan[player] << 8));
                    }
                }
                pDSprite.x = pSprite.x;
                pDSprite.y = pSprite.y;
                pDSprite.z = pSprite.z;
                if (Globals.SectAbove[pSprite.sectnum] <= -1) {
                    pDSprite.cstat = Short.MIN_VALUE;
                } else {
                    pDSprite.ang = pSprite.ang;
                    Main.engine.mychangespritesect(dspr, Globals.SectAbove[pSprite.sectnum]);
                    pDSprite.cstat = (short)257;
                }
                Weapons.MoveWeapons(player);
                return;
            }
            case 589824: {
                Seq.PlotSequence((short)(a1 & 0xFFFF), Player.ActionSeq[anim].seq + Seq.SeqOffsets[Globals.PlayerList[player].seq], Globals.PlayerList[player].animCount, Player.ActionSeq[anim].a2 ? 1 : 0);
                return;
            }
            case 524288: {
                if (a2 == 0) {
                    return;
                }
                v229 = (short)(a1 & 0xFFFF);
                break;
            }
            case 655360: {
                if (Globals.PlayerList[player].HealthAmount <= 0) break;
                a2 = Sprites.CheckRadialDamage(spr);
                if (a2 == 0) {
                    return;
                }
                v229 = (short)Globals.nRadialOwner;
                break;
            }
            default: {
                return;
            }
        }
        if (Globals.PlayerList[player].HealthAmount != 0) {
            if (Globals.PlayerList[player].invisibility == 0) {
                Globals.PlayerList[player].HealthAmount = (short)(Globals.PlayerList[player].HealthAmount - a2);
                if (player == Globals.nLocalPlayer) {
                    Palette.TintPalette(a2 >> 2, 0, 0);
                    View.SetHealthFrame(-1);
                }
            }
            if (Globals.PlayerList[player].HealthAmount > 0) {
                if ((a2 > 40 || (Globals.totalmoves & 0xF) < 2) && Globals.PlayerList[player].invisibility == 0) {
                    if ((Globals.SectFlag[pSprite.sectnum] & 0x2000) != 0) {
                        if (anim != 12) {
                            Globals.PlayerList[player].animCount = 0;
                            Globals.PlayerList[player].anim_ = (short)12;
                        }
                    } else if (anim != 4) {
                        Globals.PlayerList[player].animCount = 0;
                        Globals.PlayerList[player].anim_ = (short)4;
                        if (v229 > -1) {
                            short s = player;
                            Globals.nPlayerSwear[s] = (short)(Globals.nPlayerSwear[s] - 1);
                            if (Globals.nPlayerSwear[player] <= 0) {
                                Sound.D3PlayFX(Sound.StaticSound[52], dspr);
                                Globals.nPlayerSwear[player] = (short)(Random.RandomSize(3) + 4);
                            }
                        }
                    }
                }
            } else {
                int deathType;
                if (v229 < 0) {
                    short s = player;
                    Globals.nPlayerScore[s] = (short)(Globals.nPlayerScore[s] - 1);
                }
                if ((a1 & 0x7F0000) == 655360) {
                    for (int i = 122; i <= 131; ++i) {
                        Sprites.BuildCreatureChunk(spr, Seq.GetSeqPicnum(25, i, 0));
                    }
                    deathType = 1;
                } else {
                    deathType = 0;
                }
                Seq.StartDeathSeq(player, deathType);
            }
        }
    }

    public static void RestorePlayer(final short player) {
        BuildGdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                if (Globals.nNetPlayerCount == 0 && Globals.lastlevel == Globals.levelnum) {
                    Player.RestoreSavePoint(player);
                    Player.RestartPlayer(player);
                    Player.InitPlayerKeys(player);
                }
            }
        });
    }

    public static void SetCounter(int value) {
        if (value <= 999) {
            if (value < 0) {
                value = 0;
            }
        } else {
            value = 999;
        }
        Globals.nCounterDest = value;
    }

    public static void SetPlayerMummified(int nPlayer, int mummified) {
        Globals.PlayerList[nPlayer].mummified = (short)mummified;
        short nSprite = Globals.PlayerList[nPlayer].spriteId;
        if (nSprite != -1 && Engine.sprite[nSprite] != null) {
            Engine.sprite[nSprite].xvel = 0;
            Engine.sprite[nSprite].yvel = 0;
        }
        if (mummified != 0) {
            Globals.PlayerList[nPlayer].anim_ = (short)13;
            Globals.PlayerList[nPlayer].seq = (short)10;
        } else {
            Globals.PlayerList[nPlayer].anim_ = 0;
            Globals.PlayerList[nPlayer].seq = (short)25;
        }
        Globals.PlayerList[nPlayer].animCount = 0;
    }

    public static void SetCounterImmediate(int a1) {
        Player.SetCounter(a1);
        Globals.nCounter = Globals.nCounterDest;
        Player.SetCounterDigits();
    }

    public static void SetCounterDigits() {
        View.nDigit[2] = 3 * (Globals.nCounter / 100 % 10);
        View.nDigit[1] = 3 * (Globals.nCounter / 10 % 10);
        View.nDigit[0] = 3 * (Globals.nCounter % 10);
    }

    public static void UseItem(int nPlayer, int nItem) {
        switch (nItem) {
            case 4: {
                Player.UseEye(nPlayer);
                break;
            }
            case 5: {
                Player.UseMask(nPlayer);
                break;
            }
            case 0: {
                Player.UseHeart(nPlayer);
                break;
            }
            case 2: {
                Light.UseTorch(nPlayer);
                break;
            }
            case 1: {
                Player.UseScarab(nPlayer);
                break;
            }
            case 3: {
                Player.UseHand(nPlayer);
            }
        }
        int n = nItem;
        byte by = (byte)(Globals.PlayerList[nPlayer].ItemsAmount[n] - 1);
        Globals.PlayerList[nPlayer].ItemsAmount[n] = by;
        byte amount = by;
        if (nPlayer == Globals.nLocalPlayer) {
            StatusAnim.BuildStatusAnim(2 * amount + 156, Globals.nLocalPlayer ^ nPlayer);
        }
        int i = nItem;
        if (amount == 0) {
            for (i = 0; i != 6 && Globals.PlayerList[nPlayer].ItemsAmount[i] <= 0; ++i) {
            }
            if (i == 6) {
                i = -1;
            }
        }
        Globals.PlayerList[nPlayer].MagicAmount = (short)(Globals.PlayerList[nPlayer].MagicAmount - Globals.nItemMagic[nItem]);
        Player.SetPlayerItem(nPlayer, i);
        if (nPlayer == Globals.nLocalPlayer) {
            View.SetMagicFrame();
        }
    }

    public static void UseEye(int nPlayer) {
        short nSprite = Globals.PlayerList[nPlayer].spriteId;
        if (Globals.nPlayerInvisible[nPlayer] >= 0) {
            Globals.nPlayerInvisible[nPlayer] = 900;
        }
        Engine.sprite[nSprite].cstat = (short)(Engine.sprite[nSprite].cstat | 0x8000);
        short nFloorSpr = Globals.nPlayerFloorSprite[nPlayer];
        if (nFloorSpr > -1) {
            Engine.sprite[nFloorSpr].cstat = (short)(Engine.sprite[nFloorSpr].cstat | 0x8000);
        }
        if (nPlayer == Globals.nLocalPlayer) {
            Player.ItemFlash();
            Sound.D3PlayFX(Sound.StaticSound[31], nSprite);
        }
    }

    public static void UseMask(int nPlayer) {
        Globals.PlayerList[nPlayer].AirMaskAmount = (short)1350;
        Globals.PlayerList[nPlayer].AirAmount = (short)100;
        if (nPlayer == Globals.nLocalPlayer) {
            View.SetAirFrame();
            Sound.D3PlayFX(Sound.StaticSound[31], Globals.PlayerList[nPlayer].spriteId);
        }
    }

    public static void UseHeart(int nPlayer) {
        if (Globals.PlayerList[nPlayer].HealthAmount < 800) {
            Globals.PlayerList[nPlayer].HealthAmount = (short)800;
        }
        if (nPlayer == Globals.nLocalPlayer) {
            Player.ItemFlash();
            View.SetHealthFrame(1);
            Sound.D3PlayFX(Sound.StaticSound[31], Globals.PlayerList[nPlayer].spriteId);
        }
    }

    public static void UseScarab(int nPlayer) {
        if (Globals.PlayerList[nPlayer].invisibility < 900) {
            Globals.PlayerList[nPlayer].invisibility = (short)900;
        }
        if (nPlayer == Globals.nLocalPlayer) {
            Player.ItemFlash();
            Sound.D3PlayFX(Sound.StaticSound[31], Globals.PlayerList[nPlayer].spriteId);
        }
    }

    public static void UseHand(int nPlayer) {
        Globals.nPlayerDouble[nPlayer] = 1350;
        if (nPlayer == Globals.nLocalPlayer) {
            Player.ItemFlash();
            Sound.D3PlayFX(Sound.StaticSound[31], Globals.PlayerList[nPlayer].spriteId);
        }
    }

    public static void UseCurItem(int nPlayer, int nItem) {
        if (nItem >= 0 && Globals.PlayerList[nPlayer].ItemsAmount[nItem] > 0 && Globals.nItemMagic[nItem] <= Globals.PlayerList[nPlayer].MagicAmount) {
            Globals.sPlayerInput[nPlayer].field_F = (byte)nItem;
            System.err.println("Use item " + nItem);
        }
    }

    public static void SetNextItem(int a1) {
        int nNextItem;
        int nItem = Globals.nPlayerItem[a1];
        for (nNextItem = 6; nNextItem > 0; --nNextItem) {
            if (++nItem == 6) {
                nItem = 0;
            }
            if (Globals.PlayerList[a1].ItemsAmount[nItem] != 0) break;
        }
        if (nNextItem > 0) {
            Player.SetPlayerItem(a1, nItem);
        }
    }

    public static void SetPrevItem(int a1) {
        int nNextItem;
        int nItem = Globals.nPlayerItem[a1];
        if (nItem == -1) {
            return;
        }
        for (nNextItem = 6; nNextItem > 0; --nNextItem) {
            if (--nItem < 0) {
                nItem = 5;
            }
            if (Globals.PlayerList[a1].ItemsAmount[nItem] != 0) break;
        }
        if (nNextItem > 0) {
            Player.SetPlayerItem(a1, nItem);
        }
    }

    public static void ItemFlash() {
        Palette.TintPalette(4, 4, 4);
    }

    public static void FillItems(int nPlayer) {
        for (int i = 0; i < 6; ++i) {
            Globals.PlayerList[nPlayer].ItemsAmount[i] = 5;
        }
        Globals.PlayerList[nPlayer].MagicAmount = (short)1000;
        if (nPlayer == Globals.nLocalPlayer) {
            Player.ItemFlash();
            View.SetMagicFrame();
        }
        if (Globals.nPlayerItem[nPlayer] == -1) {
            Player.SetPlayerItem(nPlayer, 0);
        }
        View.StatusMessage(750, "All items loaded for player " + nPlayer, Globals.nLocalPlayer);
    }

    public static void PlayAlert(String message, int nPlayer) {
        View.StatusMessage(300, message, nPlayer);
        Sound.PlayLocalSound(Sound.StaticSound[63], 0);
    }

    static {
        sPlayerSave = new PlayerSave[8];
    }

    public static class Action {
        public short seq;
        boolean a2;

        public Action(int seq, boolean a2) {
            this.seq = (short)seq;
            this.a2 = a2;
        }
    }
}

