/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import com.badlogic.gdx.math.Vector2;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Object;
import ru.m210projects.Powerslave.Palette;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Switch;
import ru.m210projects.Powerslave.Type.BlockInfo;
import ru.m210projects.Powerslave.Type.MoveSectStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Type.TrailPointStruct;
import ru.m210projects.Powerslave.View;

public class Sector {
    public static int overridesect;
    public static short[] NearSector;
    public static int NearCount;
    public static int LinkCount;
    public static byte[][] LinkMap;
    private static Vector2 tmpVec;

    public static Vector2 MoveSector(int nObject, int angle, int xvec, int yvec) {
        if (nObject != -1) {
            SPRITE pSprite;
            short i;
            int block_y;
            int block_x;
            int v4;
            int v5;
            if (angle < 0) {
                v5 = yvec;
                v4 = xvec;
                angle = Main.engine.GetMyAngle(xvec, yvec);
            } else {
                v4 = Engine.sintable[angle + 512 & 0x7FF] << 6;
                v5 = Engine.sintable[angle & 0x7FF] << 6;
            }
            SECTOR v7 = Engine.sector[nObject];
            int v53 = v7.floorz;
            int flags = Globals.SectFlag[nObject] & 0x2000;
            BlockInfo bInfo = Globals.sBlockInfo[Engine.sector[nObject].extra];
            int oldx = block_x = bInfo.cx;
            int oldy = block_y = bInfo.cy;
            short nSector = (short)nObject;
            short nNextSector = Engine.wall[v7.wallptr].nextsector;
            int v45 = 0;
            int v54 = 0;
            if (flags != 0) {
                v54 = v7.ceilingz;
                v45 = Engine.sector[nNextSector].ceilingz + 256;
                v7.ceilingz = Engine.sector[nNextSector].ceilingz;
            } else {
                v54 = v7.floorz;
                v45 = Engine.sector[nNextSector].floorz - 256;
                v7.floorz = Engine.sector[nNextSector].floorz;
            }
            Main.engine.clipmove(block_x, block_y, v45, nSector, v4, v5, bInfo.field_8, 0, 0, 0x1000040);
            if (Engine.clipmove_sectnum > -1) {
                block_x = Engine.clipmove_x;
                block_y = Engine.clipmove_y;
                nSector = Engine.clipmove_sectnum;
            }
            int dx = block_x - oldx;
            int dy = block_y - oldy;
            if (nSector == nNextSector || nSector == nObject) {
                if (flags == 0) {
                    block_x = oldx;
                    block_y = oldy;
                    Main.engine.clipmove(block_x, block_y, v54, nSector, v4, v5, bInfo.field_8, 0, 0, 0x1000040);
                    if (Engine.clipmove_sectnum > -1) {
                        block_x = Engine.clipmove_x;
                        block_y = Engine.clipmove_y;
                        nSector = Engine.clipmove_sectnum;
                    }
                    if (Pragmas.klabs(dx) > Pragmas.klabs(block_x - oldx)) {
                        dx = block_x - oldx;
                    }
                    if (Pragmas.klabs(dy) > Pragmas.klabs(block_y - oldy)) {
                        dy = block_y - oldy;
                    }
                }
            } else {
                dx = 0;
                dy = 0;
            }
            if ((dx | dy) != 0) {
                i = Engine.headspritesect[nObject];
                while (i != -1) {
                    pSprite = Engine.sprite[i];
                    Main.game.pInt.setsprinterpolate(i, pSprite);
                    if (pSprite.statnum >= 99) {
                        if (flags != 0 || pSprite.z != v54 || (pSprite.cstat & 0x8000) != 0) {
                            block_x = pSprite.x;
                            block_y = pSprite.y;
                            nSector = (short)nObject;
                            Main.engine.clipmove(block_x, block_y, pSprite.z, nSector, -dx, -dy, 4 * pSprite.clipdist, 0, 0, 65537);
                            if (Engine.clipmove_sectnum > -1) {
                                block_x = Engine.clipmove_x;
                                block_y = Engine.clipmove_y;
                                pSprite.z = Engine.clipmove_z;
                                nSector = Engine.clipmove_sectnum;
                            }
                            if (nSector >= 0 && nSector < 1024 && nSector != nObject) {
                                Main.engine.mychangespritesect(i, nSector);
                            }
                        }
                    } else {
                        pSprite.x += dx;
                        pSprite.y += dy;
                    }
                    i = Engine.nextspritesect[i];
                }
                i = Engine.headspritesect[nNextSector];
                while (i != -1) {
                    pSprite = Engine.sprite[i];
                    if (pSprite.statnum >= 99) {
                        block_x = pSprite.x;
                        block_y = pSprite.y;
                        nSector = nNextSector;
                        int dist = 4 * pSprite.clipdist;
                        Main.engine.clipmove(block_x, block_y, pSprite.z, nSector, -dx - Engine.sintable[angle + 512 & 0x7FF] * dist, -dy - Engine.sintable[angle] * dist, dist, 0, 0, 65537);
                        if (Engine.clipmove_sectnum > -1) {
                            block_x = Engine.clipmove_x;
                            block_y = Engine.clipmove_y;
                            pSprite.z = Engine.clipmove_z;
                            nSector = Engine.clipmove_sectnum;
                        }
                        if (nSector != nNextSector && (nSector == nObject || nNextSector == nObject)) {
                            if (nSector != nObject || v53 >= pSprite.z) {
                                if (nSector >= 0 && nSector < 1024) {
                                    Main.engine.mychangespritesect(i, nSector);
                                }
                            } else {
                                Main.engine.movesprite(i, (dx << 14) + Engine.sintable[angle + 512 & 0x7FF] * pSprite.clipdist, (dy << 14) + pSprite.clipdist * Engine.sintable[angle], 0, 0, 0, 0);
                            }
                        }
                    }
                    i = Engine.nextspritesect[i];
                }
                for (i = v7.wallptr; i < v7.wallptr + v7.wallnum; i = (short)(i + 1)) {
                    Main.engine.dragpoint(i, dx + Engine.wall[i].x, dy + Engine.wall[i].y);
                }
                bInfo.cx += dx;
                bInfo.cy += dy;
            }
            dx <<= 14;
            dy <<= 14;
            if (flags == 0) {
                i = Engine.headspritesect[nObject];
                while (i != -1) {
                    pSprite = Engine.sprite[i];
                    if (pSprite.statnum >= 99 && v54 == pSprite.z && (pSprite.cstat & 0x8000) == 0) {
                        nSector = (short)nObject;
                        Main.game.pInt.setsprinterpolate(i, pSprite);
                        Main.engine.clipmove(pSprite.x, pSprite.y, pSprite.z, nSector, dx, dy, 4 * pSprite.clipdist, 5120, -5120, 65537);
                        if (Engine.clipmove_sectnum > -1) {
                            pSprite.x = Engine.clipmove_x;
                            pSprite.y = Engine.clipmove_y;
                            pSprite.z = Engine.clipmove_z;
                            nSector = Engine.clipmove_sectnum;
                        }
                    }
                    i = Engine.nextspritesect[i];
                }
            }
            if (flags != 0) {
                v7.ceilingz = v54;
            } else {
                v7.floorz = v54;
            }
            tmpVec.set(dx, dy);
        } else {
            tmpVec.set(xvec, yvec);
        }
        return tmpVec;
    }

    public static int feebtag(int x, int y, int z, int sectnum, int a6, int dist) {
        int out = -1;
        int sec = sectnum;
        for (int i = Engine.sector[sectnum].wallptr; i < Engine.sector[sectnum].wallptr + Engine.sector[sectnum].wallnum; ++i) {
            if (sec != -1) {
                int nSprite = Engine.headspritesect[sec];
                while (nSprite >= 0) {
                    SPRITE pSprite = Engine.sprite[nSprite];
                    if (pSprite.statnum >= 900 && (pSprite.cstat & 0x8000) == 0) {
                        int v15;
                        int v11 = pSprite.x - x;
                        int v14 = pSprite.y - y;
                        int v13 = pSprite.z - z;
                        if (v13 < 5120 && v13 > -25600 && (v15 = Main.engine.ksqrt(v14 * v14 + v11 * v11)) < dist && (pSprite.statnum != 950 && pSprite.statnum != 949 || (a6 & 1) == 0) && (pSprite.statnum != 912 && pSprite.statnum != 913 || (a6 & 2) == 0)) {
                            dist = v15;
                            out = nSprite;
                        }
                    }
                    nSprite = Engine.nextspritesect[nSprite];
                }
            }
            sec = Engine.wall[i].nextsector;
        }
        return out;
    }

    public static void DoMovingSects() {
        for (int i = 0; i < Globals.nMoveSects; ++i) {
            short v2;
            MoveSectStruct v0 = Globals.sMoveSect[i];
            if (v0.field_0 == -1 || (v2 = v0.field_E) != -1 && RunList.channel[v2].field_4 == 0) continue;
            BlockInfo v3 = Globals.sBlockInfo[Engine.sector[v0.field_0].extra];
            if (v0.field_4 == -1) {
                int v5;
                short v4 = v0.field_6;
                if ((v4 & 0x20) != 0) {
                    RunList.ChangeChannel(v0.field_E, 0);
                }
                if ((v5 = v4 & 0x10) != 0) {
                    Globals.sMoveDir[i] = -Globals.sMoveDir[i];
                    v0.field_4 = Globals.sMoveDir[i] <= 0 ? Globals.sTrail[v0.field_2].field_4 : Globals.sTrail[v0.field_2].field_0;
                } else {
                    v0.field_4 = Globals.sTrail[v0.field_2].field_0;
                }
            }
            TrailPointStruct v9 = Globals.sTrailPoint[v0.field_4];
            int dx = v9.x - v3.cx;
            int dy = v9.y - v3.cy;
            int ang = Main.engine.GetMyAngle(dx, dy) & 0x7FF;
            int v29 = 16 * Engine.sintable[ang] * v0.field_A;
            int v30 = 16 * Engine.sintable[ang + 512 & 0x7FF] * v0.field_A;
            int v16 = dx << 14;
            int v20 = dy << 14;
            if (Pragmas.klabs(v30) > Pragmas.klabs(v16) || Pragmas.klabs(v29) > Pragmas.klabs(v20)) {
                v29 = v20;
                v30 = v16;
                v0.field_4 = Globals.sMoveDir[i] <= 0 ? Globals.nTrailPointPrev[v0.field_4] : Globals.nTrailPointNext[v0.field_4];
            }
            if (v0.field_8 != -1) {
                Vector2 vec = Sector.MoveSector(v0.field_8, -1, v30, v29);
                v30 = (int)vec.x;
                v29 = (int)vec.y;
            }
            int v28 = v30;
            int v27 = v29;
            Vector2 vec = Sector.MoveSector(v0.field_0, -1, v30, v29);
            v30 = (int)vec.x;
            v29 = (int)vec.y;
            if (v30 == v28 && v29 == v27) continue;
            Sector.MoveSector(v0.field_8, -1, v28, v27);
            Sector.MoveSector(v0.field_8, -1, v30, v29);
        }
    }

    public static Vector2 CheckSectorFloor(int nSector, int z, int dx, int dy) {
        tmpVec.set(dx, dy);
        if (Globals.SectSpeed[nSector] != 0) {
            int v10 = Globals.SectFlag[nSector] & 0x7FF;
            if (z >= Engine.sector[nSector].floorz) {
                Sector.tmpVec.x += (float)(Globals.SectSpeed[nSector] * 8 * Engine.sintable[v10 + 512 & 0x7FF]);
                Sector.tmpVec.y += (float)(Globals.SectSpeed[nSector] * 8 * Engine.sintable[v10 & 0x7FF]);
            } else {
                if ((Globals.SectFlag[nSector] & 0x800) == 0) {
                    return tmpVec;
                }
                Sector.tmpVec.x += (float)(Globals.SectSpeed[nSector] * 16 * Engine.sintable[v10 + 512 & 0x7FF]);
                Sector.tmpVec.y += (float)(Globals.SectSpeed[nSector] * 16 * Engine.sintable[v10 & 0x7FF]);
            }
        }
        return tmpVec;
    }

    public static ByteBuffer saveSecExtra() {
        ByteBuffer bb = ByteBuffer.allocate(16384);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < 1024; ++i) {
            bb.putShort(Globals.SectSoundSect[i]);
            bb.putShort(Globals.SectSound[i]);
            bb.putShort(Globals.SectAbove[i]);
            bb.putShort(Globals.SectBelow[i]);
            bb.putShort(Globals.SectDepth[i]);
            bb.putShort(Globals.SectFlag[i]);
            bb.putShort(Globals.SectSpeed[i]);
            bb.putShort(Globals.SectDamage[i]);
        }
        return bb;
    }

    public static void loadSecExtra(SafeLoader loader, Resource bb) {
        if (bb != null) {
            for (int i = 0; i < 1024; ++i) {
                loader.SectSoundSect[i] = bb.readShort();
                loader.SectSound[i] = bb.readShort();
                loader.SectAbove[i] = bb.readShort();
                loader.SectBelow[i] = bb.readShort();
                loader.SectDepth[i] = bb.readShort();
                loader.SectFlag[i] = bb.readShort();
                loader.SectSpeed[i] = bb.readShort();
                loader.SectDamage[i] = bb.readShort();
            }
        } else {
            System.arraycopy(loader.SectSoundSect, 0, Globals.SectSoundSect, 0, 1024);
            System.arraycopy(loader.SectSound, 0, Globals.SectSound, 0, 1024);
            System.arraycopy(loader.SectAbove, 0, Globals.SectAbove, 0, 1024);
            System.arraycopy(loader.SectBelow, 0, Globals.SectBelow, 0, 1024);
            System.arraycopy(loader.SectDepth, 0, Globals.SectDepth, 0, 1024);
            System.arraycopy(loader.SectFlag, 0, Globals.SectFlag, 0, 1024);
            System.arraycopy(loader.SectSpeed, 0, Globals.SectSpeed, 0, 1024);
            System.arraycopy(loader.SectDamage, 0, Globals.SectDamage, 0, 1024);
        }
    }

    public static void SnapSectors(int a1, int a2, int a3) {
        int v20 = a1;
        int v19 = a2;
        int v18 = a3;
        SECTOR v3 = Engine.sector[a1];
        SECTOR v4 = Engine.sector[v19];
        int v29 = v3.wallnum;
        int v30 = v4.wallnum;
        int i = 0;
        while (i < v29) {
            int v5 = v4.wallptr;
            int v6 = 0x7FFFFFF;
            int v7 = v3.wallptr;
            int j = 0;
            int v9 = 0x7FFFFFF;
            int v26 = Engine.wall[v7].x;
            int v24 = Engine.wall[v7].y;
            int v31 = 0;
            while (j < v30) {
                int v11 = v26 - Engine.wall[v5].x;
                int v12 = v24 - Engine.wall[v5].y;
                int v13 = v26 - Engine.wall[v5].x;
                if (v13 < 0) {
                    v13 = -v13;
                }
                int v22 = v13;
                int v14 = v12;
                if (v12 < 0) {
                    v14 = -v12;
                }
                int v23 = v14 + v22;
                int v15 = v6;
                if (v6 < 0) {
                    v15 = -v6;
                }
                int v21 = v15;
                int v16 = v9;
                if (v9 < 0) {
                    v16 = -v9;
                }
                if (v23 < v16 + v21) {
                    v31 = v5;
                    v6 = v11;
                    v9 = v12;
                }
                ++j;
                ++v5;
            }
            ++i;
            ++v7;
            Main.engine.dragpoint((short)v31, v6 + Engine.wall[v31].x, v9 + Engine.wall[v31].y);
        }
        if (v18 != 0) {
            Engine.sector[v19].ceilingz = Engine.sector[v20].floorz;
        }
        if ((Globals.SectFlag[v20] & 0x1000) != 0) {
            Map.SnapBobs(v20, v19);
        }
    }

    public static int FindWallSprites(int a1) {
        int miny = Integer.MAX_VALUE;
        int maxy = -2147483646;
        int nwall = Engine.sector[a1].wallptr;
        int minx = Integer.MAX_VALUE;
        int wallnum = Engine.sector[a1].wallnum;
        int maxx = -2147483646;
        for (int i = 0; i < wallnum; ++i) {
            if (minx > Engine.wall[nwall].x) {
                minx = Engine.wall[nwall].x;
            }
            if (maxx < Engine.wall[nwall].x) {
                maxx = Engine.wall[nwall].x;
            }
            if (miny > Engine.wall[nwall].y) {
                miny = Engine.wall[nwall].y;
            }
            if (maxy < Engine.wall[nwall].y) {
                maxy = Engine.wall[nwall].y;
            }
            ++nwall;
        }
        int x1 = minx - 5;
        int y1 = miny - 5;
        int x2 = maxx + 5;
        int y2 = maxy + 5;
        int spr = -1;
        for (int i = 0; i < 4096; ++i) {
            if (Engine.sprite[i].lotag != 0 || (Engine.sprite[i].cstat & 0x50) != 80 || Engine.sprite[i].x < x1 || x2 < Engine.sprite[i].x || Engine.sprite[i].y < y1 || Engine.sprite[i].y > y2) continue;
            Engine.sprite[i].owner = (short)spr;
            spr = (short)i;
        }
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)a1, 401);
            Engine.sprite[spr].x = (x2 + x1) / 2;
            Engine.sprite[spr].y = (y2 + y1) / 2;
            Engine.sprite[spr].z = Engine.sector[a1].floorz;
            Engine.sprite[spr].cstat = Short.MIN_VALUE;
            Engine.sprite[spr].owner = (short)-1;
            Engine.sprite[spr].lotag = 0;
            Engine.sprite[spr].hitag = 0;
        }
        return spr;
    }

    public static int BuildLink(int a1, int ... a2) {
        int v2 = -1;
        if (LinkCount > 0) {
            v2 = --LinkCount;
            for (int v3 = 0; v3 < 8; ++v3) {
                int v5 = -1;
                if (v3 < a1) {
                    v5 = a2[v3];
                }
                Sector.LinkMap[v2][v3] = (byte)v5;
            }
        }
        return v2;
    }

    public static ByteBuffer saveLinks() {
        ByteBuffer bb = ByteBuffer.allocate(8194);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)LinkCount);
        for (int i = 0; i < 1024; ++i) {
            for (int j = 0; j < 8; ++j) {
                bb.put(LinkMap[i][j]);
            }
        }
        return bb;
    }

    public static void loadLinks(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.LinkCount = bb.readShort().shortValue();
            for (int i = 0; i < 1024; ++i) {
                for (int j = 0; j < 8; ++j) {
                    loader.LinkMap[i][j] = bb.readByte();
                }
            }
        } else {
            LinkCount = loader.LinkCount;
            for (int i = 0; i < 1024; ++i) {
                System.arraycopy(loader.LinkMap[i], 0, LinkMap[i], 0, 8);
            }
        }
    }

    public static void ProcessSectorTag(short nSector, int nLotag, int nHitag) {
        int nNext = -1;
        int nChannel = RunList.AllocChannel(nHitag % 1000);
        int[] v263 = new int[8];
        int var_24 = nHitag / 1000 << 12;
        int v269 = 4 * Gameutils.BClipLow(nLotag / 1000, 1);
        int v270 = 100 * v269;
        switch (nLotag % 1000 - 1) {
            case 0: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].ceilingz, -1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].ceilingz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, Sector.BuildLink(1, 1), nSector, var_24));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 60));
                break;
            }
            case 1: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].ceilingz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, Sector.BuildLink(1, 1), nSector, var_24));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 60));
                break;
            }
            case 4: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz + 1, -1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].ceilingz));
                break;
            }
            case 5: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), 400, 400, 2, Engine.sector[nNext].floorz, Engine.sector[nSector].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, Sector.BuildLink(2, 1, 1), nSector));
                Engine.sector[nSector].floorz = Engine.sector[nNext].floorz;
                return;
            }
            case 6: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, Sector.BuildLink(1, 1), nSector));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwNotOnPause(nChannel, Sector.BuildLink(2, -1, 0), nSector, 8));
                break;
            }
            case 7: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz + 1, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                break;
            }
            case 8: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 150));
                break;
            }
            case 9: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, Sector.BuildLink(1, 1), nSector));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwNotOnPause(nChannel, Sector.BuildLink(2, -1, 0), nSector, 8));
                break;
            }
            case 10: 
            case 13: 
            case 37: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                break;
            }
            case 11: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 150));
                break;
            }
            case 12: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwReady(nChannel, Sector.BuildLink(2, 1, 0)));
                break;
            }
            case 14: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                break;
            }
            case 15: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), 200, v270, 2, Engine.sector[nSector].ceilingz, Engine.sector[nSector].floorz - 8));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, Sector.BuildLink(1, 1), nSector));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwReady(nChannel, Sector.BuildLink(2, -1, 0)));
                break;
            }
            case 16: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), 200, v270, 2, Engine.sector[nSector].ceilingz, Engine.sector[nSector].floorz - 8));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwReady(nChannel, Sector.BuildLink(2, -1, 0)));
                break;
            }
            case 17: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), 200, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nSector].ceilingz + (Engine.sector[nSector].floorz - Engine.sector[nSector].ceilingz) / 2));
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), 200, v270, 2, Engine.sector[nSector].ceilingz, (Engine.sector[nSector].floorz - Engine.sector[nSector].ceilingz) / 2 + Engine.sector[nSector].ceilingz - 8));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, Sector.BuildLink(1, 1), nSector));
                break;
            }
            case 20: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, Sector.BuildLink(2, 1, 1), nSector));
                break;
            }
            case 23: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].ceilingz, -1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].ceilingz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 60));
                break;
            }
            case 24: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 300));
                break;
            }
            case 25: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 450));
                break;
            }
            case 26: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 600));
                break;
            }
            case 27: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 900));
                break;
            }
            case 30: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), Short.MAX_VALUE, Short.MAX_VALUE, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, Sector.BuildLink(1, 1), nSector));
                break;
            }
            case 31: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), Short.MAX_VALUE, Short.MAX_VALUE, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                break;
            }
            case 32: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].ceilingz, -1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(20, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nNext].ceilingz, Engine.sector[nSector].floorz));
                break;
            }
            case 33: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].ceilingz, -1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(28, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nNext].ceilingz, Engine.sector[nSector].floorz));
                break;
            }
            case 34: 
            case 35: {
                ++Globals.nEnergyTowers;
                int i = Sector.BuildEnergyBlock(nSector);
                if (nLotag == 36) {
                    Globals.nFinaleSpr = i;
                }
                return;
            }
            case 36: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                break;
            }
            case 38: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), Short.MAX_VALUE, Short.MAX_VALUE, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, Sector.BuildLink(1, 1), nSector));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwNotOnPause(nChannel, Sector.BuildLink(2, -1, 0), nSector, 8));
                break;
            }
            case 39: {
                Sector.AddMovingSector(nSector, nLotag, nHitag % 1000, 2);
                return;
            }
            case 40: {
                Sector.AddMovingSector(nSector, nLotag, nHitag % 1000, 18);
                return;
            }
            case 41: {
                Sector.AddMovingSector(nSector, nLotag, nHitag % 1000, 58);
                return;
            }
            case 42: {
                Sector.AddMovingSector(nSector, nLotag, nHitag % 1000, 122);
                return;
            }
            case 43: {
                Sector.AddMovingSector(nSector, nLotag, nHitag % 1000, 90);
                return;
            }
            case 44: {
                Sector.CreatePushBlock(nSector);
                return;
            }
            case 47: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].ceilingz, -1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), 200, v270, 2, Engine.sector[nSector].ceilingz, Engine.sector[nNext].ceilingz));
                break;
            }
            case 48: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].ceilingz, -1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), 200, v270, 2, Engine.sector[nSector].ceilingz, Engine.sector[nNext].ceilingz));
                break;
            }
            case 50: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), 200, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nSector].ceilingz + (Engine.sector[nSector].floorz - Engine.sector[nSector].ceilingz) / 2));
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), 200, v270, 2, Engine.sector[nSector].ceilingz, Engine.sector[nSector].ceilingz + (Engine.sector[nSector].floorz - Engine.sector[nSector].ceilingz) / 2 - 8));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwReady(nChannel, Sector.BuildLink(2, 1, 0)));
                break;
            }
            case 51: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].ceilingz + (Engine.sector[nSector].floorz - Engine.sector[nSector].ceilingz) / 2, Engine.sector[nSector].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].ceilingz + (Engine.sector[nSector].floorz - Engine.sector[nSector].ceilingz) / 2, Engine.sector[nSector].ceilingz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, Sector.BuildLink(1, 1), nSector, var_24));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 60));
                break;
            }
            case 52: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].ceilingz + (Engine.sector[nSector].floorz - Engine.sector[nSector].ceilingz) / 2, Engine.sector[nSector].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].ceilingz + (Engine.sector[nSector].floorz - Engine.sector[nSector].ceilingz) / 2, Engine.sector[nSector].ceilingz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 150));
                break;
            }
            case 53: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].ceilingz, -1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].ceilingz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, Sector.BuildLink(1, 1), nSector, var_24));
                break;
            }
            case 54: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].ceilingz, -1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].ceilingz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, Sector.BuildLink(1, 1), nSector, var_24));
                break;
            }
            case 55: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].ceilingz, -1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].ceilingz));
                break;
            }
            case 56: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].ceilingz, Engine.sector[nNext].floorz));
                break;
            }
            case 57: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, Sector.BuildLink(1, 1), nSector, var_24));
            }
            case 62: {
                if (nLotag % 1000 == 63) {
                    Globals.nEnergyChan = nChannel;
                }
                if ((nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].ceilingz, -1, -1)) == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].ceilingz));
                break;
            }
            case 58: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, Sector.BuildLink(1, 1), nSector));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwNotOnPause(nChannel, Sector.BuildLink(1, 1), nSector, 60));
                break;
            }
            case 60: {
                int i;
                v263[0] = Engine.sector[nSector].floorz;
                int v212 = nSector;
                for (i = 1; i < 8 && (v212 = Main.engine.nextsectorneighborz(nSector, Engine.sector[v212].floorz, 1, -1)) >= 0; ++i) {
                    v263[i] = Engine.sector[v212].floorz;
                }
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, i, v263));
                break;
            }
            case 61: {
                int i;
                int v220 = nSector;
                v263[0] = Engine.sector[nSector].floorz;
                for (i = 1; i < 8 && (v220 = Main.engine.nextsectorneighborz(nSector, Engine.sector[v220].floorz, 1, 1)) >= 0; ++i) {
                    v263[i] = Engine.sector[v220].floorz;
                }
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, i, v263));
                break;
            }
            case 63: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwStepOn(nChannel, Sector.BuildLink(2, 0, 0), nSector));
                break;
            }
            case 74: {
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].ceilingz, Engine.sector[nSector].floorz));
                break;
            }
            case 67: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                break;
            }
            case 22: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), Short.MAX_VALUE, 200, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].floorz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 60 * v269));
                break;
            }
            case 49: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].floorz, 1, 1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevF(nChannel, nSector, Sector.FindWallSprites(nSector), Short.MAX_VALUE, 200, 2, Engine.sector[nNext].floorz, Engine.sector[nSector].floorz));
                break;
            }
            case 69: 
            case 70: {
                nNext = Main.engine.nextsectorneighborz(nSector, Engine.sector[nSector].ceilingz, -1, -1);
                if (nNext == -1) break;
                RunList.AddRunRec(RunList.channel[nChannel].head, Object.BuildElevC(0, nChannel, nSector, Sector.FindWallSprites(nSector), v270, v270, 2, Engine.sector[nSector].floorz, Engine.sector[nNext].ceilingz));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPressSector(nChannel, Sector.BuildLink(1, 1), nSector, var_24));
                RunList.AddRunRec(RunList.channel[nChannel].head, Switch.BuildSwPause(nChannel, Sector.BuildLink(2, -1, 0), 60));
                break;
            }
            case 79: {
                int n = nSector;
                Globals.SectFlag[n] = (short)(Globals.SectFlag[n] | 0x8000);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static int GrabPushBlock() {
        if (Map.nPushBlocks < 100) {
            if (Globals.sBlockInfo[Map.nPushBlocks] == null) {
                Globals.sBlockInfo[Map.nPushBlocks] = new BlockInfo();
            } else {
                Globals.sBlockInfo[Map.nPushBlocks].clear();
            }
            return Map.nPushBlocks++;
        }
        return -1;
    }

    public static ByteBuffer savePushBlocks() {
        ByteBuffer bb = ByteBuffer.allocate(2 + 16 * Map.nPushBlocks);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)Map.nPushBlocks);
        for (int i = 0; i < Map.nPushBlocks; ++i) {
            Globals.sBlockInfo[i].save(bb);
        }
        return bb;
    }

    public static void loadPushBlocks(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.nPushBlocks = bb.readShort().shortValue();
            for (int i = 0; i < loader.nPushBlocks; ++i) {
                if (loader.sBlockInfo[i] == null) {
                    loader.sBlockInfo[i] = new BlockInfo();
                }
                loader.sBlockInfo[i].load(bb);
            }
        } else {
            Map.nPushBlocks = loader.nPushBlocks;
            for (int i = 0; i < loader.nPushBlocks; ++i) {
                if (Globals.sBlockInfo[i] == null) {
                    Globals.sBlockInfo[i] = new BlockInfo();
                }
                Globals.sBlockInfo[i].copy(loader.sBlockInfo[i]);
            }
        }
    }

    private static void CreatePushBlock(int a1) {
        int i;
        int block = Sector.GrabPushBlock();
        BlockInfo binfo = Globals.sBlockInfo[block];
        SECTOR sec = Engine.sector[a1];
        int wx = 0;
        int wy = 0;
        for (i = sec.wallptr; i < sec.wallptr + sec.wallnum; ++i) {
            wx += Engine.wall[i].x;
            wy += Engine.wall[i].y;
        }
        binfo.cx = wx / sec.wallnum;
        binfo.cy = wy / sec.wallnum;
        i = Main.engine.insertsprite((short)a1, 0);
        binfo.sprite = (short)i;
        SPRITE spr = Engine.sprite[i];
        spr.x = binfo.cx;
        spr.y = binfo.cy;
        spr.z = Engine.sector[a1].floorz - 256;
        spr.cstat = Short.MIN_VALUE;
        int clipdist = 0;
        for (int j = sec.wallptr; j < sec.wallptr + sec.wallnum; ++j) {
            int dist = Main.engine.ksqrt((binfo.cx - Engine.wall[j].x) * (binfo.cx - Engine.wall[j].x) + (binfo.cy - Engine.wall[j].y) * (binfo.cy - Engine.wall[j].y));
            if (dist <= clipdist) continue;
            clipdist = dist;
        }
        binfo.field_8 = clipdist;
        spr.clipdist = 4 * clipdist & 0xFF;
        sec.extra = (short)block;
    }

    public static void AddMovingSector(int a1, int a2, int a3, int a4) {
        if (Globals.nMoveSects >= 50) {
            Main.game.ThrowError("Too many moving sectors");
            return;
        }
        Sector.CreatePushBlock(a1);
        Globals.sMoveDir[Globals.nMoveSects] = 1;
        if (Globals.sMoveSect[Globals.nMoveSects] == null) {
            Globals.sMoveSect[Globals.nMoveSects] = new MoveSectStruct();
        }
        MoveSectStruct v10 = Globals.sMoveSect[Globals.nMoveSects++];
        v10.field_2 = (short)Object.FindTrail(a3);
        v10.field_4 = (short)-1;
        v10.field_8 = (short)-1;
        v10.field_6 = (short)a4;
        v10.field_A = (short)(a2 / 1000 + 1);
        v10.field_0 = (short)a1;
        v10.field_E = (a4 & 8) != 0 ? (short)RunList.AllocChannel(a3 % 1000) : (short)-1;
        Engine.sector[a1].floorstat = (short)(Engine.sector[a1].floorstat | 0x40);
    }

    public static ByteBuffer saveMoves() {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(2 + Globals.nMoveSects * 16 + 50);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)Globals.nMoveSects);
        for (i = 0; i < 50; ++i) {
            bb.put(Globals.sMoveDir[i]);
        }
        for (i = 0; i < Globals.nMoveSects; ++i) {
            Globals.sMoveSect[i].save(bb);
        }
        return bb;
    }

    public static void loadMoves(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i;
            loader.nMoveSects = bb.readShort().shortValue();
            for (i = 0; i < 50; ++i) {
                loader.sMoveDir[i] = bb.readByte();
            }
            for (i = 0; i < loader.nMoveSects; ++i) {
                if (loader.sMoveSect[i] == null) {
                    loader.sMoveSect[i] = new MoveSectStruct();
                }
                loader.sMoveSect[i].load(bb);
            }
        } else {
            Globals.nMoveSects = loader.nMoveSects;
            System.arraycopy(loader.sMoveDir, 0, Globals.sMoveDir, 0, Globals.nMoveSects);
            for (int i = 0; i < loader.nMoveSects; ++i) {
                if (Globals.sMoveSect[i] == null) {
                    Globals.sMoveSect[i] = new MoveSectStruct();
                }
                Globals.sMoveSect[i].copy(loader.sMoveSect[i]);
            }
        }
    }

    private static int BuildEnergyBlock(int nSector) {
        SECTOR sec = Engine.sector[nSector];
        int wx = 0;
        int wy = 0;
        for (int i = sec.wallptr; i < sec.wallptr + sec.wallnum; ++i) {
            wx += Engine.wall[i].x;
            wy += Engine.wall[i].y;
            Engine.wall[i].pal = 0;
            Engine.wall[i].shade = (byte)50;
            Engine.wall[i].picnum = (short)3621;
        }
        int cx = wx / sec.wallnum;
        int cy = wy / sec.wallnum;
        short nextsec = Engine.wall[sec.wallptr].nextsector;
        short i = Main.engine.insertsprite((short)nSector, 406);
        Engine.sprite[i].x = cx;
        Engine.sprite[i].y = cy;
        Engine.sprite[i].z = Engine.sector[nextsec].floorz;
        Engine.sprite[i].xrepeat = (short)Gameutils.BClipHigh(Engine.sector[nextsec].floorz - sec.floorz >> 8, 255);
        Engine.sprite[i].cstat = Short.MIN_VALUE;
        Engine.sprite[i].xvel = 0;
        Engine.sprite[i].yvel = 0;
        Engine.sprite[i].zvel = 0;
        Engine.sprite[i].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[i].hitag = 0;
        Engine.sprite[i].owner = (short)RunList.AddRunRec(Engine.sprite[i].lotag - 1, 0x250000 | i);
        Engine.sprite[i].extra = (short)-1;
        sec.extra = i;
        ++Globals.nEnergyBlocks;
        return i;
    }

    public static void FuncEnergyBlock(int a1, int nDamage, int RunPtr) {
        short nEnergy = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        short nSector = Engine.sprite[nEnergy].sectnum;
        if (Engine.sector[nSector].extra != -1) {
            switch (a1 & 0x7F0000) {
                case 655360: {
                    Engine.sector[nSector].floorz = Engine.sprite[nEnergy].z;
                    Engine.sprite[nEnergy].z -= 256;
                    nDamage = Sprites.CheckRadialDamage(nEnergy);
                    Engine.sprite[nEnergy].z += 256;
                    Engine.sector[nSector].floorz = Engine.sector[nSector].floorz;
                }
                case 524288: {
                    if (nDamage > 0) {
                        if ((nDamage >>= 2) < Engine.sprite[nEnergy].xrepeat) {
                            Engine.sprite[nEnergy].xrepeat = (short)(Engine.sprite[nEnergy].xrepeat - nDamage);
                            short spr = Main.engine.insertsprite((short)Bullet.lasthitsect, 0);
                            Engine.sprite[spr].ang = (short)a1;
                            Engine.sprite[spr].x = Bullet.lasthitx;
                            Engine.sprite[spr].y = Bullet.lasthity;
                            Engine.sprite[spr].z = Bullet.lasthitz;
                            Object.BuildSpark(spr, 0);
                            Main.engine.mydeletesprite(spr);
                        } else {
                            Engine.sprite[nEnergy].xrepeat = 0;
                            Sector.ExplodeEnergyBlock(nEnergy);
                        }
                    }
                    return;
                }
            }
        }
    }

    private static void ExplodeEnergyBlock(short nEnergy) {
        int i;
        SECTOR pSector = Engine.sector[Engine.sprite[nEnergy].sectnum];
        int wallptr = pSector.wallptr;
        for (i = 0; i < pSector.wallnum; ++i) {
            WALL pNext = Engine.wall[Engine.wall[wallptr++].nextwall];
            pNext.pal = pNext.pal >= 4 ? (short)7 : (short)0;
            pNext.shade = (byte)50;
        }
        pSector.floorpal = pSector.floorpal >= 4 ? (short)7 : (short)0;
        pSector.floorshade = (byte)50;
        pSector.extra = (short)-1;
        pSector.floorz = Engine.sprite[nEnergy].z;
        Engine.sprite[nEnergy].z = (Engine.sprite[nEnergy].z + pSector.floorz) / 2;
        Object.BuildSpark(nEnergy, 3);
        Engine.sprite[nEnergy].cstat = 0;
        Engine.sprite[nEnergy].xrepeat = (short)100;
        Sound.PlayFX2(Sound.StaticSound[78], nEnergy);
        Engine.sprite[nEnergy].xrepeat = 0;
        --Globals.nEnergyTowers;
        for (i = 0; i < 20; ++i) {
            Engine.sprite[nEnergy].ang = (short)Random.RandomSize(11);
            Object.BuildSpark(nEnergy, 1);
        }
        Palette.TintPalette(16, 16, 16);
        if (Globals.nEnergyTowers == 1) {
            RunList.ChangeChannel(Globals.nEnergyChan, 1);
            View.StatusMessage(1000, "TAKE OUT THE CONTROL CENTER!", -1);
        } else if (Globals.nEnergyTowers != 0) {
            View.StatusMessage(500, Globals.nEnergyTowers + " TOWERS REMAINING", -1);
        } else {
            Globals.nFinaleSpr = nEnergy;
            Globals.lFinaleStart = Gameutils.BClipLow(Engine.totalclock, 1);
            for (int s = 0; s < Engine.numsectors; ++s) {
                SECTOR pSec = Engine.sector[s];
                if (pSec.ceilingpal == 1) {
                    pSec.ceilingpal = 0;
                }
                if (pSec.floorpal == 1) {
                    pSec.floorpal = 0;
                }
                for (int w = pSec.wallptr; w < pSec.wallptr + pSec.wallnum; ++w) {
                    if (Engine.wall[w].pal != 1) continue;
                    Engine.wall[w].pal = 0;
                }
            }
            Sector.KillCreatures();
        }
        Main.engine.changespritestat(nEnergy, 0);
    }

    private static void KillCreatures() {
        for (int statnum = 99; statnum < 108; ++statnum) {
            if (statnum == 100) continue;
            short i = Engine.headspritestat[statnum];
            while (i != -1) {
                Sprites.DamageEnemy(i, -1, 1600);
                i = Engine.nextspritestat[i];
            }
        }
    }

    static {
        NearSector = new short[Engine.MAXSECTORS];
        LinkMap = new byte[1024][8];
        tmpVec = new Vector2();
    }
}

