/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Type.SnakeStruct;

public class Snake {
    public static final int MAX_SNAKES = 50;
    private static int nSnakesFree;
    private static short[] SnakeFree;
    private static short[] nSnakePlayer;
    public static SnakeStruct[] SnakeList;

    public static void InitSnakes() {
        for (int i = 0; i < 50; i = (int)((short)(i + 1))) {
            Snake.SnakeFree[i] = i;
        }
        nSnakesFree = 50;
        Arrays.fill(Globals.nPlayerSnake, (short)0);
    }

    public static ByteBuffer saveSnakes() {
        int i;
        int nSnakes = 0;
        for (int i2 = 0; i2 < 50; ++i2) {
            if (SnakeList[i2] == null || Snake.SnakeList[i2].nFunc == -1) continue;
            ++nSnakes;
        }
        ByteBuffer bb = ByteBuffer.allocate(202 + 34 * nSnakes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)nSnakesFree);
        for (i = 0; i < 50; ++i) {
            bb.putShort(SnakeFree[i]);
            bb.putShort(nSnakePlayer[i]);
        }
        if (nSnakes != 0) {
            for (i = 0; i < 50; ++i) {
                if (SnakeList[i] == null || Snake.SnakeList[i].nFunc == -1) continue;
                bb.putShort((short)i);
                SnakeList[i].save(bb);
            }
        }
        return bb;
    }

    public static void loadSnakes(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i;
            for (i = 0; i < 50; ++i) {
                if (loader.SnakeList[i] == null) continue;
                loader.SnakeList[i].nFunc = (short)-1;
            }
            loader.nSnakesFree = bb.readShort().shortValue();
            for (i = 0; i < 50; ++i) {
                loader.SnakeFree[i] = bb.readShort();
                loader.nSnakePlayer[i] = bb.readShort();
            }
            for (int nSnakes = 50 - loader.nSnakesFree; nSnakes > 0; --nSnakes) {
                short i2 = bb.readShort();
                if (loader.SnakeList[i2] == null) {
                    loader.SnakeList[i2] = new SnakeStruct();
                }
                loader.SnakeList[i2].load(bb);
            }
        } else {
            nSnakesFree = loader.nSnakesFree;
            System.arraycopy(loader.SnakeFree, 0, SnakeFree, 0, 50);
            System.arraycopy(loader.nSnakePlayer, 0, nSnakePlayer, 0, 50);
            for (int i = 0; i < 50; ++i) {
                if (SnakeList[i] != null) {
                    Snake.SnakeList[i].nFunc = (short)-1;
                }
                if (loader.SnakeList[i] == null || loader.SnakeList[i].nFunc == -1) continue;
                if (SnakeList[i] == null) {
                    Snake.SnakeList[i] = new SnakeStruct();
                }
                SnakeList[i].copy(loader.SnakeList[i]);
            }
        }
    }

    public static int GrabSnake() {
        return SnakeFree[--nSnakesFree];
    }

    public static void DestroySnake(int a1) {
        RunList.SubRunRec(Snake.SnakeList[a1].nFunc);
        for (int i = 0; i < 8; ++i) {
            short spr = Snake.SnakeList[a1].nSprite[i];
            RunList.DoSubRunRec(Engine.sprite[spr].lotag - 1);
            RunList.DoSubRunRec(Engine.sprite[spr].owner);
            Main.engine.mydeletesprite(spr);
        }
        Snake.SnakeList[a1].nFunc = (short)-1;
        Snake.SnakeFree[Snake.nSnakesFree] = (short)a1;
        ++nSnakesFree;
        if (a1 == Globals.nSnakeCam) {
            Globals.nSnakeCam = -1;
        }
    }

    public static void ExplodeSnakeSprite(int a1, int a2) {
        int v3 = Bullet.BulletInfo[5].force;
        if (Globals.nPlayerDouble[a2] > 0) {
            v3 = 2 * Bullet.BulletInfo[5].force;
        }
        short old = Engine.sprite[a1].owner;
        Engine.sprite[a1].owner = Globals.PlayerList[a2].spriteId;
        Sprites.RadialDamageEnemy(a1, v3, Bullet.BulletInfo[5].inf_10);
        Engine.sprite[a1].owner = old;
        Anim.BuildAnim(-1, 23, 0, Engine.sprite[a1].x, Engine.sprite[a1].y, Engine.sprite[a1].z, Engine.sprite[a1].sectnum, 40, 4);
        Light.AddFlash(Engine.sprite[a1].sectnum, Engine.sprite[a1].x, Engine.sprite[a1].y, Engine.sprite[a1].z, 128);
        Sound.StopSpriteSound(a1);
    }

    public static void BuildSnake(int a1, int a2) {
        if (nSnakesFree != 0) {
            short pspr = Globals.PlayerList[a1].spriteId;
            short sect = Globals.nPlayerViewSect[a1];
            short picnum = Seq.GetSeqPicnum(21, 0, 0);
            int v40 = a2 - 1280;
            Main.engine.hitscan(Engine.sprite[pspr].x, Engine.sprite[pspr].y, v40 + Engine.sprite[pspr].z - 2560, Engine.sprite[pspr].sectnum, Engine.sintable[Engine.sprite[pspr].ang + 512 & 0x7FF], Engine.sintable[Engine.sprite[pspr].ang & 0x7FF], 0, Engine.pHitInfo, 0x1000040);
            if (Main.engine.ksqrt((Engine.pHitInfo.hitx - Engine.sprite[pspr].x) * (Engine.pHitInfo.hitx - Engine.sprite[pspr].x) + (Engine.pHitInfo.hity - Engine.sprite[pspr].y) * (Engine.pHitInfo.hity - Engine.sprite[pspr].y)) >= Engine.sintable[512] >> 4) {
                short nTarget = Engine.pHitInfo.hitsprite < 0 || Engine.sprite[Engine.pHitInfo.hitsprite].statnum < 90 || Engine.sprite[Engine.pHitInfo.hitsprite].statnum > 199 ? Globals.sPlayerInput[a1].nTarget : Engine.pHitInfo.hitsprite;
                int nSnake = Snake.GrabSnake();
                if (SnakeList[nSnake] == null) {
                    Snake.SnakeList[nSnake] = new SnakeStruct();
                }
                int v55 = 0;
                int peer = -1;
                for (int i = 0; i < 8; ++i) {
                    short spr = Main.engine.insertsprite(sect, 202);
                    if (spr < 0 || spr >= Engine.MAXSPRITES) {
                        Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
                        return;
                    }
                    Engine.sprite[spr].owner = pspr;
                    Engine.sprite[spr].picnum = picnum;
                    if (i != 0) {
                        short siz;
                        Engine.sprite[spr].x = Engine.sprite[peer].x;
                        Engine.sprite[spr].y = Engine.sprite[peer].y;
                        Engine.sprite[spr].z = Engine.sprite[peer].z;
                        Engine.sprite[spr].xrepeat = siz = (short)(40 - (i + v55));
                        Engine.sprite[spr].yrepeat = siz;
                    } else {
                        Engine.sprite[spr].x = Engine.sprite[pspr].x;
                        Engine.sprite[spr].y = Engine.sprite[pspr].y;
                        Engine.sprite[spr].z = v40 + Engine.sprite[pspr].z;
                        Engine.sprite[spr].xrepeat = (short)32;
                        Engine.sprite[spr].yrepeat = (short)32;
                        peer = spr;
                        sect = Engine.sprite[spr].sectnum;
                    }
                    Engine.sprite[spr].clipdist = 10;
                    Engine.sprite[spr].cstat = 0;
                    Engine.sprite[spr].shade = (byte)-64;
                    Engine.sprite[spr].pal = 0;
                    Engine.sprite[spr].xoffset = 0;
                    Engine.sprite[spr].yoffset = 0;
                    Engine.sprite[spr].ang = Engine.sprite[pspr].ang;
                    Engine.sprite[spr].xvel = 0;
                    Engine.sprite[spr].yvel = 0;
                    Engine.sprite[spr].zvel = 0;
                    Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
                    Engine.sprite[spr].hitag = 0;
                    Engine.sprite[spr].extra = (short)-1;
                    Snake.SnakeList[nSnake].nSprite[i] = spr;
                    Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x110000 | i << 8 | nSnake);
                    Main.game.pInt.setsprinterpolate(spr, Engine.sprite[spr]);
                    v55 += 2;
                }
                Snake.SnakeList[nSnake].nFunc = (short)RunList.AddRunRec(RunList.NewRun, 0x110000 | nSnake);
                Snake.SnakeList[nSnake].field_14[1] = 2;
                Snake.SnakeList[nSnake].field_14[2] = 4;
                Snake.SnakeList[nSnake].field_14[3] = 6;
                Snake.SnakeList[nSnake].field_14[4] = 7;
                Snake.SnakeList[nSnake].field_14[5] = 5;
                Snake.SnakeList[nSnake].field_14[6] = 6;
                Snake.SnakeList[nSnake].field_14[7] = 7;
                Snake.SnakeList[nSnake].nTarget = nTarget;
                Snake.SnakeList[nSnake].field_10 = (short)1200;
                Snake.SnakeList[nSnake].zvec = 0;
                Snake.nSnakePlayer[nSnake] = (short)a1;
                Globals.nPlayerSnake[a1] = (short)nSnake;
                if (Globals.bSnakeCam && Globals.nSnakeCam < 0) {
                    Globals.nSnakeCam = nSnake;
                }
                Sound.D3PlayFX(Sound.StaticSound[6], peer);
            } else {
                Bullet.BackUpBullet(Engine.pHitInfo.hitx, Engine.pHitInfo.hity, Engine.sprite[pspr].ang);
                short i = Main.engine.insertsprite(Engine.pHitInfo.hitsect, 202);
                Engine.sprite[i].x = Engine.pHitInfo.hitx;
                Engine.sprite[i].y = Engine.pHitInfo.hity;
                Engine.sprite[i].z = Engine.pHitInfo.hitz;
                Snake.ExplodeSnakeSprite(i, a1);
                Main.engine.mydeletesprite(i);
            }
        }
    }

    public static void FindSnakeEnemy(int nSnake) {
        short pspr = Globals.PlayerList[Snake.nSnakePlayer[nSnake]].spriteId;
        short spr = Snake.SnakeList[nSnake].nSprite[0];
        short v15 = -1;
        int v5 = 2048;
        short i = Engine.headspritesect[Engine.sprite[spr].sectnum];
        while (i >= 0) {
            int v9;
            if (Engine.sprite[i].statnum >= 90 && Engine.sprite[i].statnum < 150 && (Engine.sprite[i].cstat & 0x101) != 0 && i != pspr && (Engine.sprite[i].cstat >> 8 & 0x80) == 0 && (v9 = Engine.sprite[spr].ang - Sprites.GetAngleToSprite(spr, i) & 0x7FF) < v5) {
                v15 = i;
                v5 = v9;
            }
            i = Engine.nextspritesect[i];
        }
        if (v15 != -1) {
            Snake.SnakeList[nSnake].nTarget = v15;
            return;
        }
        Snake.SnakeList[nSnake].nTarget = (short)(Snake.SnakeList[nSnake].nTarget - 1);
        if (Snake.SnakeList[nSnake].nTarget < -25) {
            Snake.SnakeList[nSnake].nTarget = pspr;
        }
    }

    public static void FuncSnake(int a1, int a2, int RunPtr) {
        short nSnake = (short)(RunList.RunData[RunPtr].RunEvent & 0xFF);
        if (nSnake < 0 || nSnake >= 50) {
            Main.game.ThrowError("nSnake>=0 && nSnake<MAX_SNAKES");
            return;
        }
        int v37 = 0;
        int nHitMove = 0;
        short nObject = (short)(a1 & 0xFFFF);
        short nSprite = Snake.SnakeList[nSnake].nSprite[0];
        switch (a1 & 0x7F0000) {
            case 131072: {
                Seq.MoveSequence(nSprite, Seq.SeqOffsets[20], 0);
                short nTarget = Snake.SnakeList[nSnake].nTarget;
                if (nTarget >= 0) {
                    if ((Engine.sprite[nTarget].cstat & 0x101) != 0) {
                        nHitMove = Sprites.AngleChase(nSprite, nTarget, 1200, Snake.SnakeList[nSnake].zvec, 32);
                        v37 = Engine.sprite[nSprite].z - Engine.sprite[nSprite].z;
                        break;
                    }
                    Snake.SnakeList[nSnake].nTarget = (short)-1;
                }
                v37 = 0;
                nHitMove = Main.engine.movesprite(nSprite, 600 * Engine.sintable[Engine.sprite[nSprite].ang + 512 & 0x7FF], 600 * Engine.sintable[Engine.sprite[nSprite].ang & 0x7FF], Engine.sintable[Snake.SnakeList[nSnake].zvec & 0x7FF] >> 5, 0, 0, 1);
                Snake.FindSnakeEnemy(nSnake);
                break;
            }
            case 589824: {
                if ((RunList.RunData[RunPtr].RunEvent & 0xFF00) != 0) {
                    Seq.PlotSequence(nObject, Seq.SeqOffsets[21], 0, 0);
                } else {
                    Seq.PlotSequence(nObject, Seq.SeqOffsets[20], 0, 0);
                }
                Engine.tsprite[nObject].owner = (short)-1;
                return;
            }
        }
        if (nHitMove != 0) {
            Snake.ExplodeSnakeSprite(Snake.SnakeList[nSnake].nSprite[0], nSnakePlayer[nSnake]);
            Globals.nPlayerSnake[nObject] = -1;
            Snake.nSnakePlayer[nSnake] = -1;
            Snake.DestroySnake(nSnake);
        } else {
            short ang = Engine.sprite[nSprite].ang;
            int v14 = -64 * Engine.sintable[ang & 0x7FF];
            int dx = -576 * Engine.sintable[ang + 512 & 0x7FF];
            int v36 = -64 * Engine.sintable[ang + 512 & 0x7FF];
            int v15 = -512 * Engine.sintable[ang & 0x7FF];
            int dy = v36 + v15;
            int v39 = Snake.SnakeList[nSnake].zvec;
            Snake.SnakeList[nSnake].zvec = (short)(v39 + 64 & 0x7FF);
            short sectnum = Engine.sprite[nSprite].sectnum;
            int sx = Engine.sprite[nSprite].x;
            int sy = Engine.sprite[nSprite].y;
            int sz = Engine.sprite[nSprite].z;
            int dz = -7 * v37;
            for (int i = 7; i > 0; --i) {
                short spr = Snake.SnakeList[nSnake].nSprite[i];
                Main.game.pInt.setsprinterpolate(spr, Engine.sprite[spr]);
                Engine.sprite[spr].ang = ang;
                Engine.sprite[spr].x = sx;
                Engine.sprite[spr].y = sy;
                Engine.sprite[spr].z = sz;
                Main.engine.mychangespritesect(spr, sectnum);
                int vel = Snake.SnakeList[nSnake].field_14[i] * Engine.sintable[v39 & 0x7FF] >> 9;
                Main.engine.movesprite(spr, vel * Engine.sintable[Engine.sprite[nSprite].ang + 1024 & 0x7FF] + (dx -= v36), Engine.sintable[Engine.sprite[nSprite].ang + 512 & 0x7FF] * vel + (dy -= v14), dz += v37, 0, 0, 1);
                v39 = v39 + 128 & 0x7FF;
            }
        }
    }

    static {
        SnakeFree = new short[50];
        nSnakePlayer = new short[50];
        SnakeList = new SnakeStruct[50];
    }
}

