/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Types.LittleEndian;

public class Input
implements BuildNet.NetInput {
    private static final int sizeof = 10;
    private static final int gdxsizeof = 17;
    public float avel;
    public float horz;
    public short fvel;
    public short svel;
    public int bits;
    public byte carang;
    private int bufferVersion;
    private ByteBuffer InputBuffer;

    public Input() {
    }

    public Input(Object data, int nVersion) {
        this.setBytes(data, nVersion, new int[0]);
    }

    public int setBytes(Object data, int nVersion, int ... offs) {
        int offset = 0;
        if (offs.length == 1) {
            offset = offs[0];
        }
        ByteBuffer bb = null;
        if (data instanceof byte[]) {
            bb = ByteBuffer.wrap((byte[])data);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.position(offset);
        } else if (data instanceof ByteBuffer) {
            bb = (ByteBuffer)data;
        } else {
            return offset;
        }
        if (nVersion < 147) {
            this.avel = bb.get();
            this.horz = bb.get();
        } else {
            this.avel = bb.getFloat();
            this.horz = bb.getFloat();
            this.carang = bb.get();
        }
        this.fvel = bb.getShort();
        this.svel = bb.getShort();
        this.bits = bb.getInt();
        return bb.position();
    }

    public byte[] getBytes(int nVersion) {
        if (this.InputBuffer == null || nVersion != this.bufferVersion) {
            this.InputBuffer = ByteBuffer.allocate(Input.sizeof(nVersion));
            this.bufferVersion = nVersion;
        } else {
            this.InputBuffer.clear();
        }
        this.InputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (nVersion < 147) {
            this.InputBuffer.put((byte)this.avel);
            this.InputBuffer.put((byte)this.horz);
        } else {
            this.InputBuffer.putFloat(this.avel);
            this.InputBuffer.putFloat(this.horz);
            this.InputBuffer.put(this.carang);
        }
        this.InputBuffer.putShort(this.fvel);
        this.InputBuffer.putShort(this.svel);
        this.InputBuffer.putInt(this.bits);
        return this.InputBuffer.array();
    }

    public static int sizeof(int nVersion) {
        int size = 10;
        if (nVersion >= 147) {
            size = 17;
        }
        return size;
    }

    @Override
    public int GetInput(byte[] packbuf, int offset, BuildNet.NetInput oldInput) {
        int k = (packbuf[offset++] & 0xFF) << 8 | packbuf[offset++] & 0xFF;
        this.Copy(oldInput);
        if ((k & 1) != 0) {
            this.fvel = LittleEndian.getShort(packbuf, offset);
            offset += 2;
        }
        if ((k & 2) != 0) {
            this.svel = LittleEndian.getShort(packbuf, offset);
            offset += 2;
        }
        if ((k & 4) != 0) {
            this.avel = LittleEndian.getFloat(packbuf, offset);
            offset += 4;
        }
        if ((k & 8) != 0) {
            this.bits = this.bits & 0xFFFFFF00 | packbuf[offset++] & 0xFF;
        }
        if ((k & 0x10) != 0) {
            this.bits = this.bits & 0xFFFF00FF | (packbuf[offset++] & 0xFF) << 8;
        }
        if ((k & 0x20) != 0) {
            this.bits = this.bits & 0xFF00FFFF | (packbuf[offset++] & 0xFF) << 16;
        }
        if ((k & 0x40) != 0) {
            this.bits = this.bits & 0xFFFFFF | (packbuf[offset++] & 0xFF) << 24;
        }
        if ((k & 0x80) != 0) {
            this.horz = LittleEndian.getFloat(packbuf, offset);
            offset += 4;
        }
        if ((k & 0x100) != 0) {
            this.carang = packbuf[offset++];
        }
        return offset;
    }

    @Override
    public int PutInput(byte[] packbuf, int offset, BuildNet.NetInput oldInput) {
        int syncptr = offset;
        packbuf[offset++] = 0;
        packbuf[offset++] = 0;
        Input osyn = (Input)oldInput;
        if (this.fvel != osyn.fvel) {
            LittleEndian.putShort(packbuf, offset, this.fvel);
            offset += 2;
            int n = syncptr + 1;
            packbuf[n] = (byte)(packbuf[n] | 1);
        }
        if (this.svel != osyn.svel) {
            LittleEndian.putShort(packbuf, offset, this.svel);
            offset += 2;
            int n = syncptr + 1;
            packbuf[n] = (byte)(packbuf[n] | 2);
        }
        if (this.avel != osyn.avel) {
            LittleEndian.putFloat(packbuf, offset, this.avel);
            offset += 4;
            int n = syncptr + 1;
            packbuf[n] = (byte)(packbuf[n] | 4);
        }
        if (((this.bits ^ osyn.bits) & 0xFF) != 0) {
            packbuf[offset++] = (byte)(this.bits & 0xFF);
            int n = syncptr + 1;
            packbuf[n] = (byte)(packbuf[n] | 8);
        }
        if (((this.bits ^ osyn.bits) & 0xFF00) != 0) {
            packbuf[offset++] = (byte)(this.bits >> 8 & 0xFF);
            int n = syncptr + 1;
            packbuf[n] = (byte)(packbuf[n] | 0x10);
        }
        if (((this.bits ^ osyn.bits) & 0xFF0000) != 0) {
            packbuf[offset++] = (byte)(this.bits >> 16 & 0xFF);
            int n = syncptr + 1;
            packbuf[n] = (byte)(packbuf[n] | 0x20);
        }
        if (((this.bits ^ osyn.bits) & 0xFF000000) != 0) {
            packbuf[offset++] = (byte)(this.bits >> 24 & 0xFF);
            int n = syncptr + 1;
            packbuf[n] = (byte)(packbuf[n] | 0x40);
        }
        if (this.horz != osyn.horz) {
            LittleEndian.putFloat(packbuf, offset, this.horz);
            offset += 4;
            int n = syncptr + 1;
            packbuf[n] = (byte)(packbuf[n] | 0x80);
        }
        if (this.carang != osyn.carang) {
            packbuf[offset++] = this.carang;
            int n = syncptr;
            packbuf[n] = (byte)(packbuf[n] | 1);
        }
        return offset;
    }

    @Override
    public void Reset() {
        this.fvel = 0;
        this.svel = 0;
        this.avel = 0.0f;
        this.bits = 0;
        this.horz = 0.0f;
        this.carang = 0;
    }

    @Override
    public BuildNet.NetInput Copy(BuildNet.NetInput netsrc) {
        if (netsrc == null) {
            return null;
        }
        Input src = (Input)netsrc;
        this.fvel = src.fvel;
        this.svel = src.svel;
        this.avel = src.avel;
        this.bits = src.bits;
        this.horz = src.horz;
        this.carang = src.carang;
        return this;
    }
}

