/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Fonts;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.TileFont;

public class StandartFont
extends BuildFont {
    private TileFont font;
    private char[] sym = new char[1];

    public StandartFont(Engine draw) {
        super(draw, 4, 32768, 0);
        this.font = Engine.pTextfont;
    }

    @Override
    public int getWidth(char[] text) {
        int width = 0;
        if (text != null) {
            int pos = 0;
            while (pos < text.length && text[pos++] != '\u0000') {
                width += 4;
            }
        }
        return width;
    }

    @Override
    public int getWidth(char[] text, int scale) {
        int width = 0;
        if (text != null) {
            int pos = 0;
            while (pos < text.length && text[pos++] != '\u0000') {
                width += Pragmas.scale(4L, scale, 65536L);
            }
        }
        return width;
    }

    @Override
    public int drawChar(int x, int y, char ch, int shade, int pal, int nBits, boolean shadow) {
        this.sym[0] = ch;
        this.drawText(x, y, this.sym, shade, pal, BuildFont.TextAlign.Center, nBits, shadow);
        return (int)((float)this.nScale / 65536.0f * (float)this.font.charsizx);
    }

    @Override
    public int drawText(int x, int y, char[] text, int shade, int pal, BuildFont.TextAlign align, int nBits, boolean shadow) {
        if (text == null) {
            return 0;
        }
        x = Gameutils.coordsConvertXScaled(x, Gameutils.ConvertType.Normal);
        y = Gameutils.coordsConvertYScaled(y);
        if (align != BuildFont.TextAlign.Left) {
            int nWidth = this.getWidth(text);
            if (align == BuildFont.TextAlign.Center) {
                nWidth >>= 1;
            }
            x -= nWidth;
        }
        int xdim = 4 * Engine.ydim / 3;
        float scale = (float)this.nScale / 65536.0f * (float)xdim / 320.0f;
        this.draw.getrender().printext(this.font, x, y, text, 30, shade, Renderer.Transparent.None, scale);
        return 0;
    }
}

